# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [7.1.0-29](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-28...7.1.0-29) - 2022-03-27

### Merged

- Remove unused EXPLICIT_TEMPLATE_INSTANTIATION [`#4982`](https://github.com/ImageMagick/ImageMagick/pull/4982)
- Fixes #4985: 4e+26 is outside the range of representable values of type 'unsigned long' at coders/pcl.c:299 [`#4986`](https://github.com/ImageMagick/ImageMagick/pull/4986)

### Fixed

- Fixes #4985: 4e+26 is outside the range of representable values of type 'unsigned long' at coders/pcl.c:299 (#4986) [`#4985`](https://github.com/ImageMagick/ImageMagick/issues/4985)

### Commits

- https://github.com/ImageMagick/ImageMagick/issues/4936 [`83b114f`](https://github.com/ImageMagick/ImageMagick/commit/83b114f7ae99561d9c6abc67ab11c50f9d547655)
- latest changelog [`d1d344b`](https://github.com/ImageMagick/ImageMagick/commit/d1d344b0ac1b5e98955009d57ed7f6954b54afcf)
- ... [`280e7e6`](https://github.com/ImageMagick/ImageMagick/commit/280e7e6c2183a534efdf08db225dfa21350f0403)
- enforce one `id` per MIFF image [`966a769`](https://github.com/ImageMagick/ImageMagick/commit/966a769a646aaaeff127862b8e475297bf5058d3)
- https://github.com/ImageMagick/ImageMagick/issues/4987 [`25309b9`](https://github.com/ImageMagick/ImageMagick/commit/25309b9772d72072f8574352968aeca7134ba433)
- over allocate quantum pixel buffer [`219d19f`](https://github.com/ImageMagick/ImageMagick/commit/219d19f96e6a87b17ab26dfa6eadc7ad3169092a)
- https://github.com/ImageMagick/ImageMagick/issues/4972 [`ffc2aaa`](https://github.com/ImageMagick/ImageMagick/commit/ffc2aaae543dcd60c6cc7e5a426f66dbc51df560)
- https://github.com/ImageMagick/ImageMagick/issues/4936 [`000557d`](https://github.com/ImageMagick/ImageMagick/commit/000557da249fa36ad8111c312cb43f179a1f7070)
- set quantum extent [`c909df1`](https://github.com/ImageMagick/ImageMagick/commit/c909df15fc9e55b99c9d4480d4ed48a141fb943b)
- revert [`96162eb`](https://github.com/ImageMagick/ImageMagick/commit/96162ebad2f05140a0d899b46a3e5dec9d4005f2)
- revert [`cb65691`](https://github.com/ImageMagick/ImageMagick/commit/cb656913eb12c67f3d8a3098635e239c3d94bf18)
- revert [`ab39cc4`](https://github.com/ImageMagick/ImageMagick/commit/ab39cc4abe3510b31d9e3dafe8a3b898ce627605)
- cosmetic [`2c35b9a`](https://github.com/ImageMagick/ImageMagick/commit/2c35b9a24bd6abf17b1f135ced20611f4ad7fa17)
- cosmetic [`e36bd84`](https://github.com/ImageMagick/ImageMagick/commit/e36bd84b0935b204a27a05aa041dfea6faf25099)
- no suitable delegate utility for CGM or FIG formats [`004fc5d`](https://github.com/ImageMagick/ImageMagick/commit/004fc5d725fa2dc395391d1ac65f815823595189)
- speculative allocation since we don't yet know the quantum type [`bd77531`](https://github.com/ImageMagick/ImageMagick/commit/bd77531ae8dd24adb583f87e7c0b73c306ac64cc)
- latest changes [`2bfd2be`](https://github.com/ImageMagick/ImageMagick/commit/2bfd2beb581bbfd242ff7dd20a15dc602a154014)
- account for case where gray image is imported as RGBA [`22cfaf3`](https://github.com/ImageMagick/ImageMagick/commit/22cfaf35dcea6d07e5353660794edca16b363c6b)
- reset id [`a4736b4`](https://github.com/ImageMagick/ImageMagick/commit/a4736b4577b45def91148a4e5e71d8d4151ff96f)
- pending release [`a6551b2`](https://github.com/ImageMagick/ImageMagick/commit/a6551b2514ecf294c7ee11841d1e0b665fbbc7a8)
- pending release [`8be1086`](https://github.com/ImageMagick/ImageMagick/commit/8be1086bee313dfcfe014e3c60197bf0b636776f)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=45887 [`96ae906`](https://github.com/ImageMagick/ImageMagick/commit/96ae9066b001ff951c6a3c936081bacfaa69935f)
- https://github.com/ImageMagick/ImageMagick/issues/4975 [`44cb819`](https://github.com/ImageMagick/ImageMagick/commit/44cb81933777a199b9209d89a72fd2acf202d5de)
- https://github.com/ImageMagick/ImageMagick/issues/4974 [`c871830`](https://github.com/ImageMagick/ImageMagick/commit/c8718305f120293d8bf13724f12eed885d830b09)
- https://github.com/ImageMagick/ImageMagick/issues/4988 [`ca3654e`](https://github.com/ImageMagick/ImageMagick/commit/ca3654ebf7a439dc736f56f083c9aa98e4464b7f)
- release [`4c0b7d2`](https://github.com/ImageMagick/ImageMagick/commit/4c0b7d25daf11131af48820b2aa6cc0b1cf11a9e)
- reset id [`83de35d`](https://github.com/ImageMagick/ImageMagick/commit/83de35d0ab6e5100450d604bf300670af7e1b3e8)

## [7.1.0-28](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-27...7.1.0-28) - 2022-03-20

### Merged

- Fix setting the pixel intensity method with SetImageProperty [`#4969`](https://github.com/ImageMagick/ImageMagick/pull/4969)
- fix issue: outside the range of representable values of type 'unsigned int' at coders/psd.c:1025 [`#4963`](https://github.com/ImageMagick/ImageMagick/pull/4963)

### Commits

- Coders: support 10-bit AVIF per https://github.com/ImageMagick/ImageMagick/discussions/4932 [`418e3f4`](https://github.com/ImageMagick/ImageMagick/commit/418e3f40dc7302dae664eaaf0ea4cd4b7b59f852)
- support grayscale and linear colorspaces [`298ac0b`](https://github.com/ImageMagick/ImageMagick/commit/298ac0bf3b2a00a4eda82934b6aae48e564ee7c5)
- MagickCore: support getentropy() [`b1027c8`](https://github.com/ImageMagick/ImageMagick/commit/b1027c855af1c8c29e07217b9216b1743d8004e0)
- build: release [`1627727`](https://github.com/ImageMagick/ImageMagick/commit/16277279886c57325d874e1acce04d979172a304)
- ... [`daef664`](https://github.com/ImageMagick/ImageMagick/commit/daef66469b28411755b42f000daa5c1dceec8697)
- Coders: eliminate compiler warnings [`8ed4f9a`](https://github.com/ImageMagick/ImageMagick/commit/8ed4f9a8d722e70d6072c374d4dccc9b5da50057)
- improve checking for conditional function arguments [`a1d46a8`](https://github.com/ImageMagick/ImageMagick/commit/a1d46a8566c5fb79583e82fec3a561402ff9cec1)
- Coders: https://github.com/ImageMagick/ImageMagick/issues/4947 [`8043433`](https://github.com/ImageMagick/ImageMagick/commit/8043433ba9ce0c550e09f2b3b6a3f5f62d802e6d)
- export libjxl version # [`4f15721`](https://github.com/ImageMagick/ImageMagick/commit/4f15721bb54adf029a3e6d2b44ec674a4ccbbcbf)
- https://github.com/ImageMagick/ImageMagick/issues/4927 [`d8624b4`](https://github.com/ImageMagick/ImageMagick/commit/d8624b4611882b4e15be6c22d306d56f1914056f)
- Coders: PS and EPS %%BoundingBox not being parsed #4961 [`35fdd9f`](https://github.com/ImageMagick/ImageMagick/commit/35fdd9f89aca2f8ec6c7b770641e0c5c2853eb47)
- Changed the format of MAGICK_GIT_REVISION and use this in -version. [`a7c4ca3`](https://github.com/ImageMagick/ImageMagick/commit/a7c4ca34d4e6670b3741027c2ad6dde931c92871)
- https://github.com/ImageMagick/ImageMagick/issues/4927 [`7441e31`](https://github.com/ImageMagick/ImageMagick/commit/7441e318c500975be5d55378e37c2f4695f0b864)
- Coders: proper check for out of bounds per https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=45640 [`ea43d4b`](https://github.com/ImageMagick/ImageMagick/commit/ea43d4b023e7b2fdbf8ff6d6fb23e7dd91add4c3)
- Coders: cosmetic [`0dadfa7`](https://github.com/ImageMagick/ImageMagick/commit/0dadfa75c7fa54f57d771f6c6f97b969863d2601)
- coders: sync JXL output [`9ca56be`](https://github.com/ImageMagick/ImageMagick/commit/9ca56be04a4229105e9cd20ccde47528a048f80f)
- Corrected name of the define. [`dfaeb2e`](https://github.com/ImageMagick/ImageMagick/commit/dfaeb2e05707f9bd4cff0cbdc4778b3bdb2b001f)
- correct date format [`301a801`](https://github.com/ImageMagick/ImageMagick/commit/301a8014ffe901739e20ef08098bb54120243cdc)
- no need to check for &lt; 0 [`69f805b`](https://github.com/ImageMagick/ImageMagick/commit/69f805b22c8c24fcd7c75587a0ad2fd53740dbb8)
- regenerate compare docs [`f9d988b`](https://github.com/ImageMagick/ImageMagick/commit/f9d988b415174751c3efd7acb4d8b3231d465572)
- getentropy() requires sys/random.h include [`b62bc9d`](https://github.com/ImageMagick/ImageMagick/commit/b62bc9dc24e6c59db3a3185b87def27ff02789d3)
- MagickCore: cosmetic [`08e77d2`](https://github.com/ImageMagick/ImageMagick/commit/08e77d21968bd9c7374692b46af51cd7a1ff1e3b)
- Corrected date format. [`a6f7e16`](https://github.com/ImageMagick/ImageMagick/commit/a6f7e1627f54cf08c883ec83988db424ff914fe0)
- Restore dds:compression=dxt5 behavior [`7dcb23a`](https://github.com/ImageMagick/ImageMagick/commit/7dcb23a29c6b1110c2c29f9862cf39b502a98982)
- Coders: https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=42549 [`a81927b`](https://github.com/ImageMagick/ImageMagick/commit/a81927b4801ffe7b2168c39588a3043d26d70df2)
- pending release [`b83772f`](https://github.com/ImageMagick/ImageMagick/commit/b83772f8cdc35f27aa669c9e15eb6b8ad0f98786)
- set pixel format in image out block [`e709dbf`](https://github.com/ImageMagick/ImageMagick/commit/e709dbf20aa1d025bfcf9bbe463ece3aa2f02125)

## [7.1.0-27](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-26...7.1.0-27) - 2022-03-04

### Commits

- auto-generate the change log from git commits [`67bc403`](https://github.com/ImageMagick/ImageMagick/commit/67bc40387b9270e28f911199bac2de577f828b42)
- https://github.com/ImageMagick/ImageMagick/issues/4876 [`17b8572`](https://github.com/ImageMagick/ImageMagick/commit/17b85720f0685d83797c3925a866f42971c23713)
- Code style changes. [`161b2bd`](https://github.com/ImageMagick/ImageMagick/commit/161b2bdc8221078fb84119fd64be9376979d5819)
- include reference to JXL coder source module [`18f7a0a`](https://github.com/ImageMagick/ImageMagick/commit/18f7a0afba8374f6b52053a383101d36aef0dab6)
- https://github.com/ImageMagick/ImageMagick/discussions/4862 [`9d74db9`](https://github.com/ImageMagick/ImageMagick/commit/9d74db9c45eb207c6c9d3f1ac762d05f0ae3bf86)
- The value is also utf8 when RegEnumValueW is used. [`9954343`](https://github.com/ImageMagick/ImageMagick/commit/995434350c3ac84cfeaaad0eeeb00483a0030110)
- https://github.com/ImageMagick/ImageMagick/issues/4874 [`3630e5c`](https://github.com/ImageMagick/ImageMagick/commit/3630e5c63e6188d037fd225d4073b001275dc830)
- Code style changes. [`fbb2bad`](https://github.com/ImageMagick/ImageMagick/commit/fbb2bad1388403d617fc87d72254ad86534de4a7)
- https://github.com/ImageMagick/ImageMagick/issues/4896 [`14a8a35`](https://github.com/ImageMagick/ImageMagick/commit/14a8a358452405e99dfa52e799ed37c02db316e6)
- https://github.com/ImageMagick/ImageMagick/issues/966 [`5c23779`](https://github.com/ImageMagick/ImageMagick/commit/5c2377996445ce1c3be00e78a08afde131fb813d)
- ... [`fe3a627`](https://github.com/ImageMagick/ImageMagick/commit/fe3a627b4a9f9c15ef8d34daefc08f5471681f4a)
- https://github.com/ImageMagick/ImageMagick/issues/4870 [`eb08826`](https://github.com/ImageMagick/ImageMagick/commit/eb0882667cddc4ea71b61a583a782c430220faf4)
- Removed one of the buffers. [`3be14c7`](https://github.com/ImageMagick/ImageMagick/commit/3be14c7f5b2ac83e078471e96a8fc393869f8c3e)
- improve "geometry does not contain image" exception message [`28be54d`](https://github.com/ImageMagick/ImageMagick/commit/28be54df1dbf9726ff9dd257955a1a78470e76f4)
- proper check for libjxl minimum version [`ccf788b`](https://github.com/ImageMagick/ImageMagick/commit/ccf788bd768a2ff75bb529d39bdcdfbeadeede23)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`4b1dc4c`](https://github.com/ImageMagick/ImageMagick/commit/4b1dc4cb1e91af85f5cf05da92588da7696ce3ed)
- More code style changes. [`0d2723e`](https://github.com/ImageMagick/ImageMagick/commit/0d2723e796313a72aceb73784d6d203c1bdfb477)
- Use RegEnumValueW instead. [`bfad2a3`](https://github.com/ImageMagick/ImageMagick/commit/bfad2a34d6fdcabda36cff83e49fe5320804dc9d)
- pending release [`b7174d2`](https://github.com/ImageMagick/ImageMagick/commit/b7174d211065e5b794cdb5ebc72f317124b2cd47)
- ... [`165327a`](https://github.com/ImageMagick/ImageMagick/commit/165327a5247525ccd0bea04b88114df86896cfee)
- Corrected adjoin check. [`ffaf35e`](https://github.com/ImageMagick/ImageMagick/commit/ffaf35e7dce75cf5492308ff90b1a38228e5c0bf)
- escape \n character [`624e514`](https://github.com/ImageMagick/ImageMagick/commit/624e5144d9b76789b51c8c24e002ea2c854bc406)
- https://github.com/ImageMagick/ImageMagick/issues/966 [`f6db6e0`](https://github.com/ImageMagick/ImageMagick/commit/f6db6e06dfabe0412d61b433b89efe5ad58d9b21)
- Only set system_root_length once. [`6fe9a5f`](https://github.com/ImageMagick/ImageMagick/commit/6fe9a5fe6e2ce2c8faccd6f2e609222ade42ac75)
- throw exception on reserved filename character (\xff) [`ee80bac`](https://github.com/ImageMagick/ImageMagick/commit/ee80bacc9d4c36c0405a46cd555e953a40fd129e)
- ... [`d2ad523`](https://github.com/ImageMagick/ImageMagick/commit/d2ad523daad137e04a148e0ab15fe044393206aa)
- https://github.com/ImageMagick/ImageMagick/issues/966 [`62a3cd5`](https://github.com/ImageMagick/ImageMagick/commit/62a3cd54416c067da75be895a27362a01aaebdc8)
- https://github.com/ImageMagick/ImageMagick/issues/4888 [`2fa2184`](https://github.com/ImageMagick/ImageMagick/commit/2fa218431d622f33da90a79c1a2f5f5750710fdc)
- cosmetic [`c1fe09e`](https://github.com/ImageMagick/ImageMagick/commit/c1fe09e3533d2b778f45d49f243e210dcb915cc7)
- https://github.com/ImageMagick/ImageMagick/issues/4888 [`5512240`](https://github.com/ImageMagick/ImageMagick/commit/5512240ff88749d9450d51aa977969a9ad321d6c)
- pending release [`dc2b955`](https://github.com/ImageMagick/ImageMagick/commit/dc2b9553e9b1e73ce264f41e5820a236db7403fd)
- Changed trigger for release. [`ccff96d`](https://github.com/ImageMagick/ImageMagick/commit/ccff96dfb318c906a396681a0dbfa12b08e1e90f)
- canonical copyright notice [`cd32501`](https://github.com/ImageMagick/ImageMagick/commit/cd32501e861b3755c116baa47fa879323e11cffd)
- ChangeLog =&gt; ChangeLog.md [`0b5cb6e`](https://github.com/ImageMagick/ImageMagick/commit/0b5cb6edef00d63af0904dbd955cb57f186f7e9f)
- Fixed memory leak in ThumbnailImage. [`47fed11`](https://github.com/ImageMagick/ImageMagick/commit/47fed11f7bae354cb40f1805aa9707faf593438c)

## [7.1.0-26](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-25...7.1.0-26) - 2022-02-21

### Merged

- Appropriate default kmin, kmax values for lossy and lossless into webp encoder [`#4846`](https://github.com/ImageMagick/ImageMagick/pull/4846)

### Commits

- ... [`f43aa87`](https://github.com/ImageMagick/ImageMagick/commit/f43aa87b45ac36dae42a33457603f2d67e5c4fbd)
- https://github.com/ImageMagick/ImageMagick/discussions/4856 [`717546e`](https://github.com/ImageMagick/ImageMagick/commit/717546e1e02660f471bd53bf6a5f83e62ff08f8c)
- Removed the xtrn coder. [`6a863cc`](https://github.com/ImageMagick/ImageMagick/commit/6a863ccebb6d777739fb8d9b5b3b78c868dafb82)
- rename method to TLS-moniker, thread local storage [`5775664`](https://github.com/ImageMagick/ImageMagick/commit/5775664a028c8fdd9fe9d99a4628d08ec57f424c)
- Removed NTGhostscriptDLL and NTGhostscriptLoadDLL from the private header. [`c27d494`](https://github.com/ImageMagick/ImageMagick/commit/c27d494351fcb8e5f1f69cceff27824122c4d0a2)
- remove reference to ImageMagickObject [`a7141eb`](https://github.com/ImageMagick/ImageMagick/commit/a7141eb10579909e1bf5070ebaf700182cbcf25a)
- Fixes for installation in a folder that contains non ASCII characters (#4382). [`9928afc`](https://github.com/ImageMagick/ImageMagick/commit/9928afc2c123f2be6720f5aaa5931978e6ca2e2e)
- https://github.com/ImageMagick/ImageMagick/discussions/4859 [`c1304c0`](https://github.com/ImageMagick/ImageMagick/commit/c1304c02317ba992dde535314c459ced1a463848)
- Changed copyright. [`05b88b4`](https://github.com/ImageMagick/ImageMagick/commit/05b88b46eac5f8929e3461e86748474d98c2e7ab)
- Use MagickBooleanType instead. [`fc3c6fb`](https://github.com/ImageMagick/ImageMagick/commit/fc3c6fbed9ba036bc3227b80a8ac36d30abbbedf)
- ... [`c2617e9`](https://github.com/ImageMagick/ImageMagick/commit/c2617e9a8de9e4a3c481956d647e12f09cec97f0)
- https://github.com/ImageMagick/ImageMagick/issues/4843 [`17eaebd`](https://github.com/ImageMagick/ImageMagick/commit/17eaebd2c1ffb42c1b1b5b17c2db12e19ec69d30)
- https://github.com/ImageMagick/ImageMagick/discussions/4856 [`66cb4f9`](https://github.com/ImageMagick/ImageMagick/commit/66cb4f91bc09b645f0ce3824a8469718d0cbc761)
- https://github.com/ImageMagick/ImageMagick/issues/4761 [`35b2e14`](https://github.com/ImageMagick/ImageMagick/commit/35b2e14d82ae87fe97b2a0e3f49cdd19d82c8f06)
- don't over-allocate thread-specific data [`7ff4ae1`](https://github.com/ImageMagick/ImageMagick/commit/7ff4ae104a9710407786c14223001ad4176d1331)
- ... [`702d55a`](https://github.com/ImageMagick/ImageMagick/commit/702d55a87c2b6dc5052a9a71bbbeba2b0b2fc619)
- adjust -extent geometry support for &lt; && &gt; [`3db22d0`](https://github.com/ImageMagick/ImageMagick/commit/3db22d038089abfdd3bff3ca4f0edc9158ac57e5)
- Changed copyright. [`0efff06`](https://github.com/ImageMagick/ImageMagick/commit/0efff06599dc6d08c30ec19a79c494d2a6607846)
- Removed xtrn coder. [`0d1b03d`](https://github.com/ImageMagick/ImageMagick/commit/0d1b03d3176d47e6f2e512bdc7968a9fa153189a)
- cosmetic [`f3a4813`](https://github.com/ImageMagick/ImageMagick/commit/f3a48131fad4067240698714eba044ca78236c8c)
- https://github.com/ImageMagick/ImageMagick/issues/4867 [`da3971c`](https://github.com/ImageMagick/ImageMagick/commit/da3971cb2ecde8856358e2221aec5b924467ef85)
- fix compiler exception under Cygwin [`ee54f8d`](https://github.com/ImageMagick/ImageMagick/commit/ee54f8dcf76a6c82b741cfdf8e0a7b4558671c9d)
- https://github.com/ImageMagick/ImageMagick/issues/4864 [`3663328`](https://github.com/ImageMagick/ImageMagick/commit/3663328cd031976250bb06cdcd78c1bdffbfe8b8)
- pending release [`893aea3`](https://github.com/ImageMagick/ImageMagick/commit/893aea3e3d8a102036e67cc0d97e351d69e5b6f6)
- cosmetic [`6f6caf2`](https://github.com/ImageMagick/ImageMagick/commit/6f6caf214b9cbfd008a8712a501a1e3e6a83b832)
- remove references to ImageMagickObject [`ccb6b35`](https://github.com/ImageMagick/ImageMagick/commit/ccb6b35068bfc9bdc7da309d8985cfd6644f8e71)
- Added option to allow specifying -dShowAnnots=false. [`60e8f2c`](https://github.com/ImageMagick/ImageMagick/commit/60e8f2ce8bdf0822cd59e1f898a984d79ef50690)
- pending release [`a6458f9`](https://github.com/ImageMagick/ImageMagick/commit/a6458f9b8b5805bab5ff781c3ae22baa05cd8494)
- pending release [`1363b1e`](https://github.com/ImageMagick/ImageMagick/commit/1363b1e1e27aac515305f0979541e23c0716932b)
- https://github.com/ImageMagick/ImageMagick/issues/4865 [`63a25b5`](https://github.com/ImageMagick/ImageMagick/commit/63a25b5f4f5c70a00b330c6fc36133903774752c)
- no need for conditional compile [`57be678`](https://github.com/ImageMagick/ImageMagick/commit/57be6784c1bea811aa35199f56e5cec9777946f0)
- add strimg image format [`86b1eb4`](https://github.com/ImageMagick/ImageMagick/commit/86b1eb465afe7be1de3a6baf16c535118855a22c)
- pending release [`50b7ec5`](https://github.com/ImageMagick/ImageMagick/commit/50b7ec519c4f07ffd8eb80fdd0aaa00d0e82b6d6)
- Raise exception when image could not be read but no exception was raised. [`f939c22`](https://github.com/ImageMagick/ImageMagick/commit/f939c225f2a62e4ba2d8d449f7ffa514a9aac500)
- pending release [`aa668b2`](https://github.com/ImageMagick/ImageMagick/commit/aa668b23d9f4804fe47761bb4ed65b6877cc0914)
- off-by-one fix [`352a9ab`](https://github.com/ImageMagick/ImageMagick/commit/352a9ab54ef228553d793c148c717d9f0beac864)
- ... [`31720fe`](https://github.com/ImageMagick/ImageMagick/commit/31720fee01114d59f6122ae2251f1452e0e9b67f)
- Removed unnecessary initialization. [`51cbb7d`](https://github.com/ImageMagick/ImageMagick/commit/51cbb7d8d8ceb70b111dee0a8d1cfe58a7914233)
- pending release [`0c5784d`](https://github.com/ImageMagick/ImageMagick/commit/0c5784d96b39e3ea78105b595dab1342bb963799)
- https://github.com/ImageMagick/ImageMagick/discussions/4755 [`0101c29`](https://github.com/ImageMagick/ImageMagick/commit/0101c2901a8c0922ef0dba06dca446efe38d8dd1)
- pending release [`4dfd217`](https://github.com/ImageMagick/ImageMagick/commit/4dfd21705173d2a6e3ca4b0a6723a6e1f48ef885)
- pending release [`78680f5`](https://github.com/ImageMagick/ImageMagick/commit/78680f51e98d6aecf25b0d9951de3d8122d3b871)

## [7.1.0-25](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-24...7.1.0-25) - 2022-02-15

### Commits

- Changed copyright headers. [`3ddbe16`](https://github.com/ImageMagick/ImageMagick/commit/3ddbe16bbe136160f4bbff3804a8423816974e57)
- Removed unused binary. [`a83ebfc`](https://github.com/ImageMagick/ImageMagick/commit/a83ebfcaf3eb79fa846718af70df6b978c8ed946)
- cosmetic [`0e22666`](https://github.com/ImageMagick/ImageMagick/commit/0e2266611121c1eab597a5051fd4cb37d5300e2d)
- https://github.com/ImageMagick/ImageMagick/issues/4841 [`0fec6dc`](https://github.com/ImageMagick/ImageMagick/commit/0fec6dca6c990038c7f275f04b3e6829c9aea95a)
- ... [`191fd98`](https://github.com/ImageMagick/ImageMagick/commit/191fd9864aa54bde02bf1863bc306fbe24843f64)
- Corrected copyright header. [`678fb88`](https://github.com/ImageMagick/ImageMagick/commit/678fb8880e29819d30e5e35b73eafddc9cd9b461)
- Corrected header. [`8960f4d`](https://github.com/ImageMagick/ImageMagick/commit/8960f4d9433627848550f86cecedbad6f5bd4a34)
- https://github.com/ImageMagick/ImageMagick/issues/4837 [`a833062`](https://github.com/ImageMagick/ImageMagick/commit/a8330620ca1695f35bd8a8b07245b78cbe21880b)
- Added missing copyright and header. [`de8c61d`](https://github.com/ImageMagick/ImageMagick/commit/de8c61dc8d2492219397c312653128109d3c7c1f)
- fix unitialized value [`1931a77`](https://github.com/ImageMagick/ImageMagick/commit/1931a7732fb7488d1c7d992ccdb1dffd026aeb5d)
- off-by-one fix [`7f7c905`](https://github.com/ImageMagick/ImageMagick/commit/7f7c90526187ddd560d2a511cde2d9b9acef4fb1)
- Corrected header style. [`18f5a8f`](https://github.com/ImageMagick/ImageMagick/commit/18f5a8fca87fb6dbb204e1c62a426df61842e055)
- pending release [`14e94c3`](https://github.com/ImageMagick/ImageMagick/commit/14e94c311502613805a8973de2dc1d6958858d80)
- display last debugging character [`7fd967e`](https://github.com/ImageMagick/ImageMagick/commit/7fd967ef5e60ac3a814a3b34fc87c48c59dae3a9)
- Removed unnecessary variable. [`6b246ff`](https://github.com/ImageMagick/ImageMagick/commit/6b246ffd6e4c92076c44a75c77d535f861368074)
- Corrected length check. [`a563804`](https://github.com/ImageMagick/ImageMagick/commit/a5638045db7c13d2e8a86e51a4b339080f03d5cc)
- https://github.com/ImageMagick/ImageMagick/issues/4822 [`111d4e4`](https://github.com/ImageMagick/ImageMagick/commit/111d4e4aae5b27bff8a9028b2ad230bc89a57039)
- off-by-one fix [`56f1643`](https://github.com/ImageMagick/ImageMagick/commit/56f1643600448447dbdb6c03716ec9474153c43b)
- one off when debugging [`869315d`](https://github.com/ImageMagick/ImageMagick/commit/869315df81a6c70f339e58e55eccef7c4fb19cc7)
- Removed ImageMagickObject because we no longer support this. [`61dcc55`](https://github.com/ImageMagick/ImageMagick/commit/61dcc55d596e8e241841cb3b9088fd9f55a154e7)
- alpha is never zero [`8d33dd8`](https://github.com/ImageMagick/ImageMagick/commit/8d33dd8dd63729d0cb9ceb7432cadeca69beab17)
- revert [`7d5e159`](https://github.com/ImageMagick/ImageMagick/commit/7d5e159ed8872c1ce51f1b89b4027689fb80e3a0)

## [7.1.0-24](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-23...7.1.0-24) - 2022-02-12

### Commits

- Changed copyright headers. [`8891ec1`](https://github.com/ImageMagick/ImageMagick/commit/8891ec1db10a70558deef45f61941b4fe0576b66)
- Added copyright headers. [`78e4a56`](https://github.com/ImageMagick/ImageMagick/commit/78e4a56a833cd64f1676bf54847409cae1debaf4)
- Changed copyright headers. [`2056a1f`](https://github.com/ImageMagick/ImageMagick/commit/2056a1f77255bd551926f18ec321063d5c2ee195)
- possible performance optimization [`4a8a0d4`](https://github.com/ImageMagick/ImageMagick/commit/4a8a0d4f26b828532f266143d9dd3b8ca6fb52ac)
- Removed reverences to travis. [`aa1806d`](https://github.com/ImageMagick/ImageMagick/commit/aa1806d1f437958cd847692d3c781bdd4c9a22e2)
- prefer performance over quality [`75d1dbf`](https://github.com/ImageMagick/ImageMagick/commit/75d1dbf70f63ae365e3359d4b8c473a546d68bca)
- https://github.com/ImageMagick/ImageMagick/discussions/4813 [`cadfcdd`](https://github.com/ImageMagick/ImageMagick/commit/cadfcdd11829197ed415177ef00a61921add7345)
- ... [`8c52d6f`](https://github.com/ImageMagick/ImageMagick/commit/8c52d6fa50d7c39ea4446d416640e29dada61996)
- https://github.com/ImageMagick/ImageMagick/issues/4830 [`b3fc034`](https://github.com/ImageMagick/ImageMagick/commit/b3fc034f37ffe46c8314fae42acbd6c6a11b9da5)
- Changed copyright headers. [`67beeff`](https://github.com/ImageMagick/ImageMagick/commit/67beeff5d03c194d0c846632c124905a56324625)
- cosmetic [`68eb33f`](https://github.com/ImageMagick/ImageMagick/commit/68eb33f7660a78ff22daec7a60265db15e3e46fe)
- correct copyright year [`2652397`](https://github.com/ImageMagick/ImageMagick/commit/26523979fc9cb29e586b3e668e1fc6e075fc235e)
- optimize reading of XPM properties [`f578dad`](https://github.com/ImageMagick/ImageMagick/commit/f578dad6151beb51747e7928770975ccddf064b6)
- cosmetic [`4f923a8`](https://github.com/ImageMagick/ImageMagick/commit/4f923a83f2acf86eb56399442223513dcd2aa503)
- Removed IsAVI check (#4819). [`a1c342c`](https://github.com/ImageMagick/ImageMagick/commit/a1c342c04916670b4a1f161a29d24e9c04c4108d)
- Removed unused flags. [`73b1d1d`](https://github.com/ImageMagick/ImageMagick/commit/73b1d1d2d45566f69697e0402508d73946c45359)
- Corrected UTF-16 big endian encoding (#4771). [`1d8b675`](https://github.com/ImageMagick/ImageMagick/commit/1d8b67552892fd3f1342a31f189305fb6b073165)
- remove debugging statement [`e69f2b1`](https://github.com/ImageMagick/ImageMagick/commit/e69f2b1413f1a9f2d5518aad13debacbe5b32195)
- Code style changes. [`1b9c0c9`](https://github.com/ImageMagick/ImageMagick/commit/1b9c0c96e41e48dd26ed2ebbaac36382d249ae96)
- invalid free memory on NULL pointer [`4b03774`](https://github.com/ImageMagick/ImageMagick/commit/4b0377467fb3e1864ccd91c54393ca5d9bdeb3db)
- Use GetPixelInfo instead. [`3eb643b`](https://github.com/ImageMagick/ImageMagick/commit/3eb643b7fe36d4a5200afe1e11e79dab48ddc5c4)
- pending release [`e5eed1c`](https://github.com/ImageMagick/ImageMagick/commit/e5eed1ca1a43df880c8a851a1c49b3cbb31510b1)
- revert [`503333f`](https://github.com/ImageMagick/ImageMagick/commit/503333f87ae676f5e327d83e10def04b3ecee5ab)
- https://github.com/ImageMagick/ImageMagick/issues/4822 [`acc0934`](https://github.com/ImageMagick/ImageMagick/commit/acc0934a25ca392823d3d90febeb093c4ce9f2f0)
- prevent integer overflow [`32ce1ca`](https://github.com/ImageMagick/ImageMagick/commit/32ce1ca9b0746a592461e2cafc134d7a3eecbe54)
- Removed RIFF header to avoid issues with WEBP images (#4819). [`4c156f2`](https://github.com/ImageMagick/ImageMagick/commit/4c156f21b3f6ece862b85bdef6062b6bfd1d7c71)
- eliminate compiler warning [`0595255`](https://github.com/ImageMagick/ImageMagick/commit/0595255bde9edab97da3331f90b7489bc92ca6dc)
- Removed method that has been renamed. [`f8a1cf9`](https://github.com/ImageMagick/ImageMagick/commit/f8a1cf9eae09a52a63609bcacfa3c36bbf6cd4ac)
- update copyright year [`80629df`](https://github.com/ImageMagick/ImageMagick/commit/80629dfb3fea55eefa2dd8bdd9ca1be341502e16)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=44457 [`a9bd4c0`](https://github.com/ImageMagick/ImageMagick/commit/a9bd4c0e16d034f733c93d5d1b022f9e5f78e70e)
- Removed empty header file. [`f5f9030`](https://github.com/ImageMagick/ImageMagick/commit/f5f90302c9d3fd9a987fda8f8cddbd6ede4cf697)
- Fixed build error. [`15f9463`](https://github.com/ImageMagick/ImageMagick/commit/15f9463eed4b4affd9dd3031d00e86c8f6b4753d)
- Set the alpha_trait of the pixel in the colormap. [`07559b5`](https://github.com/ImageMagick/ImageMagick/commit/07559b540a0c3311bebe8a6948492fcf0101f06b)
- Also set the colorspace in the colormap. [`2ec7d4c`](https://github.com/ImageMagick/ImageMagick/commit/2ec7d4cbf8b7d13a2a0afe12e1af3df8cb59b51a)
- https://github.com/ImageMagick/ImageMagick/issues/4828 [`3e2b04a`](https://github.com/ImageMagick/ImageMagick/commit/3e2b04a63c564aa4f2ce1da45a7346a59d15c0a2)
- remove debugging statement [`38a2625`](https://github.com/ImageMagick/ImageMagick/commit/38a2625f094c42ac1c62ace34b5c560b8dbfd026)

## [7.1.0-23](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-22...7.1.0-23) - 2022-02-05

### Merged

- Make MagickSet/GetSamplingFactors() use ':' instead of ',' [`#4794`](https://github.com/ImageMagick/ImageMagick/pull/4794)

### Commits

- Moved setting the resolution info from the exif/tiff properties to a separate method. [`7df7426`](https://github.com/ImageMagick/ImageMagick/commit/7df7426ad3a5f7753198fded7d22603370987c03)
- Parse the image info once for all the frames. [`2488fc5`](https://github.com/ImageMagick/ImageMagick/commit/2488fc552ea38f34d7b5463cc81769f50dabff71)
- Renamed struct. [`49edbf0`](https://github.com/ImageMagick/ImageMagick/commit/49edbf034d00512a5e2022cf12d46ff1baf13586)
- The properties can only be deleted after they have been used. [`715cf34`](https://github.com/ImageMagick/ImageMagick/commit/715cf341e699bf928d06e23c2964c3d5b5122471)
- ... [`419dd8d`](https://github.com/ImageMagick/ImageMagick/commit/419dd8de4432beafd827339ca0595895db8ce032)
- Moved sync of orientation to a separate method. [`c3839eb`](https://github.com/ImageMagick/ImageMagick/commit/c3839ebf2fa4d75d8899e68acab892953f8cf553)
- Added extra option to also disable syncing from tiff. [`59ccfd7`](https://github.com/ImageMagick/ImageMagick/commit/59ccfd7425f367c53e9aeb0c7cfbde820086f2f7)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=44424 [`7069862`](https://github.com/ImageMagick/ImageMagick/commit/70698622896fc9b045527740952b4627a352e119)
- https://github.com/ImageMagick/ImageMagick/issues/4793 [`6d69fce`](https://github.com/ImageMagick/ImageMagick/commit/6d69fceff3d6a30d8c7a1b7fd6702d9febcf9bd7)
- apply the Fx expression to each image in the sequence [`c516ca8`](https://github.com/ImageMagick/ImageMagick/commit/c516ca8d21c1c2b6b0223b259cfc1f572d343e99)
- Moved declaration of variables. [`1980a3b`](https://github.com/ImageMagick/ImageMagick/commit/1980a3b0faa63159b19a3ba769dbc5f94a886d38)
- exit MVG parser realy if clipping path fails to render [`a628a09`](https://github.com/ImageMagick/ImageMagick/commit/a628a0918de7fa4c54fb84c036775ed6d92d84a8)
- ... [`51f487a`](https://github.com/ImageMagick/ImageMagick/commit/51f487aaab80518d5f601002bd818e8588b6b439)
- cosmetic [`3fbdf95`](https://github.com/ImageMagick/ImageMagick/commit/3fbdf95d043aed30d7a6aa4fd9b3f68519f3c49f)
- Use read_info instead of image_info. [`b38ab1e`](https://github.com/ImageMagick/ImageMagick/commit/b38ab1e28668bbfb7f39373f05b4906ae66b93ef)
- small memory leak if images exceed list length [`ce5c2b1`](https://github.com/ImageMagick/ImageMagick/commit/ce5c2b1847cbc90df68b0985cb99e3cf5f852813)
- release [`038f317`](https://github.com/ImageMagick/ImageMagick/commit/038f31702e52b5c87254e96b10cb1490d92152a0)
- pending release [`48edb6a`](https://github.com/ImageMagick/ImageMagick/commit/48edb6a2b5e6771354284870667ce0d9c379e6c5)
- https://github.com/ImageMagick/ImageMagick/issues/4790 [`b51707c`](https://github.com/ImageMagick/ImageMagick/commit/b51707c08f3dee192d464d38fc507c86051e62e6)
- check if image extent is NaN [`94650bc`](https://github.com/ImageMagick/ImageMagick/commit/94650bc4f10a5bb49e16c0f766adcb0db5f04a41)
- Corrected setting delay instead. [`2adce17`](https://github.com/ImageMagick/ImageMagick/commit/2adce170469980ba2b0d4f33947fa6be3495e732)
- avoid deep recursion [`a42870a`](https://github.com/ImageMagick/ImageMagick/commit/a42870a846d9471ac696475cc3aaabea8c76d6d5)
- ... [`4b4f4c3`](https://github.com/ImageMagick/ImageMagick/commit/4b4f4c381367a83f03959493be622b77abd9117c)
- Corrected copy paste mistake. [`c9e20a4`](https://github.com/ImageMagick/ImageMagick/commit/c9e20a4623da788cc2f3f3c316e9456fb7aec41d)
- Code style change. [`a6c2928`](https://github.com/ImageMagick/ImageMagick/commit/a6c292867872458731a827dc42aaeb4006a086fd)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=44401 [`a987a8a`](https://github.com/ImageMagick/ImageMagick/commit/a987a8ae4b7e7a1c0f3fc14f53ebbce86230ca47)
- https://github.com/ImageMagick/ImageMagick/issues/4807 [`d61dd34`](https://github.com/ImageMagick/ImageMagick/commit/d61dd34fe01ee2c48d81932124e1a913ed477c89)
- https://github.com/ImageMagick/ImageMagick/issues/4807 [`9492d1f`](https://github.com/ImageMagick/ImageMagick/commit/9492d1faaee3adeaa270428814844bc72f16f200)

## [7.1.0-22](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-21...7.1.0-22) - 2022-01-29

### Commits

- bump patch level version [`d2ce572`](https://github.com/ImageMagick/ImageMagick/commit/d2ce5721f36572fb80c7a4df8ccec83a399f15ee)
- permit compositing MPRI images [`5aaf162`](https://github.com/ImageMagick/ImageMagick/commit/5aaf16278f79d2c4e51fd9b75cbe198b8949c407)
- Corrected MPRI fix. [`2c2d1d8`](https://github.com/ImageMagick/ImageMagick/commit/2c2d1d842845a85933c5bbd8b269e305cabdc130)
- permit compositing MPRI images [`cb0ac90`](https://github.com/ImageMagick/ImageMagick/commit/cb0ac90228fdc388cbb724ca68f9afc3619a3d05)
- Only check the path when filename is specified. [`417f4fb`](https://github.com/ImageMagick/ImageMagick/commit/417f4fb9cef7b37aafccd686efd3635202b33d9a)
- pending release [`3eb8a9b`](https://github.com/ImageMagick/ImageMagick/commit/3eb8a9b78e03510542f7d8a7e4d77fd7055d12da)
- check for excessive color name length [`d3b7cdb`](https://github.com/ImageMagick/ImageMagick/commit/d3b7cdbecc0bca9a4eba59e7837830e8acd0b0e9)
- pending release [`c10371d`](https://github.com/ImageMagick/ImageMagick/commit/c10371db6c8363d76f204877110d1d0980502ce8)
- restore MPRI URI [`9651500`](https://github.com/ImageMagick/ImageMagick/commit/9651500e10cb2f7dcf014b2d244753988817ad0b)

## [7.1.0-21](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-20...7.1.0-21) - 2022-01-28

### Merged

- msl coder: add support for autoorient [`#4745`](https://github.com/ImageMagick/ImageMagick/pull/4745)

### Commits

- Cleanup file to use our coding style. [`9b3f50f`](https://github.com/ImageMagick/ImageMagick/commit/9b3f50f6664be6568e47a83a6ac1e5f9b487332b)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`4c96061`](https://github.com/ImageMagick/ImageMagick/commit/4c960619700ed551d92bc137df4c60c83699866c)
- It's a new dawn; It's a new day; It's a new life; For ImageMagick [`03ddd19`](https://github.com/ImageMagick/ImageMagick/commit/03ddd19cfd5a3937aecef34e2173f47c9f2f4825)
- check for excessive memory request when drawing [`1496901`](https://github.com/ImageMagick/ImageMagick/commit/1496901aea4d6de5bc5c1051a423e95a80d77995)
- https://github.com/ImageMagick/ImageMagick/issues/4761 [`cdb8e3f`](https://github.com/ImageMagick/ImageMagick/commit/cdb8e3f6e5b2268621ae1317addc7941676a9aab)
- https://github.com/ImageMagick/ImageMagick/issues/4766 [`62845d5`](https://github.com/ImageMagick/ImageMagick/commit/62845d5672eca4446b952dd0ab2e3e0dab0309d4)
- promote blocksize from int to ssize_t [`7347fb3`](https://github.com/ImageMagick/ImageMagick/commit/7347fb36cafe764d9d67c66adf3d80a6c784d22e)
- https://github.com/ImageMagick/ImageMagick/discussions/4533#discussioncomment-20 [`ae90a62`](https://github.com/ImageMagick/ImageMagick/commit/ae90a6229bc6216a728879b18d11c01e34bdbf0a)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`a0b049f`](https://github.com/ImageMagick/ImageMagick/commit/a0b049ff449a3b2f8a673b97d77ea7458b580df6)
- ... [`7ba9959`](https://github.com/ImageMagick/ImageMagick/commit/7ba995934e985d22340fddcfc79767d95291c93b)
- PDF unicode title [`f084a86`](https://github.com/ImageMagick/ImageMagick/commit/f084a86ecaf9737af86f242d68d5e9cf25a61144)
- pending release [`2b1d06d`](https://github.com/ImageMagick/ImageMagick/commit/2b1d06d650782c55263ff5bbb8aad65b45775b97)
- pending release [`622ed89`](https://github.com/ImageMagick/ImageMagick/commit/622ed89edc6d1e38025a72df388f0845fa5e8da6)
- for debug(), print channels in array style, e.g. [1] [`2cee06e`](https://github.com/ImageMagick/ImageMagick/commit/2cee06e61fd6a104c7a386775e769c79f2176169)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=43967 [`2df3d01`](https://github.com/ImageMagick/ImageMagick/commit/2df3d0124b6e1b12c01421c1d5ed60143125af5f)
- pending release [`ddc7540`](https://github.com/ImageMagick/ImageMagick/commit/ddc75409693fa681446d39e2cf9929780631e848)
- Added missing version check. [`7cc55cc`](https://github.com/ImageMagick/ImageMagick/commit/7cc55cc5e5a666e17287c81e2f40d1b79be410f4)
- https://github.com/ImageMagick/ImageMagick/issues/4771 [`e035b46`](https://github.com/ImageMagick/ImageMagick/commit/e035b46ae5802754075b9abd7aa577d1006ab545)
- eliminate compiler warning [`03470b4`](https://github.com/ImageMagick/ImageMagick/commit/03470b4bf61f4805668812d78df83fdfb8c53bc5)
- Silenced warning. [`df88116`](https://github.com/ImageMagick/ImageMagick/commit/df88116c3eea2f7e3ba073570cb5573c57186ad7)

## [7.1.0-20](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-19...7.1.0-20) - 2022-01-22

### Merged

- Fix wrong logic when compare two float values with '==" directly [`#4723`](https://github.com/ImageMagick/ImageMagick/pull/4723)
- Support 'msf1' support in heic.c [`#4701`](https://github.com/ImageMagick/ImageMagick/pull/4701)
- QOI fixes [`#4665`](https://github.com/ImageMagick/ImageMagick/pull/4665)
- Added support for QOI format [`#4653`](https://github.com/ImageMagick/ImageMagick/pull/4653)

### Commits

- https://github.com/ImageMagick/ImageMagick/discussions/4533#discussioncomment-2012423 [`d6b1d74`](https://github.com/ImageMagick/ImageMagick/commit/d6b1d74cbd6967e070ee5a614cc0b37dbfb4a662)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`12dc47a`](https://github.com/ImageMagick/ImageMagick/commit/12dc47a56b402472e018ca6710705132566c1dcc)
- cosmetic [`86142bd`](https://github.com/ImageMagick/ImageMagick/commit/86142bdc2932550ec121081ff0f3359a34cd15cc)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`1c5e6e1`](https://github.com/ImageMagick/ImageMagick/commit/1c5e6e1b80dacc6c7410ae464da440e6ed3ca5bc)
- precedence bug, now fixed [`0d9b7a6`](https://github.com/ImageMagick/ImageMagick/commit/0d9b7a60617849f55014d619306dc34ae77eb062)
- eliminate compiler warnings [`4f37566`](https://github.com/ImageMagick/ImageMagick/commit/4f37566212b7cd0dab0cd64df5b2666b2462e5a0)
- https://github.com/ImageMagick/ImageMagick/discussions/4515 [`444045d`](https://github.com/ImageMagick/ImageMagick/commit/444045d683bc7fb26c9f912f67917c8149fa769b)
- support saliency blend composite op [`ed1b215`](https://github.com/ImageMagick/ImageMagick/commit/ed1b215781d5a1202bfe3e068357a60e70e1974c)
- support seamless blending of a foreground and background image [`104fede`](https://github.com/ImageMagick/ImageMagick/commit/104fede6e66a2af7ff45ee07d318cd49ca073e0c)
- cosmetic [`6253a76`](https://github.com/ImageMagick/ImageMagick/commit/6253a76ab0bda5d5c1544ecda9db2b6f2726cb8e)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`9420e11`](https://github.com/ImageMagick/ImageMagick/commit/9420e11f33e7c5d4c64567b1c192bab14b5864a1)
- Code style changes. [`a819f8e`](https://github.com/ImageMagick/ImageMagick/commit/a819f8efbe1a2b57eab3baee1171e11200e118dc)
- don't blur the foreground object [`4719503`](https://github.com/ImageMagick/ImageMagick/commit/471950301a62ef7ac4a0de85817b238dd9beb9d1)
- Added missing comments and fixed the IsQOI implementation. [`98994d0`](https://github.com/ImageMagick/ImageMagick/commit/98994d0fd74014e81839b08f832c795d8532a0c9)
- https://github.com/ImageMagick/ImageMagick/pull/4653 [`57bc254`](https://github.com/ImageMagick/ImageMagick/commit/57bc2540bc42f4a05747a8bbf57c41609b091765)
- framework for saliency blending composite op [`e137239`](https://github.com/ImageMagick/ImageMagick/commit/e13723901f184a8cf1df8dc3c5859e8f4a901fc6)
- only mask portions of alpha channel [`7d87b21`](https://github.com/ImageMagick/ImageMagick/commit/7d87b215eca34dc4ce9ec6a0f1127f5885322eb7)
- revert for now [`57e0828`](https://github.com/ImageMagick/ImageMagick/commit/57e08283fb2f0498366f1c5fa01e9aeed3833af8)
- Fixed build errors. [`67b7057`](https://github.com/ImageMagick/ImageMagick/commit/67b70572c269db276a04300145773063e41ccb67)
- https://github.com/ImageMagick/ImageMagick/discussions/4533#discussioncomment-2001819 [`2606211`](https://github.com/ImageMagick/ImageMagick/commit/260621179f340cd8be4c0251004061c2e861d26f)
- thread seamless blending [`5eb6905`](https://github.com/ImageMagick/ImageMagick/commit/5eb6905d1b4e03c92e65bf22886ccc145f21c037)
- cosmetic [`3d8da65`](https://github.com/ImageMagick/ImageMagick/commit/3d8da65b5ac16d730fdd3f6ebbfbce91262e8026)
- support mask image for seamless blending [`d90a154`](https://github.com/ImageMagick/ImageMagick/commit/d90a154e9a6e557a8c211ece8ee60b9d8f2099b1)
- Added method to make it more clear why we have a quantum depth check. [`555ed1d`](https://github.com/ImageMagick/ImageMagick/commit/555ed1d6e0cc50e6c2fa697e7796a807bd27a2c7)
- https://github.com/ImageMagick/ImageMagick/issues/4629 [`6221134`](https://github.com/ImageMagick/ImageMagick/commit/62211342165a1179af752818764944c917c7de26)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`f54aa4e`](https://github.com/ImageMagick/ImageMagick/commit/f54aa4e7ba8a8fb82d200844dc59804f5f6c8cbf)
- Build ImageMagick on Windows with VisualStudio 2022 instead. [`7a16ce0`](https://github.com/ImageMagick/ImageMagick/commit/7a16ce07b57ddda9fc7643860069fe104e6a0f75)
- Removed printf to sderr. [`ded93a9`](https://github.com/ImageMagick/ImageMagick/commit/ded93a9e88b8b446abe4d9970fd672fcc80a5e04)
- Added option to force using pam as the intermediate video format. [`4a0226a`](https://github.com/ImageMagick/ImageMagick/commit/4a0226a0b05795da1b9f018d4322c7aaf314e41b)
- check for runlength overrun [`4149bcd`](https://github.com/ImageMagick/ImageMagick/commit/4149bcde427b331fdfc2cb16c6ded991cd8315cc)
- Silenced warnings on Windows. [`31bf1f2`](https://github.com/ImageMagick/ImageMagick/commit/31bf1f23534892244c94c13cd7e3ed23091c5073)
- respect -verbose for seamless blending [`c6de626`](https://github.com/ImageMagick/ImageMagick/commit/c6de626f2c2ed6c829a3a87fb961838458c787d7)
- fix memory leak for empty Fx expression [`db160de`](https://github.com/ImageMagick/ImageMagick/commit/db160dea48c932241b084efe6421e07700066a34)
- permit 4GB blocks [`c05a26d`](https://github.com/ImageMagick/ImageMagick/commit/c05a26d41177de18191ce595f78d0d64e573a9d3)
- eliminate compiler warnings [`457ad2f`](https://github.com/ImageMagick/ImageMagick/commit/457ad2f58daf38a177ea6d08eff89afb17e27e01)
- ... [`bc39ec6`](https://github.com/ImageMagick/ImageMagick/commit/bc39ec6f0c977dfd2a6aacc334e4143f56e97dd3)
- improved fix for possible DoS for certain SVG constructs [`f460242`](https://github.com/ImageMagick/ImageMagick/commit/f4602423ad9dc1f1b70f3b851c867925cab7d17c)
- account for floating point when comparing alpha values [`8a4791c`](https://github.com/ImageMagick/ImageMagick/commit/8a4791c9840d1926c3ae7cbb81e8b996ee1d1e8c)
- https://github.com/ImageMagick/ImageMagick/issues/4704 [`14ee325`](https://github.com/ImageMagick/ImageMagick/commit/14ee32548b8f9143317ebc30436f7adfa7e42c78)
- revert composite masking change [`0c02614`](https://github.com/ImageMagick/ImageMagick/commit/0c026146f2de66641919976bafd02641592dba03)
- AVIF is supported by the HEIC coder [`1b89b2b`](https://github.com/ImageMagick/ImageMagick/commit/1b89b2b729238758a98c596c256a1d5753fa5670)
- make const [`d914d77`](https://github.com/ImageMagick/ImageMagick/commit/d914d779f7ad3bc5db2533c6e103925dd933626e)
- https://github.com/ImageMagick/ImageMagick/issues/4639 [`de0e304`](https://github.com/ImageMagick/ImageMagick/commit/de0e304d9ca8c6d0365692e26ea0cef4d4f7d02c)
- eliminate Windows compiler warnings [`72043e9`](https://github.com/ImageMagick/ImageMagick/commit/72043e927b891e301f447298802c5462f0b43904)
- Silenced warning. [`26d792a`](https://github.com/ImageMagick/ImageMagick/commit/26d792a4de80a3a33ca1398b4ffb75e923efcd04)
- support writing gray and colormapped images [`6fee782`](https://github.com/ImageMagick/ImageMagick/commit/6fee7820d3959196fe683112b075bd8da36b3df6)
- seamless blending works for non-HRDI but is less effective [`04fe3b0`](https://github.com/ImageMagick/ImageMagick/commit/04fe3b0c862d3739193527042df6e9d6862551c2)
- seamless blending requires the HDRI feature [`12db194`](https://github.com/ImageMagick/ImageMagick/commit/12db1942902aa2ec3c59e252806bb61623ed02df)
- update built-in delegates [`91b5044`](https://github.com/ImageMagick/ImageMagick/commit/91b504436ea48f362137242dfb9ec90098fab04a)
- https://github.com/ImageMagick/ImageMagick/issues/4704 [`f524d98`](https://github.com/ImageMagick/ImageMagick/commit/f524d98a7693602d671af2d80be5a352d2e08f2d)
- distinquish foreground object with read mask [`8940d00`](https://github.com/ImageMagick/ImageMagick/commit/8940d001988c0b92243411092a3d298c7438bb88)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`10ef22c`](https://github.com/ImageMagick/ImageMagick/commit/10ef22c64a1e7789fc03fa323823ed331d076de3)
- https://github.com/ImageMagick/ImageMagick/issues/4681 [`dc2f71d`](https://github.com/ImageMagick/ImageMagick/commit/dc2f71d3672c7fc8eaf22c6ca0a182a2dbed773a)
- composite crop with relaxed [`b119ff5`](https://github.com/ImageMagick/ImageMagick/commit/b119ff59ffcacb5480f97cd08f1ebf596324401f)
- set image type to linear or non-linear RGB before checking quantum type [`f718d82`](https://github.com/ImageMagick/ImageMagick/commit/f718d82aa82c623cbd4826c72308a35557efa6c9)
- only print select iterations [`d307949`](https://github.com/ImageMagick/ImageMagick/commit/d3079499851338ad7c6b5f6365f90421d3840754)
- the FLIF library is no longer being maintained, change to opt-in [`b31cab4`](https://github.com/ImageMagick/ImageMagick/commit/b31cab4783aa9c90124e04f4fd7b326335ff0447)
- https://github.com/ImageMagick/ImageMagick/issues/4679 [`50780da`](https://github.com/ImageMagick/ImageMagick/commit/50780da98acdb8b427bc589a6e3637308d7f9fd9)
- eliminate "declaration of 'p' hides previous local declaration" warning [`def69fd`](https://github.com/ImageMagick/ImageMagick/commit/def69fd7bee47398269378be88d16e8be4328c7a)
- revert [`86aa371`](https://github.com/ImageMagick/ImageMagick/commit/86aa371142b4c6b110acf88cbabb146513279a5c)
- Added checks for invalid PSD channel size. [`7adbd99`](https://github.com/ImageMagick/ImageMagick/commit/7adbd9998130d5d3014bd6a3ed58d93f24b06987)
- print last iteration residual [`9ef6c1c`](https://github.com/ImageMagick/ImageMagick/commit/9ef6c1cc35bfa2d53b5ccce37f5866ea5b866623)
- sums require a double type [`b6d4849`](https://github.com/ImageMagick/ImageMagick/commit/b6d484960b84e0c31ba56bbd589c02b753086026)
- Style changes. [`d8aa7be`](https://github.com/ImageMagick/ImageMagick/commit/d8aa7be021d7700539e4f7528f417ed45bc2922a)
- Moved ping exit. [`cb62455`](https://github.com/ImageMagick/ImageMagick/commit/cb62455a1d86b7cd13bb6fd3df29583f314caaef)
- eliminate rare memory leak [`647d129`](https://github.com/ImageMagick/ImageMagick/commit/647d1294b47f6b79a5369b39a91a7e188e598445)
- Changed the build of configure to 64-bit. [`5f99f02`](https://github.com/ImageMagick/ImageMagick/commit/5f99f02fef37e8d04f90c30aab9c59c128d0fe46)
- Silenced warning. [`29bb2fb`](https://github.com/ImageMagick/ImageMagick/commit/29bb2fb0917d7b72dc3b62d4fe6d716d96fc496e)
- Set depth and colorspace before the width and height are checked. [`e67a3e2`](https://github.com/ImageMagick/ImageMagick/commit/e67a3e24f8f8c76f74af0ac539878c83a72f7265)
- Revert useless patch because the image will get destroyed. [`9de7a82`](https://github.com/ImageMagick/ImageMagick/commit/9de7a828e6a945a08fb1acbd3d40f4649aad0fa7)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`08cc32b`](https://github.com/ImageMagick/ImageMagick/commit/08cc32b451fb151bb41d026bffe39c9721a83657)
- Raise exception instead of printing to stderr. [`58d1336`](https://github.com/ImageMagick/ImageMagick/commit/58d1336cce69f3202ca41e8889c59c9455afb3df)
- Fixed Windows build. [`566a4ca`](https://github.com/ImageMagick/ImageMagick/commit/566a4ca03c2353739deb75c9d3c20cbc336e658b)
- declaration hides previous local declaration [`22c7591`](https://github.com/ImageMagick/ImageMagick/commit/22c75910e8951328de801b2875b70b37ce5e6731)
- Silenced warnings. [`27c7eed`](https://github.com/ImageMagick/ImageMagick/commit/27c7eedcb0f287d6cbeea20969e78227954d54c9)
- Removed unused variable. [`4048fd6`](https://github.com/ImageMagick/ImageMagick/commit/4048fd670ce5e5f3bef5a7bf6d2e16a22cefe266)
- Added step to install InnoSetup. [`d4de816`](https://github.com/ImageMagick/ImageMagick/commit/d4de816bc1ba88a2dea9ba6beb9345b67da37c98)
- ... [`17c52a2`](https://github.com/ImageMagick/ImageMagick/commit/17c52a2e28d702c5d0aa1b3d90c9d2f7511e7a53)
- zero papersize geometry [`a6e081b`](https://github.com/ImageMagick/ImageMagick/commit/a6e081bf73c54035e8aa7b08481ea5db446eeb47)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=43390 [`fbbf013`](https://github.com/ImageMagick/ImageMagick/commit/fbbf013a252376e2afe4eaff6f00c5b3803fb505)
- pending release [`9fe6b78`](https://github.com/ImageMagick/ImageMagick/commit/9fe6b787854b576a6502c0e103a686503d71d58b)
- cosmetic [`f7c813e`](https://github.com/ImageMagick/ImageMagick/commit/f7c813e801a855b27c35bb956e6af5a2dad8dc27)
- ... [`ae109d4`](https://github.com/ImageMagick/ImageMagick/commit/ae109d4b44a2ddda160b1131a8e301f4a770a3a6)
- eliminate warnings [`7399756`](https://github.com/ImageMagick/ImageMagick/commit/7399756302dedfcfdfc45d3f81edabc61658ee45)
- https://github.com/ImageMagick/ImageMagick/security/code-scanning/38? [`0a0e0e4`](https://github.com/ImageMagick/ImageMagick/commit/0a0e0e44bd7e43c767ef594b9059a8c09c8a4943)
- add cast to eliminate splint warning [`2cd8407`](https://github.com/ImageMagick/ImageMagick/commit/2cd8407760811bf4e219a467a19b56f889416a5d)
- cosmetic [`1b697c4`](https://github.com/ImageMagick/ImageMagick/commit/1b697c46834bf3ca227161f1001e763a5f5c5419)
- change default iterations and residual threshold [`f24cbc8`](https://github.com/ImageMagick/ImageMagick/commit/f24cbc8017c4a79f18c701f708b1c391ebe1be31)
- https://github.com/ImageMagick/ImageMagick/issues/4729 [`e50f19f`](https://github.com/ImageMagick/ImageMagick/commit/e50f19fd73c792ebe912df8ab83aa51a243a3da7)
- set proper type [`332418d`](https://github.com/ImageMagick/ImageMagick/commit/332418dd242c30ace1067bb977ceda999819e780)
- add cast to avoid overflow [`40fd5db`](https://github.com/ImageMagick/ImageMagick/commit/40fd5dbf305e4d7b8ee268bb6f715e27843a0d2f)
- Silenced warnings. [`3c3fa17`](https://github.com/ImageMagick/ImageMagick/commit/3c3fa171517119825ac65edc54db3f8df9bcf009)
- fix for divide by zero until snibgo settles on a solution [`bf5fccd`](https://github.com/ImageMagick/ImageMagick/commit/bf5fccd54a350da3b76826b42e3664adbb7e0926)
- Silenced warnings. [`075565e`](https://github.com/ImageMagick/ImageMagick/commit/075565e93c71bcaaabf0ce70b7d1060bccdf0020)
- infrastructure for saliency blending [`1b2ad4d`](https://github.com/ImageMagick/ImageMagick/commit/1b2ad4dee2a1c656b0dd1906f00e043e66c2edd8)
- style [`f7e6b23`](https://github.com/ImageMagick/ImageMagick/commit/f7e6b23f33320ccfb26a4da739fdf2349b6a7fe3)
- Fixed possible memory leak. [`19feb22`](https://github.com/ImageMagick/ImageMagick/commit/19feb22358570919e6fb5e28acd20c4dee19ad19)
- Update qoi header file. [`b7cec57`](https://github.com/ImageMagick/ImageMagick/commit/b7cec57ef3a11adf041073464f65a40a9b0f5061)
- Updated ChangeLog. [`d1131e6`](https://github.com/ImageMagick/ImageMagick/commit/d1131e6585c60a75f5c7c18273f5eb6e188453e6)
- https://github.com/ImageMagick/ImageMagick/issues/4660 [`7fc7c5c`](https://github.com/ImageMagick/ImageMagick/commit/7fc7c5cb5461cb7588a9ce120b5da32f2af4a6fc)
- Added missing SeamlessBlendCompositeOp. [`45f37ad`](https://github.com/ImageMagick/ImageMagick/commit/45f37ad1ae7eaf3a1fd12306c7b87c0bbcb8735a)
- Removed unused call. [`6986984`](https://github.com/ImageMagick/ImageMagick/commit/698698484aed96d56a053f68106672d7eeb4dcbc)
- Fixed Windows build. [`966d7ca`](https://github.com/ImageMagick/ImageMagick/commit/966d7cafa9e17750511de1f372de044be0cc987b)
- remove read mask [`88393c2`](https://github.com/ImageMagick/ImageMagick/commit/88393c22a3b17234fd76c0fe281d95e8a33f5f3e)
- pending release [`660e30f`](https://github.com/ImageMagick/ImageMagick/commit/660e30fd68a24d677adfa0d462962298d6b9fe34)
- ... [`69efcf8`](https://github.com/ImageMagick/ImageMagick/commit/69efcf81adc31bc52ff72f917586bd6313233502)
- semaless blending requires we disable composite clamping [`a5aadc5`](https://github.com/ImageMagick/ImageMagick/commit/a5aadc523de40ea77f722747151a4e92d99f6c6d)
- Removed unnecessary backslash. [`ddda61c`](https://github.com/ImageMagick/ImageMagick/commit/ddda61cd9d5af6a54566db3ceb827af61016a97b)
- Added missing typecast. [`e11ced0`](https://github.com/ImageMagick/ImageMagick/commit/e11ced0bdf1e3c9336394243e50c552e3b8ffb74)
- Fixed build. [`6888325`](https://github.com/ImageMagick/ImageMagick/commit/6888325d8673aa33b312d2f4dff3146ada1b6ed6)
- Updated link to ffmpeg version. [`e790aef`](https://github.com/ImageMagick/ImageMagick/commit/e790aef43efce1709559bf2f572b5155bdab8649)
- https://github.com/ImageMagick/ImageMagick/issues/4649 [`9e492fa`](https://github.com/ImageMagick/ImageMagick/commit/9e492fa37cff83e9bb178633e84b1b49638b101a)
- ensure tick is at least 1 [`6dd4736`](https://github.com/ImageMagick/ImageMagick/commit/6dd4736658ca49b5195bfe22b9a6f6622d041d77)
- https://github.com/ImageMagick/ImageMagick/issues/4654 [`e1cf544`](https://github.com/ImageMagick/ImageMagick/commit/e1cf544ecc7d34122f2a0d44f4eb4368dc37f3ae)
- Added arm64 to the daily build on Windows. [`ce81f99`](https://github.com/ImageMagick/ImageMagick/commit/ce81f9963795802b9a730edd519ca4d67886fabe)
- revert [`6bc980f`](https://github.com/ImageMagick/ImageMagick/commit/6bc980fece71145a001f5dc325a045f0de5736bc)
- https://github.com/ImageMagick/ImageMagick/issues/4689 [`4ff42a4`](https://github.com/ImageMagick/ImageMagick/commit/4ff42a4ca11b7cdfef58c25bc12e6b58b84a9c16)
- ... [`64be892`](https://github.com/ImageMagick/ImageMagick/commit/64be8922ecae95888846dca0ec828e67aca46714)
- ... [`ebfd707`](https://github.com/ImageMagick/ImageMagick/commit/ebfd707c2a442fbe3b1c4aa15fbf4e8a73af742b)
- Try without the move. [`966be37`](https://github.com/ImageMagick/ImageMagick/commit/966be3715b1bea8194c9604cad4696bf9715c7c0)
- ... [`20dbaa2`](https://github.com/ImageMagick/ImageMagick/commit/20dbaa2405fa184a818df70312838cfd52fb75fb)
- ... [`d63614b`](https://github.com/ImageMagick/ImageMagick/commit/d63614b163aba55e2cc8edd738cbc63df473bb39)
- destroy relaxed image [`5b645b6`](https://github.com/ImageMagick/ImageMagick/commit/5b645b61f8bd0c1e9301b250d87f714127636f77)
- Added missing call to DestroyImageList. [`71e8cc6`](https://github.com/ImageMagick/ImageMagick/commit/71e8cc68420a9a4d236c9b3364eb8291ac5f3ce8)
- Removed ImageMagickObject from the Windows installer. [`36ceca1`](https://github.com/ImageMagick/ImageMagick/commit/36ceca115c4042f1779db127f86f88b7e81b0d5d)
- https://github.com/ImageMagick/ImageMagick/discussions/4533 [`8d9268b`](https://github.com/ImageMagick/ImageMagick/commit/8d9268b8daf19842f62f5aa367efe7fba9f5afb5)
- Added move to use the installed version of Strawberry Perl instead. [`8d5921b`](https://github.com/ImageMagick/ImageMagick/commit/8d5921b11e7b4ba633a2d630d2bad6e8f3322dab)
- ... [`11f1e07`](https://github.com/ImageMagick/ImageMagick/commit/11f1e07c09f68d678830a5fa09ec345f667825b6)

## [7.1.0-19](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-18...7.1.0-19) - 2021-12-22

### Commits

- support -integral option [`4928887`](https://github.com/ImageMagick/ImageMagick/commit/49288871f6f12d3f42ac32cc42835e24501740c7)
- ... [`8a24e36`](https://github.com/ImageMagick/ImageMagick/commit/8a24e363687b2e9221eb06c90cf236a882f1ff82)
- optimize [`a22aff9`](https://github.com/ImageMagick/ImageMagick/commit/a22aff94916cfcbf8f26c75096dcff2901b907df)
- Set the colorspace after the width and height of the image have been checked. [`661eafd`](https://github.com/ImageMagick/ImageMagick/commit/661eafd82e0666dc983d0fcb26e9b6eda71fc695)
- pending release [`fe8039f`](https://github.com/ImageMagick/ImageMagick/commit/fe8039f5b40f8dde11a6524dc0530bfb785c5ee7)
- ... [`95e02e5`](https://github.com/ImageMagick/ImageMagick/commit/95e02e562d728e23bdb058e38c6e2282f08e64d3)
- https://github.com/ImageMagick/ImageMagick/issues/4626 [`d7f1b2b`](https://github.com/ImageMagick/ImageMagick/commit/d7f1b2b9b816baaa956381ff80c3b120e83faa95)
- check for unbalanced parenthesis [`e2ce775`](https://github.com/ImageMagick/ImageMagick/commit/e2ce77517df3cbe7e53cca5cb63125846646096a)
- pointer is const [`449bba2`](https://github.com/ImageMagick/ImageMagick/commit/449bba22b048ecdc91d7ea51df2dd0254ca63102)

## [7.1.0-18](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-17...7.1.0-18) - 2021-12-18

### Commits

- Swapped the Sync8BimProfile and the SyncExifProfile methods. [`dd26314`](https://github.com/ImageMagick/ImageMagick/commit/dd263149f709f1a8fe4e17e23fe6eb17f15dac04)
- Added option to disabling synchronization of the image with the data from the exif profile. [`0d20e11`](https://github.com/ImageMagick/ImageMagick/commit/0d20e11dfb3776f099368b7bee84107b90a40e63)
- ... [`28c8f05`](https://github.com/ImageMagick/ImageMagick/commit/28c8f0508984cb3515bf74d6227097a9331d9ab7)
- Improved adjustment of page offset when resizing an image. [`0c4bc88`](https://github.com/ImageMagick/ImageMagick/commit/0c4bc88231fd1dc5eaa3861dbe3f3821497faf0a)
- Don't use SetImageGray inside a coder but use a method for the coders only instead. [`98a14e0`](https://github.com/ImageMagick/ImageMagick/commit/98a14e0603299b83138dd4e5c1cdec8e89ce1b33)
- https://github.com/ImageMagick/ImageMagick/issues/4558 [`54c3203`](https://github.com/ImageMagick/ImageMagick/commit/54c32036e238d23197812fc93471f2886b72e27d)
- Also sync the exif profile inside the 8bim profile. [`6ce6671`](https://github.com/ImageMagick/ImageMagick/commit/6ce66717d9e976ed947eeae7639d2a2e625a4c10)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=42504 [`f74fefd`](https://github.com/ImageMagick/ImageMagick/commit/f74fefdb120cfe5c4357c5792fd716c95a1adbe0)
- https://github.com/ImageMagick/ImageMagick/issues/4587 [`bd62b31`](https://github.com/ImageMagick/ImageMagick/commit/bd62b31c436a37f85458fc149b4867486ce147b2)
- https://github.com/ImageMagick/ImageMagick/discussions/4580 [`86b8264`](https://github.com/ImageMagick/ImageMagick/commit/86b8264127054186cd38514d8e986bf848f2e9cd)
- revert [`d173288`](https://github.com/ImageMagick/ImageMagick/commit/d173288bf5b8a3a466d2cd412090ebe569da53f8)
- https://github.com/ImageMagick/ImageMagick/security/code-scanning/31 [`e4c5667`](https://github.com/ImageMagick/ImageMagick/commit/e4c566742265eaa4f677dba53443e35a41ee7045)
- improved adjustment of page offset when resizing an image [`ecb4ffa`](https://github.com/ImageMagick/ImageMagick/commit/ecb4ffaefbce69112097ecafef8f0e714dc0c3da)
- pending release [`085d991`](https://github.com/ImageMagick/ImageMagick/commit/085d9911160ea304e4661fdd158f9933981d30f8)
- Corrected the built-in video encoder and decoder. [`c51be1d`](https://github.com/ImageMagick/ImageMagick/commit/c51be1d973437666da9705d159d8d0aaa8c4ae61)
- Add note to avoid confusion. [`2ee9473`](https://github.com/ImageMagick/ImageMagick/commit/2ee9473f35bbf5d42dd8e47e4d0d683eb5c7eda7)
- Corrected method name. [`62001c3`](https://github.com/ImageMagick/ImageMagick/commit/62001c33f1f1568fa78fd422ca47399a4413e2f7)
- Restored debug message. [`6c7d62f`](https://github.com/ImageMagick/ImageMagick/commit/6c7d62f7dc40862730c2acc2fe9d2772573bf501)
- Removed last line from the note. [`ff55679`](https://github.com/ImageMagick/ImageMagick/commit/ff55679c06a44c0e588d758e34ee0cd495f04a4c)
- Corrected typecast [`123b157`](https://github.com/ImageMagick/ImageMagick/commit/123b15740896247379d4202cfefa700f5f065fb1)
- Removed typecast. [`5e25ac4`](https://github.com/ImageMagick/ImageMagick/commit/5e25ac4536df6603fe6ed57fa6a7497b3a8fb401)
- ... [`53fb13e`](https://github.com/ImageMagick/ImageMagick/commit/53fb13e21b41877a2f1b5a9039e06c989fbc7995)

## [7.1.0-17](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-16...7.1.0-17) - 2021-12-04

### Commits

- Moved check for the define to the methods itself. [`23402d5`](https://github.com/ImageMagick/ImageMagick/commit/23402d5ca69f33a351b026aa1efbff824a995a5f)
- ... [`40189c3`](https://github.com/ImageMagick/ImageMagick/commit/40189c37f33b77df5970ddbba7560c596a61c877)
- https://github.com/ImageMagick/ImageMagick/issues/4501 [`1e40102`](https://github.com/ImageMagick/ImageMagick/commit/1e40102cee6bea0a4252d5d44551129f59d991f2)
- revert memory leak patch [`34266d6`](https://github.com/ImageMagick/ImageMagick/commit/34266d6acf9cd9a0f94175d39e92472fbd894c22)
- https://github.com/ImageMagick/ImageMagick/issues/4501 [`f4375d0`](https://github.com/ImageMagick/ImageMagick/commit/f4375d0a48b89a5c7696d487bf12f363dae9dfa6)
- Reduce number of typecasts. [`bb38559`](https://github.com/ImageMagick/ImageMagick/commit/bb38559758dedfb70a318c1b8c1ecffead52d636)
- https://github.com/ImageMagick/ImageMagick/issues/4512 [`a400176`](https://github.com/ImageMagick/ImageMagick/commit/a40017631a00a823470cfac376b1277c0a73466d)
- https://github.com/ImageMagick/ImageMagick/discussions/4529 [`e66261f`](https://github.com/ImageMagick/ImageMagick/commit/e66261ffe76e9b2c2e4f0257023952acd8b30017)
- Added missing checks for the return value of the exr methods. [`3aa48d3`](https://github.com/ImageMagick/ImageMagick/commit/3aa48d31f03d2b08999480890f69b53c554afc79)
- Added extra check to make sure that the index is already set. [`79eec91`](https://github.com/ImageMagick/ImageMagick/commit/79eec9112cd5f5a0d356b0989229422070c294f4)
- ASAN returns false positives for OMP [`63062af`](https://github.com/ImageMagick/ImageMagick/commit/63062afee01f2db250016a2c7c526324dd0060a5)
- Corrected the patch made in #4497. [`44cf75f`](https://github.com/ImageMagick/ImageMagick/commit/44cf75ff01a9c8f4accfbd630297a1aae1512ea9)
- https://github.com/ImageMagick/ImageMagick/issues/4501 [`9b817fb`](https://github.com/ImageMagick/ImageMagick/commit/9b817fbed41712afca743e78d7f1faedff1b6939)
- Corrected argument. [`775c1bd`](https://github.com/ImageMagick/ImageMagick/commit/775c1bd2aef0bfee8c71f97dbaaab4472ca83250)
- pending release [`abded9a`](https://github.com/ImageMagick/ImageMagick/commit/abded9a381edea209c5ab7c3924abe0155831a36)
- Removed unused define. [`5f8ace2`](https://github.com/ImageMagick/ImageMagick/commit/5f8ace2080b644376ea1b4e3e2be83f73b1d75b0)
- close input file if early exit on exception [`5394e32`](https://github.com/ImageMagick/ImageMagick/commit/5394e32bdd509195f8ac41752853e7b325d609ed)
- Added check for invalid size (#4522). [`285c84a`](https://github.com/ImageMagick/ImageMagick/commit/285c84a86dacdc4ebee2ce3e88e642dbf174d3dc)
- Use magick_unreferenced instead. [`264d486`](https://github.com/ImageMagick/ImageMagick/commit/264d48677caeda69e306434d153fc1e77b80d9f9)
- pending release [`1d5c2e5`](https://github.com/ImageMagick/ImageMagick/commit/1d5c2e55adc8bcdf0d93ebf8f30ab098bb9e5303)
- pending release [`1c66ab8`](https://github.com/ImageMagick/ImageMagick/commit/1c66ab80705174cd729449fdeebdf64c3d9d9025)
- Fixed memory leak. [`eaf0aa4`](https://github.com/ImageMagick/ImageMagick/commit/eaf0aa4a717672d18a1f239faa6d7301ea658b0b)
- Corrected the check. [`0e417f4`](https://github.com/ImageMagick/ImageMagick/commit/0e417f477b5914308ce7e8de13a5c6e787a133d1)
- eliminate compiler exception [`90de0c0`](https://github.com/ImageMagick/ImageMagick/commit/90de0c000b08ee4618429221ab73caf8dfb83fe2)
- Whitespace. [`979856a`](https://github.com/ImageMagick/ImageMagick/commit/979856ae5e08d97a26790e4a2999824b64342ce4)
- pending release [`79af0b3`](https://github.com/ImageMagick/ImageMagick/commit/79af0b3fae0015e9474d9be88e5d1a5d012f5cd4)
- Corrected reading the next image. [`2b6531d`](https://github.com/ImageMagick/ImageMagick/commit/2b6531d36c68316211dfe89b1f99fe2dd07b0371)

## [7.1.0-16](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-15...7.1.0-16) - 2021-11-21

### Commits

- Set the channel earlier to get rid of the switch when setting the pixel value. [`f219611`](https://github.com/ImageMagick/ImageMagick/commit/f21961130656ccc3ae1e91ba5b653e0b27778028)
- ... [`0446e05`](https://github.com/ImageMagick/ImageMagick/commit/0446e0544e2e9b6deb2614397dadb993503d5e5b)
- Renamed variable. [`12431a3`](https://github.com/ImageMagick/ImageMagick/commit/12431a37363724d32b8419fb62a730a898890956)
- Make sure the other channels of the pixel are also set when setting the index of the pixel. [`c43c03c`](https://github.com/ImageMagick/ImageMagick/commit/c43c03cf02d4e94d2df03dd6913f34b8a6db8cc0)
- Added flag for unsupported channels and skip them instead. [`39a9ab7`](https://github.com/ImageMagick/ImageMagick/commit/39a9ab792c997be4c722ea998d2af6e0470341a0)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=41268 [`b434f8c`](https://github.com/ImageMagick/ImageMagick/commit/b434f8cf9d7ec472fdfa8214d9ad07216c39f2b1)
- pending release [`03b1a2e`](https://github.com/ImageMagick/ImageMagick/commit/03b1a2ecb4a14f5ea3f1f073418008109bdffb55)
- Corrected OpenCL define checks (#4450). [`7dc99d8`](https://github.com/ImageMagick/ImageMagick/commit/7dc99d829fe73df68911e32d8b72cf355586123d)
- Removed unnecessary define. [`3afb075`](https://github.com/ImageMagick/ImageMagick/commit/3afb075b42014ab86fbe4c2ffcecc9d33150326b)
- Corrected comments. [`bad0b1c`](https://github.com/ImageMagick/ImageMagick/commit/bad0b1c4929745544547fd1efc9f77071965d641)
- Moved define. [`a839c2a`](https://github.com/ImageMagick/ImageMagick/commit/a839c2a1751cd48bb19b9951d5b450f7b54938c8)
- Also check for other modes in the GetPixelChannelFromPsdIndex method. [`9c9b65e`](https://github.com/ImageMagick/ImageMagick/commit/9c9b65e53859f422f890c38ca85ab1a46ea2b64f)
- Corrected the type. [`63cfa54`](https://github.com/ImageMagick/ImageMagick/commit/63cfa542ab3d2d15eb067b12ef9160d6eebd9845)
- Code style change. [`0a4e402`](https://github.com/ImageMagick/ImageMagick/commit/0a4e4026f01be479fa3f92f349f3da29912eea86)
- Corrected initial channel type. [`dd26030`](https://github.com/ImageMagick/ImageMagick/commit/dd26030975e827fe9af9c5d10b5ff69c429a2961)
- eliminate possible device by zero [`cdf8735`](https://github.com/ImageMagick/ImageMagick/commit/cdf8735e35ad9df344b99a2ae1255cd0f2f0ccea)
- Minor refactoring. [`9b562c2`](https://github.com/ImageMagick/ImageMagick/commit/9b562c258e638e725dc078ef0a73337d8444441f)
- DuotoneMode does not support alpha. [`927796d`](https://github.com/ImageMagick/ImageMagick/commit/927796d9340a1591c8ed9ea4a26f21cdf59b6282)

## [7.1.0-15](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-14...7.1.0-15) - 2021-11-20

### Merged

- Make exported name be same as in C file. [`#4430`](https://github.com/ImageMagick/ImageMagick/pull/4430)

### Commits

- Also added support for reading extra channels in the layers of a PSD file (#4499). [`f8373be`](https://github.com/ImageMagick/ImageMagick/commit/f8373be7636aa975a4ff63e0299e6f9f67d8aa01)
- Make sure the alpha channel is always -1 in the merged image. [`b3a8c52`](https://github.com/ImageMagick/ImageMagick/commit/b3a8c527e0df0c49854f5f32012f3c1e36eb52c7)
- ... [`cd9d52c`](https://github.com/ImageMagick/ImageMagick/commit/cd9d52cb636d8bb7d996cd7e5017515d34d09bf4)
- Move indexes of the meta channels to the end of the channel_map of the image. [`9239f3b`](https://github.com/ImageMagick/ImageMagick/commit/9239f3bdbcdf83e98957c2cbed7374ba62a5dc05)
- MaximumValue should have the highest value instead of reordering the other values. [`8098f33`](https://github.com/ImageMagick/ImageMagick/commit/8098f3335cfdcf5ed1de6f284b9aabb4786808d0)
- Added support for reading the extra channels in the merged image of a PSD file (#4499). [`3b265d7`](https://github.com/ImageMagick/ImageMagick/commit/3b265d7066c36e08e6b619fa2d3b8ac80fe7eac9)
- ... [`db57cff`](https://github.com/ImageMagick/ImageMagick/commit/db57cffb9c170f60d86066a761b37e34f670dfc5)
- Removed unused pixel-private includes. [`d6da28b`](https://github.com/ImageMagick/ImageMagick/commit/d6da28b0e03c15d1290ed17c94ff35d85b7ac5a5)
- eliminate compiler warning [`5adddc2`](https://github.com/ImageMagick/ImageMagick/commit/5adddc2efa20b5670dde30545c344cba1086f6f5)
- https://github.com/ImageMagick/ImageMagick6/issues/168 [`55fc1ab`](https://github.com/ImageMagick/ImageMagick/commit/55fc1abb3422a00a94b66f4cf6a560a36eb2624c)
- Moved StartMetaChannel to the private header. [`3f2d061`](https://github.com/ImageMagick/ImageMagick/commit/3f2d06172752e489df5ee1a1b8002423f8c04a03)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=41172 [`9c171c8`](https://github.com/ImageMagick/ImageMagick/commit/9c171c8af6420bdf6c953a8db0c8a654b1f7f74d)
- Renamed define. [`b80d247`](https://github.com/ImageMagick/ImageMagick/commit/b80d2471da61c56e9f3571805332d0fc5da04f06)
- https://github.com/ImageMagick/ImageMagick/issues/4497 [`9bf7dfc`](https://github.com/ImageMagick/ImageMagick/commit/9bf7dfc372c55095f767e1f3ed0bbc077e88382d)
- Removed unused pixel-private includes. [`07a87b2`](https://github.com/ImageMagick/ImageMagick/commit/07a87b29a9e16878be6392a415f6736192cf6443)
- We no longer support -4 and -3 will be skipped [`c07194a`](https://github.com/ImageMagick/ImageMagick/commit/c07194a63d417c92e2e9e07deb1781027037e121)
- Changed type of the type field. [`7ff1303`](https://github.com/ImageMagick/ImageMagick/commit/7ff13033d0982e4f1d8095acfc07df948a8eef20)
- eliminate compiler warning [`4eb5f9a`](https://github.com/ImageMagick/ImageMagick/commit/4eb5f9a940f96de1e69657b129a472264c1004b1)
- pending release [`c7fed90`](https://github.com/ImageMagick/ImageMagick/commit/c7fed9006739151f43803acf82646fac48b5bb61)
- Added extra check to make sure number_meta_channels won't exceed the size of channel_map. [`4fb50e2`](https://github.com/ImageMagick/ImageMagick/commit/4fb50e2e8bc2cff0057ab9af8f40715e8ae7eda1)
- mitigate UBSAN alerts [`9458e3d`](https://github.com/ImageMagick/ImageMagick/commit/9458e3dd3fb96ff599c3b71568de98c9f88208b2)
- pending release [`7030880`](https://github.com/ImageMagick/ImageMagick/commit/7030880c6da1c382f3b1251f0fe2a805fdab3ba5)
- Corrected type cast. [`d221c6f`](https://github.com/ImageMagick/ImageMagick/commit/d221c6ff23d5a1fb5acb13a7ae7bda9c517bb940)
- pending release [`6a57c70`](https://github.com/ImageMagick/ImageMagick/commit/6a57c7014b5f2af01284da3c2169cf9e61895d21)
- fix overly aggressive sanity check [`c836221`](https://github.com/ImageMagick/ImageMagick/commit/c8362214aca7af3d7af410a2c6fd87fa41cbf0f0)
- mitigate UBSAN alerts [`128c05a`](https://github.com/ImageMagick/ImageMagick/commit/128c05aab27b5f950c79f0d542cc15e4d17e7e2c)
- mitigate UBSAN alerts [`3dc9db6`](https://github.com/ImageMagick/ImageMagick/commit/3dc9db61aca5f45e479cbd8ce4747edf5e870551)
- No longer support reading type -4 that does not exist according to the PSD file format specification. [`186e62a`](https://github.com/ImageMagick/ImageMagick/commit/186e62abf45b692086e8f6355ce8f49826f02ab2)
- https://github.com/ImageMagick/ImageMagick/issues/4495 [`79da16f`](https://github.com/ImageMagick/ImageMagick/commit/79da16f30ca9085bbefcd9903155ea7d75ade21b)
- pending release [`fdd9410`](https://github.com/ImageMagick/ImageMagick/commit/fdd9410fcfb365ed3d92b75dbfdf817ccc152f3d)

## [7.1.0-14](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-13...7.1.0-14) - 2021-11-14

### Merged

- Typo in magick color threshold image [`#4431`](https://github.com/ImageMagick/ImageMagick/pull/4431)

### Fixed

- Moved the free to the correct position to fix #4446. [`#4446`](https://github.com/ImageMagick/ImageMagick/issues/4446)

### Commits

- latest docs [`8a9b071`](https://github.com/ImageMagick/ImageMagick/commit/8a9b07155b7bb6e9c4768b117e9e6fb1c21e0306)
- https://github.com/ImageMagick/ImageMagick/issues/4448 [`5d3bc2a`](https://github.com/ImageMagick/ImageMagick/commit/5d3bc2abc650c16eff55c7d89f3d49b819f733c1)
- Removed unnecessary semicolons. [`7fef3c3`](https://github.com/ImageMagick/ImageMagick/commit/7fef3c3ac8ef5397f8a7f318a5316f09a2c999c7)
- https://github.com/ImageMagick/ImageMagick/discussions/4447 [`9a3756d`](https://github.com/ImageMagick/ImageMagick/commit/9a3756d8e54996c95b2f3880c0803c87a23b7036)
- typo in houghline comments. [`157b21d`](https://github.com/ImageMagick/ImageMagick/commit/157b21d508b8a3662c922b762aa92e524e67e57c)
- early exit on exception [`4cca191`](https://github.com/ImageMagick/ImageMagick/commit/4cca19105ccdd0991a79e138ce202ee30ebf9f64)
- ... [`661c7a1`](https://github.com/ImageMagick/ImageMagick/commit/661c7a194bf8f621245f5ea5d0a0147decdab584)
- Improved detection of %%. [`8ff9f59`](https://github.com/ImageMagick/ImageMagick/commit/8ff9f59fcc7aa581ab6a1d53688bf94094ebe347)
- https://github.com/ImageMagick/ImageMagick/issues/4448 [`2ba5cdf`](https://github.com/ImageMagick/ImageMagick/commit/2ba5cdf4255cdf5d9349a15b7adfff13558397aa)
- The profile of a PSD file will no longer be copied to all the images. To old behavior can be re-enabled with the define psd:replicate-profile. [`50e2f07`](https://github.com/ImageMagick/ImageMagick/commit/50e2f07b37414dec19fd470d78fb2750428b2bed)
- Fix stripes in output when resizing with OpenCL acceleration enabled [`0c660f2`](https://github.com/ImageMagick/ImageMagick/commit/0c660f2ff8899401be4acf0ce539f0441ebc370e)
- ... [`9f7884c`](https://github.com/ImageMagick/ImageMagick/commit/9f7884ca8864a6a7d99d9618abae263ce8b5a4a5)
- Corrected detection of the CMYK colorspace (#4106). [`e6a45aa`](https://github.com/ImageMagick/ImageMagick/commit/e6a45aa7b61bb217a8a66b5a6799d365c5ba0187)
- https://github.com/ImageMagick/ImageMagick/issues/4452 [`b4ece92`](https://github.com/ImageMagick/ImageMagick/commit/b4ece92cdf03be8308d4eac86444f5b0be0935aa)
- ... [`7a608d6`](https://github.com/ImageMagick/ImageMagick/commit/7a608d6686258d6534cf948c61ad68356b91cd9c)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=40454 [`b93521f`](https://github.com/ImageMagick/ImageMagick/commit/b93521f5087ea92d3564862046422a0dc0ce8692)
- pending release [`fab9aae`](https://github.com/ImageMagick/ImageMagick/commit/fab9aaeafc5954d45cc4c5d8edd1503fcc1dadc9)
- ... [`4ade863`](https://github.com/ImageMagick/ImageMagick/commit/4ade8632d14c349d0a6eef3ba0f9c09aa24ab76b)
- ... [`bb886ff`](https://github.com/ImageMagick/ImageMagick/commit/bb886ff398ae0dd6111ff011382dd84d4b6633e5)
- ... [`08dec75`](https://github.com/ImageMagick/ImageMagick/commit/08dec75b2fc1dcb913eec2d7ffd8810b00cc9a2f)
- https://github.com/ImageMagick/ImageMagick/issues/4465 [`2a0dd59`](https://github.com/ImageMagick/ImageMagick/commit/2a0dd59371cb64bbfc4604451cec88477260e766)
- pending release [`e4182c9`](https://github.com/ImageMagick/ImageMagick/commit/e4182c967a9434f180cbb748b24ed437c287381b)

## [7.1.0-13](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-12...7.1.0-13) - 2021-10-28

### Commits

- ... [`d988cbf`](https://github.com/ImageMagick/ImageMagick/commit/d988cbfa42a0cbe1bb3c90a0aad5fa0b5221f85f)
- Fix stack overflow when parsing malicious ps image file (#4415). [`c5fad5e`](https://github.com/ImageMagick/ImageMagick/commit/c5fad5e9446c23ff651f2655980877a0c81ec956)
- ... [`366946d`](https://github.com/ImageMagick/ImageMagick/commit/366946defe55a8ea03dbbf87319a0f7cd6d0e324)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=40451 [`987f36b`](https://github.com/ImageMagick/ImageMagick/commit/987f36b509139818c969a5474fee150e3f4034b4)
- cosmetic [`ddae967`](https://github.com/ImageMagick/ImageMagick/commit/ddae9678fb137ab41ee6c09d9a1c91e4d014b8e4)
- pending release [`ab9bcad`](https://github.com/ImageMagick/ImageMagick/commit/ab9bcade8cf99b1ba2c42573d6ac080907374518)
- pending release [`7ab72fa`](https://github.com/ImageMagick/ImageMagick/commit/7ab72fa00a9bf0c2c95d2beb55feb888f6629dbc)

## [7.1.0-12](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-11...7.1.0-12) - 2021-10-25

### Commits

- ... [`1b0f475`](https://github.com/ImageMagick/ImageMagick/commit/1b0f475ea77b71891df97ac0ca4a6c58e7f62b35)
- Cosmetic. [`113f8f9`](https://github.com/ImageMagick/ImageMagick/commit/113f8f901efa88c63779d393340872c443ecfa3b)
- pending release [`02476ce`](https://github.com/ImageMagick/ImageMagick/commit/02476ce3ca19f2f0a267a036525182b626c9d24d)
- Removed unused define. [`b89ecbc`](https://github.com/ImageMagick/ImageMagick/commit/b89ecbc2d163ec1cc3184cb6a611ee0c5cff8bbb)
- Corrected writing the user mask data. [`53e9540`](https://github.com/ImageMagick/ImageMagick/commit/53e954000034cac934a07e88da0c87b1cff13775)

## [7.1.0-11](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-10...7.1.0-11) - 2021-10-24

### Commits

- https://github.com/ImageMagick/ImageMagick/issues/4379 [`4bd86b0`](https://github.com/ImageMagick/ImageMagick/commit/4bd86b05421e998c95491e2bf9d1f987c2f517eb)
- Create new struct for refactoring. [`7c8d19b`](https://github.com/ImageMagick/ImageMagick/commit/7c8d19b19d7f97a6e1d58ad05c3bd93c8d753757)
- Use IdentifyImageCoderGray instead. [`b1d4280`](https://github.com/ImageMagick/ImageMagick/commit/b1d42802bb46e86aa2d45fb9b3e31fc70cae1e8c)
- https://github.com/ImageMagick/ImageMagick/issues/4378 [`42ddb98`](https://github.com/ImageMagick/ImageMagick/commit/42ddb98ee68ac63f2df5f80bc631ec3c289b2a5c)
- Also allow setting the max and start pointsize in the label coder. [`3990e66`](https://github.com/ImageMagick/ImageMagick/commit/3990e661655540843da53964576395abca80dd27)
- Added RelinquishDCMMemory. [`9a301fa`](https://github.com/ImageMagick/ImageMagick/commit/9a301fa41f3bb299194d122e60d04380d4571e35)
- Removed checks for the macintosh define. [`f18599b`](https://github.com/ImageMagick/ImageMagick/commit/f18599b05e2ee0c54ecdc7dbd7527227973822e9)
- Corrected debug logging. [`40aa490`](https://github.com/ImageMagick/ImageMagick/commit/40aa4901db52e2d98077b5f81558b9c0d17fac84)
- Corrected indentation. [`a864d83`](https://github.com/ImageMagick/ImageMagick/commit/a864d835725ccf4e6ba09112e1cb04f7a7f662a9)
- Also include zero configuration build in the daily build. [`46b6677`](https://github.com/ImageMagick/ImageMagick/commit/46b66778bf4d9801a38164bf1022b84812ff15ab)
- Removed IdentifyImageCoderMonochrome. [`d934c9a`](https://github.com/ImageMagick/ImageMagick/commit/d934c9a945a7a9528ba78f836ffecc188219a4d2)
- Use new methods to check if the image is gray or monochrome. [`06e4331`](https://github.com/ImageMagick/ImageMagick/commit/06e4331e198718fe644f1f9e80be43161962b941)
- ... [`46c028b`](https://github.com/ImageMagick/ImageMagick/commit/46c028b5b76f590f38fe9c25039a560d848cd888)
- Removed gravity check. [`e90b163`](https://github.com/ImageMagick/ImageMagick/commit/e90b163f2f71ce78487560009a05127628cafab3)
- Added additional boundary checks. [`be3c7dc`](https://github.com/ImageMagick/ImageMagick/commit/be3c7dc182ca88690083929ef550a9cb01d5860d)
- Copy scale to avoid duplicate free (https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=36990). [`7e2565b`](https://github.com/ImageMagick/ImageMagick/commit/7e2565b79a2268bc89a1b83bd30ed19fe8881add)
- Silenced warnings. [`1b04b83`](https://github.com/ImageMagick/ImageMagick/commit/1b04b8317378589d1c3a2fddecf30ef1f7cf2c80)
- Introduce new method that only checks if the image is grayscale. [`f10a8a1`](https://github.com/ImageMagick/ImageMagick/commit/f10a8a16f45ac7b5f061b7d8e4dfd1c9c84e0d6b)
- Only check the image type once. [`ba95a78`](https://github.com/ImageMagick/ImageMagick/commit/ba95a784116406f60ad98ee1133e1ee79f331eb0)
- Create separate for the conversion of the wchar mode. [`72ffc83`](https://github.com/ImageMagick/ImageMagick/commit/72ffc835deeab2231b7c3f4ccc857396da219fca)
- Corrected indentation. [`8c85ce0`](https://github.com/ImageMagick/ImageMagick/commit/8c85ce001ebb8c32986f0378dcaca3173ddd09b9)
- Stop writing the icc profile to the output image because this changes the colors of the image and switch back to JxlColorEncodingSetToSRGB (#4385). [`b2cc365`](https://github.com/ImageMagick/ImageMagick/commit/b2cc365614f734c1cac39b8343c5c1f6033ee92f)
- Revert adjustment of the y1 value (#4405). [`f5c3396`](https://github.com/ImageMagick/ImageMagick/commit/f5c3396e2644cdd9b4350e537c9c0550c05f960c)
- Changed argument to blob_info. [`c7a767c`](https://github.com/ImageMagick/ImageMagick/commit/c7a767c55cded4e9fb7721388c7e2898f0227808)
- Renamed method. [`cb8d9ed`](https://github.com/ImageMagick/ImageMagick/commit/cb8d9ed1e5058a52e958df9e2bcea5dede3788db)
- https://oss-fuzz.com/testcase-detail/6308942275805184 [`5e99821`](https://github.com/ImageMagick/ImageMagick/commit/5e998214b84b69437a7cd93474b6dab9f82b4088)
- Use IsGrayImageType when possible [`ef939ef`](https://github.com/ImageMagick/ImageMagick/commit/ef939ef74c996b91e5dbd1cc73bc40030c0c8ae0)
- Also allow disabling the interpolation. [`b464cd2`](https://github.com/ImageMagick/ImageMagick/commit/b464cd2dbf8eaa9abde3a1b231906038ee873336)
- The check for auto-grayscale should be done earlier. [`36febfd`](https://github.com/ImageMagick/ImageMagick/commit/36febfdd03cd2f546aa4c014b4ad0df7910c07c2)
- slight performance optimization [`753f39f`](https://github.com/ImageMagick/ImageMagick/commit/753f39fef6c5f8aff18b793ef1d363ce08244c1b)
- Whitespace. [`c47f0e3`](https://github.com/ImageMagick/ImageMagick/commit/c47f0e34dcf05cfe8762b378c8b32065c600e5ed)
- Silenced warning. [`3bb4253`](https://github.com/ImageMagick/ImageMagick/commit/3bb4253e7c343c9b5f94e3d763a12f762f11a646)
- Renamed variable to silence warning. [`7eba68f`](https://github.com/ImageMagick/ImageMagick/commit/7eba68fd23e68f48911291e6e6ccda90c0b16548)
- Fixed possible memory leak. [`fbf76f2`](https://github.com/ImageMagick/ImageMagick/commit/fbf76f2efa62b644d41a6075c7d9bb598dfb3bbf)
- fix stack overflow when parsing malicious tiff image [`f620340`](https://github.com/ImageMagick/ImageMagick/commit/f620340935777b28fa3f7b0ed7ed6bd86946934c)
- Added new option called caption:start-pointsize that will allow setting the starting pointsize when trying to find the best font size. [`031a853`](https://github.com/ImageMagick/ImageMagick/commit/031a8533ddaffceeb31925d59c7bd80516e53d60)
- ... [`a3a2cc7`](https://github.com/ImageMagick/ImageMagick/commit/a3a2cc75063e372b50d804e5b04fa9dff4d9a47c)
- https://github.com/ImageMagick/ImageMagick/issues/4372 [`f178d56`](https://github.com/ImageMagick/ImageMagick/commit/f178d564e761469158e2311db453a949184ea333)
- Moved variable declaration. [`8391e04`](https://github.com/ImageMagick/ImageMagick/commit/8391e04b1a8f9000472c61e001420b9a9996c022)
- Optimization for the low point size when the width and height of the image are fixed. [`f8cb770`](https://github.com/ImageMagick/ImageMagick/commit/f8cb770e502906c8888386402c6393d6efb4683c)
- Removed unnecessary statement. [`43ee149`](https://github.com/ImageMagick/ImageMagick/commit/43ee149af2ba600ffc4cf4a688d8e57a4b408596)
- Added flag that the handle is not inheritable by the child process. [`7241ee3`](https://github.com/ImageMagick/ImageMagick/commit/7241ee31f2e3b323e93830cd8482dc45794d8422)
- Removed else statement. [`4c8c7c6`](https://github.com/ImageMagick/ImageMagick/commit/4c8c7c689623b4c7071308492785e9364112ae0f)
- Optimization for the low point size when the width and height of the image are fixed. [`74af638`](https://github.com/ImageMagick/ImageMagick/commit/74af638e37801da5a156c0634dc3e4bcf4ed2681)
- Corrected calls to heif_image_handle_release. [`7b9b7c6`](https://github.com/ImageMagick/ImageMagick/commit/7b9b7c6a2a9c370b27d48d2da760600342881e5b)
- pending release [`5ac355f`](https://github.com/ImageMagick/ImageMagick/commit/5ac355fe99f9aaed48d05715256b7a54ccf87b12)
- pending release [`a0291e9`](https://github.com/ImageMagick/ImageMagick/commit/a0291e944baf076f1036ca120aa115b7f46878c7)
- Added missing (void). [`6e2983b`](https://github.com/ImageMagick/ImageMagick/commit/6e2983b9389b0494e44e75f78cf2a50526a481ca)
- Renamed method. [`b492aba`](https://github.com/ImageMagick/ImageMagick/commit/b492aba5ba52daa811347408a6d589b500805e6b)
- pending release [`9523594`](https://github.com/ImageMagick/ImageMagick/commit/95235946925dd5d3153d30f5e3673e7c0b1200ee)
- ... [`af76674`](https://github.com/ImageMagick/ImageMagick/commit/af766745f92967970b69091bdd52c1610722a489)
- Use IdentifyImageCoderGrayType instead. [`b95b4b1`](https://github.com/ImageMagick/ImageMagick/commit/b95b4b1b43de79fbdf81e9654f6599a43dc4f552)
- Fixed check of the boundaries when both the with and height of the image are defined. [`5a3371f`](https://github.com/ImageMagick/ImageMagick/commit/5a3371fe6f50b45d9e5a1a9271400d6166703ca9)
- pending release [`baa6c1d`](https://github.com/ImageMagick/ImageMagick/commit/baa6c1d2a756c99d8590c1bd58887e9a0080af17)
- revert optimization [`22694f6`](https://github.com/ImageMagick/ImageMagick/commit/22694f60aee3d6dc3a725605b2b39cda58dca2c9)
- Use IsImageGray instead. [`2ad55fa`](https://github.com/ImageMagick/ImageMagick/commit/2ad55fa3497655604ac03666342c7cc04e14a36f)
- Added mime type for bmp (#4395). [`45febac`](https://github.com/ImageMagick/ImageMagick/commit/45febac063c24d54ff4f348129c677447a210336)
- Added missing typecast. [`61a9889`](https://github.com/ImageMagick/ImageMagick/commit/61a9889dcc33437f48ec3637b247a4c81f07b38c)
- Added O_NOINHERIT flag. [`d8d087e`](https://github.com/ImageMagick/ImageMagick/commit/d8d087ec94092b2fc7afd9778b92d24604a78cc8)
- Argument can be const. [`c4cf2ac`](https://github.com/ImageMagick/ImageMagick/commit/c4cf2ac655820d028f228cfc8ae69e44d979e70b)
- ... [`dd7df11`](https://github.com/ImageMagick/ImageMagick/commit/dd7df1148c8140b21c2cb6e49e4554044e6b3297)
- Use IdentifyImageGray instead. [`10df973`](https://github.com/ImageMagick/ImageMagick/commit/10df973b796da6d351911e8a6cc8ca96b15f60d4)
- Reduce stack size. [`1bcee60`](https://github.com/ImageMagick/ImageMagick/commit/1bcee608550c8fb850c6e20970e20e8a53b4986c)
- Whitespace. [`4c04fad`](https://github.com/ImageMagick/ImageMagick/commit/4c04fade3b86f0f2277791bfdb121c19231d296a)
- Change to lowercase. [`18e15da`](https://github.com/ImageMagick/ImageMagick/commit/18e15da2dc6ceae05e95077f85e9d67dac31c5d8)
- cosmetic [`dadd444`](https://github.com/ImageMagick/ImageMagick/commit/dadd44478bf62d6033ecb6b822a8e38f09b5235d)
- https://oss-fuzz.com/testcase-detail/6308942275805184 [`fab0e18`](https://github.com/ImageMagick/ImageMagick/commit/fab0e185965332958bfdd16020b6b1675e8d1bb2)
- Added missing check. [`6c90dd8`](https://github.com/ImageMagick/ImageMagick/commit/6c90dd8ee5fe292714c6ac6b1d8046e7e48b2244)
- ThrowDCMException should be used instead. [`a4a2ee6`](https://github.com/ImageMagick/ImageMagick/commit/a4a2ee6593b06e430fd3565d858a3fbab63cb876)
- Use while instead. [`c2207f9`](https://github.com/ImageMagick/ImageMagick/commit/c2207f9012e32cb0ae0a7330f4736cc47f49b516)
- Fix grammar in AUTHORS.txt [`c115616`](https://github.com/ImageMagick/ImageMagick/commit/c115616ff115cf1009d3560468bccf1a21ff43e6)
- test release [`4c62b10`](https://github.com/ImageMagick/ImageMagick/commit/4c62b10ebf3c45de5724cbeabf2f0ac455e58686)
- pending release [`97e5cdf`](https://github.com/ImageMagick/ImageMagick/commit/97e5cdfc8f4a318882ee41e62da1ba82a8c0a294)
- Fixed copy paste mistake. [`44179b2`](https://github.com/ImageMagick/ImageMagick/commit/44179b21d11e7edfceb194be9a966f47d5cfb314)
- Whitespace. [`c191d5d`](https://github.com/ImageMagick/ImageMagick/commit/c191d5d0da3489fd0ab0640bd4450f4cee122471)
- pending release [`e16d679`](https://github.com/ImageMagick/ImageMagick/commit/e16d67915d7ca440701f934f97cb9e0a75ea77f3)
- eliminate compiler error [`1b855b7`](https://github.com/ImageMagick/ImageMagick/commit/1b855b7b12edf9ddac2810ae604bbf3764343a12)

## [7.1.0-10](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-9...7.1.0-10) - 2021-10-10

### Commits

- Update configure with latest changes [`7df9e19`](https://github.com/ImageMagick/ImageMagick/commit/7df9e19ff93984991b768f763aaeb661ed07c43a)
- Update libjxl to use a .pc [`c82a9aa`](https://github.com/ImageMagick/ImageMagick/commit/c82a9aa538007d2d397e3c106493d4637e9b3900)
- https://github.com/ImageMagick/ImageMagick/discussions/4311 [`494c960`](https://github.com/ImageMagick/ImageMagick/commit/494c960c815577d1ce4adfd663f75c9466b4bc72)
- ... [`78efee9`](https://github.com/ImageMagick/ImageMagick/commit/78efee93db2217a8ad2ff622921e51465de64eb4)
- don't adjust metrics if gravity is undefined [`3fc5106`](https://github.com/ImageMagick/ImageMagick/commit/3fc51062618127a8b683bb06344ca6152d9791fe)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=39708 [`524edfe`](https://github.com/ImageMagick/ImageMagick/commit/524edfed7587623a24ce7b7bb16af049b8b5e920)
- Moved using namespace std after ImageMagick header files to fix issues when enabling ISO C++ 17 and ISO C17 [`f7ff309`](https://github.com/ImageMagick/ImageMagick/commit/f7ff309b0b64fb0b478b3af1531ce5e6f179eea3)
- determine configuration with the `magick` utility [`6422663`](https://github.com/ImageMagick/ImageMagick/commit/6422663885abc973f74c3a5f0bdfa0afbc3202ca)
- https://github.com/ImageMagick/ImageMagick/issues/4312 [`bc2f658`](https://github.com/ImageMagick/ImageMagick/commit/bc2f658a6c3d260d086aac795d9502035ae246d7)
- ... [`c5afe90`](https://github.com/ImageMagick/ImageMagick/commit/c5afe90f2cb98e7874318581ca446170ce3ff716)
- https://github.com/ImageMagick/ImageMagick/issues/4314 [`9c8b025`](https://github.com/ImageMagick/ImageMagick/commit/9c8b025640bffb45e5caedf27f10cec222c38290)
- ... [`a3c0680`](https://github.com/ImageMagick/ImageMagick/commit/a3c068017b549cc29ccea9f545af6c079d94c3bd)
- ... [`c1e67e9`](https://github.com/ImageMagick/ImageMagick/commit/c1e67e9a606247f5cc51fa079f242c93a9aaaa60)
- pending release [`32bf14a`](https://github.com/ImageMagick/ImageMagick/commit/32bf14aa2ddb63cc919cf2fcb88a47998622cb69)
- Added missing call to SetImageProfile. [`4dca4a7`](https://github.com/ImageMagick/ImageMagick/commit/4dca4a7b3e719216a481b592683fb93c506dfda5)
- ... [`07ebe6b`](https://github.com/ImageMagick/ImageMagick/commit/07ebe6b6e47bbeadd84287c7395888df460677f8)

## [7.1.0-9](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-8...7.1.0-9) - 2021-10-03

### Commits

- Moved AngleThreshold to a separate method. [`64b48fc`](https://github.com/ImageMagick/ImageMagick/commit/64b48fc3dcf8cacf3334adcd236ae5eead1cef2e)
- Moved CircularityThreshold to a separate method. [`563de1c`](https://github.com/ImageMagick/ImageMagick/commit/563de1ce718e7c2cc9ed954bf3f1da7bc44ad301)
- Moved MinorAxisThreshold to a separate method. [`c7035c3`](https://github.com/ImageMagick/ImageMagick/commit/c7035c377f5734ddecf3665e92bdabcc8e90d93e)
- Moved PerimeterThreshold to a separate method. [`7052540`](https://github.com/ImageMagick/ImageMagick/commit/7052540aff4ab22021f06cdd539c987fd8a587c4)
- Silenced warnings. [`8cc5ffd`](https://github.com/ImageMagick/ImageMagick/commit/8cc5ffdf20195e2a854915f5c6039f7fafe281e6)
- Moved MajorAxisThreshold to a separate method. [`7ae012a`](https://github.com/ImageMagick/ImageMagick/commit/7ae012ab99a969603aa570d1ec0460390ab517b5)
- Moved EccentricityThreshold to a separate method. [`0886f20`](https://github.com/ImageMagick/ImageMagick/commit/0886f209b8e350e23725fd50f69877932aa19aba)
- Silenced warnings. [`927966d`](https://github.com/ImageMagick/ImageMagick/commit/927966d480bc9b81f19a4d1124b9e3845cae78be)
- Silenced warnings. [`ab616d3`](https://github.com/ImageMagick/ImageMagick/commit/ab616d398b342995edc55ccf6cc8b3c560b222e4)
- Removed unused arguments. [`7b3b3c7`](https://github.com/ImageMagick/ImageMagick/commit/7b3b3c76c7bf6b755fb11b496c64eb38f444ec54)
- Silenced warnings. [`083ac80`](https://github.com/ImageMagick/ImageMagick/commit/083ac80d33d0274ab7915751edaf8eed7b306672)
- Silenced warnings. [`a5ef57a`](https://github.com/ImageMagick/ImageMagick/commit/a5ef57ae24656e18405052e62313f58bfc3209bb)
- Adjust the x1 offset of the bounds to make sure a font is rendered inside the canvas (#4278). [`ed6f7d0`](https://github.com/ImageMagick/ImageMagick/commit/ed6f7d073f2de45f6c6f07385bcf63196ca53edd)
- Silenced warnings. [`5405b78`](https://github.com/ImageMagick/ImageMagick/commit/5405b780821cd45845506e6c6afb409d01691a3e)
- ignore zero-length profiles [`071274b`](https://github.com/ImageMagick/ImageMagick/commit/071274b98aa4f12844595d8f14d667406069ef22)
- Silenced warnings. [`26380ba`](https://github.com/ImageMagick/ImageMagick/commit/26380ba9cf89464da86d690d9ba0bf7ce1687b06)
- Silenced warnings. [`a26b4b7`](https://github.com/ImageMagick/ImageMagick/commit/a26b4b78e2b45e36fb62aa046ae7d6b8f00dc26c)
- cosmetic [`8dbdb98`](https://github.com/ImageMagick/ImageMagick/commit/8dbdb9866e6522bf5ceea6b11b92a0d3370970eb)
- Correct replacement of spaces that use more than one octet (#4305). [`f5ea8b0`](https://github.com/ImageMagick/ImageMagick/commit/f5ea8b08fe2dc607b15741b56ebe9553f080210f)
- Silenced warnings. [`8a1f456`](https://github.com/ImageMagick/ImageMagick/commit/8a1f456ed3b23bd4334854b152a7756dceeac8e1)
- Silenced warnings. [`fa6182e`](https://github.com/ImageMagick/ImageMagick/commit/fa6182e1e5d6924976d662456e49666ed905ba8f)
- Silenced warnings. [`cbe2ee3`](https://github.com/ImageMagick/ImageMagick/commit/cbe2ee36bc291658d3b2e5a260d68991149af0fd)
- Silenced warnings. [`36a5fa7`](https://github.com/ImageMagick/ImageMagick/commit/36a5fa73c78600cbd0308e36440d84d4a84585b2)
- https://github.com/ImageMagick/ImageMagick/discussions/4227 [`633618c`](https://github.com/ImageMagick/ImageMagick/commit/633618c249b97bf5ac9d85fbeb5b6654757d809f)
- ... [`a14c4cd`](https://github.com/ImageMagick/ImageMagick/commit/a14c4cd8dddfa9fbb431aa55913914ba7f6efd02)
- Silenced warnings. [`db0911b`](https://github.com/ImageMagick/ImageMagick/commit/db0911bd69133c72a0fb2de06f8f10841e01d0ab)
- Corrected typecast. [`e0e829a`](https://github.com/ImageMagick/ImageMagick/commit/e0e829a84377110b5b35598726d6dcd5696b8dad)
- Removed unnecessary check. [`45b1ad6`](https://github.com/ImageMagick/ImageMagick/commit/45b1ad6cc5e1c4a4a50ebc0f97ed17c83991c0db)
- Silenced warnings. [`3ab1ec4`](https://github.com/ImageMagick/ImageMagick/commit/3ab1ec4c4bb49d1ac49911c88d8d5101799f1e46)
- Silenced warnings. [`0a9a6a8`](https://github.com/ImageMagick/ImageMagick/commit/0a9a6a8458d1b12a5ea5d16a0bda49fde6fd973e)
- Silenced warnings. [`9755ee2`](https://github.com/ImageMagick/ImageMagick/commit/9755ee291f559471eb400b9dd1729a648eedbb54)
- Silenced warnings. [`a0eac20`](https://github.com/ImageMagick/ImageMagick/commit/a0eac20ff7a8c0d8143eac41f8efa9047b002ce9)
- cosmetic [`7c50d57`](https://github.com/ImageMagick/ImageMagick/commit/7c50d57e4814cd66c1a943fefd9e5ed97c38ce85)
- Silenced warnings. [`30e4e15`](https://github.com/ImageMagick/ImageMagick/commit/30e4e15b7a54408bec7075d61ffe829e96b81c8f)
- Silenced warnings. [`ef8d0d7`](https://github.com/ImageMagick/ImageMagick/commit/ef8d0d76df6cfc20e1138eec0d4910e8142a7da5)
- Corrected typecast. [`7366f26`](https://github.com/ImageMagick/ImageMagick/commit/7366f2608cbf893212024955a1851ede76449ddf)
- Silenced warnings. [`8bdd2e5`](https://github.com/ImageMagick/ImageMagick/commit/8bdd2e5ef0afbfc5ed858d5466d251a414137869)
- Silenced warning. [`4df253e`](https://github.com/ImageMagick/ImageMagick/commit/4df253e17e8b224866088ef396eed2c760cb2753)
- Silenced warning. [`d61c9a0`](https://github.com/ImageMagick/ImageMagick/commit/d61c9a0fd30b3352ce8d6514e80471f6d2c85178)
- Revert patch because this breaks font rendering for other fonts. [`94721c6`](https://github.com/ImageMagick/ImageMagick/commit/94721c614080a605d911f1caf1bbd9f326827993)
- https://github.com/ImageMagick/ImageMagick/issues/4278 [`fd26b54`](https://github.com/ImageMagick/ImageMagick/commit/fd26b54726415f89d412c9b7c31f9c9d9a8954c7)
- Cosmetic [`2322da9`](https://github.com/ImageMagick/ImageMagick/commit/2322da9e21f1b2290dea74f5b1973d29466374a7)
- Cosmetic. [`7044df1`](https://github.com/ImageMagick/ImageMagick/commit/7044df16e5c834a66d650f293e6480a3026d46cc)
- Corrected comments and changed argument order. [`f64d4e0`](https://github.com/ImageMagick/ImageMagick/commit/f64d4e043a1fe05d4905e09c4836ad40fd6cf279)
- pending release [`7b5d247`](https://github.com/ImageMagick/ImageMagick/commit/7b5d247173533a7a29411f556cf548cf5d69b8de)
- Silenced warnings. [`a40c341`](https://github.com/ImageMagick/ImageMagick/commit/a40c34116fffaaf77dc0eb3fa426f4c637a90aad)
- Correction of the bounds measurements. [`bafbac2`](https://github.com/ImageMagick/ImageMagick/commit/bafbac2ace6a4f8b61fd8fe58401582fa8614330)
- Build both 32 and 64 bit version on Windows. [`4703bc1`](https://github.com/ImageMagick/ImageMagick/commit/4703bc125a353ce4701ffee8836249bf4d242eb4)
- Silenced warnings. [`5131213`](https://github.com/ImageMagick/ImageMagick/commit/51312133557621ac14fab5771360c8e953ac12e9)
- Silenced warnings. [`9e336f1`](https://github.com/ImageMagick/ImageMagick/commit/9e336f1f3c9511f2e848eb4ee80324b64a7d4c9d)
- Added extra check to prevent replacing a non-breaking space with a newline (#4305). [`de54d48`](https://github.com/ImageMagick/ImageMagick/commit/de54d48d716c833da3157f767233f25bd2e4d96f)
- Silenced warnings. [`5023814`](https://github.com/ImageMagick/ImageMagick/commit/5023814b5a23065f77edddb97c79eed1a810905f)
- Silenced warnings. [`c89ec48`](https://github.com/ImageMagick/ImageMagick/commit/c89ec48fed14278b965a203e1d4723b438d74d03)
- Silenced warning. [`49015df`](https://github.com/ImageMagick/ImageMagick/commit/49015df6081a0496a531251e3995c268252da2a1)
- Minor optimization. [`a251f85`](https://github.com/ImageMagick/ImageMagick/commit/a251f85620fcb7f03654feb94265d850df48ca94)
- Silence warning. [`bfe17f8`](https://github.com/ImageMagick/ImageMagick/commit/bfe17f8d308825079b886b11ed9b2e32ab50b576)
- Silenced warnings. [`3156587`](https://github.com/ImageMagick/ImageMagick/commit/31565876329d4813de0f1e4330a7a84f9a7b5dac)
- Throw exception instead. [`b5d7d22`](https://github.com/ImageMagick/ImageMagick/commit/b5d7d22de2c63129f85483523a45761a60a5677b)
- Added missing typecast. [`926e45f`](https://github.com/ImageMagick/ImageMagick/commit/926e45f87ba06e9adf168077988afea024982022)
- Silenced warnings. [`688b19a`](https://github.com/ImageMagick/ImageMagick/commit/688b19a560a3d4fa213bb07cdd15de00eb846576)
- cosmetic [`75be18b`](https://github.com/ImageMagick/ImageMagick/commit/75be18b28a037f37aa0c58dd81a044ac113c98e4)
- Silenced warnings. [`ba74500`](https://github.com/ImageMagick/ImageMagick/commit/ba74500b196220fa01d1cfc2632bba4721bfa56a)
- Silenced warning. [`cbf73b0`](https://github.com/ImageMagick/ImageMagick/commit/cbf73b0d97a1033d883091d3661eea002d2cf332)
- Minor adjustment. [`ebaee9e`](https://github.com/ImageMagick/ImageMagick/commit/ebaee9ea620690dabdff3792e3c86a2c8de9325f)
- Silenced warnings. [`8098135`](https://github.com/ImageMagick/ImageMagick/commit/8098135f9e2db5a70aad466cfa32e7abbdc20d59)
- Cosmetic. [`04643cd`](https://github.com/ImageMagick/ImageMagick/commit/04643cdd916553b19e4b7ec61b60a45ad22217f8)
- Removed unused variables. [`6d12d96`](https://github.com/ImageMagick/ImageMagick/commit/6d12d967a7c74a7830f4360172ff9a11518416f2)
- Removed unused variable. [`db286e6`](https://github.com/ImageMagick/ImageMagick/commit/db286e608e075d6d67cae77afe2c839eda3cb7ee)
- Space pointer was still pointing to the old string. [`dbfb273`](https://github.com/ImageMagick/ImageMagick/commit/dbfb273e2a261b6e849614c6c510bbac515955a6)
- ... [`1829d08`](https://github.com/ImageMagick/ImageMagick/commit/1829d08946e761db88ec9504f7d4afbfe8d58dc8)
- argument is const [`442703a`](https://github.com/ImageMagick/ImageMagick/commit/442703a3eb2c6f738c703fb01ded2833d7493a1a)
- check return status [`b213e5f`](https://github.com/ImageMagick/ImageMagick/commit/b213e5f2c02a81f9ee328f6ba1d1a4db80c2450b)
- use ANSI comments rather than C++ [`f76e974`](https://github.com/ImageMagick/ImageMagick/commit/f76e9743c33b04364b6c3ee1f5234bb0ee1695eb)
- Corrected typecast. [`33cbae2`](https://github.com/ImageMagick/ImageMagick/commit/33cbae2c6fdb2dae77621e06204cfc571b1dda7b)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=39091 [`d9cb7ae`](https://github.com/ImageMagick/ImageMagick/commit/d9cb7ae93cb29b4a0624805cf4a40ef2d3824ee2)
- Corrected typecast. [`5940040`](https://github.com/ImageMagick/ImageMagick/commit/5940040706509a2f9fe5d93825c472b4207134cf)
- Use SETJMP_IS_THREAD_SAFE instead of custom IMPNG_SETJMP_IS_THREAD_SAFE (#4123). [`7921bf0`](https://github.com/ImageMagick/ImageMagick/commit/7921bf068c25e876a1adf287313de47e20d86817)
- Removed unused variable. [`dfa9f1a`](https://github.com/ImageMagick/ImageMagick/commit/dfa9f1a3b4d270ecf9dcd4c507e128d65241a574)
- Silenced warning. [`071352e`](https://github.com/ImageMagick/ImageMagick/commit/071352e56d35d187ebff342acace3891aea9560c)
- cosmetic [`cc13ed5`](https://github.com/ImageMagick/ImageMagick/commit/cc13ed59273c2412ede5278abccbd418eeab5420)
- Silenced warning. [`66ee0f7`](https://github.com/ImageMagick/ImageMagick/commit/66ee0f77b6a47c2d313e3f62fde5ff34cea5900e)
- Removed unnecessary include. [`f7bce58`](https://github.com/ImageMagick/ImageMagick/commit/f7bce58427ccb4d48d3c42e2648dfdcc6fe87474)
- Fixed warning. [`c7c273f`](https://github.com/ImageMagick/ImageMagick/commit/c7c273fb89b7d14f7b2b56a6c4dda40eaf504759)
- Added missing semicolon. [`7f8d3bc`](https://github.com/ImageMagick/ImageMagick/commit/7f8d3bcd04c44242d448ae9fbd7a9d37f5f6b183)
- Use MAGICK_SSIZE_MAX instead because of the MagickMin. [`6ccb83b`](https://github.com/ImageMagick/ImageMagick/commit/6ccb83b8ad7e4532547ca738774a1aa74ff3b076)
- Removed assert. [`a70f43f`](https://github.com/ImageMagick/ImageMagick/commit/a70f43f5586ab3d8496f28e6833eb38bd273b534)
- pending release [`85b3172`](https://github.com/ImageMagick/ImageMagick/commit/85b3172d179b96ff45d27565fbe70e8ff946b5ab)
- Corrected solution configuration for the 32 bit build. [`f8c1f13`](https://github.com/ImageMagick/ImageMagick/commit/f8c1f138bd746a27b41aee6355a571f7fd89a2cb)
- Corrected return type. [`7530cc8`](https://github.com/ImageMagick/ImageMagick/commit/7530cc8f3225be7b821fedfeb8aa49e06164f68a)
- https://github.com/ImageMagick/ImageMagick/pull/4270 [`3037b2f`](https://github.com/ImageMagick/ImageMagick/commit/3037b2f32923df3da91949f0d39129b7da4f0674)
- eliminate compiler warning [`69ea678`](https://github.com/ImageMagick/ImageMagick/commit/69ea678c1eb65755af1bb7753179da4f36f357fd)
- ... [`dd922fe`](https://github.com/ImageMagick/ImageMagick/commit/dd922fe9467bc6bf3cae41ce6a08c14c4d41abcf)
- Cosmetic. [`f910a2d`](https://github.com/ImageMagick/ImageMagick/commit/f910a2df14d7687cab2412aea64b1883d22aae05)
- eliminate compiler warning [`59dc862`](https://github.com/ImageMagick/ImageMagick/commit/59dc86278286f391dc6afe86145bd9ee9482a1d4)
- Corrected compare. [`a37c206`](https://github.com/ImageMagick/ImageMagick/commit/a37c2068cd6dc918c275fa20e09e3fd8e113f353)
- Forgot to save the file before the commit. [`40384dd`](https://github.com/ImageMagick/ImageMagick/commit/40384dd6905598ce98d1fbf9e05432113ee9f174)
- Silenced warning. [`e50d7d3`](https://github.com/ImageMagick/ImageMagick/commit/e50d7d37b3402734157b74b40a2f56ff1d38bf89)
- Corrected typecast. [`f440be7`](https://github.com/ImageMagick/ImageMagick/commit/f440be70190edd7e6bf07616a27a9bed37d98292)
- Cosmetic. [`536cc83`](https://github.com/ImageMagick/ImageMagick/commit/536cc83a975bfd1345582bd7a81eba64740f722b)
- Use SIZE_MAX instead. [`2f442f7`](https://github.com/ImageMagick/ImageMagick/commit/2f442f7f05d02dc4d0a0399c32c07c1f47fc3841)
- Cosmetic. [`1a2c0fa`](https://github.com/ImageMagick/ImageMagick/commit/1a2c0fa9e1c56928acaac2b0c16afeaa3e8df9eb)
- Silenced warning. [`df0b207`](https://github.com/ImageMagick/ImageMagick/commit/df0b2071554a87a4c1a2b4a97965787aeb3ee793)
- continue parsing for warning [`8fd90c7`](https://github.com/ImageMagick/ImageMagick/commit/8fd90c7a92a487661ade6316444a8e6abe8d3c8e)
- Add another missing statement. [`fd03a8f`](https://github.com/ImageMagick/ImageMagick/commit/fd03a8fc9308f12a98ad8375d5ad16a3b8906c0a)
- Added missing statement. [`aa493c1`](https://github.com/ImageMagick/ImageMagick/commit/aa493c105f3b6f496f26f60735fb0d0848ba9b5b)

## [7.1.0-8](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-7...7.1.0-8) - 2021-09-18

### Commits

- ... [`ffee953`](https://github.com/ImageMagick/ImageMagick/commit/ffee953296479c7cb6a27b08b3cd12b29a96ef48)
- Silenced warning. [`e5e0a7d`](https://github.com/ImageMagick/ImageMagick/commit/e5e0a7dcaef08286e4e8066b42c415f8c73f4ead)
- Silenced warning. [`9419d6f`](https://github.com/ImageMagick/ImageMagick/commit/9419d6fd49f4944eef82c222e5e9c791be738444)
- Silenced warning. [`42ab885`](https://github.com/ImageMagick/ImageMagick/commit/42ab885b82356a810bf7d20a5169632ab883f45b)
- Removed date markers. [`428fe19`](https://github.com/ImageMagick/ImageMagick/commit/428fe19219b5bf7d84afa03109ee7c8c21a53b74)
- Silenced warning. [`30626f4`](https://github.com/ImageMagick/ImageMagick/commit/30626f44f3307a39d7a3addc47f31936e4ad043e)
- Give the buffer a proper size instead of "over allocating". [`00bb801`](https://github.com/ImageMagick/ImageMagick/commit/00bb80173921219b213cc4808e13fc7733edc44b)
- Make it easier to find the dates [`fdb072f`](https://github.com/ImageMagick/ImageMagick/commit/fdb072f8273b1ca4bc66a3e026bb6508b5af6862)
- ... [`d273f0f`](https://github.com/ImageMagick/ImageMagick/commit/d273f0fdd3e4b086959f10701b0cfbb27645344d)
- Add some more date prints to figure out what is taking so much time. [`739788f`](https://github.com/ImageMagick/ImageMagick/commit/739788fc60e50eb5140e83a280cae74858815cd9)
- Added missing null checks. [`ed9b3a1`](https://github.com/ImageMagick/ImageMagick/commit/ed9b3a1a403edce373912ad8862ffddb4a3125cc)
- Removed unused variable. [`3c4656a`](https://github.com/ImageMagick/ImageMagick/commit/3c4656a3f39071b7e7a35f6ddd9ec0d1333d68ff)
- DDS: fixed a bug that caused artefacts in images [`c799d44`](https://github.com/ImageMagick/ImageMagick/commit/c799d44523506a5f58fa39307a3c6e5504a3b144)
- Added missing null check. [`9ccbd97`](https://github.com/ImageMagick/ImageMagick/commit/9ccbd97d788dd3a5b876a808dcfacf2311392f54)
- Added missing call to InitializeMagick. [`d6d5a7d`](https://github.com/ImageMagick/ImageMagick/commit/d6d5a7da72dc4d2ff73ad0f335e1c3c4b70735a0)
- Added link to advisory. [`600a8e5`](https://github.com/ImageMagick/ImageMagick/commit/600a8e54c1a6cf353cf9365a02b9ba52bda91ee5)
- Print date at the start of the build. [`021d3ce`](https://github.com/ImageMagick/ImageMagick/commit/021d3ce4805618ff46d18bbfd7a0db2542f53781)
- Added missing bom. [`ecb2d22`](https://github.com/ImageMagick/ImageMagick/commit/ecb2d22d33ae9b8324dc641d6ea1afcf1920d9f2)
- pending release [`881869e`](https://github.com/ImageMagick/ImageMagick/commit/881869ed01d35333c4184edc319b17006dda3ce3)
- https://github.com/ImageMagick/ImageMagick/issues/4235 [`772e98c`](https://github.com/ImageMagick/ImageMagick/commit/772e98c6431d9999830acfe67eb95857530317d5)

## [7.1.0-7](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-6...7.1.0-7) - 2021-09-12

### Merged

- Added decode support for DDS Dxt10 format [`#4126`](https://github.com/ImageMagick/ImageMagick/pull/4126)

### Commits

- Code cleanup. [`2819152`](https://github.com/ImageMagick/ImageMagick/commit/28191523ff8650a3b4f28bbffcc60e02f593abc4)
- Renamed variables. [`6d56ce1`](https://github.com/ImageMagick/ImageMagick/commit/6d56ce1c2776bbeb71146b00b226fefc7328c815)
- Added separate method for MSVG rendering. [`5bc6089`](https://github.com/ImageMagick/ImageMagick/commit/5bc608983b3d1b364e91d927cb0fdca037b44b8e)
- Added BC7_ prefix to the new variables. [`abed239`](https://github.com/ImageMagick/ImageMagick/commit/abed23939f5a05972bca3c70c9a265f20f5fe960)
- Use yaml issue template instead. [`ecda000`](https://github.com/ImageMagick/ImageMagick/commit/ecda000b48679864cc03efd7ab14d56475f65feb)
- https://github.com/ImageMagick/ImageMagick/issues/4059 [`0ad86b1`](https://github.com/ImageMagick/ImageMagick/commit/0ad86b1de8de30a95f52e291f556836c7ce27701)
- Clean up the remaining PDF files if reading one of the files fails. [`51d10c0`](https://github.com/ImageMagick/ImageMagick/commit/51d10c05d5a4a409a80d90826dd3fbdd2b765c5f)
- Fixed incorrect check when module is used as the domain in policy.xml that would allow the use of a disabled module. [`816a070`](https://github.com/ImageMagick/ImageMagick/commit/816a070b8039102d1ead418c5101761cd7505836)
- ... [`f135b4c`](https://github.com/ImageMagick/ImageMagick/commit/f135b4cedfb418733d372ffc129eda5e0d1cb1d1)
- DDSInfo should be a const instead. [`c8bfe14`](https://github.com/ImageMagick/ImageMagick/commit/c8bfe144765bf91a200136054822badb1ea611b5)
- Don't set the resolution when the cropbox is used. (#2657) [`ae08737`](https://github.com/ImageMagick/ImageMagick/commit/ae0873767ab7b862e3d50a852279150e2f692fb2)
- Renamed variable. [`cc73c49`](https://github.com/ImageMagick/ImageMagick/commit/cc73c49654f15c11e8e8ce1d3810c78b0f8d6a1a)
- Code style changes. [`325f1f1`](https://github.com/ImageMagick/ImageMagick/commit/325f1f12643ed86f893b347c21f0811ff2a1dfee)
- Renamed variable. [`b0cda46`](https://github.com/ImageMagick/ImageMagick/commit/b0cda462f3a8190fd1694087eb44b12866159f00)
- ... [`faa87f4`](https://github.com/ImageMagick/ImageMagick/commit/faa87f444450529de0d6dddd37baa992bd3460dc)
- Corrected indentation. [`6d3a9fc`](https://github.com/ImageMagick/ImageMagick/commit/6d3a9fc09db05d8a4db6eae3af1c0586e22b1b77)
- Update README.md [`029ff7d`](https://github.com/ImageMagick/ImageMagick/commit/029ff7d5ea6c5d19ee6c9d6154a6e4262943caa6)
- Added yml to the .editorconfig [`c5ae597`](https://github.com/ImageMagick/ImageMagick/commit/c5ae59784cd3942e2cb302f819e8911c4d431fa8)
- Use the correct rights. [`01faddb`](https://github.com/ImageMagick/ImageMagick/commit/01faddbe2711a4156180c4a92837e2f23683cc68)
- Update README.md [`1838dee`](https://github.com/ImageMagick/ImageMagick/commit/1838dee27e2907e0f16c252be0029f6ea00aec6d)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=38401 [`c5d3358`](https://github.com/ImageMagick/ImageMagick/commit/c5d3358acc7cb76b9321004ff3fe6342e7c630e7)
- Renamed variable. [`99c26a8`](https://github.com/ImageMagick/ImageMagick/commit/99c26a87fabc827b9b6a00c6f34beff1a53db7eb)
- Update comment about availbale ImageTypes [`59b288d`](https://github.com/ImageMagick/ImageMagick/commit/59b288da691c30adf330334898261eff868bd13d)
- Update README.md [`bc29170`](https://github.com/ImageMagick/ImageMagick/commit/bc291701c358532dcdea350b3447b839cfc3043f)
- Update README.md [`4606c0a`](https://github.com/ImageMagick/ImageMagick/commit/4606c0aa51e9512ed48fc0199ece6cf0caec850c)
- Whitespace. [`341249b`](https://github.com/ImageMagick/ImageMagick/commit/341249be9340fc3382c86045779b756dae43fe87)
- Added missing calls to clean up the tile_image. [`a0232bf`](https://github.com/ImageMagick/ImageMagick/commit/a0232bf812f419c97eedde66e0a764f318eab7bd)
- Added extra policy check. [`faad5a3`](https://github.com/ImageMagick/ImageMagick/commit/faad5a3caa24d7d0b34a7d8fe3f2b214a626293a)
- Code style changes. [`86f886d`](https://github.com/ImageMagick/ImageMagick/commit/86f886daf4d48f966a47a70ab8e1bd6003565267)
- Code style change. [`67bafc4`](https://github.com/ImageMagick/ImageMagick/commit/67bafc4db482d5d90fa4455293c982713b11dee0)
- pending release [`9d3fc1a`](https://github.com/ImageMagick/ImageMagick/commit/9d3fc1a6142ee1180692d5a79f8c4367527d6843)
- Revert break to make it possible to use and allow list. [`8fa0697`](https://github.com/ImageMagick/ImageMagick/commit/8fa069797945f7b6e64b33cad4780311ff1b4ad5)
- Added early exits. [`b344d1f`](https://github.com/ImageMagick/ImageMagick/commit/b344d1f1090e73ce488938d6e5f5ac96a792356b)
- Initialize the arrays. [`8a41ce8`](https://github.com/ImageMagick/ImageMagick/commit/8a41ce827dfb1f499323ff20844e6c8ddf007c60)
- Added missing policy checks in RegisterStaticModules. [`35893e7`](https://github.com/ImageMagick/ImageMagick/commit/35893e7cad78ce461fcaffa56076c11700ba5e4e)
- Added missing call to CloseBlob. [`225b51d`](https://github.com/ImageMagick/ImageMagick/commit/225b51d7f2e86b8c8588022fe1e391249d023904)
- Minor optimization when nothing will change. [`0b295fb`](https://github.com/ImageMagick/ImageMagick/commit/0b295fbcf5d69a4388f67df55a7dbd468f5786e8)
- pending release [`bae7240`](https://github.com/ImageMagick/ImageMagick/commit/bae72403751eeaac75b87216ca34b59254c2af3e)
- Update README.md [`5cfbef1`](https://github.com/ImageMagick/ImageMagick/commit/5cfbef1a171606738bbf85b7e830de368f1d2f52)
- Removed define that breaks with the Windows 10 SDK version 2104. [`ae0bf44`](https://github.com/ImageMagick/ImageMagick/commit/ae0bf4469b4546914e1cd3767d560e665876e92a)
- Also set RGB channels when reading the image. [`adbc185`](https://github.com/ImageMagick/ImageMagick/commit/adbc1855ec4768bd6069d7749185410ecef63a37)
- Fixed typo. [`a538bea`](https://github.com/ImageMagick/ImageMagick/commit/a538beafd0c2edc9111663e62cff4e8127b07a29)
- pending release [`957e478`](https://github.com/ImageMagick/ImageMagick/commit/957e47818ef0ae9ce73ade28a649ee7411a736e7)
- Added missing magick_unreferenced. [`647e477`](https://github.com/ImageMagick/ImageMagick/commit/647e47752ca6053d4ba060ac808c359f5ef2d4d4)
- https://github.com/ImageMagick/ImageMagick/issues/2576 [`d368d3c`](https://github.com/ImageMagick/ImageMagick/commit/d368d3c6bab35ad8857acaccc7b85d10c021c2c8)
- Changed file encoding. [`4ffb600`](https://github.com/ImageMagick/ImageMagick/commit/4ffb60019e0958ba02dd7252efad5f6c45e5d109)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=38573 [`6d00c96`](https://github.com/ImageMagick/ImageMagick/commit/6d00c96343ce0f5d3a91327c4ef2ed42fbcf86ad)
- Changed build status link. [`1e1ab50`](https://github.com/ImageMagick/ImageMagick/commit/1e1ab508b1b5468fd9ae3a314d451e7da46f44de)
- Update README.md [`7f0e767`](https://github.com/ImageMagick/ImageMagick/commit/7f0e7673af0b63b76f27e13fb4c16ba5979c0d50)
- Use InheritException instead. [`d2a2f1c`](https://github.com/ImageMagick/ImageMagick/commit/d2a2f1ca5917cfbdfa188b0a8a534061659db2cb)
- Use AllPolicyRights instead. [`6920157`](https://github.com/ImageMagick/ImageMagick/commit/6920157d93973bc8f75bc60fa2f22da5127f1f4b)
- Added missing typecast. [`affcc88`](https://github.com/ImageMagick/ImageMagick/commit/affcc8804ab94d0d6dc0ee5afe8089517a1050ce)
- Added missing call to ConstrainColormapIndex. [`ea286be`](https://github.com/ImageMagick/ImageMagick/commit/ea286be7fdc95934b4773d3ef9d8eeb4efafd0b3)
- pending release [`9a01274`](https://github.com/ImageMagick/ImageMagick/commit/9a01274ab11088c8d59713748c0554bb4d534699)
- Update README.md [`f5e052e`](https://github.com/ImageMagick/ImageMagick/commit/f5e052eb551452a9a0411c15e2d05c2fc705513c)
- https://github.com/ImageMagick/ImageMagick/issues/2579 [`9108421`](https://github.com/ImageMagick/ImageMagick/commit/91084218c9a9d2fdcdb2f11d8af797acfc21d367)
- pending release [`720b86f`](https://github.com/ImageMagick/ImageMagick/commit/720b86f5d2c130b9dffb5e0e5a7b72f2c041b2a8)
- Update README.md [`e6077ba`](https://github.com/ImageMagick/ImageMagick/commit/e6077ba1f74cb26605f5561949c72e2bb80029eb)
- Removed travis CI link. [`15359c4`](https://github.com/ImageMagick/ImageMagick/commit/15359c48a90e7866d7b2599d3a572dd1b7190360)
- Added donate badge. [`71e0b77`](https://github.com/ImageMagick/ImageMagick/commit/71e0b772dd1f3df1ac54e46d85909c955405420e)
- Fixed memory leak. [`f9c35c9`](https://github.com/ImageMagick/ImageMagick/commit/f9c35c91bac4d6380edeaaad8e536a7ef1fdb489)

## [7.1.0-6](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-5...7.1.0-6) - 2021-09-04

### Commits

- https://github.com/ImageMagick/ImageMagick/issues/4105 [`90914bd`](https://github.com/ImageMagick/ImageMagick/commit/90914bd1b924ef4b95c24a3ca1e579252d2fc5fc)
- Code style changes. [`3b90f52`](https://github.com/ImageMagick/ImageMagick/commit/3b90f52ce2fb342d26bf8e0c2cf60f9e312e2bd2)
- Moved typecast to silence warnings. [`b069eb6`](https://github.com/ImageMagick/ImageMagick/commit/b069eb61b146e146c9583f72067c2426c3e1fe55)
- Use different values per channel for scale and translate. [`4b9d95f`](https://github.com/ImageMagick/ImageMagick/commit/4b9d95fb1aa138cc75592f5331c5ce99faae94ba)
- Some optimizations when reading the exif profile. [`eb7cd80`](https://github.com/ImageMagick/ImageMagick/commit/eb7cd800ba6392ae6bd05f71a2c2718e59848af5)
- Removed checks for old Visual Studio versions. [`01ad6b3`](https://github.com/ImageMagick/ImageMagick/commit/01ad6b38b56cb3d1338eb959555e2eeffa986314)
- Use link for the Windows build instructions instead. [`5ec7806`](https://github.com/ImageMagick/ImageMagick/commit/5ec78060a7a8a19066029f4eb32bee8eca4b585b)
- Added support for reading the XMP profile from iTXt chunk (#4114). [`02fab91`](https://github.com/ImageMagick/ImageMagick/commit/02fab910d4043b5d6d0ab41676d53741aaea334c)
- ./configure --help no longer lists -disable-assert twice [`ac8fdfa`](https://github.com/ImageMagick/ImageMagick/commit/ac8fdfa944724cf5565b33d3f876d5ebdefded71)
- ... [`2d444c9`](https://github.com/ImageMagick/ImageMagick/commit/2d444c93b34f1a77c7d1d7570ba3e9350697af4e)
- Revert local changes that should not have been committed yet. [`b9d8ebf`](https://github.com/ImageMagick/ImageMagick/commit/b9d8ebf930f22b375ffe09b59b33e6eb7e8ad44c)
- Introduce new define for the visual studio version. [`94700f1`](https://github.com/ImageMagick/ImageMagick/commit/94700f1662e4ec293b0bea4e5d096d468988ebae)
- Code style fixes. [`8447575`](https://github.com/ImageMagick/ImageMagick/commit/8447575dace7a606f73a8c3e2f374d907af382c1)
- Minor refactoring. [`c2907ae`](https://github.com/ImageMagick/ImageMagick/commit/c2907ae9a2751ffd37981ea78e8b7b5d8495cdae)
- Include the compiler version in the output when it is known. [`cf472f4`](https://github.com/ImageMagick/ImageMagick/commit/cf472f4997caf053cd467ce10ae00c5fc696ed00)
- https://github.com/ImageMagick/ImageMagick/issues/4128 [`37c9732`](https://github.com/ImageMagick/ImageMagick/commit/37c9732d4fd51f6868a7c005b6036a137cdccc8b)
- initialize buffer before calling TIFFGetField() [`428fa64`](https://github.com/ImageMagick/ImageMagick/commit/428fa64baa6075b93f09857aea77fdac74d16f86)
- Some more code cleanup. [`99f677d`](https://github.com/ImageMagick/ImageMagick/commit/99f677d622fc946f4376aa18846fdd85cead9a28)
- Add -HDRI to the quantum in the version string when HDRI is enabled. [`0e7233e`](https://github.com/ImageMagick/ImageMagick/commit/0e7233ef4256a7ac1a03bc726ca74f8228f192b9)
- Whitespace. [`70956aa`](https://github.com/ImageMagick/ImageMagick/commit/70956aa4058c556b5b3f0a28416951ba966d4419)
- Comment changes. [`ccb5555`](https://github.com/ImageMagick/ImageMagick/commit/ccb5555af3aa0bc1b1197cf5e3ba0c4049145c73)
- pending release [`a454b3a`](https://github.com/ImageMagick/ImageMagick/commit/a454b3a2aec75482aaaf040f072102b264e0fa35)
- Added missing define for the Windows build. [`6476508`](https://github.com/ImageMagick/ImageMagick/commit/6476508e5af1e6ad8be337fb526a4b955e5f98b5)
- https://github.com/ImageMagick/ImageMagick/issues/4121 [`3c9c259`](https://github.com/ImageMagick/ImageMagick/commit/3c9c25927f6601dc778278de595b5cb0a4da6bd1)
- Minor changes to the formatting of the parentheses. [`827d30b`](https://github.com/ImageMagick/ImageMagick/commit/827d30b598bcd8e8ffdf1d80f4f468ce94a7ec72)
- Use UTC date instead. [`7c589e7`](https://github.com/ImageMagick/ImageMagick/commit/7c589e7806142e6ee8d0afe68930ce7f501c214e)
- pending release [`f500d17`](https://github.com/ImageMagick/ImageMagick/commit/f500d17454a43130ffb30bd4ca7836594eabb456)
- tweak the bilevel image type [`83fb8c8`](https://github.com/ImageMagick/ImageMagick/commit/83fb8c8644eeac8c667bbcb19b647c36830cc64f)
- Also prevent disabling highres for a quantum depth above 16 [`bc6d819`](https://github.com/ImageMagick/ImageMagick/commit/bc6d819af99d742bd6cdcc2f191af2a72600898e)
- Updated .editorconfig. [`ffbe1ce`](https://github.com/ImageMagick/ImageMagick/commit/ffbe1cedd2aa83b365552bdadb44dc886fa0e792)
- Fixed typo. [`e007d45`](https://github.com/ImageMagick/ImageMagick/commit/e007d45b069de531e763f369baeed10fb391c5c5)
- Removed extra endif that breaks the build. [`5992cba`](https://github.com/ImageMagick/ImageMagick/commit/5992cba82a8dc90ccdf39163189dc72408836df8)
- https://oss-fuzz.com/testcase-detail/6502669439598592 [`1161978`](https://github.com/ImageMagick/ImageMagick/commit/1161978e8f3ff6607c5d0a34cd0e29150c4e29aa)
- Add -dPrinted=false to the Ghostscript options (#4019) [`f9b8490`](https://github.com/ImageMagick/ImageMagick/commit/f9b8490463b7d98ffb795457ceb4cf6e09593619)

## [7.1.0-5](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-4...7.1.0-5) - 2021-08-22

### Merged

- fix #4097：Division by zero in ReadEnhMetaFile() of coders/emf.c [`#4098`](https://github.com/ImageMagick/ImageMagick/pull/4098)
- fix Division by zero in XMenuWidget() of MagickCore/widget.c [`#4041`](https://github.com/ImageMagick/ImageMagick/pull/4041)

### Fixed

- fix #4097：Division by zero in ReadEnhMetaFile() of coders/emf.c (#4098) [`#4097`](https://github.com/ImageMagick/ImageMagick/issues/4097)

### Commits

- identify grayscale images lurking in the PPM image format [`e4b53d0`](https://github.com/ImageMagick/ImageMagick/commit/e4b53d0f17962641e0502a93ec9c7a13b7086c98)
- additional grayscale optimizations [`acbf6a8`](https://github.com/ImageMagick/ImageMagick/commit/acbf6a87adc8b6a86628e006b8582a43c4ac4fc0)
- check is colorspace is incompatible before transforming it to sRGB [`f9e7a09`](https://github.com/ImageMagick/ImageMagick/commit/f9e7a09d8c2a1f24cfab503ac80cf2426b9c289d)
- migrate colorspace:auto-grayscale from MagickCore to coders where it belongs [`2af2970`](https://github.com/ImageMagick/ImageMagick/commit/2af297015b3752df59794ae554f8df33103caff3)
- prefer utimensat() over utime() [`481c8a4`](https://github.com/ImageMagick/ImageMagick/commit/481c8a4d165374a4e1262e75480147e3996f1072)
- check for grayscale with alpha channel [`6eea084`](https://github.com/ImageMagick/ImageMagick/commit/6eea084fd9f9f1be258376547344ca199ddc4625)
- Added new method to also preserve the creation of a file on Windows. This also fixes setting the timestamps on utf8 file names. [`df0b5ac`](https://github.com/ImageMagick/ImageMagick/commit/df0b5ac3eab808c0b39c497dcad41321dd8b4de6)
- optimizing grayscale images, a work in progress [`e265516`](https://github.com/ImageMagick/ImageMagick/commit/e26551682dd93331b6f3ef78a2ac366226df4915)
- Added support for reading the embedded thumbnail. [`06b50d3`](https://github.com/ImageMagick/ImageMagick/commit/06b50d3e60a23d23d11114f32fb128df86109033)
- Add support for writing the alpha channel (#1361) [`9da8d9c`](https://github.com/ImageMagick/ImageMagick/commit/9da8d9ccef4eaf37b3c765aae1399d8d2d83f0c6)
- Use a single buffer instead. [`c4367bc`](https://github.com/ImageMagick/ImageMagick/commit/c4367bc3ce261a03f74b66ff0c97cb7720b70725)
- Set the color encoding to fix writing JXL images with libjxl 0.5 (#4064) [`7fb6eda`](https://github.com/ImageMagick/ImageMagick/commit/7fb6eda2c0ce209bacdc38d1c88c4a7d26125322)
- ... [`085c116`](https://github.com/ImageMagick/ImageMagick/commit/085c1165f6158ebf968342d5a7d86690fdd7cf88)
- ensure we set image gamma to 1 for linear grayscale image types [`4dac01e`](https://github.com/ImageMagick/ImageMagick/commit/4dac01ec2f038b75316c99c64a3c0dbaed717cd5)
- Whitespace [`c79cf71`](https://github.com/ImageMagick/ImageMagick/commit/c79cf71e91bbdfff81ec0353f31671c2116c5dc1)
- Corrected indentation. [`1b25f37`](https://github.com/ImageMagick/ImageMagick/commit/1b25f37fb374cb371d78e6ba139ad9bf7a9bf6fe)
- optimize on grayscale detection [`11c49cd`](https://github.com/ImageMagick/ImageMagick/commit/11c49cde3c2b00cf5097d804f695762bc486ddc2)
- heap-based buffer overflow in TIFF coder (alert from Hunter Mitchell) [`1fa6e59`](https://github.com/ImageMagick/ImageMagick/commit/1fa6e59b0a8ae937cd04893ab3c6cdbdca0b5433)
- timeb.h is deprecated [`18e9f44`](https://github.com/ImageMagick/ImageMagick/commit/18e9f449af1847f650bab4d482d8e78b962748f8)
- grayscale images were not being written properly [`944a910`](https://github.com/ImageMagick/ImageMagick/commit/944a910a82f654e2eb2dc28d3081594d18b6a393)
- slight grayscale optimization [`b3f2cc6`](https://github.com/ImageMagick/ImageMagick/commit/b3f2cc6adf6f3b108958944eb4a7f58c96dd5ffc)
- Use new solution that is already upgrade to VS2019. [`8f77c3c`](https://github.com/ImageMagick/ImageMagick/commit/8f77c3c9caeb586f4a77e5aa09ade19320b67fe0)
- Added .editorconfig. [`558ff49`](https://github.com/ImageMagick/ImageMagick/commit/558ff49afbde4c208cf380682772a09cd9ee6746)
- revert grayscale optimization for now [`a8416bd`](https://github.com/ImageMagick/ImageMagick/commit/a8416bdc2a2a4bc04a9c0e9acf53cb4d070c9ab3)
- Fix memory leak in AnimateImageCommand() of MagickWand/animate.c and DisplayImageCommand() of MagickWand/display.c [`1630cbb`](https://github.com/ImageMagick/ImageMagick/commit/1630cbb8a5065aa769466baedac91f87e5c5bc89)
- Whitespace changes. [`85e440a`](https://github.com/ImageMagick/ImageMagick/commit/85e440a514fc24e78f51c7611538a02a44f812ac)
- eliminate compiler warning [`f0ed21d`](https://github.com/ImageMagick/ImageMagick/commit/f0ed21d134c26e5c2153c2910bf5b709553de393)
- reset image structure magick member [`7480434`](https://github.com/ImageMagick/ImageMagick/commit/748043424030bc4e01875812e199601c78739c72)
- Corrected return type to fix emscripten build error. [`bdeb549`](https://github.com/ImageMagick/ImageMagick/commit/bdeb549c28e130a02fdf90791acf7a7d5e10a66a)
- heap-based buffer overflow in TIFF coder (alert from Hunter Mitchell) [`005f7b9`](https://github.com/ImageMagick/ImageMagick/commit/005f7b9b4faba4a218befdae0d109fdfce0e8496)
- Fix typo - ellipical to elliptical [`346218b`](https://github.com/ImageMagick/ImageMagick/commit/346218b2d2d14466521d993e8c56c23fb9c8df76)
- https://github.com/ImageMagick/ImageMagick/issues/4059 [`b93a6a2`](https://github.com/ImageMagick/ImageMagick/commit/b93a6a2be891f1dbc761bdf4774b2e25b9109ff2)
- st_atim is st_atimespec under Apple/NetBSD [`fa64172`](https://github.com/ImageMagick/ImageMagick/commit/fa64172595cece87878e7b0b6439fca0e900b118)
- revert [`b6800c8`](https://github.com/ImageMagick/ImageMagick/commit/b6800c8f2aed871845b70462a70c8155abec1419)
- Upgrade solution instead. [`a225f4c`](https://github.com/ImageMagick/ImageMagick/commit/a225f4c065bb9ed031777ea8f4893f991f01e37d)
- Fix typo - Rodidoux to Robidoux [`f03ee36`](https://github.com/ImageMagick/ImageMagick/commit/f03ee363ed5a541383ee9f9dcda67a90c8aa7a24)
- Added missing call to DestroyDisplay. [`b38b91d`](https://github.com/ImageMagick/ImageMagick/commit/b38b91d035cd5524431563d91983dd803d1c7d2f)
- https://github.com/ImageMagick/ImageMagick/issues/4059 [`c14022a`](https://github.com/ImageMagick/ImageMagick/commit/c14022ab5b8593cc5c4c3f6936af93d2f9fb58b7)
- Renamed the method. [`e28d7c5`](https://github.com/ImageMagick/ImageMagick/commit/e28d7c54773706b02c65045d3c4a1d9e8b589f4a)
- Corrected remark to make it clear that this is for both reading and writing. [`5c09e3e`](https://github.com/ImageMagick/ImageMagick/commit/5c09e3e9cc6f904114e5c71cd1ff1a6df46cb9f8)
- heap-based buffer overflow in TIFF coder (alert from Hunter Mitchell) [`1ef7420`](https://github.com/ImageMagick/ImageMagick/commit/1ef7420842ae912a746350605b016b928ab0004d)
- Make sure a value is returned. [`1e59b57`](https://github.com/ImageMagick/ImageMagick/commit/1e59b5794eb74d1ff33138a79813fd23b36ad847)
- Added the new option to the ChangeLog. [`7f4edad`](https://github.com/ImageMagick/ImageMagick/commit/7f4edad9ae80cccfa0250656f1df1ba85997f744)
- revert [`5ee49d6`](https://github.com/ImageMagick/ImageMagick/commit/5ee49d66e6534ab7d145dce89e502a6d0b9f18fa)
- cosmetic [`2c2545d`](https://github.com/ImageMagick/ImageMagick/commit/2c2545d439c43bc2f5c1ebc2c6a9ad8511ecc359)
- pending release [`69ba0c4`](https://github.com/ImageMagick/ImageMagick/commit/69ba0c45f657e7b7bf5171099de24c5c57898684)
- revert and revisit [`386f933`](https://github.com/ImageMagick/ImageMagick/commit/386f933f4197446ced4873b184b966885c52229b)
- revert [`fcbce07`](https://github.com/ImageMagick/ImageMagick/commit/fcbce07c69505662575c09069802fe894c6a8dd2)
- slight optimization [`3aee329`](https://github.com/ImageMagick/ImageMagick/commit/3aee329e309398b1e830a7293b15ab6cb9a48c9c)
- Corrected return type to fix emscripten build error. [`9916dc4`](https://github.com/ImageMagick/ImageMagick/commit/9916dc45d319d0810882fd8d659246bcec041fff)
- Fixed build on non-Windows platform. [`86812bb`](https://github.com/ImageMagick/ImageMagick/commit/86812bb015dc8963d5bc006ce0b92207a12c7bac)
- Removed unused include. [`8334a7e`](https://github.com/ImageMagick/ImageMagick/commit/8334a7efba0571dc6a1561295eb1a309c5da65eb)
- Update reference to ImageMagick-6 [`4d65ee5`](https://github.com/ImageMagick/ImageMagick/commit/4d65ee597fd05151a9e7d8467c1e17f87baaa273)
- cosmetic [`8dd4859`](https://github.com/ImageMagick/ImageMagick/commit/8dd4859aac64ca758e15ba20c9f9f2fc0c1e58f0)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=36990 [`d137050`](https://github.com/ImageMagick/ImageMagick/commit/d137050dbe63cf1dcc815d6ecb5dfd1d56624335)
- set proper colormap index channel [`3ca9d29`](https://github.com/ImageMagick/ImageMagick/commit/3ca9d2972527b867f2c96b4997ddbd2ffc68d535)
- The DDSD_CAPS flags should also always be set. [`357ec61`](https://github.com/ImageMagick/ImageMagick/commit/357ec616c7a0a7247bd861619f2b32028af7cd2f)
- Use JxlColorEncodingSetToLinearSRGB instead. [`970724d`](https://github.com/ImageMagick/ImageMagick/commit/970724dfdbabb5476e314ec66723cbd93885fa3d)
- reduce memory moves [`316adb6`](https://github.com/ImageMagick/ImageMagick/commit/316adb6d5f257c51dd47bf9f47f20d141f1e57ec)
- pending release [`74f8154`](https://github.com/ImageMagick/ImageMagick/commit/74f8154136d2f631ca3e0421e6cf6c8dccd548f7)
- fix compiler exception [`84d7493`](https://github.com/ImageMagick/ImageMagick/commit/84d7493233fdbc60ad979bd97071c9bca121ce0a)
- cosmetic [`19cadba`](https://github.com/ImageMagick/ImageMagick/commit/19cadba2492ebb41dddbaea6c4219d2593f90129)
- pending release [`007c888`](https://github.com/ImageMagick/ImageMagick/commit/007c8882eb8b72878ae7a0209f1e2d225e533889)
- Use &amp; instead. [`c37514a`](https://github.com/ImageMagick/ImageMagick/commit/c37514ac3a08eece93ba23670529745026551c1f)
- cosmetic [`8c6e77e`](https://github.com/ImageMagick/ImageMagick/commit/8c6e77e03928ece193767f7ad9a1485b79578099)
- Correct order. [`fff99c1`](https://github.com/ImageMagick/ImageMagick/commit/fff99c14b1eaa7d0d11865d8ac2199689679bd9b)
- pending release [`6e11e59`](https://github.com/ImageMagick/ImageMagick/commit/6e11e59b8a8111c3052dfea99312d802254ebe95)
- https://github.com/ImageMagick/ImageMagick/discussions/4096 [`dc1df68`](https://github.com/ImageMagick/ImageMagick/commit/dc1df68764b537d90be3311f6413c4271ef1ad22)
- Removed incorrect assert. [`a365542`](https://github.com/ImageMagick/ImageMagick/commit/a36554278729ca2ab6dc9e84a220528380ec06a9)
- stop parsing on exception [`f0af490`](https://github.com/ImageMagick/ImageMagick/commit/f0af49097aafef2fcd391ee48ca02fb8ec99277c)
- stop parsing after exception [`21a99da`](https://github.com/ImageMagick/ImageMagick/commit/21a99da0c4da80453fa442998ffd92aa3f1716e8)

## [7.1.0-4](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-3...7.1.0-4) - 2021-07-18

### Commits

- ... [`433d174`](https://github.com/ImageMagick/ImageMagick/commit/433d17474d91aa37c5d933062b9c0a12fcbe9cf3)
- Fixed writing the iptc information when it is not stored as long. [`9f44f1e`](https://github.com/ImageMagick/ImageMagick/commit/9f44f1eb60a7669a0fd07ffb3086ba2075b8dd11)
- search for fftw delegate library by default [`7c082c3`](https://github.com/ImageMagick/ImageMagick/commit/7c082c32a622763b11644e05a16ea4ad717b09b8)
- revert, use -enable-fftw to include FFT support [`273b425`](https://github.com/ImageMagick/ImageMagick/commit/273b425df8f66dec898b3774b2ae24a8ea5d60ad)
- include header that defines DestroyWandIDs() [`2618a34`](https://github.com/ImageMagick/ImageMagick/commit/2618a34db049f68eea07d010de6961cc1ea63a1a)
- Added new video options to the ChangeLog. [`8930dae`](https://github.com/ImageMagick/ImageMagick/commit/8930dae0d126fff1ff3ccb76b12da895c7b2c89a)
- ... [`3497eb4`](https://github.com/ImageMagick/ImageMagick/commit/3497eb45819651fc3f16a4ee2e0e6c4f3c5c56cb)
- revert mods [`bb96fe8`](https://github.com/ImageMagick/ImageMagick/commit/bb96fe8039793751e7815b1c7d0aad6cd98cff3f)
- revert; keep CoreGenesis/CoreTerminus pairs; destroy wand ids [`d987d2d`](https://github.com/ImageMagick/ImageMagick/commit/d987d2d852bc55dd6d0895decf16d4d95bd5ba07)
- https://github.com/ImageMagick/ImageMagick/issues/3896 [`73ef506`](https://github.com/ImageMagick/ImageMagick/commit/73ef50686e69dbc2ea709f87435b1fd7cd3e4f8b)
- pending release [`fa6c65a`](https://github.com/ImageMagick/ImageMagick/commit/fa6c65a4c40e1fa63629cff9d847191b270378da)
- Use MagickWandGenesis and Terminus instead. [`2e262f3`](https://github.com/ImageMagick/ImageMagick/commit/2e262f3b1196b2ff8a43eaf454fc6fc52f805d91)
- pending release [`0c074c1`](https://github.com/ImageMagick/ImageMagick/commit/0c074c122501a5bc3831ff4f95a6bf2e323929ce)
- https://github.com/ImageMagick/ImageMagick/issues/3951 [`e7d3e18`](https://github.com/ImageMagick/ImageMagick/commit/e7d3e182b72ff9b2c3ea1c9aa0f14d69cc968ba7)
- pending release [`5369493`](https://github.com/ImageMagick/ImageMagick/commit/53694931e6abe01d86ecabd3b45dc60a0d7461df)
- pending release [`159d069`](https://github.com/ImageMagick/ImageMagick/commit/159d06999c78d620f07de749dea93137527114d6)
- Call MagickWandTerminus instead of MagickCoreTerminus to also destroy the wand id's. [`e80cbdf`](https://github.com/ImageMagick/ImageMagick/commit/e80cbdf3752eb5c8972f579ba9f88cfc235db524)
- ... [`d2a7a08`](https://github.com/ImageMagick/ImageMagick/commit/d2a7a083b6aa31232ecd90c28399059bbd747c77)
- Corrected call to RelinquishUniqueFileResource. [`4c1f846`](https://github.com/ImageMagick/ImageMagick/commit/4c1f84677557e44ae7c1e1c698a9415993a9dbee)
- ... [`5bd18b5`](https://github.com/ImageMagick/ImageMagick/commit/5bd18b5181671f534e9a01f366a19c7b6d902438)
- make genesis/terminus calls symmetric [`eddd1d9`](https://github.com/ImageMagick/ImageMagick/commit/eddd1d9d55b1bbda1b1ddad5c775fe251c65b003)
- ... [`418102d`](https://github.com/ImageMagick/ImageMagick/commit/418102ddffba555a18480b79de8713e69bdebe16)
- remove virtual canvas offset from similarity image [`e87b9ea`](https://github.com/ImageMagick/ImageMagick/commit/e87b9ea62438e2f679548bb2e50a3a64892b001d)
- Corrected cleanup of temporary files. [`8eb9c6c`](https://github.com/ImageMagick/ImageMagick/commit/8eb9c6c4898ac774a4c97dcfb783d0c751e64736)
- Set the file to null to make sure a new file is written. [`59c28ac`](https://github.com/ImageMagick/ImageMagick/commit/59c28ac750bfdb5c67ee72cbd5d9906e7227f50d)

## [7.1.0-3](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-2...7.1.0-3) - 2021-07-17

### Merged

- magick.sh.in: Corrected sample command [`#3867`](https://github.com/ImageMagick/ImageMagick/pull/3867)

### Commits

- accelerated correlation-based image similary using FFT local statistics [`a6515bf`](https://github.com/ImageMagick/ImageMagick/commit/a6515bf66736dee023a579dfc4a0b3922e447ccd)
- Moved PKGBUILD file to the ImageMagick-Windows repository. [`f3bca7e`](https://github.com/ImageMagick/ImageMagick/commit/f3bca7e8a352d18877e08170dbac37c4f376fa06)
- Test with mingw-w64 using MSYS2 CI [`6509eba`](https://github.com/ImageMagick/ImageMagick/commit/6509eba48ebb5fd8a398a3548389ddcec0b60836)
- Use a single check instead of multiple separate checks. [`a0b1ef3`](https://github.com/ImageMagick/ImageMagick/commit/a0b1ef32180ba0e71279d09da4a4f3c1a7575df4)
- ... [`bec7f7b`](https://github.com/ImageMagick/ImageMagick/commit/bec7f7bbe74e41b382e8dc0a54a277c76bc1d9aa)
- optimize NCC distortion [`d5a0e51`](https://github.com/ImageMagick/ImageMagick/commit/d5a0e51def85b5be295e8e1fb32b8f15c3f343d6)
- support -evaluate:clamp setting [`85f61c1`](https://github.com/ImageMagick/ImageMagick/commit/85f61c1974daeb23d53ac693198fbdbdee8e35b7)
- optimize grayscale detection [`ae67947`](https://github.com/ImageMagick/ImageMagick/commit/ae67947f9c098d2bd70b29dd3d502df6161bd06b)
- Restored changes that were removed by accident. [`c071597`](https://github.com/ImageMagick/ImageMagick/commit/c071597408a3265f7ef319b890e30b3cb2d7a7fc)
- Corrected getting the image dimensions when identifying a postscript file. [`d3eaf1a`](https://github.com/ImageMagick/ImageMagick/commit/d3eaf1ad42d07e612cbf85c42b9e5ba719f9a527)
- Fixed parsing the spot colors of a postscript document. [`86f2fd2`](https://github.com/ImageMagick/ImageMagick/commit/86f2fd2c65b051d244de445a99f8419b89dd5b2f)
- Added Windows MSYS2 to the daily build. [`1a50afe`](https://github.com/ImageMagick/ImageMagick/commit/1a50afeebd1a1204ffa748824af53717eebcdac8)
- ... [`20cee9e`](https://github.com/ImageMagick/ImageMagick/commit/20cee9ed101b9b57f3202f5e982a7621d3df7040)
- Use different defines to silence warning. [`dffc5fd`](https://github.com/ImageMagick/ImageMagick/commit/dffc5fd0103ecb44223b200fc0ff43e0e62359fe)
- system() is not supported under IOS [`43c4c09`](https://github.com/ImageMagick/ImageMagick/commit/43c4c099f349fba0d033b731064a1d021c1c80ad)
- Corrected earlier patch. [`c09727c`](https://github.com/ImageMagick/ImageMagick/commit/c09727c8fed0d557e2f9f2bc9821913da06851a9)
- Restored __MINGW32__ check. [`f69e87d`](https://github.com/ImageMagick/ImageMagick/commit/f69e87d030988d83025f735c3100cfc2416a28eb)
- skip channels with a zero standard-deviation [`1618240`](https://github.com/ImageMagick/ImageMagick/commit/161824005ee122630dfe09ac54faf16e1a6e23ed)
- Only call GetImageChannels once. [`86ff043`](https://github.com/ImageMagick/ImageMagick/commit/86ff0435472a50877a83a26ccfccaa8365f08e08)
- Check if this silences the mingw warnings. [`5c4a256`](https://github.com/ImageMagick/ImageMagick/commit/5c4a256ca0bb8aee173d5ffc49e88e4e69d05cd9)
- Introduce helper method. [`7bdaf57`](https://github.com/ImageMagick/ImageMagick/commit/7bdaf57fe297802a158b10f29d2a847218b44eac)
- Use defines from tiff headers to silence warnings. [`bad2e2d`](https://github.com/ImageMagick/ImageMagick/commit/bad2e2dac531eab540da9f19e687ccaf5769aa50)
- Replace all values with the new defines. [`cbd1212`](https://github.com/ImageMagick/ImageMagick/commit/cbd1212554265d32ad5ee803549b6f5e61f348d8)
- The defines are not available on MacOS. [`edaaf13`](https://github.com/ImageMagick/ImageMagick/commit/edaaf1326e87293f269f3b83490264ce3dae5580)
- The predictor tag should only be set for specific compression types. [`c55d9ac`](https://github.com/ImageMagick/ImageMagick/commit/c55d9ac269c1129230c82942820537acaab58261)
- Use markdown in the intro instead. [`48e729d`](https://github.com/ImageMagick/ImageMagick/commit/48e729dced01220ed5cf4f7035afaff4aab01a32)
- Added option to peek in the byte buffer. [`59d0b87`](https://github.com/ImageMagick/ImageMagick/commit/59d0b87bc168f0b510902f2402bc2cb5e9986704)
- Only get the number of channels once. [`d4ecdd3`](https://github.com/ImageMagick/ImageMagick/commit/d4ecdd329d067bafae6d59f91fcf65ed5ed57c71)
- Only do a single MSYS2 build in a regular commit. [`8b0e9aa`](https://github.com/ImageMagick/ImageMagick/commit/8b0e9aa6043782fa5d2a8e0a54e3a65e2b16f408)
- Silence warning. [`7b8159c`](https://github.com/ImageMagick/ImageMagick/commit/7b8159c1772d90f3e1a0cab56bea2a61e93e915a)
- Also allow specifying the pixel format when reading the image. [`81e4de3`](https://github.com/ImageMagick/ImageMagick/commit/81e4de31833026997edb9d85d540c623815afe55)
- skip zero pixels when dividing [`431e9b2`](https://github.com/ImageMagick/ImageMagick/commit/431e9b2b4445400d08a9d1b48199c380d9edc0ce)
- Use double instead. [`6680fc3`](https://github.com/ImageMagick/ImageMagick/commit/6680fc386ac06395c3ffd0cfa23207c34b336702)
- check for zero demoninator [`1999a4b`](https://github.com/ImageMagick/ImageMagick/commit/1999a4ba5623a3e56e3cebf0b416fb8dfed63aaa)
- Renamed variable. [`9264818`](https://github.com/ImageMagick/ImageMagick/commit/9264818998f920a9765d8d08986b4fc6a1dac923)
- Try without markdown. [`b56a2f6`](https://github.com/ImageMagick/ImageMagick/commit/b56a2f62ef2ec44692490b654c6cfe6f1352efae)
- Fixed copy paste mistake. [`40968cf`](https://github.com/ImageMagick/ImageMagick/commit/40968cff0716e3bd7e33e74be2f5258949fa4547)
- Moved define inside other define to silence warning. [`5498b40`](https://github.com/ImageMagick/ImageMagick/commit/5498b40f1609caf3e3cfd427396a2014ea4dc905)
- Added raqm to the autolinking list. [`c431f3f`](https://github.com/ImageMagick/ImageMagick/commit/c431f3f3a614aab0041b9643d1c022a04a0f76fd)
- Make it more clear that no memory is leaking. [`78228f0`](https://github.com/ImageMagick/ImageMagick/commit/78228f05b022912f368a3652da9937b135fe9311)
- fix threading issue [`3d924d1`](https://github.com/ImageMagick/ImageMagick/commit/3d924d1f29aa2bf40efb8ce036ee24c3c1ebbced)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=36248 [`cce49e3`](https://github.com/ImageMagick/ImageMagick/commit/cce49e30a5d1465f42d2c9b5deaa402ed2332f15)
- Try a different syntax instead. [`8c5a1af`](https://github.com/ImageMagick/ImageMagick/commit/8c5a1af2aadb054a086348ef87ab4ad6248a30ce)
- default to FFT acceleration when HDRI/FFT is enabled [`63d6df8`](https://github.com/ImageMagick/ImageMagick/commit/63d6df8addd0e83c32b960dae19cad70df0b9f9c)
- prevent blow-up when standard deviation is 0 [`6b1a23f`](https://github.com/ImageMagick/ImageMagick/commit/6b1a23fb3e75feddb217ed8dde7610c853a1ed30)
- Try a different check. [`0b606a7`](https://github.com/ImageMagick/ImageMagick/commit/0b606a75680fc3970b925881537198d2fb6c4126)
- pending release [`a39db78`](https://github.com/ImageMagick/ImageMagick/commit/a39db78bea625be78c1574f26b754696b20c3289)
- Corrected return type. [`ed3933d`](https://github.com/ImageMagick/ImageMagick/commit/ed3933d5cf2c3c6ea605cdff5fddd3ba1291e3e4)
- ... [`4480b3e`](https://github.com/ImageMagick/ImageMagick/commit/4480b3ec63f428c63c6c1f1c92e8dfd80326ca32)
- Disable font antialiasing when text_antialias is false (#3906). [`0c6512f`](https://github.com/ImageMagick/ImageMagick/commit/0c6512f82749e054a393675c7b68fdba4f327397)
- Added typecast to silence warning. [`af8fc23`](https://github.com/ImageMagick/ImageMagick/commit/af8fc23d08bc770aade4fa807d254251f475062c)
- cosmetic [`692e6e0`](https://github.com/ImageMagick/ImageMagick/commit/692e6e0594ab861566d70a4ceadbfa5f22234e97)
- Set the pixel format to ARGB when reading an animated PNG file. [`95add9f`](https://github.com/ImageMagick/ImageMagick/commit/95add9f12b236e0bf51e4ad94fc3c4f7afdaa87e)
- Added support for setting the interline_spacing (#3827) [`8ada7db`](https://github.com/ImageMagick/ImageMagick/commit/8ada7db5007dbf92477755c7bcd1d234ff1d63d9)
- Corrected copy paste mistake. [`deb6c52`](https://github.com/ImageMagick/ImageMagick/commit/deb6c5268af1003c4f015580d731905e32b595a5)
- Try linking with different libraries. [`8d1c095`](https://github.com/ImageMagick/ImageMagick/commit/8d1c0955250540216d88c7f4ba9241e3357caa54)
- Add libwebp.a again. [`7f5451f`](https://github.com/ImageMagick/ImageMagick/commit/7f5451f1fd54f96f68da227a81afa02068bdcd80)
- set imaginary component of the complex conjugate to -Ai [`3a9c3ed`](https://github.com/ImageMagick/ImageMagick/commit/3a9c3ed1e4b5aba7f6eef5a6c9af1974a4c7e16b)
- ... [`6c23915`](https://github.com/ImageMagick/ImageMagick/commit/6c23915c22c46d322580909b99f515cd67277aa7)
- Added missing typecast. [`ef201e1`](https://github.com/ImageMagick/ImageMagick/commit/ef201e152033a37913efa6dd191f96205df65f32)
- https://github.com/ImageMagick/ImageMagick/issues/3925 [`a4aa7af`](https://github.com/ImageMagick/ImageMagick/commit/a4aa7afdeb56c495b9ed48852a768174382639c0)
- Moved define to silence warning [`7107723`](https://github.com/ImageMagick/ImageMagick/commit/7107723e5c107f7f6146e5a42ae0d2f9c8f6b90f)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=36257 [`606b7da`](https://github.com/ImageMagick/ImageMagick/commit/606b7dab1c1f3e63b4cd2cca5d77ae3978a6659b)
- ... [`2f59f48`](https://github.com/ImageMagick/ImageMagick/commit/2f59f484faf87958830755d3b29bfa16de1e8091)
- remove debugging output [`e261961`](https://github.com/ImageMagick/ImageMagick/commit/e261961e2af8bd1031f5a54b4d2a184ac9728e35)
- ... [`c4df93b`](https://github.com/ImageMagick/ImageMagick/commit/c4df93bb37c4d82aea20af77fdbfea5c3df54753)
- ... [`2f8d1ea`](https://github.com/ImageMagick/ImageMagick/commit/2f8d1ea3a55c2c76d8fc19f716f58e029397fc17)
- Remove newline [`1ebec54`](https://github.com/ImageMagick/ImageMagick/commit/1ebec5455d4783125cca25fdd6631b617ba99296)

## [7.1.0-2](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-1...7.1.0-2) - 2021-06-25

### Commits

- ... [`580ab36`](https://github.com/ImageMagick/ImageMagick/commit/580ab36e3c1f35820007d76a65f899fe070ebd78)
- ... [`7e4a3fd`](https://github.com/ImageMagick/ImageMagick/commit/7e4a3fd49ce77e6ab77a31c1683f04f904e82658)
- pending release [`779e759`](https://github.com/ImageMagick/ImageMagick/commit/779e7591234a038f515f415cee7fdc42d1968d24)
- pending release [`c475e5e`](https://github.com/ImageMagick/ImageMagick/commit/c475e5eb6608b8e12b0a31ecb20817c65ad3c62c)
- fix memory corruption in ConcatenateStringInfo [`601356f`](https://github.com/ImageMagick/ImageMagick/commit/601356f1d2881b57945de8c22349d8758927f76a)
- ... [`c46b374`](https://github.com/ImageMagick/ImageMagick/commit/c46b37479fb7ddec1455a040c72aae0f61c76d46)

## [7.1.0-1](https://github.com/ImageMagick/ImageMagick/compare/7.1.0-0...7.1.0-1) - 2021-06-20

### Commits

- Execute the video decode delegate differently to make it possible to add extra options. [`cc4638d`](https://github.com/ImageMagick/ImageMagick/commit/cc4638de0c98701b04478a7ecd828caaeb0b58bd)
- ver allocate memory, typically used when concatentating strings [`dfbf466`](https://github.com/ImageMagick/ImageMagick/commit/dfbf466c79608daf2ed4fe449c699eee4fae0891)
- The pixel memory should be available until WebPAnimEncoderAssemble has been called when writing an animated image. [`75600bb`](https://github.com/ImageMagick/ImageMagick/commit/75600bb09759939ec9ff9434b8dc8c7a53c8ba10)
- Minor refactor. [`ab341ee`](https://github.com/ImageMagick/ImageMagick/commit/ab341eeb27d977eb70d67c54090d6b8fce169590)
- ... [`2375efa`](https://github.com/ImageMagick/ImageMagick/commit/2375efa7071024ae4e7a229285860958b4ffdab4)
- Renamed variables to make the code more readable. [`409b7c6`](https://github.com/ImageMagick/ImageMagick/commit/409b7c6303a5085408343b892d763b0a0e605075)
- ... [`ef93bbf`](https://github.com/ImageMagick/ImageMagick/commit/ef93bbf56ee823bad6ec8b35d415c51ff4ccf2b3)
- Added option to set the vsync option of the video decoder. [`b5604c4`](https://github.com/ImageMagick/ImageMagick/commit/b5604c459f80ff3421e4667d30cf11460a192c2a)
- https://github.com/ImageMagick/ImageMagick/issues/3844 [`ab847ac`](https://github.com/ImageMagick/ImageMagick/commit/ab847ac43f81ea470ac297bf17dc519b1bc06700)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=35322 [`4e56815`](https://github.com/ImageMagick/ImageMagick/commit/4e568154b4c8f9c3a3d5e86d433df013a1c65e96)
- Added extra method to silence warning. [`1f1b43e`](https://github.com/ImageMagick/ImageMagick/commit/1f1b43ea7a493b47d77a9f9de767f06ba511378d)
- Revert patch that automatically changes the image orientation #3844. [`b1d0888`](https://github.com/ImageMagick/ImageMagick/commit/b1d08886f2f4dce7a2edf24d954b46564ced8cd8)
- Use const instead. [`95a729d`](https://github.com/ImageMagick/ImageMagick/commit/95a729dec8abc3aa294eb5cc01cb9d41ed76bfa1)
- Allow reading of incorrectly stored XMP profiles (#3617). [`e71d08a`](https://github.com/ImageMagick/ImageMagick/commit/e71d08aa98be7f1d42b638c12d5f5291a873eb75)
- pending release [`7d5d870`](https://github.com/ImageMagick/ImageMagick/commit/7d5d8709200877102c5a46c2a273c013c407aa77)
- Moved type cast. [`98e5c74`](https://github.com/ImageMagick/ImageMagick/commit/98e5c745a15bfb366f7111230ab60349e4cb2220)
- pending release [`a5513da`](https://github.com/ImageMagick/ImageMagick/commit/a5513da1b8559fc6789248b7d5afdc1b0bc672e1)
- pending release [`0dfbabe`](https://github.com/ImageMagick/ImageMagick/commit/0dfbabe9a64c106cfded5aaa1759d39ee5f09272)
- pending release [`85ae49e`](https://github.com/ImageMagick/ImageMagick/commit/85ae49e52b28376eee6c62a286217a7aae8efd3b)
- ... [`50a0ccb`](https://github.com/ImageMagick/ImageMagick/commit/50a0ccbf19bc57f40a372a8c9de11e29de74bcce)

## [7.1.0-0](https://github.com/ImageMagick/ImageMagick/compare/7.0.11-14...7.1.0-0) - 2021-06-12

### Commits

- Use script from GitHub repository instead. [`a684bb0`](https://github.com/ImageMagick/ImageMagick/commit/a684bb010b8ef84481b1603d8a6b74d94c556439)
- Corrected writing the icc profile in a PDF file (#2070). [`05486ef`](https://github.com/ImageMagick/ImageMagick/commit/05486efc97630a35f9c054f3fe2a4f09b103278a)
- https://github.com/ImageMagick/ImageMagick/issues/3768 [`4cf2209`](https://github.com/ImageMagick/ImageMagick/commit/4cf220914f3aac3df8ddbb805d26ee670eb7d89f)
- ... [`0a231ef`](https://github.com/ImageMagick/ImageMagick/commit/0a231ef6295b99d27f08db1406ea3aff39bf8fd5)
- ... [`3198e92`](https://github.com/ImageMagick/ImageMagick/commit/3198e92443989fba52c454c259d9495aea86defc)
- https://github.com/ImageMagick/ImageMagick/issues/3786 [`bccd8ab`](https://github.com/ImageMagick/ImageMagick/commit/bccd8abe11e42b1549a1ce2dcb809ed0d33519e5)
- ... [`20ff6c8`](https://github.com/ImageMagick/ImageMagick/commit/20ff6c82c75ecc5b8241610c25464daf01f615a3)
- Minor refactoring. [`8d78773`](https://github.com/ImageMagick/ImageMagick/commit/8d78773891268cf41429ece4a688a80651818361)
- https://github.com/ImageMagick/ImageMagick/issues/3779 [`59b1d3f`](https://github.com/ImageMagick/ImageMagick/commit/59b1d3fe20b237e61f12efaf321dbdd68b5e2d77)
- https://github.com/ImageMagick/ImageMagick/discussions/3813 [`2430701`](https://github.com/ImageMagick/ImageMagick/commit/24307018801f6c0aea5a8286769a1d25c55ba611)
- Write the number of channels of the color profile instead of the image (#2070). [`53a01a2`](https://github.com/ImageMagick/ImageMagick/commit/53a01a2eb137c57e57f060705247fd3df81a5a5f)
- https://github.com/ImageMagick/ImageMagick/issues/3765 [`4cfe557`](https://github.com/ImageMagick/ImageMagick/commit/4cfe557096716f29ab2b2c5202bb2024e63b198b)
- Fix memory leak when it failed to apply ICC color profile [`565b9c4`](https://github.com/ImageMagick/ImageMagick/commit/565b9c4c1d09cdcb016ab77a16c643b9a1755ae2)
- https://github.com/ImageMagick/ImageMagick/issues/3768 [`61ef464`](https://github.com/ImageMagick/ImageMagick/commit/61ef464fc1f1163b4c5b9eacac68ab8ba872e107)
- pending release [`9876f46`](https://github.com/ImageMagick/ImageMagick/commit/9876f46e75aa33874e2d5f807f1d68e2b7887a6d)
- The area value should only be atomic. [`220b524`](https://github.com/ImageMagick/ImageMagick/commit/220b5247245022d9f7636b9fab4adcef88ee3be9)
- https://github.com/ImageMagick/ImageMagick/issues/3818 [`d64f1bb`](https://github.com/ImageMagick/ImageMagick/commit/d64f1bb3a4444898da8cc542c3b9bdda667ea3e9)
- Updated ChangeLog with jpeg-xl changes. [`57e2c38`](https://github.com/ImageMagick/ImageMagick/commit/57e2c3877b3b257467abcdf0c600561a658d7caf)
- When the compression is OJPEG the colorspace should not be changed to YCbCr. [`bb64ce7`](https://github.com/ImageMagick/ImageMagick/commit/bb64ce7240670b4f87bbeba4ac26d342cd1be016)
- Fixed incorrect call to ThrowWriterException. [`f2a0b40`](https://github.com/ImageMagick/ImageMagick/commit/f2a0b4043f0c506df781dd715e161db5d2cb0b33)
- https://github.com/ImageMagick/ImageMagick/issues/3818 [`864cf87`](https://github.com/ImageMagick/ImageMagick/commit/864cf878a04dbf976ca8e8b5dab7ddfd8a983aa2)
- Added define to silence a warning. [`010ae56`](https://github.com/ImageMagick/ImageMagick/commit/010ae561b65e7106a440b86eef895477996b2981)
- ... [`07b01f2`](https://github.com/ImageMagick/ImageMagick/commit/07b01f2760622b7ad0bed07b8dfb72cdf0444a81)
- ... [`fadc0fc`](https://github.com/ImageMagick/ImageMagick/commit/fadc0fc36d01baad3651194e27938d375228d46f)
- Whitespace. [`435fad9`](https://github.com/ImageMagick/ImageMagick/commit/435fad9d1e61d5a3f595cb556986052c4db33e03)
- https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=35024 [`6eac50b`](https://github.com/ImageMagick/ImageMagick/commit/6eac50b44aa93f52d9244329446b1f45a680c162)
- https://github.com/ImageMagick/ImageMagick/issues/3818 [`c955242`](https://github.com/ImageMagick/ImageMagick/commit/c9552421c6e970ba8b2740d10a9ef230b58f7dd3)
- pending release [`b4ca2be`](https://github.com/ImageMagick/ImageMagick/commit/b4ca2bed6e55417f439155eaa6a406ff71798116)
- Added missing define MAGICKCORE_HAVE_UTIME for the Windows build (#3777) [`9be0520`](https://github.com/ImageMagick/ImageMagick/commit/9be05207eb24eed7a161ac90ce5650d392546e41)
- ... [`869dd6b`](https://github.com/ImageMagick/ImageMagick/commit/869dd6bb77d9ded5da2e41fcf85dc580a28ce8aa)
- ... [`8050b71`](https://github.com/ImageMagick/ImageMagick/commit/8050b715a47876f01921fbee2d9d210e59620f91)
