/** \file base64.h
 * prototypes and definitions for base64.c
 */

#ifndef	BASE64_H_INCLUDED
#define	BASE64_H_INCLUDED

#include <stdbool.h>
#include <sys/types.h>

#include "word.h"

/** decode base64 in-place, \return the count of decoded bytes in the \a
 * word */
uint	base64_decode(word_t *word /** string to decode in-place, will be modified */);
/** check if \a word contains conformant base64-encoded data */
bool	base64_validate(const word_t *word);

#endif	/* BASE64_H_INCLUDED */
