/*****************************************************************************

NAME:
   system.h -- system definitions and prototypes for bogofilter

   WARNING: be sure to include this - or config.h - early, because
   some systems may otherwise #define macros from it.

   For instance, OpenIndiana defines _FILE_OFFSET_BITS unless we do.

******************************************************************************/

/* parts were taken from autoconf.info */

#ifndef SYSTEM_H
#define SYSTEM_H

#include "config.h"

#include <stdbool.h>    // for bool
#include <sys/types.h>  // for mode_t

#ifndef HAVE_STRLCPY
size_t strlcpy(/*@out@*/ char *dst, const char *src, size_t size);
#endif

#ifndef HAVE_STRLCAT
size_t strlcat(/*@out@*/ char *dst, const char *src, size_t size);
#endif

#ifdef __DGUX__
#undef EX_OK
#endif

/* Ignore __attribute__ if not using GNU CC */
#if	!defined(__GNUC__) && !defined(__attribute__)
#define __attribute__(a)
#endif

/* system.c - function prototypes */

extern bool bf_abspath(const char *path);
extern int  bf_mkdir(const char *path, mode_t mode);
extern void bf_sleep(long delay);

#endif /* SYSTEM_H */
