/*****************************************************************************

NAME:
   token.h -- prototypes and definitions for token.c

******************************************************************************/

#ifndef	TOKEN_H_INCLUDED
#define	TOKEN_H_INCLUDED

#include <sys/types.h>

#include "lexer.h"
#include "bftypes.h"
#include "word.h"


extern word_t *msg_addr;	/* First IP Address in Received: statement */
extern word_t *msg_id;		/* Message ID */
extern word_t *queue_id;	/* Message's first Queue ID */

extern token_t get_token(word_t *token);

extern void got_from(void);
extern void clr_tag(void);
extern void set_tag(const char *text);

extern void set_msg_id(byte *text, uint leng);

extern void token_init(void);
extern void token_cleanup(void);

/* used by lexer_text_html.l */
extern void html_tag(int level);
extern void html_comment(int level);

#endif	/* TOKEN_H_INCLUDED */
