export declare enum DocumentationTag {
    OS_MACOS = "os_macos",
    OS_MAS = "os_mas",
    OS_WINDOWS = "os_windows",
    OS_LINUX = "os_linux",
    STABILITY_EXPERIMENTAL = "stability_experimental",
    STABILITY_DEPRECATED = "stability_deprecated",
    AVAILABILITY_READONLY = "availability_readonly"
}
export declare type PossibleStringValue = {
    value: string;
    description: string;
};
export declare type DetailedStringType = {
    type: 'String';
    possibleValues: PossibleStringValue[] | null;
};
export declare type DetailedObjectType = {
    type: 'Object';
    properties: PropertyDocumentationBlock[];
};
export declare type DetailedEventType = {
    type: 'Event';
    eventProperties: PropertyDocumentationBlock[];
};
export declare type DetailedEventReferenceType = {
    type: 'Event';
    eventPropertiesReference: TypeInformation;
};
export declare type DetailedFunctionType = {
    type: 'Function';
    parameters: MethodParameterDocumentation[];
    returns: TypeInformation | null;
};
export declare type DetailedType = ({
    type: TypeInformation[];
} | DetailedFunctionType | DetailedObjectType | DetailedEventType | DetailedEventReferenceType | DetailedStringType | {
    type: string;
}) & {
    innerTypes?: TypeInformation[];
};
export declare type TypeInformation = {
    collection: boolean;
} & DetailedType;
export declare type MethodParameterDocumentation = {
    name: string;
    description: string;
    required: boolean;
} & TypeInformation;
export declare type EventParameterDocumentation = {
    name: string;
    description: string;
    required: boolean;
} & TypeInformation;
export declare type DocumentationBlock = {
    name: string;
    description: string;
    additionalTags: DocumentationTag[];
    urlFragment?: string;
};
export declare type MethodDocumentationBlock = DocumentationBlock & {
    rawGenerics?: string;
    signature: string;
    parameters: MethodParameterDocumentation[];
    returns: TypeInformation | null;
};
export declare type EventDocumentationBlock = DocumentationBlock & {
    parameters: EventParameterDocumentation[];
};
export declare type PropertyDocumentationBlock = DocumentationBlock & {
    required: boolean;
} & TypeInformation;
export declare type BaseDocumentationContainer = {
    name: string;
    extends?: string;
    description: string;
    version: string;
    slug: string;
    websiteUrl: string;
    repoUrl: string;
};
export declare type ProcessBlock = {
    main: boolean;
    renderer: boolean;
    utility: boolean;
    exported: boolean;
};
export declare type ModuleDocumentationContainer = {
    type: 'Module';
    process: ProcessBlock;
    methods: MethodDocumentationBlock[];
    events: EventDocumentationBlock[];
    properties: PropertyDocumentationBlock[];
    constructorMethod?: undefined;
    instanceMethods?: undefined;
    instanceEvents?: undefined;
    instanceProperties?: undefined;
    staticProperties?: undefined;
    staticMethods?: undefined;
    exportedClasses: ClassDocumentationContainer[];
} & BaseDocumentationContainer;
export declare type StructureDocumentationContainer = {
    type: 'Structure';
    properties: PropertyDocumentationBlock[];
    constructorMethod?: undefined;
    methods?: undefined;
    events?: undefined;
    instanceMethods?: undefined;
    instanceEvents?: undefined;
    instanceProperties?: undefined;
    staticProperties?: undefined;
    staticMethods?: undefined;
    extends?: string;
} & BaseDocumentationContainer;
export declare type ClassDocumentationContainer = {
    type: 'Class';
    process: ProcessBlock;
    constructorMethod: Pick<MethodDocumentationBlock, 'signature' | 'parameters'> | null;
    instanceName: string;
    staticMethods: MethodDocumentationBlock[];
    staticProperties: PropertyDocumentationBlock[];
    instanceMethods: MethodDocumentationBlock[];
    instanceEvents: EventDocumentationBlock[];
    instanceProperties: PropertyDocumentationBlock[];
    methods?: undefined;
    events?: undefined;
    properties?: undefined;
} & BaseDocumentationContainer;
export declare type ElementDocumentationContainer = {
    type: 'Element';
    process: ProcessBlock;
    constructorMethod?: undefined;
    methods: MethodDocumentationBlock[];
    events: EventDocumentationBlock[];
    properties: PropertyDocumentationBlock[];
    instanceMethods?: undefined;
    instanceEvents?: undefined;
    instanceProperties?: undefined;
    staticProperties?: undefined;
    staticMethods?: undefined;
} & BaseDocumentationContainer;
export declare type ParsedDocumentationResult = (ModuleDocumentationContainer | ClassDocumentationContainer | StructureDocumentationContainer | ElementDocumentationContainer)[];
export declare class ParsedDocumentation {
    private repr;
    addStructure(struct: StructureDocumentationContainer): void;
    addModuleOrClassOrElement(...apiContainers: (ModuleDocumentationContainer | ClassDocumentationContainer | ElementDocumentationContainer)[]): void;
    getJSON(): ParsedDocumentationResult;
}
