export declare class Fiddle {
    readonly mainPath: string;
    readonly source: string;
    constructor(mainPath: string, // /path/to/main.js
    source: string);
    remove(): Promise<void>;
}
/**
 * - Iterable of [string, string] - filename-to-content key/value pairs
 * - string of form '/path/to/fiddle' - a fiddle on the filesystem
 * - string of form 'https://github.com/my/repo.git' - a git repo fiddle
 * - string of form '642fa8daaebea6044c9079e3f8a46390' - a github gist fiddle
 */
export type FiddleSource = Fiddle | string | Iterable<[string, string]>;
export declare class FiddleFactory {
    private readonly fiddles;
    constructor(fiddles?: string);
    fromGist(gistId: string): Promise<Fiddle>;
    fromFolder(source: string): Promise<Fiddle>;
    fromRepo(url: string, checkout?: string): Promise<Fiddle>;
    fromEntries(src: Iterable<[string, string]>): Promise<Fiddle>;
    create(src: FiddleSource): Promise<Fiddle | undefined>;
}
