"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.runFromCommandLine = void 0;
const util_1 = require("util");
const debug_1 = __importDefault(require("debug"));
const versions_1 = require("./versions");
const fiddle_1 = require("./fiddle");
const runner_1 = require("./runner");
async function runFromCommandLine(argv) {
    const d = (0, debug_1.default)('fiddle-core:runFromCommandLine');
    d((0, util_1.inspect)({ argv }));
    const versions = await versions_1.ElectronVersions.create();
    const fiddleFactory = new fiddle_1.FiddleFactory();
    const runner = await runner_1.Runner.create({ versions, fiddleFactory });
    const versionArgs = [];
    let cmd = undefined;
    let fiddle = undefined;
    d('argv', (0, util_1.inspect)(argv));
    for (const param of argv) {
        d('param', param);
        if (param === 'bisect') {
            cmd = 'bisect';
        }
        else if (param === 'test' || param === 'start' || param === 'run') {
            d('it is test');
            cmd = 'test';
        }
        else if (versions.isVersion(param)) {
            versionArgs.push(param);
        }
        else {
            fiddle = await fiddleFactory.create(param);
            if (fiddle)
                continue;
            console.error(`Unrecognized parameter "${param}". Must be 'test', 'start', 'bisect', a version, a gist, a folder, or a repo URL.`);
            process.exit(1);
        }
    }
    d((0, util_1.inspect)({ cmd, fiddle, versions }));
    if (!cmd) {
        console.error("Command-line parameters must include one of ['bisect', 'test', 'start']");
        process.exit(1);
    }
    if (!fiddle) {
        console.error('No fiddle specified.');
        process.exit(1);
    }
    if (cmd === 'test' && versionArgs.length === 1) {
        const result = await runner.run(versionArgs[0], fiddle, {
            out: process.stdout,
        });
        const vals = ['test_passed', 'test_failed', 'test_error', 'system_error'];
        process.exitCode = vals.indexOf(result.status);
        return;
    }
    if (cmd === 'bisect' && versionArgs.length === 2) {
        const result = await runner.bisect(versionArgs[0], versionArgs[1], fiddle, {
            out: process.stdout,
        });
        const vals = ['bisect_succeeded', 'test_error', 'system_error'];
        process.exitCode = vals.indexOf(result.status);
        return;
    }
    console.error(`Invalid parameters. Got ${cmd}, ${versionArgs.join(', ')}`);
    process.exit(1);
}
exports.runFromCommandLine = runFromCommandLine;
