/// <reference types="node" />
import { EventEmitter } from 'events';
import { Paths } from './paths';
export type ProgressObject = {
    percent: number;
};
/**
 * The state of a current Electron version.
 * See {@link Installer.state} to get this value.
 * See Installer.on('state-changed') to watch for state changes.
 */
export declare enum InstallState {
    missing = "missing",
    downloading = "downloading",
    downloaded = "downloaded",
    installing = "installing",
    installed = "installed"
}
export interface InstallStateEvent {
    version: string;
    state: InstallState;
}
export interface Mirrors {
    electronMirror: string;
    electronNightlyMirror: string;
}
export interface ElectronBinary {
    path: string;
    alreadyExtracted: boolean;
}
export interface InstallerParams {
    progressCallback: (progress: ProgressObject) => void;
    mirror: Mirrors;
}
/**
 * Manage downloading and installing Electron versions.
 *
 * An Electron release's .zip is downloaded into `paths.electronDownloads`,
 * which holds all the downloaded zips.
 *
 * The installed version is unzipped into `paths.electronInstall`. Only one
 * version is installed at a time -- installing a new version overwrites the
 * current one in `paths.electronInstall`.
 *
 * See {@link DefaultPaths} for the default paths.
 */
export declare class Installer extends EventEmitter {
    private readonly paths;
    private readonly stateMap;
    constructor(pathsIn?: Partial<Paths>);
    static execSubpath(platform?: string): string;
    static getExecPath(folder: string): string;
    state(version: string): InstallState;
    private setState;
    private rebuildStates;
    /** Removes an Electron download or Electron install from the disk. */
    remove(version: string): Promise<void>;
    /** The current Electron installation, if any. */
    get installedVersion(): string | undefined;
    private download;
    private ensureDownloadedImpl;
    /** map of version string to currently-running active Promise */
    private downloading;
    ensureDownloaded(version: string, opts?: Partial<InstallerParams>): Promise<ElectronBinary>;
    /** keep a track of all currently installing versions */
    private installing;
    install(version: string, opts?: Partial<InstallerParams>): Promise<string>;
    private installVersionImpl;
}
