# parse-gitignore [![NPM version](https://img.shields.io/npm/v/parse-gitignore.svg?style=flat)](https://www.npmjs.com/package/parse-gitignore) [![NPM monthly downloads](https://img.shields.io/npm/dm/parse-gitignore.svg?style=flat)](https://npmjs.org/package/parse-gitignore)  [![NPM total downloads](https://img.shields.io/npm/dt/parse-gitignore.svg?style=flat)](https://npmjs.org/package/parse-gitignore) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/parse-gitignore.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/parse-gitignore)

> Parse a gitignore file into an array of patterns. Comments and empty lines are stripped.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save parse-gitignore
```

## Usage

```js
var gitignore = require('parse-gitignore');

// pass a filepath
var patterns = gitignore('.gitignore');
//=> ['*.DS_Store', 'node_modules', ...];
```

**Pass additional patterns**

Since the function already does unique-ifying on patterns, you can optionally pass an additional array of patterns to add to the patterns parsed from `.gitignore`:

```js
gitignore('.gitignore', ['foo', 'bar']);
//=> ['*.DS_Store', 'node_modules', 'foo', 'bar', ...]
```

## About

### Related projects

* [parse-author](https://www.npmjs.com/package/parse-author): Parse an author, contributor, maintainer or other 'person' string into an object with name, email… [more](https://github.com/jonschlinkert/parse-author) | [homepage](https://github.com/jonschlinkert/parse-author "Parse an author, contributor, maintainer or other 'person' string into an object with name, email and url properties following npm conventions.")
* [parse-git-config](https://www.npmjs.com/package/parse-git-config): Parse `.git/config` into a JavaScript object. sync or async. | [homepage](https://github.com/jonschlinkert/parse-git-config "Parse `.git/config` into a JavaScript object. sync or async.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** | 
| --- | --- |
| 26 | [jonschlinkert](https://github.com/jonschlinkert) |
| 1 | [schnittstabil](https://github.com/schnittstabil) |

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.4.3, on April 02, 2017._