import MarkdownIt from 'markdown-it';
import { FileStat, IMdLinkComputer, IMdParser, ITextDocument, IWorkspace, MdLink } from '@dsanders11/vscode-markdown-languageservice';
import { TextDocument } from 'vscode-languageserver-textdocument';
import { URI } from 'vscode-uri';
import type { Code } from 'mdast';
export type { Code };
export declare class MarkdownParser implements IMdParser {
    slugifier: import("@dsanders11/vscode-markdown-languageservice").ISlugifier;
    tokenize(document: TextDocument): Promise<{
        type: string;
        tag: string;
        attrs: [string, string][] | null;
        map: [number, number] | null;
        nesting: MarkdownIt.Token.Nesting;
        level: number;
        children: any[] | null;
        content: string;
        markup: string;
        info: string;
        meta: any;
        block: boolean;
        hidden: boolean;
        attrIndex(name: string): number;
        attrPush(attrData: [string, string]): void;
        attrSet(name: string, value: string): void;
        attrGet(name: string): string | null;
        attrJoin(name: string, value: string): void;
    }[]>;
}
export declare class DocsWorkspace implements IWorkspace {
    #private;
    private readonly documentCache;
    readonly root: string;
    readonly globs: string[];
    readonly ignoreGlobs: string[];
    constructor(root: string, globs: string[], ignoreGlobs?: string[]);
    get workspaceFolders(): URI[];
    getAllMarkdownDocuments(): Promise<Iterable<TextDocument>>;
    hasMarkdownDocument(resource: URI): boolean;
    getWorkspaceRelativePath(resource: URI): string;
    openMarkdownDocument(resource: URI): Promise<TextDocument | undefined>;
    stat(resource: URI): Promise<FileStat | undefined>;
    readDirectory(): Promise<Iterable<readonly [string, FileStat]>>;
    onDidChangeMarkdownDocument: import("vscode-languageserver").Event<ITextDocument>;
    onDidCreateMarkdownDocument: import("vscode-languageserver").Event<ITextDocument>;
    onDidDeleteMarkdownDocument: import("vscode-languageserver").Event<URI>;
}
export declare class MarkdownLinkComputer implements IMdLinkComputer {
    #private;
    private readonly workspace;
    constructor(workspace: IWorkspace);
    getAllLinks(document: ITextDocument): Promise<MdLink[]>;
}
export declare function getCodeBlocks(content: string): Promise<Code[]>;
