import * as OctokitTypes from "@octokit/types";
import * as DeviceTypes from "@octokit/auth-oauth-device";
import * as OAuthMethodsTypes from "@octokit/oauth-methods";
export declare type ClientType = "oauth-app" | "github-app";
export declare type WebFlowOptions = {
    code: string;
    state?: string;
    redirectUrl?: string;
};
declare type CommonOAuthAppStrategyOptions = {
    clientType?: "oauth-app";
    clientId: string;
    clientSecret: string;
    request?: OctokitTypes.RequestInterface;
};
declare type CommonGitHubAppStrategyOptions = {
    clientType?: "github-app";
    clientId: string;
    clientSecret: string;
    request?: OctokitTypes.RequestInterface;
};
declare type OAuthAppDeviceFlowOptions = {
    onVerification: DeviceTypes.OAuthAppStrategyOptions["onVerification"];
    scopes?: string[];
};
declare type GitHubDeviceFlowOptions = {
    onVerification: DeviceTypes.OAuthAppStrategyOptions["onVerification"];
};
declare type ExistingOAuthAppAuthenticationOptions = {
    clientType: "oauth-app";
    token: string;
    scopes: string[];
};
declare type ExistingGitHubAppAuthenticationOptions = {
    token: string;
};
declare type ExistingGitHubAppAuthenticationWithExpirationOptions = {
    token: string;
    refreshToken: string;
    expiresAt: string;
    refreshTokenExpiresAt: string;
};
export declare type OAuthAppStrategyOptionsWebFlow = CommonOAuthAppStrategyOptions & WebFlowOptions;
export declare type GitHubAppStrategyOptionsWebFlow = CommonGitHubAppStrategyOptions & WebFlowOptions;
export declare type OAuthAppStrategyOptionsDeviceFlow = CommonOAuthAppStrategyOptions & OAuthAppDeviceFlowOptions;
export declare type GitHubAppStrategyOptionsDeviceFlow = CommonGitHubAppStrategyOptions & GitHubDeviceFlowOptions;
export declare type OAuthAppStrategyOptionsExistingAuthentication = CommonOAuthAppStrategyOptions & ExistingOAuthAppAuthenticationOptions;
export declare type GitHubAppStrategyOptionsExistingAuthentication = CommonGitHubAppStrategyOptions & ExistingGitHubAppAuthenticationOptions;
export declare type GitHubAppStrategyOptionsExistingAuthenticationWithExpiration = CommonGitHubAppStrategyOptions & ExistingGitHubAppAuthenticationWithExpirationOptions;
export declare type OAuthAppStrategyOptions = OAuthAppStrategyOptionsWebFlow | OAuthAppStrategyOptionsDeviceFlow | OAuthAppStrategyOptionsExistingAuthentication;
export declare type GitHubAppStrategyOptions = GitHubAppStrategyOptionsWebFlow | GitHubAppStrategyOptionsDeviceFlow | GitHubAppStrategyOptionsExistingAuthentication | GitHubAppStrategyOptionsExistingAuthenticationWithExpiration;
export declare type OAuthAppAuthentication = {
    tokenType: "oauth";
    type: "token";
} & OAuthMethodsTypes.OAuthAppAuthentication;
export declare type GitHubAppAuthentication = {
    tokenType: "oauth";
    type: "token";
} & OAuthMethodsTypes.GitHubAppAuthentication;
export declare type GitHubAppAuthenticationWithExpiration = {
    tokenType: "oauth";
    type: "token";
} & OAuthMethodsTypes.GitHubAppAuthenticationWithExpiration;
export interface OAuthAppAuthInterface {
    (options?: OAuthAppAuthOptions): Promise<OAuthAppAuthentication>;
    hook(request: OctokitTypes.RequestInterface, route: OctokitTypes.Route | OctokitTypes.EndpointOptions, parameters?: OctokitTypes.RequestParameters): Promise<OctokitTypes.OctokitResponse<any>>;
}
export interface GitHubAppAuthInterface {
    (options?: GitHubAppAuthOptions): Promise<GitHubAppAuthentication | GitHubAppAuthenticationWithExpiration>;
    hook(request: OctokitTypes.RequestInterface, route: OctokitTypes.Route | OctokitTypes.EndpointOptions, parameters?: OctokitTypes.RequestParameters): Promise<OctokitTypes.OctokitResponse<any>>;
}
export declare type OAuthAppState = {
    clientId: string;
    clientSecret: string;
    clientType: "oauth-app";
    request: OctokitTypes.RequestInterface;
    strategyOptions: WebFlowOptions | OAuthAppDeviceFlowOptions | ExistingOAuthAppAuthenticationOptions;
    authentication?: OAuthAppAuthentication & {
        invalid?: true;
    };
};
declare type GitHubAppStateAuthentication = GitHubAppAuthentication & {
    invalid?: true;
};
declare type GitHubAppStateAuthenticationWIthExpiration = GitHubAppAuthenticationWithExpiration & {
    invalid?: true;
};
export declare type GitHubAppState = {
    clientId: string;
    clientSecret: string;
    clientType: "github-app";
    request: OctokitTypes.RequestInterface;
    strategyOptions: WebFlowOptions | GitHubDeviceFlowOptions | ExistingGitHubAppAuthenticationOptions | ExistingGitHubAppAuthenticationWithExpirationOptions;
    authentication?: GitHubAppStateAuthentication | GitHubAppStateAuthenticationWIthExpiration;
};
export declare type State = OAuthAppState | GitHubAppState;
export declare type WebFlowState = {
    clientId: string;
    clientSecret: string;
    clientType: ClientType;
    request: OctokitTypes.RequestInterface;
    strategyOptions: WebFlowOptions;
};
export declare type OAuthAppAuthOptions = {
    type?: "get" | "check" | "reset" | "delete" | "deleteAuthorization";
};
export declare type GitHubAppAuthOptions = {
    type?: "get" | "check" | "reset" | "refresh" | "delete" | "deleteAuthorization";
};
export {};
