import { Token } from 'markdown-it';
import { HeadingContent } from './markdown-helpers.js';
import { MethodDocumentationBlock, PropertyDocumentationBlock, EventDocumentationBlock } from './ParsedDocumentation.js';
type GuessedParam = {
    name: string;
    optional: boolean;
};
export declare const guessParametersFromSignature: (signature: string) => GuessedParam[];
export declare const _headingToMethodBlock: (heading: HeadingContent | null) => MethodDocumentationBlock | null;
export declare const _headingToPropertyBlock: (heading: HeadingContent) => PropertyDocumentationBlock;
export declare const _headingToEventBlock: (heading: HeadingContent) => EventDocumentationBlock;
export declare const parseMethodBlocks: (tokens: Token[] | null) => MethodDocumentationBlock[];
export declare const parsePropertyBlocks: (tokens: Token[] | null) => PropertyDocumentationBlock[];
export declare const parseEventBlocks: (tokens: Token[] | null) => EventDocumentationBlock[];
export {};
