/// <reference types="node" />
/// <reference types="node" />
import { Writable } from 'stream';
import { ChildProcess, SpawnOptions } from 'child_process';
import { SemVer } from 'semver';
import { Installer } from './installer';
import { Versions } from './versions';
import { FiddleFactory, FiddleSource } from './fiddle';
import { Paths } from './paths';
export interface RunnerOptions {
    args?: string[];
    headless?: boolean;
    out?: Writable;
    showConfig?: boolean;
}
export type RunnerSpawnOptions = SpawnOptions & RunnerOptions;
export interface TestResult {
    status: 'test_passed' | 'test_failed' | 'test_error' | 'system_error';
}
export interface BisectResult {
    range?: [string, string];
    status: 'bisect_succeeded' | 'test_error' | 'system_error';
}
export declare class Runner {
    private readonly installer;
    private readonly versions;
    private readonly fiddleFactory;
    private osInfo;
    private constructor();
    static create(opts?: {
        installer?: Installer;
        fiddleFactory?: FiddleFactory;
        paths?: Partial<Paths>;
        versions?: Versions;
    }): Promise<Runner>;
    /**
     * Figure out how to run the user-specified `electron` value.
     *
     * - if it's an existing directory, look for an execPath in it.
     * - if it's an existing file, run it. It's a local build.
     * - if it's a version number, delegate to the installer
     *
     * @param val - a version number, directory, or executable
     * @returns a path to an Electron executable
     */
    private getExec;
    private spawnInfo;
    /** If headless specified on  *nix, try to run with xvfb-run */
    private static headless;
    spawn(versionIn: string | SemVer, fiddleIn: FiddleSource, opts?: RunnerSpawnOptions): Promise<ChildProcess>;
    private static displayEmoji;
    static displayResult(result: TestResult): string;
    run(version: string | SemVer, fiddle: FiddleSource, opts?: RunnerSpawnOptions): Promise<TestResult>;
    bisect(version_a: string | SemVer, version_b: string | SemVer, fiddleIn: FiddleSource, opts?: RunnerSpawnOptions): Promise<BisectResult>;
}
