"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FiddleFactory = exports.Fiddle = void 0;
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const debug_1 = __importDefault(require("debug"));
const simple_git_1 = __importDefault(require("simple-git"));
const crypto_1 = require("crypto");
const paths_1 = require("./paths");
function hashString(str) {
    const md5sum = (0, crypto_1.createHash)('md5');
    md5sum.update(str);
    return md5sum.digest('hex');
}
class Fiddle {
    constructor(mainPath, // /path/to/main.js
    source) {
        this.mainPath = mainPath;
        this.source = source;
    }
    remove() {
        return fs.remove(path.dirname(this.mainPath));
    }
}
exports.Fiddle = Fiddle;
class FiddleFactory {
    constructor(fiddles = paths_1.DefaultPaths.fiddles) {
        this.fiddles = fiddles;
    }
    async fromGist(gistId) {
        return this.fromRepo(`https://gist.github.com/${gistId}.git`);
    }
    async fromFolder(source) {
        const d = (0, debug_1.default)('fiddle-core:FiddleFactory:fromFolder');
        // make a tmp copy of this fiddle
        const folder = path.join(this.fiddles, hashString(source));
        d({ source, folder });
        await fs.remove(folder);
        // Disable asar in case any deps bundle Electron - ex. @electron/remote
        const { noAsar } = process;
        process.noAsar = true;
        await fs.copy(source, folder);
        process.noAsar = noAsar;
        return new Fiddle(path.join(folder, 'main.js'), source);
    }
    async fromRepo(url, checkout = 'master') {
        const d = (0, debug_1.default)('fiddle-core:FiddleFactory:fromRepo');
        const folder = path.join(this.fiddles, hashString(url));
        d({ url, checkout, folder });
        // get the repo
        if (!fs.existsSync(folder)) {
            d(`cloning "${url}" into "${folder}"`);
            const git = (0, simple_git_1.default)();
            await git.clone(url, folder, { '--depth': 1 });
        }
        const git = (0, simple_git_1.default)(folder);
        await git.checkout(checkout);
        await git.pull('origin', checkout);
        return new Fiddle(path.join(folder, 'main.js'), url);
    }
    async fromEntries(src) {
        const d = (0, debug_1.default)('fiddle-core:FiddleFactory:fromEntries');
        const map = new Map(src);
        // make a name for the directory that will hold our temp copy of the fiddle
        const md5sum = (0, crypto_1.createHash)('md5');
        for (const content of map.values())
            md5sum.update(content);
        const hash = md5sum.digest('hex');
        const folder = path.join(this.fiddles, hash);
        d({ folder });
        // save content to that temp directory
        await Promise.all([...map.entries()].map(([filename, content]) => fs.outputFile(path.join(folder, filename), content, 'utf8')));
        return new Fiddle(path.join(folder, 'main.js'), 'entries');
    }
    async create(src) {
        if (src instanceof Fiddle)
            return src;
        if (typeof src === 'string') {
            if (fs.existsSync(src))
                return this.fromFolder(src);
            if (/^[0-9A-Fa-f]{32}$/.test(src))
                return this.fromGist(src);
            if (/^https:/.test(src) || /\.git$/.test(src))
                return this.fromRepo(src);
            return;
        }
        return this.fromEntries(src);
    }
}
exports.FiddleFactory = FiddleFactory;
