import { RequestInterface, Endpoints } from "@octokit/types";
import { GitHubAppAuthenticationWithExpirationEnabled, GitHubAppAuthenticationWithExpirationDisabled } from "./types";
declare type CommonOptions = {
    clientType: "github-app";
    clientId: string;
    clientSecret: string;
    token: string;
    permissions?: Endpoint["parameters"]["permissions"];
    request?: RequestInterface;
};
declare type TargetOption = {
    target: string;
};
declare type TargetIdOption = {
    target_id: number;
};
declare type RepositoriesOption = {
    repositories?: string[];
};
declare type RepositoryIdsOption = {
    repository_ids?: number[];
};
declare type Endpoint = Endpoints["POST /applications/{client_id}/token/scoped"];
export declare type ScopeTokenOptions = (CommonOptions & TargetOption & RepositoriesOption) | (CommonOptions & TargetIdOption & RepositoriesOption) | (CommonOptions & TargetOption & RepositoryIdsOption) | (CommonOptions & TargetIdOption & RepositoryIdsOption);
export declare type ScopeTokenResponse = Endpoint["response"] & {
    authentication: GitHubAppAuthenticationWithExpirationEnabled | GitHubAppAuthenticationWithExpirationDisabled;
};
export declare function scopeToken(options: ScopeTokenOptions): Promise<ScopeTokenResponse>;
export {};
