"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAuthOptionsForOrg = exports.getAuthOptionsForRepo = exports.getTokenForOrg = exports.getTokenForRepo = exports.bundleAppCredentials = exports.appCredentialsFromString = void 0;
const auth_app_1 = require("@octokit/auth-app");
const rest_1 = require("@octokit/rest");
function appCredentialsFromString(str) {
    return JSON.parse(Buffer.from(str, 'base64').toString('utf-8'));
}
exports.appCredentialsFromString = appCredentialsFromString;
function bundleAppCredentials(appCreds) {
    return Buffer.from(JSON.stringify(appCreds), 'utf-8').toString('base64');
}
exports.bundleAppCredentials = bundleAppCredentials;
async function getTokenForRepo(repo, appCreds, authNarrowing = {}) {
    const authOptions = await getAuthOptionsForRepo(repo, appCreds, authNarrowing);
    if (!authOptions)
        return null;
    const { token } = await authOptions.authStrategy(authOptions.auth)(authOptions.auth);
    return token;
}
exports.getTokenForRepo = getTokenForRepo;
async function getTokenForOrg(org, appCreds, authNarrowing = {}) {
    const authOptions = await getAuthOptionsForOrg(org, appCreds, authNarrowing);
    if (!authOptions)
        return null;
    const { token } = await authOptions.authStrategy(authOptions.auth)(authOptions.auth);
    return token;
}
exports.getTokenForOrg = getTokenForOrg;
async function getAuthOptionsForRepo(repo, appCreds, authNarrowing = {}, request) {
    return await getAuthOptionsForInstallationId(appCreds, authNarrowing, async (octokit) => {
        const installation = await octokit.apps.getRepoInstallation({
            owner: repo.owner,
            repo: repo.name,
        });
        return installation.data.id;
    }, request);
}
exports.getAuthOptionsForRepo = getAuthOptionsForRepo;
async function getAuthOptionsForOrg(org, appCreds, authNarrowing = {}, request) {
    return await getAuthOptionsForInstallationId(appCreds, authNarrowing, async (octokit) => {
        const installation = await octokit.apps.getOrgInstallation({
            org,
        });
        return installation.data.id;
    }, request);
}
exports.getAuthOptionsForOrg = getAuthOptionsForOrg;
async function getAuthOptionsForInstallationId(appCreds, authNarrowing = {}, installationIdFetcher, request) {
    const auth = (0, auth_app_1.createAppAuth)({
        appId: appCreds.appId,
        privateKey: appCreds.privateKey,
        request,
    });
    const appAuth = await auth({
        type: 'app',
    });
    const octokit = new rest_1.Octokit({
        auth: appAuth.token,
        baseUrl: request === null || request === void 0 ? void 0 : request.endpoint.DEFAULTS.baseUrl,
    });
    try {
        const installationId = await installationIdFetcher(octokit);
        const strategyOptions = Object.assign(Object.assign({}, authNarrowing), { type: 'installation', appId: appCreds.appId, privateKey: appCreds.privateKey, installationId });
        return {
            auth: strategyOptions,
            authStrategy: auth_app_1.createAppAuth,
        };
    }
    catch (err) {
        if (err.status !== 404)
            throw err;
        return null;
    }
}
//# sourceMappingURL=index.js.map