import { Token } from 'markdown-it';
import { TypeInformation, PossibleStringValue, DocumentationTag, ProcessBlock } from './ParsedDocumentation.js';
export declare const parseHeadingTags: (tags: string | null) => DocumentationTag[];
export declare const findNextList: (tokens: Token[]) => {
    type: string;
    tag: string;
    attrs: Array<[string, string]> | null;
    map: [number, number] | null;
    nesting: Token.Nesting;
    level: number;
    children: any[] | null;
    content: string;
    markup: string;
    info: string;
    meta: any;
    block: boolean;
    hidden: boolean;
    attrIndex(name: string): number;
    attrPush(attrData: [string, string]): void;
    attrSet(name: string, value: string): void;
    attrGet(name: string): string | null;
    attrJoin(name: string, value: string): void;
}[] | null;
export declare const findFirstHeading: (tokens: Token[]) => {
    type: string;
    tag: string;
    attrs: Array<[string, string]> | null;
    map: [number, number] | null;
    nesting: Token.Nesting;
    level: number;
    children: any[] | null;
    content: string;
    markup: string;
    info: string;
    meta: any;
    block: boolean;
    hidden: boolean;
    attrIndex(name: string): number;
    attrPush(attrData: [string, string]): void;
    attrSet(name: string, value: string): void;
    attrGet(name: string): string | null;
    attrJoin(name: string, value: string): void;
};
export declare const findContentAfterList: (tokens: Token[], returnAllOnNoList?: boolean) => {
    type: string;
    tag: string;
    attrs: Array<[string, string]> | null;
    map: [number, number] | null;
    nesting: Token.Nesting;
    level: number;
    children: any[] | null;
    content: string;
    markup: string;
    info: string;
    meta: any;
    block: boolean;
    hidden: boolean;
    attrIndex(name: string): number;
    attrPush(attrData: [string, string]): void;
    attrSet(name: string, value: string): void;
    attrGet(name: string): string | null;
    attrJoin(name: string, value: string): void;
}[];
export declare const findContentAfterHeadingClose: (tokens: Token[]) => {
    type: string;
    tag: string;
    attrs: Array<[string, string]> | null;
    map: [number, number] | null;
    nesting: Token.Nesting;
    level: number;
    children: any[] | null;
    content: string;
    markup: string;
    info: string;
    meta: any;
    block: boolean;
    hidden: boolean;
    attrIndex(name: string): number;
    attrPush(attrData: [string, string]): void;
    attrSet(name: string, value: string): void;
    attrGet(name: string): string | null;
    attrJoin(name: string, value: string): void;
}[];
export type HeadingContent = {
    heading: string;
    level: number;
    headingTokens: Token[];
    content: Token[];
};
export declare const headingsAndContent: (tokens: Token[]) => HeadingContent[];
export declare const findConstructorHeader: (tokens: Token[]) => HeadingContent | null;
export declare const getContentBeforeConstructor: (tokens: Token[]) => HeadingContent[];
export declare const getContentBeforeFirstHeadingMatching: (tokens: Token[], matcher: (heading: string) => boolean) => HeadingContent[];
export declare const findContentInsideHeader: (tokens: Token[], expectedHeader: string, expectedLevel: number) => {
    type: string;
    tag: string;
    attrs: Array<[string, string]> | null;
    map: [number, number] | null;
    nesting: Token.Nesting;
    level: number;
    children: any[] | null;
    content: string;
    markup: string;
    info: string;
    meta: any;
    block: boolean;
    hidden: boolean;
    attrIndex(name: string): number;
    attrPush(attrData: [string, string]): void;
    attrSet(name: string, value: string): void;
    attrGet(name: string): string | null;
    attrJoin(name: string, value: string): void;
}[] | null;
export declare const safelySeparateTypeStringOn: (typeString: string, targetChar: string) => string[];
export declare const getTopLevelMultiTypes: (typeString: string) => string[];
export declare const getTopLevelOrderedTypes: (typeString: string) => string[];
/**
 * @param typeString A type as a raw string
 *
 * @returns Either null or the isolated outer/generic types
 *
 * This method is used to extract the highest level generic from a type string.
 * Examples:
 *
 * - `Foo` --> `null`
 * - `Foo<T>` --> `{Foo, T}`
 * - `Foo<T<B, C>>` --> `{Foo, T<B, C>}`
 *
 * The caller is responsible for recursively parsing the generic
 */
export declare const getTopLevelGenericType: (typeString: string) => {
    outerType: string;
    genericType: string;
} | null;
export declare const rawTypeToTypeInformation: (rawType: string, relatedDescription: string, subTypedKeys: TypedKeyList | null) => TypeInformation;
export declare enum StripReturnTypeBehavior {
    STRIP = 0,
    DO_NOT_STRIP = 1
}
export declare const extractStringEnum: (description: string) => PossibleStringValue[] | null;
export declare const extractReturnType: (tokens: Token[], stripTypeFromDescription?: StripReturnTypeBehavior, prefix?: string) => {
    parsedDescription: string;
    parsedReturnType: TypeInformation | null;
};
export interface JoinTokenOptions {
    parseCodeFences?: boolean;
}
export declare const safelyJoinTokens: (tokens: Token[], options?: JoinTokenOptions) => string;
type TypedKey = {
    key: string;
    type: TypeInformation;
    description: string;
    required: boolean;
    additionalTags: DocumentationTag[];
};
type TypedKeyList = {
    keys: TypedKey[];
    consumed: boolean;
};
export declare const consumeTypedKeysList: (list: TypedKeyList) => TypedKey[];
export declare const convertListToTypedKeys: (listTokens: Token[]) => TypedKeyList;
export declare const findProcess: (tokens: Token[]) => ProcessBlock;
export declare const slugifyHeading: (heading: string) => string;
export {};
