#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runFromCommandLine = exports.compareVersions = exports.SemVer = exports.Runner = exports.Installer = exports.InstallState = exports.FiddleFactory = exports.Fiddle = exports.ElectronVersions = exports.DefaultPaths = exports.BaseVersions = void 0;
const paths_1 = require("./paths");
Object.defineProperty(exports, "DefaultPaths", { enumerable: true, get: function () { return paths_1.DefaultPaths; } });
const installer_1 = require("./installer");
Object.defineProperty(exports, "Installer", { enumerable: true, get: function () { return installer_1.Installer; } });
Object.defineProperty(exports, "InstallState", { enumerable: true, get: function () { return installer_1.InstallState; } });
const fiddle_1 = require("./fiddle");
Object.defineProperty(exports, "Fiddle", { enumerable: true, get: function () { return fiddle_1.Fiddle; } });
Object.defineProperty(exports, "FiddleFactory", { enumerable: true, get: function () { return fiddle_1.FiddleFactory; } });
const runner_1 = require("./runner");
Object.defineProperty(exports, "Runner", { enumerable: true, get: function () { return runner_1.Runner; } });
const versions_1 = require("./versions");
Object.defineProperty(exports, "BaseVersions", { enumerable: true, get: function () { return versions_1.BaseVersions; } });
Object.defineProperty(exports, "ElectronVersions", { enumerable: true, get: function () { return versions_1.ElectronVersions; } });
Object.defineProperty(exports, "SemVer", { enumerable: true, get: function () { return versions_1.SemVer; } });
Object.defineProperty(exports, "compareVersions", { enumerable: true, get: function () { return versions_1.compareVersions; } });
const command_line_1 = require("./command-line");
Object.defineProperty(exports, "runFromCommandLine", { enumerable: true, get: function () { return command_line_1.runFromCommandLine; } });
if (require.main === module) {
    void (0, command_line_1.runFromCommandLine)(process.argv.slice(2));
}
