/// <reference types="node" />
import * as childProcess from 'node:child_process';
export declare const dynamicImport: Function;
export declare function removeParensWrappingOrphanedObject(block: string): string;
export declare function wrapOrphanObjectInParens(block: string): string;
export type SpawnAsyncResult = {
    stdout: string;
    stderr: string;
    status: number | null;
};
export declare function spawnAsync(command: string, args: string[], options?: childProcess.SpawnOptionsWithoutStdio | undefined): Promise<SpawnAsyncResult>;
export declare function chunkFilenames(filenames: string[], offset?: number): string[][];
export declare function findCurlyBracedDirectives(directive: string, str: string): string[];
export interface LintRollerTsCheckConfig {
    defaultImports?: string[];
    typings?: string[];
}
export interface LintRollerConfig {
    'markdown-ts-check'?: LintRollerTsCheckConfig;
}
export declare function loadConfig(path: string): LintRollerConfig | undefined;
