export var DocumentationTag;
(function (DocumentationTag) {
    DocumentationTag["OS_MACOS"] = "os_macos";
    DocumentationTag["OS_MAS"] = "os_mas";
    DocumentationTag["OS_WINDOWS"] = "os_windows";
    DocumentationTag["OS_LINUX"] = "os_linux";
    DocumentationTag["STABILITY_EXPERIMENTAL"] = "stability_experimental";
    DocumentationTag["STABILITY_DEPRECATED"] = "stability_deprecated";
    DocumentationTag["AVAILABILITY_READONLY"] = "availability_readonly";
})(DocumentationTag || (DocumentationTag = {}));
export class ParsedDocumentation {
    repr = [];
    addStructure(struct) {
        this.repr.push(struct);
    }
    addModuleOrClassOrElement(...apiContainers) {
        this.repr.push(...apiContainers);
    }
    getJSON() {
        return this.repr.filter((container) => {
            if (container.type !== 'Module')
                return true;
            return container.events.length + container.methods.length + container.properties.length > 0;
        });
    }
}
//# sourceMappingURL=ParsedDocumentation.js.map