process.env.DEBUG = 'fhash:*'

const { Volume } = require('memfs'),
  path = require('path'),
  print = obj => console.log(require('util').inspect(obj, false, null))

const folderHash = require('../index'),
  prep = volume => folderHash.prep(volume, Promise)

function example1 () {
  const dir = 'folder', basename = 'file1'
  const json = {
    'abc.dat': '123',
    'abc/abc.dat': '123'
  }
  const hashElement = prep(Volume.fromJSON(json))

  const options = {
    algo: 'md5',
    encoding: 'hex',
    files: {
      include: ['*.dat'],
      ignoreRootName: true
    }
  }

  return hashElement('.', options)
    .then(result => {
      print(result)
      // hashes of /abc.dat and abc/abc.dat should be equal
      sameHash(result.children[0], result.children[1].children[0])
      
      return result
    })
}

function sameHash(a, b) {
  if (a.hash === b.hash) {
    console.log(`✓ - a.hash (${a.name}) === b.hash ({b.name})) === ${a.hash}`)
    return true
  } else {
    console.error(`✗ - hash(${a.name}) ${a.hash} should equal hash(${b.name}) ${b.hash}`)
    return false
  }
}

example1()
