"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElectronVersions = exports.BaseVersions = exports.compareVersions = exports.SemVer = void 0;
const fs = __importStar(require("fs-extra"));
const semver_1 = require("semver");
Object.defineProperty(exports, "SemVer", { enumerable: true, get: function () { return semver_1.SemVer; } });
const debug_1 = __importDefault(require("debug"));
const node_fetch_1 = __importDefault(require("node-fetch"));
const paths_1 = require("./paths");
function compareVersions(a, b) {
    const l = a.compareMain(b);
    if (l)
        return l;
    // Electron's approach is nightly -> other prerelease tags -> stable,
    // so force `nightly` to sort before other prerelease tags.
    const [prea] = a.prerelease;
    const [preb] = b.prerelease;
    if (prea === 'nightly' && preb !== 'nightly')
        return -1;
    if (prea !== 'nightly' && preb === 'nightly')
        return 1;
    return a.comparePre(b);
}
exports.compareVersions = compareVersions;
// ts type guards
function hasVersion(val) {
    return typeof val === 'object' && val !== null && 'version' in val;
}
function isReleaseInfo(val) {
    return (typeof val === 'object' &&
        val !== null &&
        'version' in val &&
        typeof val.version === 'string' &&
        'date' in val &&
        typeof val.date === 'string' &&
        'node' in val &&
        typeof val.node === 'string' &&
        'v8' in val &&
        typeof val.v8 === 'string' &&
        'uv' in val &&
        typeof val.uv === 'string' &&
        'zlib' in val &&
        typeof val.zlib === 'string' &&
        'openssl' in val &&
        typeof val.openssl === 'string' &&
        'modules' in val &&
        typeof val.modules === 'string' &&
        'chrome' in val &&
        typeof val.chrome === 'string' &&
        'files' in val &&
        isArrayOfStrings(val.files));
}
function isArrayOfVersionObjects(val) {
    return (Array.isArray(val) &&
        val.every((item) => hasVersion(item) && typeof item.version === 'string'));
}
function isArrayOfStrings(val) {
    return Array.isArray(val) && val.every((item) => typeof item === 'string');
}
const NUM_SUPPORTED_MAJORS = 3;
/**
 * Implementation of {@link Versions} that does everything except self-populate.
 * It needs to be fed version info in its constructor.
 *
 * In production, use subclass '{@link ElectronVersions}'. This base class is
 * useful in testing because it's an easy way to inject fake test data into a
 * real Versions object.
 */
class BaseVersions {
    setVersions(val) {
        // release info doesn't need to be in sorted order
        this.releaseInfo.clear();
        // build the array
        let parsed = [];
        if (isArrayOfVersionObjects(val)) {
            parsed = val.map(({ version }) => (0, semver_1.parse)(version));
            // build release info
            for (const entry of val) {
                if (isReleaseInfo(entry)) {
                    this.releaseInfo.set(entry.version, {
                        version: entry.version,
                        date: entry.date,
                        node: entry.node,
                        v8: entry.v8,
                        uv: entry.uv,
                        zlib: entry.zlib,
                        openssl: entry.openssl,
                        modules: entry.modules,
                        chrome: entry.chrome,
                        files: [...entry.files],
                    });
                }
            }
        }
        else if (isArrayOfStrings(val)) {
            parsed = val.map((version) => (0, semver_1.parse)(version));
        }
        else {
            console.warn('Unrecognized versions:', val);
        }
        // insert them in sorted order
        const semvers = parsed.filter((sem) => Boolean(sem));
        semvers.sort((a, b) => compareVersions(a, b));
        this.map.clear();
        for (const sem of semvers)
            this.map.set(sem.version, sem);
    }
    constructor(versions) {
        this.map = new Map();
        this.releaseInfo = new Map();
        this.setVersions(versions);
    }
    get prereleaseMajors() {
        const majors = new Set();
        for (const ver of this.map.values()) {
            majors.add(ver.major);
        }
        for (const ver of this.map.values()) {
            if (ver.prerelease.length === 0) {
                majors.delete(ver.major);
            }
        }
        return [...majors];
    }
    get stableMajors() {
        const majors = new Set();
        for (const ver of this.map.values()) {
            if (ver.prerelease.length === 0) {
                majors.add(ver.major);
            }
        }
        return [...majors];
    }
    get supportedMajors() {
        return this.stableMajors.slice(-NUM_SUPPORTED_MAJORS);
    }
    get obsoleteMajors() {
        return this.stableMajors.slice(0, -NUM_SUPPORTED_MAJORS);
    }
    get versions() {
        return [...this.map.values()];
    }
    get latest() {
        return this.versions.pop();
    }
    get latestStable() {
        let stable = undefined;
        for (const ver of this.map.values()) {
            if (ver.prerelease.length === 0) {
                stable = ver;
            }
        }
        return stable;
    }
    isVersion(ver) {
        return this.map.has(typeof ver === 'string' ? ver : ver.version);
    }
    inMajor(major) {
        const versions = [];
        for (const ver of this.map.values()) {
            if (ver.major === major) {
                versions.push(ver);
            }
        }
        return versions;
    }
    inRange(a, b) {
        if (typeof a !== 'string')
            a = a.version;
        if (typeof b !== 'string')
            b = b.version;
        const versions = [...this.map.values()];
        let first = versions.findIndex((ver) => ver.version === a);
        let last = versions.findIndex((ver) => ver.version === b);
        if (first > last)
            [first, last] = [last, first];
        return versions.slice(first, last + 1);
    }
    getReleaseInfo(ver) {
        return this.releaseInfo.get(typeof ver === 'string' ? ver : ver.version);
    }
}
exports.BaseVersions = BaseVersions;
/**
 * Implementation of Versions that self-populates from release information at
 * https://releases.electronjs.org/releases.json .
 *
 * This is generally what to use in production.
 */
class ElectronVersions extends BaseVersions {
    constructor(versionsCache, mtimeMs, values) {
        super(values);
        this.versionsCache = versionsCache;
        this.mtimeMs = mtimeMs;
    }
    static async fetchVersions(cacheFile) {
        const d = (0, debug_1.default)('fiddle-core:ElectronVersions:fetchVersions');
        const url = 'https://releases.electronjs.org/releases.json';
        d('fetching releases list from', url);
        const response = await (0, node_fetch_1.default)(url);
        if (!response.ok) {
            throw new Error(`Fetching versions failed with status code: ${response.status}`);
        }
        const json = (await response.json());
        await fs.outputJson(cacheFile, json);
        return json;
    }
    static isCacheFresh(cacheTimeMs, now) {
        const VERSION_CACHE_TTL_MS = 4 * 60 * 60 * 1000; // cache for N hours
        return now <= cacheTimeMs + VERSION_CACHE_TTL_MS;
    }
    static async create(paths = {}, options = {}) {
        const d = (0, debug_1.default)('fiddle-core:ElectronVersions:create');
        const { versionsCache } = { ...paths_1.DefaultPaths, ...paths };
        // Use initialVersions instead if provided, and don't fetch if so
        let versions = options.initialVersions;
        let staleCache = false;
        const now = Date.now();
        if (!options.ignoreCache) {
            try {
                const st = await fs.stat(versionsCache);
                versions = await fs.readJson(versionsCache);
                staleCache = !ElectronVersions.isCacheFresh(st.mtimeMs, now);
            }
            catch (err) {
                d('cache file missing or cannot be read', err);
            }
        }
        if (!versions || staleCache) {
            try {
                versions = await ElectronVersions.fetchVersions(versionsCache);
            }
            catch (err) {
                d('error fetching versions', err);
                if (!versions) {
                    throw err;
                }
            }
        }
        return new ElectronVersions(versionsCache, now, versions);
    }
    // update the cache
    async fetch() {
        const d = (0, debug_1.default)('fiddle-core:ElectronVersions:fetch');
        const { mtimeMs, versionsCache } = this;
        try {
            this.mtimeMs = Date.now();
            const versions = await ElectronVersions.fetchVersions(versionsCache);
            this.setVersions(versions);
            d(`saved "${versionsCache}"`);
        }
        catch (err) {
            d('error fetching versions', err);
            this.mtimeMs = mtimeMs;
        }
    }
    // update the cache iff it's too old
    async keepFresh() {
        if (!ElectronVersions.isCacheFresh(this.mtimeMs, Date.now())) {
            await this.fetch();
        }
    }
    get prereleaseMajors() {
        void this.keepFresh();
        return super.prereleaseMajors;
    }
    get stableMajors() {
        void this.keepFresh();
        return super.stableMajors;
    }
    get supportedMajors() {
        void this.keepFresh();
        return super.supportedMajors;
    }
    get obsoleteMajors() {
        void this.keepFresh();
        return super.obsoleteMajors;
    }
    get versions() {
        void this.keepFresh();
        return super.versions;
    }
    get latest() {
        void this.keepFresh();
        return super.latest;
    }
    get latestStable() {
        void this.keepFresh();
        return super.latestStable;
    }
    isVersion(ver) {
        void this.keepFresh();
        return super.isVersion(ver);
    }
    inMajor(major) {
        void this.keepFresh();
        return super.inMajor(major);
    }
    inRange(a, b) {
        void this.keepFresh();
        return super.inRange(a, b);
    }
}
exports.ElectronVersions = ElectronVersions;
