import { InstallationAuthOptions } from '@octokit/auth-app';
import { RequestInterface } from '@octokit/auth-app/dist-types/types';
export interface RepoInfo {
    owner: string;
    name: string;
}
export interface AppCredentials {
    appId: string;
    privateKey: string;
}
export declare type AuthNarrowing = Pick<InstallationAuthOptions, 'repositoryIds' | 'repositoryNames' | 'permissions'>;
export declare function appCredentialsFromString(str: string): AppCredentials;
export declare function bundleAppCredentials(appCreds: AppCredentials): string;
export declare function getTokenForRepo(repo: RepoInfo, appCreds: AppCredentials, authNarrowing?: AuthNarrowing): Promise<string | null>;
export declare function getTokenForOrg(org: string, appCreds: AppCredentials, authNarrowing?: AuthNarrowing): Promise<string | null>;
interface OctokitAuthOptions {
    auth: object;
    authStrategy: Function;
}
export declare function getAuthOptionsForRepo(repo: RepoInfo, appCreds: AppCredentials, authNarrowing?: AuthNarrowing, request?: RequestInterface): Promise<OctokitAuthOptions | null>;
export declare function getAuthOptionsForOrg(org: string, appCreds: AppCredentials, authNarrowing?: AuthNarrowing, request?: RequestInterface): Promise<OctokitAuthOptions | null>;
export {};
