# Installation
> `npm install --save @types/text-table`

# Summary
This package contains type definitions for text-table (https://github.com/substack/text-table).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/text-table.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/text-table/index.d.ts)
````ts
// Type definitions for text-table 0.2
// Project: https://github.com/substack/text-table
// Definitions by: Saad Quadri <https://github.com/saadq>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

/**
 * Generates borderless text table strings suitable for printing to stdout.
 */
declare function table(
    /** An array of arrays containing strings, numbers, or other printable values. */
    rows: Array<Array<{}>>,

    /** A configuration object to customize table output. */
    options?: table.Options
): string;

declare namespace table {
    interface Options {
        /** Separator to use between columns, (default: ' '). */
        hsep?: string | undefined;

        /** An array of alignment types for each column, default ['l','l',...]. */
        align?: Array<'l' | 'r' | 'c' | '.' | null | undefined> | undefined;

        /** A callback function to use when calculating the string length. */
        stringLength?(str: string): number;
    }
}

export = table;

````

### Additional Details
 * Last updated: Fri, 02 Jul 2021 21:32:20 GMT
 * Dependencies: none
 * Global values: none

# Credits
These definitions were written by [Saad Quadri](https://github.com/saadq).
