<!--This file is generated-->

# remark-lint-hard-break-spaces

[![Build][badge-build-image]][badge-build-url]
[![Coverage][badge-coverage-image]][badge-coverage-url]
[![Downloads][badge-downloads-image]][badge-downloads-url]
[![Size][badge-size-image]][badge-size-url]
[![Sponsors][badge-funding-sponsors-image]][badge-funding-url]
[![Backers][badge-funding-backers-image]][badge-funding-url]
[![Chat][badge-chat-image]][badge-chat-url]

[`remark-lint`][github-remark-lint] rule to warn when spaces are used for hard breaks.
Either optionally spaces at all,
or more spaces than the needed 2.

## Contents

* [What is this?](#what-is-this)
* [When should I use this?](#when-should-i-use-this)
* [Presets](#presets)
* [Install](#install)
* [Use](#use)
* [API](#api)
  * [`unified().use(remarkLintHardBreakSpaces[, options])`](#unifieduseremarklinthardbreakspaces-options)
  * [`Options`](#options)
* [Recommendation](#recommendation)
* [Examples](#examples)
* [Compatibility](#compatibility)
* [Contribute](#contribute)
* [License](#license)

## What is this?

This package checks whitespace hard breaks.

## When should I use this?

You can use this package to check that the spaces in hard breaks are
consistent.

## Presets

This plugin is included in the following presets:

| Preset | Options |
| - | - |
| [`remark-preset-lint-markdown-style-guide`](https://github.com/remarkjs/remark-lint/tree/main/packages/remark-preset-lint-markdown-style-guide) | |
| [`remark-preset-lint-recommended`](https://github.com/remarkjs/remark-lint/tree/main/packages/remark-preset-lint-recommended) | |

## Install

This package is [ESM only][github-gist-esm].
In Node.js (version 16+),
install with [npm][npm-install]:

```sh
npm install remark-lint-hard-break-spaces
```

In Deno with [`esm.sh`][esm-sh]:

```js
import remarkLintHardBreakSpaces from 'https://esm.sh/remark-lint-hard-break-spaces@4'
```

In browsers with [`esm.sh`][esm-sh]:

```html
<script type="module">
  import remarkLintHardBreakSpaces from 'https://esm.sh/remark-lint-hard-break-spaces@4?bundle'
</script>
```

## Use

On the API:

```js
import remarkLint from 'remark-lint'
import remarkLintHardBreakSpaces from 'remark-lint-hard-break-spaces'
import remarkParse from 'remark-parse'
import remarkStringify from 'remark-stringify'
import {read} from 'to-vfile'
import {unified} from 'unified'
import {reporter} from 'vfile-reporter'

const file = await read('example.md')

await unified()
  .use(remarkParse)
  .use(remarkLint)
  .use(remarkLintHardBreakSpaces)
  .use(remarkStringify)
  .process(file)

console.error(reporter(file))
```

On the CLI:

```sh
remark --frail --use remark-lint --use remark-lint-hard-break-spaces .
```

On the CLI in a config file (here a `package.json`):

```diff
 …
 "remarkConfig": {
   "plugins": [
     …
     "remark-lint",
+    "remark-lint-hard-break-spaces",
     …
   ]
 }
 …
```

## API

This package exports no identifiers.
It exports the [TypeScript][typescript] type
[`Options`][api-options].
The default export is
[`remarkLintHardBreakSpaces`][api-remark-lint-hard-break-spaces].

### `unified().use(remarkLintHardBreakSpaces[, options])`

Warn when more spaces are used than needed for hard breaks.

###### Parameters

* `options` ([`Options`][api-options], default: `'consistent'`)
  — either a preferred indent or whether to detect the first style
  and warn for further differences

###### Returns

Transform ([`Transformer` from `unified`][github-unified-transformer]).

### `Options`

Configuration (TypeScript type).

###### Fields

* `allowSpaces` (`boolean`, default: `true`)
  — allow trailing space hard breaks at all;
  use escape hard breaks otherwise

## Recommendation

Less than two spaces do not create a hard breaks and more than two spaces
have no effect.
Due to this, it’s recommended to turn this rule on.

With CommonMark,
it is now possible to use a backslash (`\`) at the end of a line to create a
hard break.
It is now recommended to pass `allowSpaces: false`.

## Examples

##### `ok.md`

###### In

```markdown
**Mercury** is the first planet from the Sun␠␠
and the smallest in the Solar System.
**Venus** is the second planet from\
the Sun.
```

###### Out

No messages.

##### `not-ok.md`

###### In

```markdown
**Mercury** is the first planet from the Sun␠␠␠
and the smallest in the Solar System.
```

###### Out

```text
1:45-2:1: Unexpected `3` spaces for hard break, expected `2` spaces
```

##### `escape.md`

When configured with `{ allowSpaces: false }`.

###### In

```markdown
**Mercury** is the first planet from the Sun␠␠
and the smallest in the Solar System.
**Venus** is the second planet from the\
Sun.
```

###### Out

```text
1:45-2:1: Unexpected `2` spaces for hard break, expected escape
```

##### `containers.md`

###### In

> 👉 **Note**: this example uses
> GFM ([`remark-gfm`][github-remark-gfm]).

```markdown
[^mercury]:
    > * > * **Mercury** is the first planet from the Sun␠␠␠
    >   >   and the smallest in the Solar System.
```

###### Out

```text
2:57-3:1: Unexpected `3` spaces for hard break, expected `2` spaces
```

##### `not-ok-options.md`

When configured with `'🌍'`.

###### Out

```text
1:1: Unexpected value `🌍` for `options`, expected object
```

##### `not-ok-options-field.md`

When configured with `{ allowSpaces: '🌍' }`.

###### Out

```text
1:1: Unexpected value `🌍` for `options.allowSpaces`, expected `boolean`
```

## Compatibility

Projects maintained by the unified collective are compatible with maintained
versions of Node.js.

When we cut a new major release, we drop support for unmaintained versions of
Node.
This means we try to keep the current release line,
`remark-lint-hard-break-spaces@4`,
compatible with Node.js 16.

## Contribute

See [`contributing.md`][github-dotfiles-contributing] in [`remarkjs/.github`][github-dotfiles-health] for ways
to get started.
See [`support.md`][github-dotfiles-support] for ways to get help.

This project has a [code of conduct][github-dotfiles-coc].
By interacting with this repository, organization, or community you agree to
abide by its terms.

## License

[MIT][file-license] © [Titus Wormer][author]

[api-options]: #options

[api-remark-lint-hard-break-spaces]: #unifieduseremarklinthardbreakspaces-options

[author]: https://wooorm.com

[badge-build-image]: https://github.com/remarkjs/remark-lint/workflows/main/badge.svg

[badge-build-url]: https://github.com/remarkjs/remark-lint/actions

[badge-chat-image]: https://img.shields.io/badge/chat-discussions-success.svg

[badge-chat-url]: https://github.com/remarkjs/remark/discussions

[badge-coverage-image]: https://img.shields.io/codecov/c/github/remarkjs/remark-lint.svg

[badge-coverage-url]: https://codecov.io/github/remarkjs/remark-lint

[badge-downloads-image]: https://img.shields.io/npm/dm/remark-lint-hard-break-spaces.svg

[badge-downloads-url]: https://www.npmjs.com/package/remark-lint-hard-break-spaces

[badge-funding-backers-image]: https://opencollective.com/unified/backers/badge.svg

[badge-funding-sponsors-image]: https://opencollective.com/unified/sponsors/badge.svg

[badge-funding-url]: https://opencollective.com/unified

[badge-size-image]: https://img.shields.io/bundlejs/size/remark-lint-hard-break-spaces

[badge-size-url]: https://bundlejs.com/?q=remark-lint-hard-break-spaces

[esm-sh]: https://esm.sh

[file-license]: https://github.com/remarkjs/remark-lint/blob/main/license

[github-dotfiles-coc]: https://github.com/remarkjs/.github/blob/main/code-of-conduct.md

[github-dotfiles-contributing]: https://github.com/remarkjs/.github/blob/main/contributing.md

[github-dotfiles-health]: https://github.com/remarkjs/.github

[github-dotfiles-support]: https://github.com/remarkjs/.github/blob/main/support.md

[github-gist-esm]: https://gist.github.com/sindresorhus/a39789f98801d908bbc7ff3ecc99d99c

[github-remark-gfm]: https://github.com/remarkjs/remark-gfm

[github-remark-lint]: https://github.com/remarkjs/remark-lint

[github-unified-transformer]: https://github.com/unifiedjs/unified#transformer

[npm-install]: https://docs.npmjs.com/cli/install

[typescript]: https://www.typescriptlang.org
