<!--This file is generated-->

# remark-lint-no-multiple-toplevel-headings

[![Build][badge-build-image]][badge-build-url]
[![Coverage][badge-coverage-image]][badge-coverage-url]
[![Downloads][badge-downloads-image]][badge-downloads-url]
[![Size][badge-size-image]][badge-size-url]
[![Sponsors][badge-funding-sponsors-image]][badge-funding-url]
[![Backers][badge-funding-backers-image]][badge-funding-url]
[![Chat][badge-chat-image]][badge-chat-url]

[`remark-lint`][github-remark-lint] rule to warn when top-level headings are used multiple times.

## Contents

* [What is this?](#what-is-this)
* [When should I use this?](#when-should-i-use-this)
* [Presets](#presets)
* [Install](#install)
* [Use](#use)
* [API](#api)
  * [`unified().use(remarkLintNoMultipleToplevelHeadings[, options])`](#unifieduseremarklintnomultipletoplevelheadings-options)
  * [`Depth`](#depth)
  * [`Options`](#options)
* [Recommendation](#recommendation)
* [Examples](#examples)
* [Compatibility](#compatibility)
* [Contribute](#contribute)
* [License](#license)

## What is this?

This package checks that top-level headings are unique.

## When should I use this?

You can use this package to check heading structure.

## Presets

This plugin is included in the following presets:

| Preset | Options |
| - | - |
| [`remark-preset-lint-markdown-style-guide`](https://github.com/remarkjs/remark-lint/tree/main/packages/remark-preset-lint-markdown-style-guide) | |

## Install

This package is [ESM only][github-gist-esm].
In Node.js (version 16+),
install with [npm][npm-install]:

```sh
npm install remark-lint-no-multiple-toplevel-headings
```

In Deno with [`esm.sh`][esm-sh]:

```js
import remarkLintNoMultipleToplevelHeadings from 'https://esm.sh/remark-lint-no-multiple-toplevel-headings@4'
```

In browsers with [`esm.sh`][esm-sh]:

```html
<script type="module">
  import remarkLintNoMultipleToplevelHeadings from 'https://esm.sh/remark-lint-no-multiple-toplevel-headings@4?bundle'
</script>
```

## Use

On the API:

```js
import remarkLint from 'remark-lint'
import remarkLintNoMultipleToplevelHeadings from 'remark-lint-no-multiple-toplevel-headings'
import remarkParse from 'remark-parse'
import remarkStringify from 'remark-stringify'
import {read} from 'to-vfile'
import {unified} from 'unified'
import {reporter} from 'vfile-reporter'

const file = await read('example.md')

await unified()
  .use(remarkParse)
  .use(remarkLint)
  .use(remarkLintNoMultipleToplevelHeadings)
  .use(remarkStringify)
  .process(file)

console.error(reporter(file))
```

On the CLI:

```sh
remark --frail --use remark-lint --use remark-lint-no-multiple-toplevel-headings .
```

On the CLI in a config file (here a `package.json`):

```diff
 …
 "remarkConfig": {
   "plugins": [
     …
     "remark-lint",
+    "remark-lint-no-multiple-toplevel-headings",
     …
   ]
 }
 …
```

## API

This package exports no identifiers.
It exports the [TypeScript][typescript] types
[`Depth`][api-depth] and
[`Options`][api-options].
The default export is
[`remarkLintNoMultipleToplevelHeadings`][api-remark-lint-no-multiple-toplevel-headings].

### `unified().use(remarkLintNoMultipleToplevelHeadings[, options])`

Warn when top-level headings are used multiple times.

###### Parameters

* `options` ([`Options`][api-options], default: `1`)
  — configuration

###### Returns

Transform ([`Transformer` from `unified`][github-unified-transformer]).

### `Depth`

Depth (TypeScript type).

###### Type

```ts
type Depth = 1 | 2 | 3 | 4 | 5 | 6
```

### `Options`

Configuration (TypeScript type).

###### Type

```ts
type Options = Depth
```

## Recommendation

Documents should almost always have one main heading,
which is typically a heading with a rank of `1`.

## Examples

##### `ok.md`

###### In

```markdown
# Mercury

## Venus
```

###### Out

No messages.

##### `not-ok.md`

###### In

```markdown
# Venus

# Mercury
```

###### Out

```text
3:1-3:10: Unexpected duplicate toplevel heading, exected a single heading with rank `1`
```

##### `not-ok.md`

When configured with `2`.

###### In

```markdown
## Venus

## Mercury
```

###### Out

```text
3:1-3:11: Unexpected duplicate toplevel heading, exected a single heading with rank `2`
```

##### `html.md`

###### In

```markdown
Venus <b>and</b> mercury.

<h1>Earth</h1>

<h1>Mars</h1>
```

###### Out

```text
5:1-5:14: Unexpected duplicate toplevel heading, exected a single heading with rank `1`
```

##### `mdx.mdx`

###### In

> 👉 **Note**: this example uses
> MDX ([`remark-mdx`][github-remark-mdx]).

```mdx
Venus <b>and</b> mercury.

<h1>Earth</h1>
<h1>Mars</h1>
```

###### Out

```text
4:1-4:14: Unexpected duplicate toplevel heading, exected a single heading with rank `1`
```

## Compatibility

Projects maintained by the unified collective are compatible with maintained
versions of Node.js.

When we cut a new major release, we drop support for unmaintained versions of
Node.
This means we try to keep the current release line,
`remark-lint-no-multiple-toplevel-headings@4`,
compatible with Node.js 16.

## Contribute

See [`contributing.md`][github-dotfiles-contributing] in [`remarkjs/.github`][github-dotfiles-health] for ways
to get started.
See [`support.md`][github-dotfiles-support] for ways to get help.

This project has a [code of conduct][github-dotfiles-coc].
By interacting with this repository, organization, or community you agree to
abide by its terms.

## License

[MIT][file-license] © [Titus Wormer][author]

[api-depth]: #depth

[api-options]: #options

[api-remark-lint-no-multiple-toplevel-headings]: #unifieduseremarklintnomultipletoplevelheadings-options

[author]: https://wooorm.com

[badge-build-image]: https://github.com/remarkjs/remark-lint/workflows/main/badge.svg

[badge-build-url]: https://github.com/remarkjs/remark-lint/actions

[badge-chat-image]: https://img.shields.io/badge/chat-discussions-success.svg

[badge-chat-url]: https://github.com/remarkjs/remark/discussions

[badge-coverage-image]: https://img.shields.io/codecov/c/github/remarkjs/remark-lint.svg

[badge-coverage-url]: https://codecov.io/github/remarkjs/remark-lint

[badge-downloads-image]: https://img.shields.io/npm/dm/remark-lint-no-multiple-toplevel-headings.svg

[badge-downloads-url]: https://www.npmjs.com/package/remark-lint-no-multiple-toplevel-headings

[badge-funding-backers-image]: https://opencollective.com/unified/backers/badge.svg

[badge-funding-sponsors-image]: https://opencollective.com/unified/sponsors/badge.svg

[badge-funding-url]: https://opencollective.com/unified

[badge-size-image]: https://img.shields.io/bundlejs/size/remark-lint-no-multiple-toplevel-headings

[badge-size-url]: https://bundlejs.com/?q=remark-lint-no-multiple-toplevel-headings

[esm-sh]: https://esm.sh

[file-license]: https://github.com/remarkjs/remark-lint/blob/main/license

[github-dotfiles-coc]: https://github.com/remarkjs/.github/blob/main/code-of-conduct.md

[github-dotfiles-contributing]: https://github.com/remarkjs/.github/blob/main/contributing.md

[github-dotfiles-health]: https://github.com/remarkjs/.github

[github-dotfiles-support]: https://github.com/remarkjs/.github/blob/main/support.md

[github-gist-esm]: https://gist.github.com/sindresorhus/a39789f98801d908bbc7ff3ecc99d99c

[github-remark-lint]: https://github.com/remarkjs/remark-lint

[github-remark-mdx]: https://mdxjs.com/packages/remark-mdx/

[github-unified-transformer]: https://github.com/unifiedjs/unified#transformer

[npm-install]: https://docs.npmjs.com/cli/install

[typescript]: https://www.typescriptlang.org
