/**
 * @typedef Info
 * @property {Array<string>} [extensionsWithDot]
 * @property {Array<string>} [extensions]
 * @property {Array<string>} names
 */

/** @type {Array<Info>} */
export const githubLinguistInfo = [
  {
    names: ['xcompose']
  },
  {
    extensions: ['.lasso', '.las', '.lasso8', '.lasso9'],
    names: ['lasso', 'lassoscript']
  },
  {
    names: [
      'go-mod',
      'go-module',
      'go-work',
      'go-workspace',
      'go.mod',
      'go.work'
    ]
  },
  {
    names: ['go-checksums', 'go.sum', 'go-sum', 'go.work.sum', 'go-work-sum']
  },
  {
    extensions: [
      '.c++-objdump',
      '.c++objdump',
      '.c-objdump',
      '.cpp-objdump',
      '.cppobjdump',
      '.cxx-objdump',
      '.d-objdump',
      '.objdump'
    ],
    names: ['c++-objdump', 'c-objdump', 'cpp-objdump', 'd-objdump', 'objdump']
  },
  {
    extensions: ['.2da'],
    names: ['2-dimensional-array']
  },
  {
    extensions: ['.4dm'],
    names: ['4d']
  },
  {
    extensions: ['.8xp', '.8xp.txt'],
    names: ['ti-program']
  },
  {
    extensions: ['.caddyfile'],
    names: ['caddyfile', 'caddy']
  },
  {
    names: [
      'quickbasic',
      'qb',
      'qbasic',
      'qb64',
      'classic-qbasic',
      'classic-quickbasic'
    ]
  },
  {
    extensions: ['.abap'],
    names: ['abap']
  },
  {
    extensions: ['.asddls'],
    names: ['abap-cds']
  },
  {
    extensions: ['.w'],
    names: ['openedge-abl', 'progress', 'openedge', 'abl']
  },
  {
    extensions: ['.abnf'],
    names: ['abnf']
  },
  {
    extensions: ['.as'],
    names: ['actionscript', 'actionscript-3', 'actionscript3', 'as3']
  },
  {
    extensionsWithDot: ['.adb'],
    extensions: ['.ada', '.ads'],
    names: ['ada', 'ada95', 'ada2005']
  },
  {
    extensions: ['.afm'],
    names: [
      'adobe-font-metrics',
      'acfm',
      'adobe-composite-font-metrics',
      'adobe-multiple-font-metrics',
      'amfm'
    ]
  },
  {
    extensions: ['.agc'],
    names: ['apollo-guidance-computer']
  },
  {
    extensions: ['.agda'],
    names: ['agda']
  },
  {
    extensions: ['.ahk', '.ahkl'],
    names: ['autohotkey', 'ahk']
  },
  {
    extensions: ['.aidl'],
    names: ['aidl']
  },
  {
    extensions: ['.al'],
    names: ['al']
  },
  {
    extensions: ['.als'],
    names: ['alloy']
  },
  {
    extensions: ['.ampl', '.mod'],
    names: ['ampl']
  },
  {
    extensions: ['.angelscript'],
    names: ['angelscript']
  },
  {
    extensions: ['.lp'],
    names: ['answer-set-programming']
  },
  {
    extensions: ['.g4'],
    names: ['antlr']
  },
  {
    extensions: ['.apacheconf', '.vhost'],
    names: ['apacheconf', 'aconf', 'apache']
  },
  {
    extensions: ['.apacheconf', '.vhost'],
    names: ['apacheconf', 'aconf', 'apache']
  },
  {
    extensions: ['.cls', '.apex', '.trigger'],
    names: ['apex']
  },
  {
    extensions: ['.apl', '.dyalog'],
    names: ['apl']
  },
  {
    extensions: ['.applescript', '.scpt'],
    names: ['applescript', 'osascript']
  },
  {
    extensions: ['.arr'],
    names: ['pyret']
  },
  {
    extensions: ['.asl', '.dsl'],
    names: ['asl']
  },
  {
    extensions: ['.asn', '.asn1'],
    names: ['asn.1']
  },
  {
    extensions: ['.aj'],
    names: ['aspectj']
  },
  {
    extensionsWithDot: ['.inc'],
    extensions: ['.asm', '.a51', '.i', '.nas', '.nasm', '.s'],
    names: ['assembly', 'asm', 'nasm']
  },
  {
    extensions: ['.astro'],
    names: ['astro']
  },
  {
    extensions: ['.dats', '.hats', '.sats'],
    names: ['ats', 'ats2']
  },
  {
    extensions: ['.au3'],
    names: ['autoit', 'au3', 'autoit3', 'autoitscript']
  },
  {
    extensions: ['.avdl'],
    names: ['avro-idl']
  },
  {
    extensions: ['.awk', '.auk', '.gawk', '.mawk', '.nawk'],
    names: ['awk']
  },
  {
    extensions: ['.bal'],
    names: ['ballerina']
  },
  {
    names: ['basic']
  },
  {
    extensions: ['.bat', '.cmd'],
    names: ['batchfile', 'bat', 'batch', 'dosbatch', 'winbatch']
  },
  {
    extensions: ['.bb', '.bbappend', '.bbclass'],
    names: ['bitbake']
  },
  {
    extensions: ['.bdf'],
    names: ['glyph-bitmap-distribution-format']
  },
  {
    extensions: ['.befunge'],
    names: ['befunge']
  },
  {
    extensions: ['.be'],
    names: ['berry', 'be']
  },
  {
    extensions: ['.b'],
    names: ['brainfuck']
  },
  {
    names: ['bluespec-bh', 'bh', 'bluespec-classic']
  },
  {
    extensions: ['.bicep', '.bicepparam'],
    names: ['bicep']
  },
  {
    extensions: ['.bmx', '.decls'],
    names: [
      'b3d',
      'blitz3d',
      'blitzbasic',
      'blitzmax',
      'blitzplus',
      'bmax',
      'bplus'
    ]
  },
  {
    extensions: ['.boo'],
    names: ['boo']
  },
  {
    extensions: ['.bpl'],
    names: ['boogie']
  },
  {
    names: ['soong']
  },
  {
    extensions: ['.bqn'],
    names: ['bqn']
  },
  {
    extensions: ['.brs'],
    names: ['brighterscript', 'brightscript']
  },
  {
    extensions: ['.bsl', '.os'],
    names: ['1c-enterprise']
  },
  {
    extensions: ['.bst'],
    names: ['bibtex-style']
  },
  {
    extensions: ['.bsv'],
    names: ['bluespec', 'bluespec-bsv', 'bsv']
  },
  {
    extensions: [
      '.asc',
      '.ash',
      '.asy',
      '.c++',
      '.cc',
      '.cp',
      '.cpp',
      '.cppm',
      '.cxx',
      '.edc',
      '.gml',
      '.h++',
      '.hh',
      '.hpp',
      '.hxx',
      '.inl',
      '.ino',
      '.ipp',
      '.ixx',
      '.metal',
      '.re',
      '.tcc',
      '.tpp',
      '.txx'
    ],
    names: [
      'ags',
      'ags-script',
      'asymptote',
      'c++',
      'cpp',
      'edje-data-collection',
      'game-maker-language',
      'metal',
      'swig'
    ]
  },
  {
    extensions: ['.ec', '.eh'],
    names: ['ec']
  },
  {
    extensions: [
      '.c',
      '.cats',
      '.h',
      '.h.in',
      '.idc',
      '.opencl',
      '.upc',
      '.xbm',
      '.xpm',
      '.xs'
    ],
    names: [
      'c',
      'dtrace',
      'dtrace-script',
      'oncrpc',
      'opencl',
      'rpc',
      'rpcgen',
      'unified-parallel-c',
      'x-bitmap',
      'x-pixmap',
      'xbm',
      'xdr',
      'xpm',
      'xs'
    ]
  },
  {
    extensions: ['.ld', '.lds', '.x'],
    names: ['linker-script']
  },
  {
    extensions: ['.nss'],
    names: ['nwscript']
  },
  {
    extensions: ['.cabal'],
    names: ['cabal-config', 'cabal']
  },
  {
    extensions: ['.cdc'],
    names: ['cadence']
  },
  {
    extensions: ['.cairo'],
    names: ['cairo']
  },
  {
    names: ['cairo-zero']
  },
  {
    extensions: ['.capnp'],
    names: ["cap'n-proto"]
  },
  {
    extensions: ['.cds'],
    names: ['cap-cds', 'cds']
  },
  {
    extensions: ['.ceylon'],
    names: ['ceylon']
  },
  {
    extensions: ['.cfc'],
    names: ['coldfusion-cfc', 'cfc']
  },
  {
    extensions: ['.chpl'],
    names: ['chapel', 'chpl']
  },
  {
    extensions: ['.cil'],
    names: ['cil']
  },
  {
    extensions: ['.circom'],
    names: ['circom']
  },
  {
    extensions: ['.cirru'],
    names: ['cirru']
  },
  {
    extensions: ['.clar'],
    names: ['clarity']
  },
  {
    extensions: ['.clw'],
    names: ['clarion']
  },
  {
    extensions: ['.icl', '.dcl'],
    names: ['clean']
  },
  {
    extensions: ['.click'],
    names: ['click']
  },
  {
    extensions: ['.clp'],
    names: ['clips']
  },
  {
    extensions: [
      '.boot',
      '.cl2',
      '.clj',
      '.cljc',
      '.cljs',
      '.cljs.hl',
      '.cljscm',
      '.cljx',
      '.edn',
      '.hic',
      '.rg',
      '.wisp'
    ],
    names: ['clojure', 'edn', 'rouge', 'wisp']
  },
  {
    extensions: ['.cmake', '.cmake.in'],
    names: ['cmake']
  },
  {
    extensions: ['.cob', '.cbl', '.ccp', '.cobol', '.cpy'],
    names: ['cobol']
  },
  {
    extensions: [
      '._coffee',
      '.cjsx',
      '.coffee',
      '.cson',
      '.em',
      '.emberscript',
      '.iced'
    ],
    names: ['coffee', 'coffee-script', 'coffeescript', 'cson', 'emberscript']
  },
  {
    extensions: [
      '.lisp',
      '.asd',
      '.cl',
      '.l',
      '.lsp',
      '.ny',
      '.podsl',
      '.sexp'
    ],
    names: ['common-lisp', 'lisp']
  },
  {
    names: ['cool']
  },
  {
    extensionsWithDot: ['.v'],
    extensions: ['.coq'],
    names: ['coq']
  },
  {
    extensions: ['.cr'],
    names: ['crystal']
  },
  {
    extensions: [
      '.bf',
      '.cake',
      '.cs',
      '.cs.pp',
      '.csx',
      '.eq',
      '.linq',
      '.uno'
    ],
    names: ['beef', 'c#', 'cake', 'cakescript', 'csharp', 'eq', 'uno']
  },
  {
    extensions: ['.csd'],
    names: ['csound-document', 'csound-csd']
  },
  {
    extensions: ['.sco'],
    names: ['csound-score', 'csound-sco']
  },
  {
    extensions: ['.orc', '.udo'],
    names: ['csound', 'csound-orc']
  },
  {
    extensions: ['.css'],
    names: ['css']
  },
  {
    extensions: ['.less'],
    names: ['less', 'less-css']
  },
  {
    extensions: ['.mss'],
    names: ['cartocss', 'carto']
  },
  {
    extensions: ['.sss'],
    names: ['sugarss']
  },
  {
    extensions: ['.scss'],
    names: ['scss']
  },
  {
    extensions: ['.bs'],
    names: ['bikeshed']
  },
  {
    extensions: ['.cu', '.cuh'],
    names: ['cuda']
  },
  {
    extensions: ['.cue'],
    names: ['cue']
  },
  {
    names: ['cue-sheet']
  },
  {
    names: ['curl-config', 'curlrc']
  },
  {
    extensions: ['.curry'],
    names: ['curry']
  },
  {
    extensions: ['.cwl'],
    names: ['common-workflow-language', 'cwl']
  },
  {
    extensions: ['.cylc'],
    names: ['cylc']
  },
  {
    extensions: ['.cyp', '.cypher'],
    names: ['cypher']
  },
  {
    extensions: ['.pyx', '.pxd', '.pxi'],
    names: ['cython', 'pyrex']
  },
  {
    extensions: ['.d', '.di', '.volt'],
    names: ['d', 'dlang', 'volt']
  },
  {
    extensions: ['.d2'],
    names: ['d2', 'd2lang']
  },
  {
    extensions: ['.dart'],
    names: ['dart']
  },
  {
    extensions: ['.dwl'],
    names: ['dataweave']
  },
  {
    extensions: ['.dsc'],
    names: ['debian-package-control-file']
  },
  {
    names: ['denizenscript']
  },
  {
    extensions: ['.desktop', '.desktop.in', '.service'],
    names: ['desktop']
  },
  {
    extensions: ['.diff', '.patch'],
    names: ['diff', 'udiff']
  },
  {
    extensions: ['.dircolors'],
    names: ['dircolors']
  },
  {
    extensions: ['.dm'],
    names: ['dm', 'byond']
  },
  {
    extensions: ['.dockerfile', '.containerfile'],
    names: ['dockerfile', 'containerfile']
  },
  {
    extensions: ['.dot', '.gv'],
    names: ['graphviz-(dot)']
  },
  {
    extensions: ['.env'],
    names: ['dotenv']
  },
  {
    names: ['dune']
  },
  {
    extensions: ['.dylan', '.dyl', '.intr', '.lid'],
    names: ['dylan']
  },
  {
    names: ['earthly', 'earthfile']
  },
  {
    extensions: ['.ebnf'],
    names: ['ebnf']
  },
  {
    extensions: ['.ecl', '.eclxml'],
    names: ['ecl']
  },
  {
    extensions: ['.edgeql', '.esdl'],
    names: ['edgeql', 'esdl']
  },
  {
    extensions: ['.editorconfig'],
    names: ['editorconfig', 'editor-config']
  },
  {
    extensions: ['.e'],
    names: ['eiffel']
  },
  {
    extensions: ['.ex', '.exs'],
    names: ['elixir']
  },
  {
    extensions: ['.elm'],
    names: ['elm']
  },
  {
    names: ['elvish-transcript']
  },
  {
    extensions: ['.elv'],
    names: ['elvish']
  },
  {
    extensions: ['.el', '.emacs', '.emacs.desktop'],
    names: ['emacs-lisp', 'elisp', 'emacs']
  },
  {
    extensions: [
      '.erl',
      '.app',
      '.app.src',
      '.es',
      '.escript',
      '.hrl',
      '.xrl',
      '.yrl'
    ],
    names: ['erlang']
  },
  {
    names: ['euphoria']
  },
  {
    extensions: ['.factor'],
    names: ['factor']
  },
  {
    extensions: ['.fan'],
    names: ['fantom']
  },
  {
    extensions: ['.fy', '.fancypack'],
    names: ['fancy']
  },
  {
    extensions: ['.dsp'],
    names: ['faust']
  },
  {
    extensions: ['.flf'],
    names: ['figlet-font', 'figfont']
  },
  {
    names: ['cloud-firestore-security-rules']
  },
  {
    extensions: ['.fir'],
    names: ['firrtl']
  },
  {
    extensions: ['.fish'],
    names: ['fish']
  },
  {
    extensions: ['.fnl'],
    names: ['fennel']
  },
  {
    names: ['x-font-directory-index']
  },
  {
    extensions: ['.fth', '.4th', '.f', '.for', '.forth', '.fr', '.frt'],
    names: ['forth']
  },
  {
    extensions: ['.f77', '.fpp'],
    names: ['fortran']
  },
  {
    extensions: ['.f90', '.f03', '.f08', '.f95'],
    names: ['fortran-free-form']
  },
  {
    extensions: ['.fs', '.fsi', '.fsx'],
    names: ['f#', 'fsharp']
  },
  {
    extensions: ['.fst', '.fsti'],
    names: ['f*', 'fstar']
  },
  {
    extensionsWithDot: ['.ftl'],
    names: ['fluent']
  },
  {
    extensions: ['.fut'],
    names: ['futhark']
  },
  {
    extensions: ['.gap', '.gd', '.gi', '.tst'],
    names: ['gap']
  },
  {
    extensions: ['.g', '.cnc', '.gco', '.gcode'],
    names: ['g-code']
  },
  {
    extensions: ['.gdb', '.gdbinit'],
    names: ['gdb']
  },
  {
    extensions: ['.gdnlib', '.gdns', '.tres', '.tscn'],
    names: ['godot-resource']
  },
  {
    names: ['gdscript']
  },
  {
    extensions: ['.ged'],
    names: ['gedcom']
  },
  {
    names: ['gemfile.lock']
  },
  {
    extensions: ['.gmi'],
    names: ['gemini', 'gemtext']
  },
  {
    extensions: ['.tsv', '.vcf'],
    names: ['tsv', 'tab-seperated-values']
  },
  {
    extensions: ['.4gl'],
    names: ['genero-4gl']
  },
  {
    extensions: ['.per'],
    names: ['genero-forms']
  },
  {
    extensions: ['.per'],
    names: ['genero-per']
  },
  {
    extensions: ['.4gl'],
    names: ['genero']
  },
  {
    extensionsWithDot: ['.ncl'],
    extensions: [
      '.gbr',
      '.cmp',
      '.gbl',
      '.gbo',
      '.gbp',
      '.gbs',
      '.gko',
      '.gpb',
      '.gpt',
      '.gtl',
      '.gto',
      '.gtp',
      '.gts',
      '.sol'
    ],
    names: ['gerber-image', 'rs-274x']
  },
  {
    extensions: ['.gf'],
    names: ['grammatical-framework', 'gf']
  },
  {
    names: ['git-revision-list', 'git-blame-ignore-revs']
  },
  {
    names: ['git-attributes', 'gitattributes']
  },
  {
    extensions: ['.gitconfig'],
    names: ['git-config', 'gitconfig', 'gitmodules']
  },
  {
    extensions: ['.gitignore'],
    names: ['ignore-list', 'ignore', 'gitignore', 'git-ignore']
  },
  {
    extensions: ['.gjs'],
    names: ['glimmer-js']
  },
  {
    extensions: ['.gleam'],
    names: ['gleam']
  },
  {
    extensions: [
      '.glsl',
      '.fp',
      '.frag',
      '.frg',
      '.fsh',
      '.fshader',
      '.geo',
      '.geom',
      '.glslf',
      '.glslv',
      '.gs',
      '.gshader',
      '.rchit',
      '.rmiss',
      '.shader',
      '.tesc',
      '.tese',
      '.vert',
      '.vrx',
      '.vs',
      '.vsh',
      '.vshader'
    ],
    names: ['glsl']
  },
  {
    extensions: ['.gn', '.gni'],
    names: ['gn']
  },
  {
    extensions: ['.gp', '.gnu', '.gnuplot', '.p', '.plot', '.plt'],
    names: ['gnuplot']
  },
  {
    extensions: ['.go'],
    names: ['go', 'golang']
  },
  {
    extensions: ['.golo'],
    names: ['golo']
  },
  {
    extensions: ['.gst', '.gsx', '.vark'],
    names: ['gosu']
  },
  {
    extensions: ['.grace'],
    names: ['grace']
  },
  {
    extensions: ['.graphql', '.gql', '.graphqls'],
    names: ['graphql']
  },
  {
    extensions: ['.gradle'],
    names: ['gradle']
  },
  {
    extensions: ['.groovy', '.grt', '.gtpl', '.gvy'],
    names: ['groovy']
  },
  {
    extensions: ['.gsc', '.csc', '.gsh'],
    names: ['gsc']
  },
  {
    names: ['glimmer-ts']
  },
  {
    extensionsWithDot: ['.php'],
    extensions: ['.hack', '.hhi'],
    names: ['hack']
  },
  {
    extensions: ['.cfg'],
    names: ['haproxy']
  },
  {
    extensions: ['.ch', '.hb', '.prg', '.prw'],
    names: ['advpl', 'clipper', 'foxpro', 'harbour', 'xbase']
  },
  {
    extensions: ['.chs', '.dhall', '.hs', '.hs-boot', '.hsc'],
    names: ['c2hs', 'c2hs-haskell', 'dhall', 'frege', 'haskell']
  },
  {
    extensions: ['.hc'],
    names: ['holyc']
  },
  {
    extensions: ['.hcl', '.nomad', '.tf', '.tfvars', '.workflow'],
    names: ['hcl', 'hashicorp-configuration-language', 'terraform']
  },
  {
    extensions: ['.tftpl'],
    names: ['terraform-template']
  },
  {
    extensions: ['.hlsl', '.cginc', '.fx', '.fxh', '.hlsli'],
    names: ['hlsl']
  },
  {
    extensions: ['.hocon'],
    names: ['hocon']
  },
  {
    extensions: ['.hoon'],
    names: ['hoon']
  },
  {
    names: ['hosts-file', 'hosts']
  },
  {
    extensionsWithDot: ['.q'],
    extensions: ['.hql'],
    names: ['hiveql']
  },
  {
    extensions: ['.http'],
    names: ['http']
  },
  {
    extensions: ['.hx', '.hxsl'],
    names: ['haxe']
  },
  {
    extensions: ['.hxml'],
    names: ['hxml']
  },
  {
    extensions: ['.hy'],
    names: ['hy', 'hylang']
  },
  {
    extensions: ['.ics', '.ical'],
    names: ['icalendar', 'ical']
  },
  {
    names: ['slice']
  },
  {
    extensions: ['.pro', '.dlm'],
    names: ['idl']
  },
  {
    extensions: ['.idr', '.lidr'],
    names: ['idris']
  },
  {
    extensions: ['.ipf'],
    names: ['igor-pro', 'igor', 'igorpro']
  },
  {
    extensions: ['.imba'],
    names: ['imba']
  },
  {
    extensions: ['.ni', '.i7x'],
    names: ['inform-7', 'i7', 'inform7']
  },
  {
    extensions: [
      '.cnf',
      '.dof',
      '.ini',
      '.lektorproject',
      '.outjob',
      '.pcbdoc',
      '.prefs',
      '.prjpcb',
      '.properties',
      '.schdoc',
      '.url'
    ],
    names: ['altium', 'altium-designer', 'dosini', 'ini']
  },
  {
    names: ['npm-config', 'npmrc']
  },
  {
    extensions: ['.ink'],
    names: ['ink']
  },
  {
    extensions: ['.iss', '.isl'],
    names: ['inno-setup']
  },
  {
    names: ['readline-config', 'inputrc', 'readline']
  },
  {
    extensions: ['.io'],
    names: ['io']
  },
  {
    extensions: ['.ik'],
    names: ['ioke']
  },
  {
    names: ['isabelle-root']
  },
  {
    extensions: ['.thy'],
    names: ['isabelle']
  },
  {
    extensions: ['.ispc'],
    names: ['ispc']
  },
  {
    extensions: ['.ijs'],
    names: ['j']
  },
  {
    extensions: ['.jai'],
    names: ['jai']
  },
  {
    extensions: ['.janet'],
    names: ['janet']
  },
  {
    extensionsWithDot: ['.j'],
    names: ['jasmin']
  },
  {
    names: ['java-properties']
  },
  {
    extensions: ['.ck', '.jav', '.java', '.jsh', '.uc'],
    names: ['chuck', 'java', 'unrealscript']
  },
  {
    extensions: ['.jcl'],
    names: ['jcl']
  },
  {
    extensions: ['.snap'],
    names: ['jest-snapshot']
  },
  {
    extensionsWithDot: ['.flex'],
    extensions: ['.jflex'],
    names: ['jflex']
  },
  {
    extensions: ['.jison'],
    names: ['jison']
  },
  {
    extensions: ['.jisonlex'],
    names: ['jison-lex']
  },
  {
    extensions: ['.ol', '.iol'],
    names: ['jolie']
  },
  {
    names: ['jq']
  },
  {
    extensions: [
      '._js',
      '.bones',
      '.cjs',
      '.cy',
      '.es6',
      '.jake',
      '.javascript',
      '.js',
      '.js.erb',
      '.jsb',
      '.jscad',
      '.jsfl',
      '.jslib',
      '.jsm',
      '.json5',
      '.jsonld',
      '.jspre',
      '.jss',
      '.jsx',
      '.mjs',
      '.njs',
      '.pac',
      '.sjs',
      '.ssjs',
      '.xsjs',
      '.xsjslib'
    ],
    names: [
      'cycript',
      'javascript',
      'javascript+erb',
      'js',
      'json5',
      'jsonld',
      'node',
      'qt-script'
    ]
  },
  {
    extensions: ['.sj'],
    names: ['objective-j', 'obj-j', 'objectivej', 'objj']
  },
  {
    extensions: [
      '.jsonc',
      '.code-snippets',
      '.code-workspace',
      '.sublime-build',
      '.sublime-color-scheme',
      '.sublime-commands',
      '.sublime-completions',
      '.sublime-keymap',
      '.sublime-macro',
      '.sublime-menu',
      '.sublime-mousemap',
      '.sublime-project',
      '.sublime-settings',
      '.sublime-theme',
      '.sublime-workspace',
      '.sublime_metrics',
      '.sublime_session'
    ],
    names: ['json-with-comments', 'jsonc']
  },
  {
    extensionsWithDot: ['.tact'],
    extensions: [
      '.4dform',
      '.4dproject',
      '.avsc',
      '.epj',
      '.geojson',
      '.gltf',
      '.har',
      '.ice',
      '.ipynb',
      '.json',
      '.json',
      '.json',
      '.json-tmlanguage',
      '.json.example',
      '.jsonl',
      '.maxhelp',
      '.maxpat',
      '.maxproj',
      '.mcmeta',
      '.mxt',
      '.pat',
      '.sarif',
      '.tfstate',
      '.tfstate.backup',
      '.topojson',
      '.webapp',
      '.webmanifest',
      '.yy',
      '.yyp'
    ],
    names: [
      'ecere-projects',
      'geojson',
      'ipython-notebook',
      'json',
      'jsonl',
      'jupyter-notebook',
      'max',
      'max/msp',
      'maxmsp',
      'oasv2-json',
      'oasv3-json',
      'sarif',
      'topojson'
    ]
  },
  {
    extensionsWithDot: ['.jq'],
    names: ['jsoniq']
  },
  {
    extensions: ['.jsonnet', '.libsonnet'],
    names: ['jsonnet']
  },
  {
    names: ['julia-repl']
  },
  {
    extensions: ['.jl'],
    names: ['julia']
  },
  {
    extensions: ['.just'],
    names: ['just', 'justfile']
  },
  {
    extensions: ['.kak'],
    names: ['kakounescript', 'kak', 'kakscript']
  },
  {
    extensions: ['.kdl'],
    names: ['kdl']
  },
  {
    extensions: ['.ks'],
    names: ['kerboscript']
  },
  {
    extensions: ['.vdf'],
    names: ['valve-data-format', 'keyvalues', 'vdf']
  },
  {
    names: ['kickstart']
  },
  {
    extensions: ['.gradle.kts', '.kt', '.ktm', '.kts'],
    names: ['gradle-kotlin-dsl', 'kotlin']
  },
  {
    extensions: ['.csl', '.kql'],
    names: ['kusto']
  },
  {
    extensions: ['.lark'],
    names: ['lark']
  },
  {
    extensions: ['.lean', '.hlean'],
    names: ['lean']
  },
  {
    names: ['lean-4']
  },
  {
    extensions: ['.lex'],
    names: ['lex', 'flex']
  },
  {
    extensions: ['.ligo'],
    names: ['ligolang']
  },
  {
    extensions: ['.ly', '.ily'],
    names: ['lilypond']
  },
  {
    extensionsWithDot: ['.md'],
    extensions: ['.lfe', '.nl', '.nlogo', '.srt'],
    names: [
      'gcc-machine-description',
      'lfe',
      'netlogo',
      'newlisp',
      'picolisp',
      'srecode-template'
    ]
  },
  {
    extensions: ['.litcoffee', '.coffee.md'],
    names: ['literate-coffeescript', 'litcoffee']
  },
  {
    extensions: ['.livecodescript'],
    names: ['livecode-script']
  },
  {
    extensions: ['.ls', '._ls'],
    names: ['livescript', 'live-script', 'ls']
  },
  {
    extensions: ['.ll'],
    names: ['llvm']
  },
  {
    extensions: ['.xm', '.xi'],
    names: ['logos']
  },
  {
    extensions: ['.lgt', '.logtalk'],
    names: ['logtalk']
  },
  {
    extensions: ['.lol'],
    names: ['lolcode']
  },
  {
    names: ['loomscript']
  },
  {
    extensions: ['.lsl', '.lslp'],
    names: ['lsl']
  },
  {
    names: ['ltspice-symbol']
  },
  {
    extensions: [
      '.lua',
      '.fcgi',
      '.nse',
      '.p8',
      '.pd_lua',
      '.rbxs',
      '.rockspec',
      '.wlua'
    ],
    names: ['lua']
  },
  {
    extensions: ['.luau'],
    names: ['luau']
  },
  {
    extensions: ['.m2'],
    names: ['macaulay2', 'm2']
  },
  {
    extensions: ['.m4', '.m4', '.mc'],
    names: ['autoconf', 'm4', 'm4sugar']
  },
  {
    extensions: ['.x68'],
    names: ['motorola-68k-assembly', 'm68k']
  },
  {
    extensions: ['.mak', '.make', '.makefile', '.mk', '.mkfile'],
    names: ['makefile', 'bsdmake', 'make', 'mf']
  },
  {
    extensions: ['.mask'],
    names: ['mask']
  },
  {
    extensions: [
      '.mathematica',
      '.cdf',
      '.ma',
      '.mt',
      '.nb',
      '.nbp',
      '.wl',
      '.wlt'
    ],
    names: [
      'mathematica',
      'mma',
      'wolfram',
      'wolfram-language',
      'wolfram-lang',
      'wl'
    ]
  },
  {
    extensions: ['.matlab', '.m'],
    names: ['matlab', 'octave']
  },
  {
    extensions: ['.ms', '.mcr'],
    names: ['maxscript']
  },
  {
    names: ['monkey-c']
  },
  {
    extensions: ['.mcfunction'],
    names: ['mcfunction']
  },
  {
    extensions: ['.mdx'],
    names: ['mdx']
  },
  {
    extensions: ['.moo'],
    names: ['mercury']
  },
  {
    extensions: ['.mmd', '.mermaid'],
    names: ['mermaid', 'mermaid-example']
  },
  {
    names: ['meson']
  },
  {
    extensionsWithDot: ['.yaml', '.yml'],
    names: ['miniyaml']
  },
  {
    extensions: ['.mint'],
    names: ['mint']
  },
  {
    extensions: ['.fun', '.sig', '.sml'],
    names: ['standard-ml', 'sml']
  },
  {
    extensions: ['.mligo'],
    names: ['cameligo']
  },
  {
    extensions: ['.mlir'],
    names: ['mlir']
  },
  {
    names: ['motoko']
  },
  {
    extensions: ['.mo'],
    names: ['modelica']
  },
  {
    extensions: ['.i3', '.ig', '.m3', '.mg'],
    names: ['modula-3']
  },
  {
    extensions: ['.ob2'],
    names: ['modula-2', 'oberon']
  },
  {
    extensions: ['.mojo'],
    names: ['mojo']
  },
  {
    extensions: ['.monkey', '.monkey2'],
    names: ['monkey']
  },
  {
    extensions: ['.mbt'],
    names: ['moonbit']
  },
  {
    extensions: ['.moon'],
    names: ['moonscript']
  },
  {
    extensions: ['.move'],
    names: ['move']
  },
  {
    extensions: ['.mq4', '.mq5', '.mqh', '.mqh'],
    names: ['mql4', 'mql5']
  },
  {
    extensions: ['.msg'],
    names: ['omnet++-msg', 'omnetpp-msg']
  },
  {
    extensions: ['.mrc'],
    names: ['mirc-script']
  },
  {
    extensions: ['.mu'],
    names: ['mupad']
  },
  {
    extensions: ['.dzn', '.mzn'],
    names: ['minizinc', 'minizinc-data']
  },
  {
    extensions: ['.nanorc'],
    names: ['nanorc']
  },
  {
    names: ['nasal']
  },
  {
    extensions: ['.nasl'],
    names: ['nasl']
  },
  {
    names: ['ncl']
  },
  {
    extensions: ['.ne', '.nearley'],
    names: ['nearley']
  },
  {
    extensions: ['.ned'],
    names: ['omnet++-ned', 'omnetpp-ned']
  },
  {
    extensions: ['.n'],
    names: ['nemerle']
  },
  {
    extensions: ['.neon'],
    names: ['neon', 'nette-object-notation', 'ne-on']
  },
  {
    extensions: ['.nc'],
    names: ['nesc']
  },
  {
    extensions: ['.axs.erb', '.axi.erb'],
    names: ['netlinx+erb']
  },
  {
    extensions: ['.axs', '.axi'],
    names: ['netlinx']
  },
  {
    extensions: ['.nf'],
    names: ['nextflow']
  },
  {
    extensions: ['.nginx', '.nginxconf'],
    names: ['nginx', 'nginx-configuration-file']
  },
  {
    extensions: ['.nim', '.nim.cfg', '.nimble', '.nimrod', '.nims'],
    names: ['nim']
  },
  {
    extensions: ['.ninja'],
    names: ['ninja']
  },
  {
    extensions: ['.nit'],
    names: ['nit']
  },
  {
    extensions: ['.nix'],
    names: ['nix', 'nixos']
  },
  {
    extensions: ['.nr'],
    names: ['noir', 'nargo']
  },
  {
    extensions: ['.nsi', '.nsh'],
    names: ['nsis']
  },
  {
    extensions: ['.nu'],
    names: ['nu', 'nush']
  },
  {
    names: ['nushell', 'nu-script', 'nushell-script']
  },
  {
    extensions: ['.nut'],
    names: ['squirrel']
  },
  {
    extensions: ['.mm'],
    names: ['objective-c++', 'obj-c++', 'objc++', 'objectivec++']
  },
  {
    names: ['objective-c', 'obj-c', 'objc', 'objectivec']
  },
  {
    names: ['objectscript']
  },
  {
    extensions: ['.ml', '.eliom', '.eliomi', '.ml4', '.mli', '.mll', '.mly'],
    names: ['ocaml']
  },
  {
    extensionsWithDot: ['.odin'],
    names: ['object-data-instance-notation']
  },
  {
    names: ['odin', 'odinlang', 'odin-lang']
  },
  {
    extensions: ['.ooc'],
    names: ['ooc']
  },
  {
    extensions: ['.opa'],
    names: ['opa']
  },
  {
    extensions: ['.opal'],
    names: ['opal']
  },
  {
    extensions: ['.fea'],
    names: ['opentype-feature-file', 'afdko']
  },
  {
    names: ['option-list', 'opts', 'ackrc']
  },
  {
    extensions: ['.overpassql'],
    names: ['overpassql']
  },
  {
    extensions: ['.ox', '.oxh', '.oxo'],
    names: ['ox']
  },
  {
    extensions: ['.oz'],
    names: ['oz']
  },
  {
    extensions: ['.p4'],
    names: ['p4']
  },
  {
    extensions: ['.pact'],
    names: ['pact']
  },
  {
    extensions: ['.pan'],
    names: ['pan']
  },
  {
    extensions: ['.psc'],
    names: ['papyrus']
  },
  {
    extensions: ['.pir'],
    names: ['parrot-internal-representation', 'pir']
  },
  {
    extensions: ['.cps', '.dfm', '.dpr', '.lpr', '.pas', '.pascal', '.pp'],
    names: ['component-pascal', 'delphi', 'objectpascal', 'pascal']
  },
  {
    extensions: ['.pwn', '.sma'],
    names: ['pawn']
  },
  {
    names: ['kicad-legacy-layout']
  },
  {
    extensions: ['.kicad_sch'],
    names: ['kicad-schematic', 'eeschema-schematic']
  },
  {
    extensions: ['.kicad_pcb', '.kicad_mod', '.kicad_wks'],
    names: ['kicad-layout', 'pcbnew']
  },
  {
    extensions: ['.pddl'],
    names: ['pddl']
  },
  {
    extensions: ['.pegjs', '.peggy'],
    names: ['peg.js']
  },
  {
    extensions: ['.pegjs', '.peggy'],
    names: ['peg.js']
  },
  {
    extensions: ['.pep'],
    names: ['pep8']
  },
  {
    extensions: ['.pl', '.cgi', '.perl', '.ph', '.plx', '.pm', '.psgi', '.t'],
    names: ['perl', 'cperl']
  },
  {
    extensions: ['.zep'],
    names: ['zephir']
  },
  {
    extensions: ['.pic', '.chem'],
    names: ['pic', 'pikchr']
  },
  {
    extensions: ['.pig'],
    names: ['piglatin']
  },
  {
    extensions: ['.pike', '.pmod'],
    names: ['pike']
  },
  {
    names: ['pip-requirements']
  },
  {
    extensions: ['.pkl'],
    names: ['pkl']
  },
  {
    extensions: ['.plist', '.glyphs'],
    names: ['openstep-property-list']
  },
  {
    extensions: ['.po', '.pot'],
    names: ['gettext-catalog', 'pot']
  },
  {
    extensions: ['.pogo'],
    names: ['pogoscript']
  },
  {
    extensions: ['.polar'],
    names: ['polar']
  },
  {
    extensions: ['.pony'],
    names: ['pony']
  },
  {
    extensions: ['.por'],
    names: ['portugol']
  },
  {
    extensions: ['.pcss', '.postcss'],
    names: ['postcss']
  },
  {
    extensions: ['.ps', '.eps', '.epsi', '.pfa'],
    names: ['postscript', 'postscr']
  },
  {
    extensions: ['.pov'],
    names: ['pov-ray-sdl', 'pov-ray', 'povray']
  },
  {
    extensions: ['.pbt', '.sra', '.sru', '.srw'],
    names: ['powerbuilder']
  },
  {
    extensions: ['.ps1', '.psd1', '.psm1'],
    names: ['powershell', 'posh', 'pwsh']
  },
  {
    extensions: ['.praat'],
    names: ['praat']
  },
  {
    extensions: ['.prisma'],
    names: ['prisma']
  },
  {
    extensions: ['.pde'],
    names: ['processing']
  },
  {
    names: ['procfile']
  },
  {
    names: ['eclipse']
  },
  {
    extensions: ['.prolog', '.yap'],
    names: ['prolog']
  },
  {
    extensions: ['.pml'],
    names: ['promela']
  },
  {
    extensions: ['.proto'],
    names: ['protocol-buffer', 'proto', 'protobuf', 'protocol-buffers']
  },
  {
    names: ['puppet']
  },
  {
    extensions: ['.purs'],
    names: ['purescript']
  },
  {
    extensions: [
      '.bzl',
      '.eb',
      '.gyp',
      '.gypi',
      '.lmi',
      '.py',
      '.py3',
      '.pyde',
      '.pyi',
      '.pyp',
      '.pyt',
      '.pyw',
      '.rpy',
      '.sage',
      '.sagews',
      '.smk',
      '.snakefile',
      '.spec',
      '.tac',
      '.wsgi',
      '.xpy',
      '.xsh'
    ],
    names: [
      'bazel',
      'bzl',
      'easybuild',
      'python',
      'python3',
      'rusthon',
      'sage',
      'snakefile',
      'snakemake',
      'starlark',
      'xonsh'
    ]
  },
  {
    extensions: ['.kv'],
    names: ['kvlang']
  },
  {
    names: ['q']
  },
  {
    extensions: ['.qasm'],
    names: ['openqasm']
  },
  {
    extensions: ['.ql', '.qll'],
    names: ['codeql', 'ql']
  },
  {
    extensions: ['.pri'],
    names: ['qmake']
  },
  {
    extensions: ['.qml', '.qbs'],
    names: ['qml']
  },
  {
    extensions: ['.qs'],
    names: ['q#', 'qsharp']
  },
  {
    names: ['quake']
  },
  {
    extensions: ['.r', '.rd', '.rsx'],
    names: ['r', 'rscript', 'splus']
  },
  {
    extensions: ['.rkt', '.rktd', '.rktl', '.scrbl'],
    names: ['racket']
  },
  {
    extensions: [
      '.6pl',
      '.6pm',
      '.nqp',
      '.p6',
      '.p6l',
      '.p6m',
      '.pl6',
      '.pm6',
      '.pod',
      '.pod6',
      '.raku',
      '.rakumod'
    ],
    names: ['perl-6', 'perl6', 'pod-6', 'raku']
  },
  {
    extensions: ['.rsc'],
    names: ['rascal']
  },
  {
    extensions: ['.rbs'],
    names: ['rbs']
  },
  {
    extensions: ['.rei'],
    names: ['reason']
  },
  {
    extensions: ['.reb', '.r2', '.r3', '.rebol'],
    names: ['rebol']
  },
  {
    names: ['record-jar']
  },
  {
    extensions: ['.red', '.reds'],
    names: ['red', 'red/system']
  },
  {
    names: ['redirect-rules', 'redirects']
  },
  {
    extensions: ['.reg'],
    names: ['windows-registry-entries']
  },
  {
    extensions: ['.regexp', '.regex'],
    names: ['regular-expression', 'regexp', 'regex']
  },
  {
    extensions: ['.rego'],
    names: ['open-policy-agent']
  },
  {
    extensions: ['.religo'],
    names: ['reasonligo']
  },
  {
    names: ["ren'py", 'renpy']
  },
  {
    extensions: ['.res'],
    names: ['rescript']
  },
  {
    extensions: ['.rexx', '.pprx', '.rex'],
    names: ['rexx', 'arexx']
  },
  {
    names: ['rez']
  },
  {
    extensions: ['.ring'],
    names: ['ring']
  },
  {
    extensions: ['.roc'],
    names: ['roc']
  },
  {
    extensions: ['.ron'],
    names: ['ron']
  },
  {
    extensions: ['.rpgle', '.sqlrpgle'],
    names: ['rpgle', 'ile-rpg', 'sqlrpgle']
  },
  {
    names: ['rpm-spec', 'specfile']
  },
  {
    extensions: [
      '.builder',
      '.druby',
      '.duby',
      '.eye',
      '.gemspec',
      '.god',
      '.jbuilder',
      '.mirah',
      '.mspec',
      '.pluginspec',
      '.podspec',
      '.prawn',
      '.rabl',
      '.rake',
      '.rb',
      '.rbi',
      '.rbuild',
      '.rbw',
      '.rbx',
      '.ru',
      '.ruby',
      '.thor',
      '.watchr'
    ],
    names: ['jruby', 'macruby', 'mirah', 'rake', 'rb', 'rbx', 'ruby']
  },
  {
    extensions: ['.rs', '.rs.in'],
    names: ['rust', 'rs']
  },
  {
    extensions: ['.sas'],
    names: ['sas']
  },
  {
    extensions: ['.sass'],
    names: ['sass']
  },
  {
    extensions: ['.scad'],
    names: ['openscad']
  },
  {
    extensions: ['.scala', '.kojo', '.sbt', '.sc'],
    names: ['scala']
  },
  {
    extensions: ['.scaml'],
    names: ['scaml']
  },
  {
    extensions: ['.scenic'],
    names: ['scenic']
  },
  {
    extensions: ['.scm', '.sld', '.sps', '.ss'],
    names: ['scheme']
  },
  {
    extensions: ['.sci', '.sce'],
    names: ['scilab']
  },
  {
    names: ['tree-sitter-query', 'tsq']
  },
  {
    extensions: ['.sed'],
    names: ['sed']
  },
  {
    extensions: ['.te'],
    names: ['selinux-policy', 'selinux-kernel-policy-language', 'sepolicy']
  },
  {
    extensions: ['.sfv'],
    names: ['simple-file-verification', 'sfv']
  },
  {
    names: ['shaderlab']
  },
  {
    extensions: [
      '.bash',
      '.bats',
      '.command',
      '.csh',
      '.ebuild',
      '.eclass',
      '.ksh',
      '.sh',
      '.sh.in',
      '.tcsh',
      '.tmux',
      '.tool',
      '.zsh',
      '.zsh-theme'
    ],
    names: [
      'abuild',
      'alpine-abuild',
      'apkbuild',
      'bash',
      'envrc',
      'gentoo-ebuild',
      'gentoo-eclass',
      'openrc',
      'openrc-runscript',
      'sh',
      'shell',
      'shell-script',
      'tcsh',
      'zsh'
    ]
  },
  {
    names: ['shellcheck-config', 'shellcheckrc']
  },
  {
    extensions: ['.shen'],
    names: ['shen']
  },
  {
    extensions: ['.sieve'],
    names: ['sieve']
  },
  {
    names: ['singularity']
  },
  {
    extensions: ['.slang'],
    names: ['slang']
  },
  {
    names: ['slice']
  },
  {
    extensions: ['.slint'],
    names: ['slint']
  },
  {
    extensions: ['.smali'],
    names: ['smali']
  },
  {
    extensions: ['.st', '.ston'],
    names: ['smalltalk', 'squeak', 'ston']
  },
  {
    extensions: ['.smithy'],
    names: ['smithy']
  },
  {
    extensions: ['.cocci'],
    names: ['smpl', 'coccinelle']
  },
  {
    extensions: ['.smt2', '.smt'],
    names: ['smt']
  },
  {
    names: ['solidity']
  },
  {
    extensions: ['.sln'],
    names: ['microsoft-visual-studio-solution']
  },
  {
    extensions: ['.sp'],
    names: ['sourcepawn', 'sourcemod']
  },
  {
    extensions: ['.sparql', '.rq'],
    names: ['sparql']
  },
  {
    extensions: ['.spin'],
    names: ['propeller-spin']
  },
  {
    extensions: ['.sqf', '.hqf'],
    names: ['sqf']
  },
  {
    extensions: [
      '.cql',
      '.db2',
      '.ddl',
      '.mysql',
      '.pgsql',
      '.prc',
      '.sql',
      '.sql',
      '.sql',
      '.tab',
      '.udf',
      '.viw'
    ],
    names: ['plpgsql', 'sql', 'sqlpl']
  },
  {
    names: [
      'ssh-config',
      'sshconfig',
      'sshdconfig',
      'ssh_config',
      'sshd_config'
    ]
  },
  {
    extensions: ['.stan'],
    names: ['stan']
  },
  {
    extensions: ['.star'],
    names: ['star']
  },
  {
    extensions: ['.do', '.ado', '.doh', '.ihlp', '.mata', '.matah', '.sthlp'],
    names: ['stata']
  },
  {
    extensions: ['.stl'],
    names: ['stl', 'ascii-stl', 'stla']
  },
  {
    names: ['stringtemplate']
  },
  {
    extensions: ['.styl'],
    names: ['stylus']
  },
  {
    names: ['supercollider']
  },
  {
    extensions: ['.svelte'],
    names: ['svelte']
  },
  {
    extensions: ['.sw'],
    names: ['sway']
  },
  {
    extensions: ['.swift'],
    names: ['swift']
  },
  {
    extensions: ['.sv', '.svh', '.vh'],
    names: ['systemverilog']
  },
  {
    names: ['tact']
  },
  {
    extensions: ['.talon'],
    names: ['talon']
  },
  {
    extensions: ['.adp', '.glf', '.sdc', '.tcl', '.tcl.in', '.tm', '.xdc'],
    names: ['glyph', 'sdc', 'tcl', 'xdc']
  },
  {
    extensions: ['.tea'],
    names: ['tea']
  },
  {
    extensions: ['.templ'],
    names: ['templ']
  },
  {
    names: ['terra']
  },
  {
    extensions: ['.hcl', '.nomad', '.tf', '.tfvars', '.workflow'],
    names: ['hcl', 'hashicorp-configuration-language', 'terraform']
  },
  {
    extensions: ['.textgrid'],
    names: ['textgrid']
  },
  {
    extensions: ['.textproto', '.pbtxt'],
    names: ['protocol-buffer-text-format', 'text-proto', 'protobuf-text-format']
  },
  {
    extensions: ['.thrift'],
    names: ['thrift']
  },
  {
    extensions: ['.tl'],
    names: ['type-language', 'tl']
  },
  {
    extensions: ['.tla'],
    names: ['tla']
  },
  {
    extensions: ['.tlv'],
    names: ['tl-verilog']
  },
  {
    names: ['textmate-properties', 'tm-properties']
  },
  {
    names: ['world-of-warcraft-addon-data']
  },
  {
    extensions: ['.toit'],
    names: ['toit']
  },
  {
    extensions: ['.toml'],
    names: ['toml']
  },
  {
    extensions: ['.ts', '.cts', '.mts'],
    names: ['typescript', 'ts']
  },
  {
    extensions: ['.tsp'],
    names: ['typespec', 'tsp']
  },
  {
    names: ['tsql']
  },
  {
    extensions: ['.tsx'],
    names: ['tsx']
  },
  {
    extensions: ['.tu'],
    names: ['turing']
  },
  {
    extensions: ['.ttl'],
    names: ['turtle']
  },
  {
    extensions: ['.txl'],
    names: ['txl']
  },
  {
    extensions: ['.typ'],
    names: ['typst', 'typ']
  },
  {
    extensions: ['.ur', '.urs'],
    names: ['urweb', 'ur/web', 'ur']
  },
  {
    extensions: ['.carbon'],
    names: ['carbon', 'v', 'vlang']
  },
  {
    extensions: ['.vala', '.vapi'],
    names: ['vala']
  },
  {
    extensions: ['.vcl'],
    names: ['vcl']
  },
  {
    extensions: [
      '.bas',
      '.bas',
      '.bas',
      '.ctl',
      '.dsr',
      '.frm',
      '.frm',
      '.vba'
    ],
    names: [
      'b4x',
      'basic-for-android',
      'classic-visual-basic',
      'vb-6',
      'vb6',
      'vba',
      'visual-basic-6',
      'visual-basic-6.0',
      'visual-basic-classic',
      'visual-basic-for-applications'
    ]
  },
  {
    extensions: [
      '.bi',
      '.rbbas',
      '.rbfrm',
      '.rbmnu',
      '.rbres',
      '.rbtbar',
      '.rbuistate',
      '.vb',
      '.vbhtml',
      '.vbs'
    ],
    names: [
      'fb',
      'freebasic',
      'realbasic',
      'vb-.net',
      'vb.net',
      'vbnet',
      'vbscript',
      'visual-basic',
      'visual-basic-.net'
    ]
  },
  {
    names: ['vcard', 'virtual-contact-file', 'electronic-business-card']
  },
  {
    extensions: ['.vtl'],
    names: ['velocity-template-language', 'vtl', 'velocity']
  },
  {
    extensions: ['.veo'],
    names: ['verilog']
  },
  {
    extensions: [
      '.vhdl',
      '.vhd',
      '.vhf',
      '.vhi',
      '.vho',
      '.vhs',
      '.vht',
      '.vhw'
    ],
    names: ['vhdl']
  },
  {
    extensionsWithDot: ['.snippet'],
    extensions: ['.snip', '.snippets'],
    names: ['vim-snippet', 'snipmate', 'ultisnip', 'ultisnips', 'neosnippet']
  },
  {
    extensions: ['.vim', '.vimrc', '.vmb'],
    names: ['vim-script', 'vim', 'viml', 'nvim', 'vimscript']
  },
  {
    extensions: ['.vue'],
    names: ['vue']
  },
  {
    extensions: ['.vy'],
    names: ['vyper']
  },
  {
    extensions: ['.mtl'],
    names: ['wavefront-material']
  },
  {
    extensions: ['.obj'],
    names: ['wavefront-object']
  },
  {
    extensions: ['.wdl'],
    names: ['wdl', 'workflow-description-language']
  },
  {
    extensions: ['.wast', '.wat'],
    names: ['webassembly', 'wast', 'wasm']
  },
  {
    extensions: ['.webidl'],
    names: ['webidl']
  },
  {
    names: ['wget-config', 'wgetrc']
  },
  {
    extensions: ['.wgsl'],
    names: ['wgsl']
  },
  {
    extensions: ['.whiley'],
    names: ['whiley']
  },
  {
    names: ['win32-message-file']
  },
  {
    extensions: ['.wit'],
    names: ['webassembly-interface-type', 'wit']
  },
  {
    extensions: ['.ws'],
    names: ['witcher-script']
  },
  {
    extensions: ['.wlk'],
    names: ['wollok']
  },
  {
    extensions: ['.wren'],
    names: ['wren', 'wrenlang']
  },
  {
    extensions: ['.puml', '.iuml', '.plantuml'],
    names: ['plantuml']
  },
  {
    extensions: ['.x10'],
    names: ['x10', 'xten']
  },
  {
    names: ['unix-assembly', 'gas', 'gnu-asm', 'unix-asm']
  },
  {
    extensions: ['.xc'],
    names: ['xc']
  },
  {
    names: ['xmake']
  },
  {
    extensions: [
      '.xojo_code',
      '.xojo_menu',
      '.xojo_report',
      '.xojo_script',
      '.xojo_toolbar',
      '.xojo_window'
    ],
    names: ['xojo']
  },
  {
    extensions: ['.xquery', '.xq', '.xql', '.xqm', '.xqy'],
    names: ['xquery']
  },
  {
    extensions: ['.xtend'],
    names: ['xtend']
  },
  {
    extensions: ['.bison', '.y', '.yacc'],
    names: ['bison', 'yacc']
  },
  {
    extensions: [
      '.anim',
      '.asset',
      '.ksy',
      '.lkml',
      '.lookml',
      '.mat',
      '.meta',
      '.mir',
      '.prefab',
      '.raml',
      '.reek',
      '.rviz',
      '.sublime-syntax',
      '.syntax',
      '.unity',
      '.yaml-tmlanguage',
      '.yaml.sed',
      '.yml.mysql'
    ],
    names: [
      'jar-manifest',
      'kaitai-struct',
      'ksy',
      'lookml',
      'oasv2-yaml',
      'oasv3-yaml',
      'raml',
      'unity3d-asset',
      'yaml',
      'yml'
    ]
  },
  {
    extensions: ['.sls'],
    names: ['saltstack', 'saltstate', 'salt']
  },
  {
    extensions: ['.yang'],
    names: ['yang']
  },
  {
    extensions: ['.yar', '.yara'],
    names: ['yara']
  },
  {
    extensions: ['.yasnippet'],
    names: ['yasnippet', 'snippet', 'yas']
  },
  {
    extensions: ['.yul'],
    names: ['yul']
  },
  {
    extensions: ['.zap', '.xzap'],
    names: ['zap']
  },
  {
    extensions: ['.zeek', '.bro'],
    names: ['zeek', 'bro']
  },
  {
    extensions: ['.zs'],
    names: ['zenscript']
  },
  {
    extensions: ['.zig', '.zig.zon'],
    names: ['zig']
  },
  {
    extensions: ['.zil', '.mud'],
    names: ['zil']
  },
  {
    extensions: ['.txt'],
    names: [
      'adblock-filter-list',
      'ad-block-filters',
      'ad-block',
      'adb',
      'adblock'
    ]
  },
  {
    extensions: ['.bib', '.bibtex'],
    names: ['bibtex']
  },
  {
    names: ['browserslist']
  },
  {
    extensions: [
      '.crc32',
      '.md2',
      '.md4',
      '.md5',
      '.sha1',
      '.sha2',
      '.sha224',
      '.sha256',
      '.sha256sum',
      '.sha3',
      '.sha384',
      '.sha512'
    ],
    names: ['checksums', 'checksum', 'hash', 'hashes', 'sum', 'sums']
  },
  {
    names: ['codeowners']
  },
  {
    extensions: ['.conllu', '.conll'],
    names: ['conll-u', 'conll', 'conll-x']
  },
  {
    names: ['crontab', 'cron', 'cron-table']
  },
  {
    extensions: ['.dfy'],
    names: ['dafny']
  },
  {
    extensions: ['.eml', '.mbox'],
    names: ['e-mail', 'email', 'eml', 'mail', 'mbox']
  },
  {
    extensions: ['.feature', '.story'],
    names: ['gherkin', 'cucumber']
  },
  {
    extensions: ['.haml', '.haml.deface'],
    names: ['haml']
  },
  {
    extensions: ['.asciidoc', '.adoc'],
    names: ['asciidoc']
  },
  {
    extensions: ['.asax', '.ascx', '.ashx', '.asmx', '.asp', '.aspx', '.axd'],
    names: ['asp', 'asp.net', 'aspx', 'aspx-vb', 'classic-asp']
  },
  {
    extensions: ['.hta', '.htm', '.html.hl', '.kit', '.mtml', '.xht', '.xhtml'],
    names: ['html', 'kit', 'mtml', 'xhtml']
  },
  {
    extensions: ['.cfm', '.cfml'],
    names: ['coldfusion', 'cfm', 'cfml', 'coldfusion-html']
  },
  {
    extensions: ['.creole'],
    names: ['creole']
  },
  {
    extensions: ['.cshtml', '.razor'],
    names: ['html+razor', 'razor']
  },
  {
    extensions: ['.jinja', '.j2', '.jinja2'],
    names: ['jinja', 'django', 'html+django', 'html+jinja', 'htmldjango']
  },
  {
    extensionsWithDot: ['.html'],
    names: ['ecmarkup', 'ecmarkdown']
  },
  {
    extensions: ['.ecr'],
    names: ['html+ecr', 'ecr']
  },
  {
    extensions: ['.edge'],
    names: ['edge']
  },
  {
    extensions: ['.html.eex', '.heex', '.leex'],
    names: ['html+eex', 'eex', 'heex', 'leex']
  },
  {
    extensions: ['.erb', '.erb.deface', '.rhtml'],
    names: ['html+erb', 'erb', 'rhtml', 'html+ruby']
  },
  {
    names: ['freemarker', 'ftl']
  },
  {
    extensions: ['.handlebars', '.hbs'],
    names: ['handlebars', 'hbs', 'htmlbars']
  },
  {
    extensions: ['.ejs', '.ect', '.ejs.t', '.jst'],
    names: ['ejs']
  },
  {
    extensions: ['.gsp', '.jsp', '.tag'],
    names: [
      'groovy-server-pages',
      'gsp',
      'java-server-page',
      'java-server-pages',
      'jsp'
    ]
  },
  {
    extensions: ['.jte'],
    names: ['java-template-engine', 'jte']
  },
  {
    extensions: ['.liquid'],
    names: ['liquid']
  },
  {
    extensions: ['.mako', '.mao'],
    names: ['mako']
  },
  {
    extensions: ['.apib'],
    names: ['api-blueprint']
  },
  {
    extensions: ['.mediawiki', '.wiki', '.wikitext'],
    names: ['wikitext', 'mediawiki', 'wiki']
  },
  {
    extensions: ['.njk'],
    names: ['nunjucks', 'njk']
  },
  {
    extensions: ['.blade', '.blade.php'],
    names: ['blade']
  },
  {
    extensions: [
      '.aw',
      '.ctp',
      '.php3',
      '.php4',
      '.php5',
      '.phps',
      '.phpt',
      '.phtml'
    ],
    names: ['html+php', 'inc', 'php']
  },
  {
    extensions: ['.riot'],
    names: ['riot']
  },
  {
    extensions: ['.sl'],
    names: ['slash']
  },
  {
    extensions: ['.latte', '.mustache', '.tpl'],
    names: ['latte', 'mustache', 'smarty']
  },
  {
    extensions: ['.soy'],
    names: ['closure-templates', 'soy']
  },
  {
    extensions: ['.antlers.html', '.antlers.php', '.antlers.xml'],
    names: ['antlers']
  },
  {
    extensions: ['.twig'],
    names: ['twig']
  },
  {
    extensions: ['.vue'],
    names: ['vue']
  },
  {
    extensions: ['.jade', '.pug'],
    names: ['pug']
  },
  {
    extensions: ['.marko'],
    names: ['marko', 'markojs']
  },
  {
    extensions: [
      '.livemd',
      '.markdown',
      '.mdown',
      '.mdwn',
      '.mkd',
      '.mkdn',
      '.mkdown',
      '.qmd',
      '.rmd',
      '.ronn',
      '.scd',
      '.workbook'
    ],
    names: ['markdown', 'md', 'pandoc', 'rmarkdown']
  },
  {
    extensions: ['.muse'],
    names: ['muse', 'amusewiki', 'emacs-muse']
  },
  {
    names: ['python-console', 'pycon']
  },
  {
    extensions: ['.pytb'],
    names: ['python-traceback']
  },
  {
    extensions: ['.rdoc'],
    names: ['rdoc']
  },
  {
    extensions: ['.rst', '.rest', '.rest.txt', '.rst.txt'],
    names: ['restructuredtext', 'rst']
  },
  {
    extensions: ['.robot', '.resource'],
    names: ['robotframework']
  },
  {
    names: ['robots.txt', 'robots', 'robots-txt']
  },
  {
    extensions: [
      '.1',
      '.1',
      '.1in',
      '.1in',
      '.1m',
      '.1m',
      '.1x',
      '.1x',
      '.2',
      '.2',
      '.3',
      '.3',
      '.3in',
      '.3in',
      '.3m',
      '.3m',
      '.3p',
      '.3p',
      '.3pm',
      '.3pm',
      '.3qt',
      '.3qt',
      '.3x',
      '.3x',
      '.4',
      '.4',
      '.5',
      '.5',
      '.6',
      '.6',
      '.7',
      '.7',
      '.8',
      '.8',
      '.9',
      '.9',
      '.man',
      '.man',
      '.mdoc',
      '.mdoc',
      '.me',
      '.roff',
      '.tmac'
    ],
    names: [
      'groff',
      'man',
      'man-page',
      'man-page',
      'manpage',
      'mdoc',
      'nroff',
      'roff',
      'roff-manpage',
      'troff'
    ]
  },
  {
    extensions: ['.rtf'],
    names: ['rich-text-format']
  },
  {
    extensions: ['.rnh', '.rno'],
    names: ['runoff']
  },
  {
    extensions: ['.sfd'],
    names: ['spline-font-database']
  },
  {
    extensions: ['.sh-session'],
    names: ['shellsession', 'bash-session', 'console']
  },
  {
    extensions: ['.slim'],
    names: ['slim']
  },
  {
    names: ['subrip-text']
  },
  {
    extensions: ['.lhs'],
    names: ['literate-haskell', 'lhaskell', 'lhs']
  },
  {
    extensions: [
      '.tex',
      '.aux',
      '.bbx',
      '.cbx',
      '.dtx',
      '.ins',
      '.lbx',
      '.ltx',
      '.mkii',
      '.mkiv',
      '.mkvi',
      '.sty',
      '.toc'
    ],
    names: ['tex', 'latex']
  },
  {
    extensions: ['.rnw'],
    names: ['sweave']
  },
  {
    extensions: ['.texinfo', '.texi', '.txi'],
    names: ['texinfo']
  },
  {
    names: ['vim-help-file', 'help', 'vimhelp']
  },
  {
    extensions: ['.vtt'],
    names: ['webvtt', 'vtt']
  },
  {
    names: ['ant-build-system']
  },
  {
    extensions: ['.kid'],
    names: ['genshi', 'xml+genshi', 'xml+kid']
  },
  {
    extensions: [
      '.adml',
      '.admx',
      '.ant',
      '.axaml',
      '.axml',
      '.brd',
      '.builds',
      '.ccproj',
      '.ccxml',
      '.clixml',
      '.cproject',
      '.cscfg',
      '.csdef',
      '.csproj',
      '.ct',
      '.dae',
      '.depproj',
      '.dita',
      '.ditamap',
      '.ditaval',
      '.dll.config',
      '.dotsettings',
      '.filters',
      '.fsproj',
      '.fxml',
      '.glade',
      '.gmx',
      '.gpx',
      '.grxml',
      '.hzp',
      '.iml',
      '.ivy',
      '.jelly',
      '.jsproj',
      '.kml',
      '.launch',
      '.lvclass',
      '.lvlib',
      '.lvproj',
      '.mdpolicy',
      '.mjml',
      '.mxml',
      '.natvis',
      '.ndproj',
      '.nproj',
      '.nuspec',
      '.odd',
      '.osm',
      '.owl',
      '.pkgproj',
      '.proj',
      '.props',
      '.ps1xml',
      '.psc1',
      '.pt',
      '.qhelp',
      '.rdf',
      '.resx',
      '.rss',
      '.sch',
      '.sch',
      '.scxml',
      '.sfproj',
      '.shproj',
      '.srdf',
      '.storyboard',
      '.sublime-snippet',
      '.targets',
      '.tml',
      '.ui',
      '.urdf',
      '.ux',
      '.vbproj',
      '.vcxproj',
      '.vsixmanifest',
      '.vssettings',
      '.vstemplate',
      '.vxml',
      '.wixproj',
      '.wsdl',
      '.wsf',
      '.wxi',
      '.wxl',
      '.wxs',
      '.x3d',
      '.xacro',
      '.xaml',
      '.xib',
      '.xlf',
      '.xliff',
      '.xmi',
      '.xml',
      '.xml.dist',
      '.xmp',
      '.xpl',
      '.xproc',
      '.xproj',
      '.xsd',
      '.xsp-config',
      '.xsp.metadata',
      '.xspec',
      '.xul',
      '.zcml'
    ],
    names: [
      'collada',
      'eagle',
      'labview',
      'rss',
      'web-ontology-language',
      'wsdl',
      'xml',
      'xpages',
      'xproc',
      'xsd'
    ]
  },
  {
    extensions: [
      '.sttheme',
      '.tmcommand',
      '.tmlanguage',
      '.tmpreferences',
      '.tmsnippet',
      '.tmtheme'
    ],
    names: ['xml-property-list']
  },
  {
    names: ['maven-pom']
  },
  {
    extensions: ['.svg'],
    names: ['svg']
  },
  {
    extensions: ['.xslt', '.xsl'],
    names: ['xslt', 'xsl']
  },
  {
    extensions: ['.zone', '.arpa'],
    names: ['dns-zone']
  }
]
