/**
 * Check according to GitHub Linguist.
 *
 * @param {string} value
 *   Language flag to check.
 * @returns {string | undefined}
 *   Whether the flag is valid (`undefined`),
 *   or a message to warn about (`string`).
 * @satisfies {CheckFlag}
 */
export function checkGithubLinguistFlag(value: string): string | undefined;
export default remarkLintFencedCodeFlag;
/**
 * Custom check.
 */
export type CheckFlag = (value: string) => string | undefined;
/**
 * Configuration.
 */
export type Options = {
    /**
     * Allow language flags to be omitted (default: `false`).
     */
    allowEmpty?: boolean | null | undefined;
    /**
     * Flags to allow,
     * other flags will result in a warning (optional).
     */
    flags?: ReadonlyArray<string> | null | undefined;
};
declare const remarkLintFencedCodeFlag: import("unified-lint-rule").Plugin<Root, readonly string[] | CheckFlag | Readonly<Options> | null | undefined>;
import type { Root } from 'mdast';
//# sourceMappingURL=index.d.ts.map