<!--This file is generated-->

# remark-lint-no-heading-punctuation

[![Build][badge-build-image]][badge-build-url]
[![Coverage][badge-coverage-image]][badge-coverage-url]
[![Downloads][badge-downloads-image]][badge-downloads-url]
[![Size][badge-size-image]][badge-size-url]
[![Sponsors][badge-funding-sponsors-image]][badge-funding-url]
[![Backers][badge-funding-backers-image]][badge-funding-url]
[![Chat][badge-chat-image]][badge-chat-url]

[`remark-lint`][github-remark-lint] rule to warn when headings end in irregular characters.

## Contents

* [What is this?](#what-is-this)
* [When should I use this?](#when-should-i-use-this)
* [Presets](#presets)
* [Install](#install)
* [Use](#use)
* [API](#api)
  * [`unified().use(remarkLintNoHeadingPunctuation[, options])`](#unifieduseremarklintnoheadingpunctuation-options)
* [Examples](#examples)
* [Compatibility](#compatibility)
* [Contribute](#contribute)
* [License](#license)

## What is this?

This package checks heading text.

## When should I use this?

You can use this package to check that heading text is consistent.

## Presets

This plugin is included in the following presets:

| Preset | Options |
| - | - |
| [`remark-preset-lint-markdown-style-guide`](https://github.com/remarkjs/remark-lint/tree/main/packages/remark-preset-lint-markdown-style-guide) | `':.'` |

## Install

This package is [ESM only][github-gist-esm].
In Node.js (version 16+),
install with [npm][npm-install]:

```sh
npm install remark-lint-no-heading-punctuation
```

In Deno with [`esm.sh`][esm-sh]:

```js
import remarkLintNoHeadingPunctuation from 'https://esm.sh/remark-lint-no-heading-punctuation@4'
```

In browsers with [`esm.sh`][esm-sh]:

```html
<script type="module">
  import remarkLintNoHeadingPunctuation from 'https://esm.sh/remark-lint-no-heading-punctuation@4?bundle'
</script>
```

## Use

On the API:

```js
import remarkLint from 'remark-lint'
import remarkLintNoHeadingPunctuation from 'remark-lint-no-heading-punctuation'
import remarkParse from 'remark-parse'
import remarkStringify from 'remark-stringify'
import {read} from 'to-vfile'
import {unified} from 'unified'
import {reporter} from 'vfile-reporter'

const file = await read('example.md')

await unified()
  .use(remarkParse)
  .use(remarkLint)
  .use(remarkLintNoHeadingPunctuation)
  .use(remarkStringify)
  .process(file)

console.error(reporter(file))
```

On the CLI:

```sh
remark --frail --use remark-lint --use remark-lint-no-heading-punctuation .
```

On the CLI in a config file (here a `package.json`):

```diff
 …
 "remarkConfig": {
   "plugins": [
     …
     "remark-lint",
+    "remark-lint-no-heading-punctuation",
     …
   ]
 }
 …
```

## API

This package exports no identifiers.
It exports no additional [TypeScript][typescript] types.
The default export is
[`remarkLintNoHeadingPunctuation`][api-remark-lint-no-heading-punctuation].

### `unified().use(remarkLintNoHeadingPunctuation[, options])`

Warn when headings end in irregular characters.

###### Parameters

* `options` (`RegExp` or `string`, default: `/[!,.:;?]/u`)
  — configuration,
  when string wrapped in `new RegExp('[' + x + ']', 'u')` so make sure to
  escape regexp characters

###### Returns

Transform ([`Transformer` from `unified`][github-unified-transformer]).

## Examples

##### `ok.md`

###### In

```markdown
# Mercury
```

###### Out

No messages.

##### `not-ok.md`

###### In

```markdown
# Mercury:

# Venus?

# Earth!

# Mars,

# Jupiter;
```

###### Out

```text
1:1-1:11: Unexpected character `:` at end of heading, remove it
3:1-3:9: Unexpected character `?` at end of heading, remove it
5:1-5:9: Unexpected character `!` at end of heading, remove it
7:1-7:8: Unexpected character `,` at end of heading, remove it
9:1-9:11: Unexpected character `;` at end of heading, remove it
```

##### `ok.md`

When configured with `',;:!?'`.

###### In

```markdown
# Mercury…
```

###### Out

No messages.

##### `regex.md`

When configured with `{ source: '[^A-Za-z0-9]' }`.

###### In

```markdown
# Mercury!
```

###### Out

```text
1:1-1:11: Unexpected character `!` at end of heading, remove it
```

##### `example.mdx`

###### In

> 👉 **Note**: this example uses
> MDX ([`remark-mdx`][github-remark-mdx]).

```mdx
<h1>Mercury?</h1>
```

###### Out

```text
1:1-1:18: Unexpected character `?` at end of heading, remove it
```

##### `not-ok-options.md`

When configured with `1`.

###### Out

```text
1:1: Unexpected value `1` for `options`, expected `RegExp` or `string`
```

## Compatibility

Projects maintained by the unified collective are compatible with maintained
versions of Node.js.

When we cut a new major release, we drop support for unmaintained versions of
Node.
This means we try to keep the current release line,
`remark-lint-no-heading-punctuation@4`,
compatible with Node.js 16.

## Contribute

See [`contributing.md`][github-dotfiles-contributing] in [`remarkjs/.github`][github-dotfiles-health] for ways
to get started.
See [`support.md`][github-dotfiles-support] for ways to get help.

This project has a [code of conduct][github-dotfiles-coc].
By interacting with this repository, organization, or community you agree to
abide by its terms.

## License

[MIT][file-license] © [Titus Wormer][author]

[api-remark-lint-no-heading-punctuation]: #unifieduseremarklintnoheadingpunctuation-options

[author]: https://wooorm.com

[badge-build-image]: https://github.com/remarkjs/remark-lint/workflows/main/badge.svg

[badge-build-url]: https://github.com/remarkjs/remark-lint/actions

[badge-chat-image]: https://img.shields.io/badge/chat-discussions-success.svg

[badge-chat-url]: https://github.com/remarkjs/remark/discussions

[badge-coverage-image]: https://img.shields.io/codecov/c/github/remarkjs/remark-lint.svg

[badge-coverage-url]: https://codecov.io/github/remarkjs/remark-lint

[badge-downloads-image]: https://img.shields.io/npm/dm/remark-lint-no-heading-punctuation.svg

[badge-downloads-url]: https://www.npmjs.com/package/remark-lint-no-heading-punctuation

[badge-funding-backers-image]: https://opencollective.com/unified/backers/badge.svg

[badge-funding-sponsors-image]: https://opencollective.com/unified/sponsors/badge.svg

[badge-funding-url]: https://opencollective.com/unified

[badge-size-image]: https://img.shields.io/bundlejs/size/remark-lint-no-heading-punctuation

[badge-size-url]: https://bundlejs.com/?q=remark-lint-no-heading-punctuation

[esm-sh]: https://esm.sh

[file-license]: https://github.com/remarkjs/remark-lint/blob/main/license

[github-dotfiles-coc]: https://github.com/remarkjs/.github/blob/main/code-of-conduct.md

[github-dotfiles-contributing]: https://github.com/remarkjs/.github/blob/main/contributing.md

[github-dotfiles-health]: https://github.com/remarkjs/.github

[github-dotfiles-support]: https://github.com/remarkjs/.github/blob/main/support.md

[github-gist-esm]: https://gist.github.com/sindresorhus/a39789f98801d908bbc7ff3ecc99d99c

[github-remark-lint]: https://github.com/remarkjs/remark-lint

[github-remark-mdx]: https://mdxjs.com/packages/remark-mdx/

[github-unified-transformer]: https://github.com/unifiedjs/unified#transformer

[npm-install]: https://docs.npmjs.com/cli/install

[typescript]: https://www.typescriptlang.org
