<!--This file is generated-->

# remark-lint-maximum-heading-length

[![Build][badge-build-image]][badge-build-url]
[![Coverage][badge-coverage-image]][badge-coverage-url]
[![Downloads][badge-downloads-image]][badge-downloads-url]
[![Size][badge-size-image]][badge-size-url]
[![Sponsors][badge-funding-sponsors-image]][badge-funding-url]
[![Backers][badge-funding-backers-image]][badge-funding-url]
[![Chat][badge-chat-image]][badge-chat-url]

[`remark-lint`][github-remark-lint] rule to warn when headings are too long.

## Contents

* [What is this?](#what-is-this)
* [When should I use this?](#when-should-i-use-this)
* [Presets](#presets)
* [Install](#install)
* [Use](#use)
* [API](#api)
  * [`unified().use(remarkLintMaximumHeadingLength[, options])`](#unifieduseremarklintmaximumheadinglength-options)
  * [`Options`](#options)
* [Recommendation](#recommendation)
* [Examples](#examples)
* [Compatibility](#compatibility)
* [Contribute](#contribute)
* [License](#license)

## What is this?

This package checks the length of heading text.

## When should I use this?

You can use this package to check that heading text is within reason.

## Presets

This plugin is included in the following presets:

| Preset | Options |
| - | - |
| [`remark-preset-lint-markdown-style-guide`](https://github.com/remarkjs/remark-lint/tree/main/packages/remark-preset-lint-markdown-style-guide) | |

## Install

This package is [ESM only][github-gist-esm].
In Node.js (version 16+),
install with [npm][npm-install]:

```sh
npm install remark-lint-maximum-heading-length
```

In Deno with [`esm.sh`][esm-sh]:

```js
import remarkLintMaximumHeadingLength from 'https://esm.sh/remark-lint-maximum-heading-length@4'
```

In browsers with [`esm.sh`][esm-sh]:

```html
<script type="module">
  import remarkLintMaximumHeadingLength from 'https://esm.sh/remark-lint-maximum-heading-length@4?bundle'
</script>
```

## Use

On the API:

```js
import remarkLint from 'remark-lint'
import remarkLintMaximumHeadingLength from 'remark-lint-maximum-heading-length'
import remarkParse from 'remark-parse'
import remarkStringify from 'remark-stringify'
import {read} from 'to-vfile'
import {unified} from 'unified'
import {reporter} from 'vfile-reporter'

const file = await read('example.md')

await unified()
  .use(remarkParse)
  .use(remarkLint)
  .use(remarkLintMaximumHeadingLength)
  .use(remarkStringify)
  .process(file)

console.error(reporter(file))
```

On the CLI:

```sh
remark --frail --use remark-lint --use remark-lint-maximum-heading-length .
```

On the CLI in a config file (here a `package.json`):

```diff
 …
 "remarkConfig": {
   "plugins": [
     …
     "remark-lint",
+    "remark-lint-maximum-heading-length",
     …
   ]
 }
 …
```

## API

This package exports no identifiers.
It exports the [TypeScript][typescript] type
[`Options`][api-options].
The default export is
[`remarkLintMaximumHeadingLength`][api-remark-lint-maximum-heading-length].

### `unified().use(remarkLintMaximumHeadingLength[, options])`

Warn when headings are too long.

###### Parameters

* `options` ([`Options`][api-options] or `number`, optional)
  — configuration

###### Returns

Transform ([`Transformer` from `unified`][github-unified-transformer]).

### `Options`

Configuration (TypeScript type).

###### Properties

* `size` (`number`, default: `60`)
  — preferred max size
* `stringLength` (`(value: string) => number`, optional)
  — function to detect text size

## Recommendation

While this rule is sometimes annoying,
reasonable size headings do help SEO purposes (bots prefer reasonable
headings),
visual users (headings are typically displayed quite large),
and users of screen readers (who use “jump to heading” features that read
every heading out loud to navigate within a page).

To better represent how long headings “look”,
you can pass a `stringLength` function.

## Examples

##### `ok.md`

###### In

```markdown
# Mercury is the first planet from the Sun
```

###### Out

No messages.

##### `not-ok.md`

When configured with `30`.

###### In

```markdown
# Mercury is the first planet from the Sun
```

###### Out

```text
1:1-1:43: Unexpected `40` characters in heading, expected at most `30` characters
```

##### `string-length-default.md`

When configured with `30`.

###### In

```markdown
# 水星是太陽系的八大行星中最小和最靠近太陽的行星
```

###### Out

No messages.

##### `string-length-custom.md`

When configured with `{ size: 30, stringLength: [Function: stringWidth] }`.

###### In

```markdown
# 水星是太陽系的八大行星中最小和最靠近太陽的行星
```

###### Out

```text
1:1-1:26: Unexpected `46` characters in heading, expected at most `30` characters
```

##### `mdx.mdx`

When configured with `30`.

###### In

> 👉 **Note**: this example uses
> MDX ([`remark-mdx`][github-remark-mdx]).

```mdx
<h1>Mercury is the first planet from the Sun</h1>
```

###### Out

```text
1:1-1:50: Unexpected `40` characters in heading, expected at most `30` characters
```

##### `not-ok.md`

When configured with `'🌍'`.

###### Out

```text
1:1: Unexpected value `🌍` for `size`, expected `number`
```

## Compatibility

Projects maintained by the unified collective are compatible with maintained
versions of Node.js.

When we cut a new major release, we drop support for unmaintained versions of
Node.
This means we try to keep the current release line,
`remark-lint-maximum-heading-length@4`,
compatible with Node.js 16.

## Contribute

See [`contributing.md`][github-dotfiles-contributing] in [`remarkjs/.github`][github-dotfiles-health] for ways
to get started.
See [`support.md`][github-dotfiles-support] for ways to get help.

This project has a [code of conduct][github-dotfiles-coc].
By interacting with this repository, organization, or community you agree to
abide by its terms.

## License

[MIT][file-license] © [Titus Wormer][author]

[api-options]: #options

[api-remark-lint-maximum-heading-length]: #unifieduseremarklintmaximumheadinglength-options

[author]: https://wooorm.com

[badge-build-image]: https://github.com/remarkjs/remark-lint/workflows/main/badge.svg

[badge-build-url]: https://github.com/remarkjs/remark-lint/actions

[badge-chat-image]: https://img.shields.io/badge/chat-discussions-success.svg

[badge-chat-url]: https://github.com/remarkjs/remark/discussions

[badge-coverage-image]: https://img.shields.io/codecov/c/github/remarkjs/remark-lint.svg

[badge-coverage-url]: https://codecov.io/github/remarkjs/remark-lint

[badge-downloads-image]: https://img.shields.io/npm/dm/remark-lint-maximum-heading-length.svg

[badge-downloads-url]: https://www.npmjs.com/package/remark-lint-maximum-heading-length

[badge-funding-backers-image]: https://opencollective.com/unified/backers/badge.svg

[badge-funding-sponsors-image]: https://opencollective.com/unified/sponsors/badge.svg

[badge-funding-url]: https://opencollective.com/unified

[badge-size-image]: https://img.shields.io/bundlejs/size/remark-lint-maximum-heading-length

[badge-size-url]: https://bundlejs.com/?q=remark-lint-maximum-heading-length

[esm-sh]: https://esm.sh

[file-license]: https://github.com/remarkjs/remark-lint/blob/main/license

[github-dotfiles-coc]: https://github.com/remarkjs/.github/blob/main/code-of-conduct.md

[github-dotfiles-contributing]: https://github.com/remarkjs/.github/blob/main/contributing.md

[github-dotfiles-health]: https://github.com/remarkjs/.github

[github-dotfiles-support]: https://github.com/remarkjs/.github/blob/main/support.md

[github-gist-esm]: https://gist.github.com/sindresorhus/a39789f98801d908bbc7ff3ecc99d99c

[github-remark-lint]: https://github.com/remarkjs/remark-lint

[github-remark-mdx]: https://mdxjs.com/packages/remark-mdx/

[github-unified-transformer]: https://github.com/unifiedjs/unified#transformer

[npm-install]: https://docs.npmjs.com/cli/install

[typescript]: https://www.typescriptlang.org
