; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=SSE --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefix=SSE --check-prefix=SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefix=SSE --check-prefix=SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-shuffle | FileCheck %s --check-prefixes=AVX,AVX512

; FIXME: should be paddusb
define <16 x i8> @test1(<16 x i8> %x) {
; SSE-LABEL: test1:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    psubb %xmm1, %xmm2
; SSE-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: test1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpsubb %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubb %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpsubb %xmm2, %xmm0, %xmm1
; AVX512-NEXT:    vpcmpeqb %xmm2, %xmm0, %k1
; AVX512-NEXT:    vmovdqu8 %xmm2, %xmm1 {%k1}
; AVX512-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512-NEXT:    retq
  %1 = add <16 x i8> %x, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %2 = icmp eq <16 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %3 = select <16 x i1> %2, <16 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <16 x i8> %1
  ret <16 x i8> %3
}

define <16 x i8> @test2(<16 x i8> %x) {
; SSE-LABEL: test2:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusb {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = add <16 x i8> %x, <i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127>
  %2 = icmp ugt <16 x i8> %x, <i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128>
  %3 = select <16 x i1> %2, <16 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <16 x i8> %1
  ret <16 x i8> %3
}

define <16 x i8> @test3(<16 x i8> %x) {
; SSE-LABEL: test3:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test3:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusb {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = add <16 x i8> %x, <i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127>
  %2 = icmp ugt <16 x i8> %x, <i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126>
  %3 = select <16 x i1> %2, <16 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <16 x i8> %1
  ret <16 x i8> %3
}

define <16 x i8> @test4(<16 x i8> %x) {
; SSE-LABEL: test4:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test4:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusb {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = add <16 x i8> %x, <i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2>
  %2 = icmp ugt <16 x i8> %x, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %3 = select <16 x i1> %2, <16 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <16 x i8> %1
  ret <16 x i8> %3
}

; FIXME: should be paddusb
define <16 x i8> @test5(<16 x i8> %x) {
; SSE-LABEL: test5:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pmaxub %xmm1, %xmm0
; SSE-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: test5:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vpmaxub %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test5:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm1
; AVX2-NEXT:    vpmaxub %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpcmpeqb %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test5:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm1
; AVX512-NEXT:    vpcmpltub %xmm0, %xmm1, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqu8 %xmm0, %xmm1 {%k1}
; AVX512-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512-NEXT:    retq
  %1 = xor <16 x i8> %x, <i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128>
  %2 = icmp ult <16 x i8> %1, %x
  %3 = select <16 x i1> %2, <16 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <16 x i8> %1
  ret <16 x i8> %3
}

define <16 x i8> @test6(<16 x i8> %x) {
; SSE-LABEL: test6:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test6:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusb {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = add <16 x i8> %x, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %2 = icmp ugt <16 x i8> %x, <i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3>
  %3 = select <16 x i1> %2, <16 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <16 x i8> %1
  ret <16 x i8> %3
}

define <32 x i8> @test7(<32 x i8> %x) {
; SSE-LABEL: test7:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    psubb %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    psubb %xmm2, %xmm4
; SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pcmpeqb %xmm2, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: test7:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpsubb %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpsubb %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test7:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpsubb %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test7:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512-NEXT:    vpsubb %ymm2, %ymm0, %ymm1
; AVX512-NEXT:    vpcmpeqb %ymm2, %ymm0, %k1
; AVX512-NEXT:    vmovdqu8 %ymm2, %ymm1 {%k1}
; AVX512-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512-NEXT:    retq
  %1 = add <32 x i8> %x, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %2 = icmp eq <32 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %3 = select <32 x i1> %2, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> %1
  ret <32 x i8> %3
}

define <32 x i8> @test8(<32 x i8> %x) {
; SSE-LABEL: test8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE-NEXT:    paddusb %xmm2, %xmm0
; SSE-NEXT:    paddusb %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpaddusb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddusb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusb {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb {{.*}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = add <32 x i8> %x, <i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127>
  %2 = icmp ugt <32 x i8> %x, <i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128>
  %3 = select <32 x i1> %2, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> %1
  ret <32 x i8> %3
}

define <32 x i8> @test9(<32 x i8> %x) {
; SSE-LABEL: test9:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129]
; SSE-NEXT:    paddusb %xmm2, %xmm0
; SSE-NEXT:    paddusb %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test9:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129]
; AVX1-NEXT:    vpaddusb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddusb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test9:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusb {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test9:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb {{.*}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = add <32 x i8> %x, <i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127>
  %2 = icmp ugt <32 x i8> %x, <i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126>
  %3 = select <32 x i1> %2, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> %1
  ret <32 x i8> %3
}

define <32 x i8> @test10(<32 x i8> %x) {
; SSE-LABEL: test10:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254]
; SSE-NEXT:    paddusb %xmm2, %xmm0
; SSE-NEXT:    paddusb %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test10:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254]
; AVX1-NEXT:    vpaddusb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddusb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test10:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusb {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test10:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb {{.*}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = add <32 x i8> %x, <i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2>
  %2 = icmp ugt <32 x i8> %x, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %3 = select <32 x i1> %2, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> %1
  ret <32 x i8> %3
}

define <32 x i8> @test11(<32 x i8> %x) {
; SSE-LABEL: test11:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm2, %xmm3
; SSE-NEXT:    pxor %xmm1, %xmm2
; SSE-NEXT:    pmaxub %xmm2, %xmm1
; SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    pmaxub %xmm3, %xmm0
; SSE-NEXT:    pcmpeqb %xmm3, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test11:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps {{.*}}(%rip), %ymm0, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpmaxub %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpxor %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmaxub %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpxor %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test11:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor {{.*}}(%rip), %ymm0, %ymm1
; AVX2-NEXT:    vpmaxub %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpcmpeqb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test11:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor {{.*}}(%rip), %ymm0, %ymm1
; AVX512-NEXT:    vpcmpltub %ymm0, %ymm1, %k1
; AVX512-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512-NEXT:    vmovdqu8 %ymm0, %ymm1 {%k1}
; AVX512-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512-NEXT:    retq
  %1 = xor <32 x i8> %x, <i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128>
  %2 = icmp ult <32 x i8> %1, %x
  %3 = select <32 x i1> %2, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> %1
  ret <32 x i8> %3
}

define <32 x i8> @test12(<32 x i8> %x) {
; SSE-LABEL: test12:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; SSE-NEXT:    paddusb %xmm2, %xmm0
; SSE-NEXT:    paddusb %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test12:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; AVX1-NEXT:    vpaddusb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddusb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test12:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusb {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test12:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb {{.*}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = add <32 x i8> %x, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %2 = icmp ugt <32 x i8> %x, <i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3>
  %3 = select <32 x i1> %2, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> %1
  ret <32 x i8> %3
}

define <64 x i8> @test13(<64 x i8> %x) {
; SSE-LABEL: test13:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm8, %xmm8
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    psubb %xmm8, %xmm5
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    psubb %xmm8, %xmm6
; SSE-NEXT:    movdqa %xmm1, %xmm7
; SSE-NEXT:    psubb %xmm8, %xmm7
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    psubb %xmm8, %xmm4
; SSE-NEXT:    pcmpeqb %xmm8, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    pcmpeqb %xmm8, %xmm2
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    pcmpeqb %xmm8, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    pcmpeqb %xmm8, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: test13:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpsubb %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vpsubb %xmm3, %xmm1, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpsubb %xmm3, %xmm5, %xmm6
; AVX1-NEXT:    vpsubb %xmm3, %xmm0, %xmm7
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vorps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm5, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm6, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test13:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpsubb %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vpsubb %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test13:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm2, %zmm2, %zmm2
; AVX512-NEXT:    vpsubb %zmm2, %zmm0, %zmm1
; AVX512-NEXT:    vpcmpeqb %zmm2, %zmm0, %k1
; AVX512-NEXT:    vmovdqu8 %zmm2, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    retq
  %1 = add <64 x i8> %x, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %2 = icmp eq <64 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %3 = select <64 x i1> %2, <64 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <64 x i8> %1
  ret <64 x i8> %3
}

define <64 x i8> @test14(<64 x i8> %x) {
; SSE-LABEL: test14:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE-NEXT:    paddusb %xmm4, %xmm0
; SSE-NEXT:    paddusb %xmm4, %xmm1
; SSE-NEXT:    paddusb %xmm4, %xmm2
; SSE-NEXT:    paddusb %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test14:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpaddusb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test14:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX2-NEXT:    vpaddusb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test14:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb {{.*}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = add <64 x i8> %x, <i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127>
  %2 = icmp ugt <64 x i8> %x, <i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128>
  %3 = select <64 x i1> %2, <64 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <64 x i8> %1
  ret <64 x i8> %3
}

define <64 x i8> @test15(<64 x i8> %x) {
; SSE-LABEL: test15:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129]
; SSE-NEXT:    paddusb %xmm4, %xmm0
; SSE-NEXT:    paddusb %xmm4, %xmm1
; SSE-NEXT:    paddusb %xmm4, %xmm2
; SSE-NEXT:    paddusb %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test15:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129]
; AVX1-NEXT:    vpaddusb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test15:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129]
; AVX2-NEXT:    vpaddusb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test15:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb {{.*}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = add <64 x i8> %x, <i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127>
  %2 = icmp ugt <64 x i8> %x, <i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126>
  %3 = select <64 x i1> %2, <64 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <64 x i8> %1
  ret <64 x i8> %3
}

define <64 x i8> @test16(<64 x i8> %x) {
; SSE-LABEL: test16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254]
; SSE-NEXT:    paddusb %xmm4, %xmm0
; SSE-NEXT:    paddusb %xmm4, %xmm1
; SSE-NEXT:    paddusb %xmm4, %xmm2
; SSE-NEXT:    paddusb %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254]
; AVX1-NEXT:    vpaddusb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254]
; AVX2-NEXT:    vpaddusb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb {{.*}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = add <64 x i8> %x, <i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2, i8 -2>
  %2 = icmp ugt <64 x i8> %x, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %3 = select <64 x i1> %2, <64 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <64 x i8> %1
  ret <64 x i8> %3
}

define <64 x i8> @test17(<64 x i8> %x) {
; SSE-LABEL: test17:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    pxor %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    pxor %xmm4, %xmm7
; SSE-NEXT:    pxor %xmm3, %xmm4
; SSE-NEXT:    pmaxub %xmm4, %xmm3
; SSE-NEXT:    pcmpeqb %xmm4, %xmm3
; SSE-NEXT:    pcmpeqd %xmm8, %xmm8
; SSE-NEXT:    pxor %xmm8, %xmm3
; SSE-NEXT:    pmaxub %xmm7, %xmm2
; SSE-NEXT:    pcmpeqb %xmm7, %xmm2
; SSE-NEXT:    pxor %xmm8, %xmm2
; SSE-NEXT:    pmaxub %xmm6, %xmm1
; SSE-NEXT:    pcmpeqb %xmm6, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    pmaxub %xmm5, %xmm0
; SSE-NEXT:    pcmpeqb %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm8, %xmm0
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    por %xmm6, %xmm1
; SSE-NEXT:    por %xmm7, %xmm2
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test17:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm3
; AVX1-NEXT:    vxorps %ymm2, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpmaxub %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpcmpeqb %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpmaxub %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpxor %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX1-NEXT:    vpmaxub %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpmaxub %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpxor %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test17:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpmaxub %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpxor %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpmaxub %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpcmpeqb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpxor %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test17:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxorq {{.*}}(%rip), %zmm0, %zmm1
; AVX512-NEXT:    vpcmpltub %zmm0, %zmm1, %k1
; AVX512-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0
; AVX512-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    retq
  %1 = xor <64 x i8> %x, <i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128>
  %2 = icmp ult <64 x i8> %1, %x
  %3 = select <64 x i1> %2, <64 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <64 x i8> %1
  ret <64 x i8> %3
}

define <64 x i8> @test18(<64 x i8> %x) {
; SSE-LABEL: test18:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; SSE-NEXT:    paddusb %xmm4, %xmm0
; SSE-NEXT:    paddusb %xmm4, %xmm1
; SSE-NEXT:    paddusb %xmm4, %xmm2
; SSE-NEXT:    paddusb %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test18:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; AVX1-NEXT:    vpaddusb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test18:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; AVX2-NEXT:    vpaddusb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test18:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb {{.*}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = add <64 x i8> %x, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %2 = icmp ugt <64 x i8> %x, <i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3, i8 -3>
  %3 = select <64 x i1> %2, <64 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <64 x i8> %1
  ret <64 x i8> %3
}

define <8 x i16> @test19(<8 x i16> %x) {
; SSE-LABEL: test19:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    psubw %xmm1, %xmm2
; SSE-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: test19:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpsubw %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test19:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubw %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test19:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpsubw %xmm2, %xmm0, %xmm1
; AVX512-NEXT:    vpcmpeqw %xmm2, %xmm0, %k1
; AVX512-NEXT:    vmovdqu16 %xmm2, %xmm1 {%k1}
; AVX512-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512-NEXT:    retq
  %1 = add <8 x i16> %x, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %2 = icmp eq <8 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %3 = select <8 x i1> %2, <8 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <8 x i16> %1
  ret <8 x i16> %3
}

define <8 x i16> @test20(<8 x i16> %x) {
; SSE-LABEL: test20:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test20:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusw {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = add <8 x i16> %x, <i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767>
  %2 = icmp ugt <8 x i16> %x, <i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768>
  %3 = select <8 x i1> %2, <8 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <8 x i16> %1
  ret <8 x i16> %3
}

define <8 x i16> @test21(<8 x i16> %x) {
; SSE-LABEL: test21:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test21:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusw {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = add <8 x i16> %x, <i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767>
  %2 = icmp ugt <8 x i16> %x, <i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766>
  %3 = select <8 x i1> %2, <8 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <8 x i16> %1
  ret <8 x i16> %3
}

define <8 x i16> @test22(<8 x i16> %x) {
; SSE-LABEL: test22:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test22:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusw {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = add <8 x i16> %x, <i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2>
  %2 = icmp ugt <8 x i16> %x, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %3 = select <8 x i1> %2, <8 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <8 x i16> %1
  ret <8 x i16> %3
}

define <8 x i16> @test23(<8 x i16> %x) {
; SSE2-LABEL: test23:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE2-NEXT:    pxor %xmm0, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    pcmpgtw %xmm0, %xmm1
; SSE2-NEXT:    por %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test23:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSSE3-NEXT:    pxor %xmm0, %xmm2
; SSSE3-NEXT:    movdqa %xmm2, %xmm1
; SSSE3-NEXT:    pcmpgtw %xmm0, %xmm1
; SSSE3-NEXT:    por %xmm2, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test23:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE41-NEXT:    pxor %xmm0, %xmm1
; SSE41-NEXT:    pmaxuw %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test23:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vpmaxuw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test23:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm1
; AVX2-NEXT:    vpmaxuw %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpcmpeqw %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test23:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm1
; AVX512-NEXT:    vpcmpltuw %xmm0, %xmm1, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqu16 %xmm0, %xmm1 {%k1}
; AVX512-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512-NEXT:    retq
  %1 = xor <8 x i16> %x, <i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768>
  %2 = icmp ult <8 x i16> %1, %x
  %3 = select <8 x i1> %2, <8 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <8 x i16> %1
  ret <8 x i16> %3
}

define <8 x i16> @test24(<8 x i16> %x) {
; SSE-LABEL: test24:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test24:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusw {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = add <8 x i16> %x, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  %2 = icmp ugt <8 x i16> %x, <i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3>
  %3 = select <8 x i1> %2, <8 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <8 x i16> %1
  ret <8 x i16> %3
}

define <16 x i16> @test25(<16 x i16> %x) {
; SSE-LABEL: test25:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    psubw %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    psubw %xmm2, %xmm4
; SSE-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: test25:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpsubw %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpsubw %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test25:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpsubw %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test25:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512-NEXT:    vpsubw %ymm2, %ymm0, %ymm1
; AVX512-NEXT:    vpcmpeqw %ymm2, %ymm0, %k1
; AVX512-NEXT:    vmovdqu16 %ymm2, %ymm1 {%k1}
; AVX512-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512-NEXT:    retq
  %1 = add <16 x i16> %x, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %2 = icmp eq <16 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %3 = select <16 x i1> %2, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> %1
  ret <16 x i16> %3
}

define <16 x i16> @test26(<16 x i16> %x) {
; SSE-LABEL: test26:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [32767,32767,32767,32767,32767,32767,32767,32767]
; SSE-NEXT:    paddusw %xmm2, %xmm0
; SSE-NEXT:    paddusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test26:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [32767,32767,32767,32767,32767,32767,32767,32767]
; AVX1-NEXT:    vpaddusw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test26:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusw {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test26:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw {{.*}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = add <16 x i16> %x, <i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767>
  %2 = icmp ugt <16 x i16> %x, <i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768>
  %3 = select <16 x i1> %2, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> %1
  ret <16 x i16> %3
}

define <16 x i16> @test27(<16 x i16> %x) {
; SSE-LABEL: test27:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [32769,32769,32769,32769,32769,32769,32769,32769]
; SSE-NEXT:    paddusw %xmm2, %xmm0
; SSE-NEXT:    paddusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test27:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [32769,32769,32769,32769,32769,32769,32769,32769]
; AVX1-NEXT:    vpaddusw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test27:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusw {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test27:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw {{.*}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = add <16 x i16> %x, <i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767>
  %2 = icmp ugt <16 x i16> %x, <i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766>
  %3 = select <16 x i1> %2, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> %1
  ret <16 x i16> %3
}

define <16 x i16> @test28(<16 x i16> %x) {
; SSE-LABEL: test28:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65534,65534,65534,65534,65534,65534,65534,65534]
; SSE-NEXT:    paddusw %xmm2, %xmm0
; SSE-NEXT:    paddusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test28:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [65534,65534,65534,65534,65534,65534,65534,65534]
; AVX1-NEXT:    vpaddusw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test28:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusw {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test28:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw {{.*}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = add <16 x i16> %x, <i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2>
  %2 = icmp ugt <16 x i16> %x, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %3 = select <16 x i1> %2, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> %1
  ret <16 x i16> %3
}

define <16 x i16> @test29(<16 x i16> %x) {
; SSE2-LABEL: test29:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    pcmpgtw %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm4, %xmm1
; SSE2-NEXT:    pcmpgtw %xmm0, %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    por %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test29:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSSE3-NEXT:    pcmpgtw %xmm1, %xmm2
; SSSE3-NEXT:    movdqa %xmm4, %xmm1
; SSSE3-NEXT:    pcmpgtw %xmm0, %xmm1
; SSSE3-NEXT:    por %xmm4, %xmm1
; SSSE3-NEXT:    por %xmm3, %xmm2
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    movdqa %xmm2, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test29:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    pxor %xmm1, %xmm2
; SSE41-NEXT:    pmaxuw %xmm2, %xmm1
; SSE41-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE41-NEXT:    pxor %xmm4, %xmm1
; SSE41-NEXT:    pmaxuw %xmm3, %xmm0
; SSE41-NEXT:    pcmpeqw %xmm3, %xmm0
; SSE41-NEXT:    pxor %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test29:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps {{.*}}(%rip), %ymm0, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpmaxuw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpxor %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmaxuw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpxor %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test29:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor {{.*}}(%rip), %ymm0, %ymm1
; AVX2-NEXT:    vpmaxuw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpcmpeqw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test29:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor {{.*}}(%rip), %ymm0, %ymm1
; AVX512-NEXT:    vpcmpltuw %ymm0, %ymm1, %k1
; AVX512-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512-NEXT:    vmovdqu16 %ymm0, %ymm1 {%k1}
; AVX512-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512-NEXT:    retq
  %1 = xor <16 x i16> %x, <i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768>
  %2 = icmp ult <16 x i16> %1, %x
  %3 = select <16 x i1> %2, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> %1
  ret <16 x i16> %3
}

define <16 x i16> @test30(<16 x i16> %x) {
; SSE-LABEL: test30:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [2,2,2,2,2,2,2,2]
; SSE-NEXT:    paddusw %xmm2, %xmm0
; SSE-NEXT:    paddusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test30:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [2,2,2,2,2,2,2,2]
; AVX1-NEXT:    vpaddusw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test30:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusw {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test30:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw {{.*}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = add <16 x i16> %x, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  %2 = icmp ugt <16 x i16> %x, <i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3>
  %3 = select <16 x i1> %2, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> %1
  ret <16 x i16> %3
}

define <32 x i16> @test31(<32 x i16> %x) {
; SSE-LABEL: test31:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm8, %xmm8
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    psubw %xmm8, %xmm5
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    psubw %xmm8, %xmm6
; SSE-NEXT:    movdqa %xmm1, %xmm7
; SSE-NEXT:    psubw %xmm8, %xmm7
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    psubw %xmm8, %xmm4
; SSE-NEXT:    pcmpeqw %xmm8, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    pcmpeqw %xmm8, %xmm2
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    pcmpeqw %xmm8, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    pcmpeqw %xmm8, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: test31:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpsubw %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vpsubw %xmm3, %xmm1, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpsubw %xmm3, %xmm5, %xmm6
; AVX1-NEXT:    vpsubw %xmm3, %xmm0, %xmm7
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vorps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm5, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm6, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test31:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpsubw %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vpsubw %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test31:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm2, %zmm2, %zmm2
; AVX512-NEXT:    vpsubw %zmm2, %zmm0, %zmm1
; AVX512-NEXT:    vpcmpeqw %zmm2, %zmm0, %k1
; AVX512-NEXT:    vmovdqu16 %zmm2, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    retq
  %1 = add <32 x i16> %x, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %2 = icmp eq <32 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %3 = select <32 x i1> %2, <32 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <32 x i16> %1
  ret <32 x i16> %3
}

define <32 x i16> @test32(<32 x i16> %x) {
; SSE-LABEL: test32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [32767,32767,32767,32767,32767,32767,32767,32767]
; SSE-NEXT:    paddusw %xmm4, %xmm0
; SSE-NEXT:    paddusw %xmm4, %xmm1
; SSE-NEXT:    paddusw %xmm4, %xmm2
; SSE-NEXT:    paddusw %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [32767,32767,32767,32767,32767,32767,32767,32767]
; AVX1-NEXT:    vpaddusw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767]
; AVX2-NEXT:    vpaddusw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw {{.*}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = add <32 x i16> %x, <i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767, i16 32767>
  %2 = icmp ugt <32 x i16> %x, <i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768>
  %3 = select <32 x i1> %2, <32 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <32 x i16> %1
  ret <32 x i16> %3
}

define <32 x i16> @test33(<32 x i16> %x) {
; SSE-LABEL: test33:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [32769,32769,32769,32769,32769,32769,32769,32769]
; SSE-NEXT:    paddusw %xmm4, %xmm0
; SSE-NEXT:    paddusw %xmm4, %xmm1
; SSE-NEXT:    paddusw %xmm4, %xmm2
; SSE-NEXT:    paddusw %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test33:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [32769,32769,32769,32769,32769,32769,32769,32769]
; AVX1-NEXT:    vpaddusw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test33:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [32769,32769,32769,32769,32769,32769,32769,32769,32769,32769,32769,32769,32769,32769,32769,32769]
; AVX2-NEXT:    vpaddusw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test33:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw {{.*}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = add <32 x i16> %x, <i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767>
  %2 = icmp ugt <32 x i16> %x, <i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766>
  %3 = select <32 x i1> %2, <32 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <32 x i16> %1
  ret <32 x i16> %3
}

define <32 x i16> @test34(<32 x i16> %x) {
; SSE-LABEL: test34:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65534,65534,65534,65534,65534,65534,65534,65534]
; SSE-NEXT:    paddusw %xmm4, %xmm0
; SSE-NEXT:    paddusw %xmm4, %xmm1
; SSE-NEXT:    paddusw %xmm4, %xmm2
; SSE-NEXT:    paddusw %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test34:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [65534,65534,65534,65534,65534,65534,65534,65534]
; AVX1-NEXT:    vpaddusw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test34:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [65534,65534,65534,65534,65534,65534,65534,65534,65534,65534,65534,65534,65534,65534,65534,65534]
; AVX2-NEXT:    vpaddusw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test34:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw {{.*}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = add <32 x i16> %x, <i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2, i16 -2>
  %2 = icmp ugt <32 x i16> %x, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %3 = select <32 x i1> %2, <32 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <32 x i16> %1
  ret <32 x i16> %3
}

define <32 x i16> @test35(<32 x i16> %x) {
; SSE2-LABEL: test35:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    pxor %xmm5, %xmm6
; SSE2-NEXT:    movdqa %xmm1, %xmm7
; SSE2-NEXT:    pxor %xmm5, %xmm7
; SSE2-NEXT:    movdqa %xmm2, %xmm8
; SSE2-NEXT:    pxor %xmm5, %xmm8
; SSE2-NEXT:    pxor %xmm3, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm4
; SSE2-NEXT:    pcmpgtw %xmm3, %xmm4
; SSE2-NEXT:    movdqa %xmm8, %xmm3
; SSE2-NEXT:    pcmpgtw %xmm2, %xmm3
; SSE2-NEXT:    movdqa %xmm7, %xmm2
; SSE2-NEXT:    pcmpgtw %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm6, %xmm1
; SSE2-NEXT:    pcmpgtw %xmm0, %xmm1
; SSE2-NEXT:    por %xmm6, %xmm1
; SSE2-NEXT:    por %xmm7, %xmm2
; SSE2-NEXT:    por %xmm8, %xmm3
; SSE2-NEXT:    por %xmm5, %xmm4
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test35:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSSE3-NEXT:    movdqa %xmm0, %xmm6
; SSSE3-NEXT:    pxor %xmm5, %xmm6
; SSSE3-NEXT:    movdqa %xmm1, %xmm7
; SSSE3-NEXT:    pxor %xmm5, %xmm7
; SSSE3-NEXT:    movdqa %xmm2, %xmm8
; SSSE3-NEXT:    pxor %xmm5, %xmm8
; SSSE3-NEXT:    pxor %xmm3, %xmm5
; SSSE3-NEXT:    movdqa %xmm5, %xmm4
; SSSE3-NEXT:    pcmpgtw %xmm3, %xmm4
; SSSE3-NEXT:    movdqa %xmm8, %xmm3
; SSSE3-NEXT:    pcmpgtw %xmm2, %xmm3
; SSSE3-NEXT:    movdqa %xmm7, %xmm2
; SSSE3-NEXT:    pcmpgtw %xmm1, %xmm2
; SSSE3-NEXT:    movdqa %xmm6, %xmm1
; SSSE3-NEXT:    pcmpgtw %xmm0, %xmm1
; SSSE3-NEXT:    por %xmm6, %xmm1
; SSSE3-NEXT:    por %xmm7, %xmm2
; SSSE3-NEXT:    por %xmm8, %xmm3
; SSSE3-NEXT:    por %xmm5, %xmm4
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    movdqa %xmm2, %xmm1
; SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSSE3-NEXT:    movdqa %xmm4, %xmm3
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test35:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pxor %xmm4, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm6
; SSE41-NEXT:    pxor %xmm4, %xmm6
; SSE41-NEXT:    movdqa %xmm2, %xmm7
; SSE41-NEXT:    pxor %xmm4, %xmm7
; SSE41-NEXT:    pxor %xmm3, %xmm4
; SSE41-NEXT:    pmaxuw %xmm4, %xmm3
; SSE41-NEXT:    pcmpeqw %xmm4, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm8
; SSE41-NEXT:    pxor %xmm8, %xmm3
; SSE41-NEXT:    pmaxuw %xmm7, %xmm2
; SSE41-NEXT:    pcmpeqw %xmm7, %xmm2
; SSE41-NEXT:    pxor %xmm8, %xmm2
; SSE41-NEXT:    pmaxuw %xmm6, %xmm1
; SSE41-NEXT:    pcmpeqw %xmm6, %xmm1
; SSE41-NEXT:    pxor %xmm8, %xmm1
; SSE41-NEXT:    pmaxuw %xmm5, %xmm0
; SSE41-NEXT:    pcmpeqw %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm8, %xmm0
; SSE41-NEXT:    por %xmm5, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm1
; SSE41-NEXT:    por %xmm7, %xmm2
; SSE41-NEXT:    por %xmm4, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test35:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768]
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm3
; AVX1-NEXT:    vxorps %ymm2, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpmaxuw %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpcmpeqw %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpmaxuw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpxor %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX1-NEXT:    vpmaxuw %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpcmpeqw %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpmaxuw %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpcmpeqw %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpxor %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test35:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768]
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpmaxuw %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpxor %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpmaxuw %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpcmpeqw %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpxor %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test35:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxorq {{.*}}(%rip), %zmm0, %zmm1
; AVX512-NEXT:    vpcmpltuw %zmm0, %zmm1, %k1
; AVX512-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0
; AVX512-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    retq
  %1 = xor <32 x i16> %x, <i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768>
  %2 = icmp ult <32 x i16> %1, %x
  %3 = select <32 x i1> %2, <32 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <32 x i16> %1
  ret <32 x i16> %3
}

define <32 x i16> @test36(<32 x i16> %x) {
; SSE-LABEL: test36:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [2,2,2,2,2,2,2,2]
; SSE-NEXT:    paddusw %xmm4, %xmm0
; SSE-NEXT:    paddusw %xmm4, %xmm1
; SSE-NEXT:    paddusw %xmm4, %xmm2
; SSE-NEXT:    paddusw %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test36:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [2,2,2,2,2,2,2,2]
; AVX1-NEXT:    vpaddusw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test36:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; AVX2-NEXT:    vpaddusw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test36:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw {{.*}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = add <32 x i16> %x, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  %2 = icmp ugt <32 x i16> %x, <i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3>
  %3 = select <32 x i1> %2, <32 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <32 x i16> %1
  ret <32 x i16> %3
}

define void @addus_v8i8(<8 x i8>* %p1, <8 x i8>* %p2) {
; SSE-LABEL: addus_v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    paddusb %xmm0, %xmm1
; SSE-NEXT:    movq %xmm1, (%rdi)
; SSE-NEXT:    retq
;
; AVX1-LABEL: addus_v8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vpaddusb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: addus_v8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpaddusb %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: addus_v8i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpaddusb %xmm0, %xmm1, %xmm0
; AVX512-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vpmovwb %xmm0, (%rdi)
; AVX512-NEXT:    retq
  %ld1 = load <8 x i8>, <8 x i8>* %p1, align 8
  %ld2 = load <8 x i8>, <8 x i8>* %p2, align 8
  %1 = add <8 x i8> %ld2, %ld1
  %2 = icmp ugt <8 x i8> %ld1, %1
  %sh3 = select <8 x i1> %2, <8 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <8 x i8> %1
  store <8 x i8> %sh3, <8 x i8>* %p1, align 8
  ret void
}

define void @addus_v4i8(<4 x i8>* %p1, <4 x i8>* %p2) {
; SSE-LABEL: addus_v4i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    paddusb %xmm0, %xmm1
; SSE-NEXT:    movd %xmm1, (%rdi)
; SSE-NEXT:    retq
;
; AVX1-LABEL: addus_v4i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpaddusb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: addus_v4i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpaddusb %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: addus_v4i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512-NEXT:    vpaddusb %xmm0, %xmm1, %xmm0
; AVX512-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX512-NEXT:    vpmovdb %xmm0, (%rdi)
; AVX512-NEXT:    retq
  %ld1 = load <4 x i8>, <4 x i8>* %p1, align 4
  %ld2 = load <4 x i8>, <4 x i8>* %p2, align 4
  %1 = add <4 x i8> %ld2, %ld1
  %2 = icmp ugt <4 x i8> %ld1, %1
  %sh3 = select <4 x i1> %2, <4 x i8> <i8 -1, i8 -1, i8 -1, i8 -1>, <4 x i8> %1
  store <4 x i8> %sh3, <4 x i8>* %p1, align 4
  ret void
}

define void @addus_v2i8(<2 x i8>* %p1, <2 x i8>* %p2) {
; SSE2-LABEL: addus_v2i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    movzwl (%rsi), %eax
; SSE2-NEXT:    movd %eax, %xmm1
; SSE2-NEXT:    paddusb %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: addus_v2i8:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movzwl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    movzwl (%rsi), %eax
; SSSE3-NEXT:    movd %eax, %xmm1
; SSSE3-NEXT:    paddusb %xmm0, %xmm1
; SSSE3-NEXT:    movd %xmm1, %eax
; SSSE3-NEXT:    movw %ax, (%rdi)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: addus_v2i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    movzwl (%rsi), %eax
; SSE41-NEXT:    movd %eax, %xmm1
; SSE41-NEXT:    paddusb %xmm0, %xmm1
; SSE41-NEXT:    pextrw $0, %xmm1, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: addus_v2i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movzwl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    movzwl (%rsi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vpaddusb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: addus_v2i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movzwl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    movzwl (%rsi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vpaddusb %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: addus_v2i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movzwl (%rdi), %eax
; AVX512-NEXT:    vmovd %eax, %xmm0
; AVX512-NEXT:    movzwl (%rsi), %eax
; AVX512-NEXT:    vmovd %eax, %xmm1
; AVX512-NEXT:    vpaddusb %xmm0, %xmm1, %xmm0
; AVX512-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero
; AVX512-NEXT:    vpmovqb %xmm0, (%rdi)
; AVX512-NEXT:    retq
  %ld1 = load <2 x i8>, <2 x i8>* %p1, align 2
  %ld2 = load <2 x i8>, <2 x i8>* %p2, align 2
  %1 = add <2 x i8> %ld2, %ld1
  %2 = icmp ugt <2 x i8> %ld1, %1
  %sh3 = select <2 x i1> %2, <2 x i8> <i8 -1, i8 -1>, <2 x i8> %1
  store <2 x i8> %sh3, <2 x i8>* %p1, align 2
  ret void
}

define void @addus_v4i16(<4 x i16>* %p1, <4 x i16>* %p2) {
; SSE-LABEL: addus_v4i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    paddusw %xmm0, %xmm1
; SSE-NEXT:    movq %xmm1, (%rdi)
; SSE-NEXT:    retq
;
; AVX1-LABEL: addus_v4i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vpaddusw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: addus_v4i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpaddusw %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: addus_v4i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpaddusw %xmm0, %xmm1, %xmm0
; AVX512-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX512-NEXT:    vpmovdw %xmm0, (%rdi)
; AVX512-NEXT:    retq
  %ld1 = load <4 x i16>, <4 x i16>* %p1, align 4
  %ld2 = load <4 x i16>, <4 x i16>* %p2, align 4
  %1 = add <4 x i16> %ld2, %ld1
  %2 = icmp ugt <4 x i16> %ld1, %1
  %sh3 = select <4 x i1> %2, <4 x i16> <i16 -1, i16 -1, i16 -1, i16 -1>, <4 x i16> %1
  store <4 x i16> %sh3, <4 x i16>* %p1, align 4
  ret void
}

define void @addus_v2i16(<2 x i16>* %p1, <2 x i16>* %p2) {
; SSE-LABEL: addus_v2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    paddusw %xmm0, %xmm1
; SSE-NEXT:    movd %xmm1, (%rdi)
; SSE-NEXT:    retq
;
; AVX1-LABEL: addus_v2i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpaddusw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: addus_v2i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpaddusw %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: addus_v2i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512-NEXT:    vpaddusw %xmm0, %xmm1, %xmm0
; AVX512-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; AVX512-NEXT:    vpmovqw %xmm0, (%rdi)
; AVX512-NEXT:    retq
  %ld1 = load <2 x i16>, <2 x i16>* %p1, align 2
  %ld2 = load <2 x i16>, <2 x i16>* %p2, align 2
  %1 = add <2 x i16> %ld2, %ld1
  %2 = icmp ugt <2 x i16> %ld1, %1
  %sh3 = select <2 x i1> %2, <2 x i16> <i16 -1, i16 -1>, <2 x i16> %1
  store <2 x i16> %sh3, <2 x i16>* %p1, align 2
  ret void
}
