An invalid meta-item was used inside an attribute.

Erroneous code example:

```compile_fail,E0539
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[rustc_deprecated(reason)] // error!
#[unstable(feature = "deprecated_fn", issue = "123")]
fn deprecated() {}

#[unstable(feature = "unstable_struct", issue)] // error!
struct Unstable;

#[rustc_const_unstable(feature)] // error!
const fn unstable_fn() {}

#[stable(feature = "stable_struct", since)] // error!
struct Stable;

#[rustc_const_stable(feature)] // error!
const fn stable_fn() {}
```

Meta items are the key-value pairs inside of an attribute.
To fix these issues you need to give required key-value pairs.

```
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[rustc_deprecated(since = "1.39.0", reason = "reason")] // ok!
#[unstable(feature = "deprecated_fn", issue = "123")]
fn deprecated() {}

#[unstable(feature = "unstable_struct", issue = "123")] // ok!
struct Unstable;

#[rustc_const_unstable(feature = "unstable_fn", issue = "124")] // ok!
const fn unstable_fn() {}

#[stable(feature = "stable_struct", since = "1.39.0")] // ok!
struct Stable;

#[rustc_const_stable(feature = "stable_fn", since = "1.39.0")] // ok!
const fn stable_fn() {}
```
