	.MODEL	SMALL, C
	.CODE
	PUBLIC cx_i486cachemode

CR0_CD_DIS	EQU	040000000h	; Disable cache with CR0

;
;	int cx_i486cachemode(void)
;
;	This routine returns 1 if the i486 cache is enabled.
;	Otherwise, it returns 0.
;

cx_i486cachemode	PROC		; The proc name.

	.386P				; 386 prot. instrucions allowed.

; Use of MASM v5.1 should make this unnecessary.
;	push	ebp
;	mov	ebp, esp

	mov	eax, cr0		; cr0 -> eax
	and	eax, CR0_CD_DIS		; Test if CD bit "on"
	or	eax, eax
	jnz	cx_cacheisoff

	mov	eax, 1			; Cache is on: set return value
	jmp	cx_mode_done

cx_cacheisoff:
	mov	eax, 0			; Cache is off: set return value

cx_mode_done:

; Didn't push it, so don't pop it.
;	pop	ebp

	ret

cx_i486cachemode	ENDP
			END

