/********:ts=4*****************************************************************
 *
 *		Copyright U.S. Robotics. 1995, all rights reserved.
 *
 *  PROGRAM: 		iscconst.h
 *
 *  DESCRIPTION:	Common constants used for function args and struct
 *					members for interfacing to the PROD_TM
 *					with the TAPI device extensions in iscdevex.h
 *
 *	Modification Log:
 *
 *	Date	Authors		Notes/Description of Change
 * 08-11-95	JLM			Genesis
 * 05-18-96	JLM			Add support for BACP.
 * 06-18-96	JLM			Add support for new commands.
 *****************************************************************************/
 
#ifndef _iscconst_h_included
#define _iscconst_h_included
 
/*****
*  Size constants
*****/
#define MACADDRESSSIZE		6		// Length of cards NAC address.
#define MAXSERIALNUMBERSIZE	36      // Length of Cards serial number.
#define	MAXSLBRICHANS		2		// Max chans configurable on a BRI Adapter.
#define	MAXSLNBNAMESIZE		33		// Max NetBIOS name size
#define	MAXSLPASSWDSIZE		24		// Max PPP password size
#define	MAXSLUSERNAMESIZE	32		// Max PPP username size
#define MAXPORTNAMESIZE 	12		// Max parallel port device name
#define MAXACCESSCODESIZE 	16		// Max digits that can be used for 
									//   an access code.

/*****
* Constants for dwPassThruMod field.  Specifies how we should handle
* the printing while connected with the switch (when not connected we
* always pass through).
*****/
#define PASSTHRUMODE_QUEUEPRINTS	1	// Do not allow port to be shared. 

#define PASSTHRUMODE_PASSIVE		2	// Allow a steal and then on a polling
										// basis process the ISDN device. This
										// mode  carries some risk in that an
										// incoming setup may be missed.

#define PASSTHRUMODE_ACTIVE			3	// Do real resource stealing as 
										// documented (ha ha) for Windows 95
										// for a parallel dongle.

/*****
*  Board type constants (used for all dwBoardType members of the structures
*  defined in ISCDEVEX.H).
*****/
#define SIB_EXTERNAL_BOARD	0		// External (parallel port) Sporster ISDN board
#define SIB_INTERNAL_BOARD	1		// Internal Sporster ISDN board
#define SIB_PNP_BOARD		2		// Plug-n-play board (eg, Megahertz XJISDN PCMCIA)
 
/*****
*  Parallel port mode constants (used for all dwParallelPortMode members of the 
*  structures defined in ISCDEVEX.H). These are the various parallel port modes
*  the External PROD_TM will work with.
*****/
#if defined(CMPL_LST_VRSN_THT_WRKD)
	#define SIB_PARALLEL_MODE_4BIT	1
	#define SIB_PARALLEL_MODE_8BIT	2
	#define SIB_PARALLEL_MODE_EPP	3
	#define SIB_PARALLEL_MODE_ECP	4
#else
	#define SIB_PARALLEL_MODE_4BIT	0
	#define SIB_PARALLEL_MODE_8BIT	1
	#define SIB_PARALLEL_MODE_EPP	2
	#define SIB_PARALLEL_MODE_ECP	3
#endif

/*****
*  Call Encapsulation constants
*****/
#define	TRANSPARENT_ENCAPSULATION	0  // no encapsulation
#define	PPP_ENCAPSULATION			1  // 1-chan encapsulation
#define	PPPML_ENCAPSULATION			2  // 2-chan encapsulation
#define	PPP_EMULATION				3  // 1-chan emulation
#define	PPPML_EMULATION				4  // 2-chan emulation
 
/*****
*  Compression constants
*****/
#define COMPRESS_NONE			0		// No Compression
#define COMPRESS_STAC			1		// Stac Compression enabled
#define COMPRESS_ASCEND			2		// Ascend Compression enabled
#define COMPRESS_MICROSOFT		3		// Microsoft Compression enabled
 
/*****
*  SecureLink Diagnostics fail codes
*****/
#define SLF_Passed				0		// No fail - passed
#define SLF_NoHw				1		// Can't find SLNK2 at given I/O base
#define SLF_BadDlFile			2		// Bad or missning download file
#define SLF_DlFail				3		// Download failed
#define SLF_InvalidIrq			4		// Invalid IRQ read from EEPROM
#define SLF_IrqFail				5		// Failed IRQ test (did not get interrupts)
#define SLF_MemFail				6		// On board FIFO memory test failed
#define SLF_BchnFail			7		// B channel loopback test failed
#define SLF_AccessFail			8 		// Register write/read file
#define SLF_SccFail				9		// SCC Reg wr/rd test fail	
#define SLF_ImaskFail			10      // Can't disable board ints	
#define SLF_Fail				11		// Some internal failure.
#define SLF_NotPortOwner		12		// On external we could not own
										//  the parallel port.
/*****
*  PPP Protocol constants
*****/
#define PPP_PROT_PAP			0x01	// Use Password Authentication Protocol.
#define PPP_PROT_CHAP			0x02	// Use Challenge Authentication Protocol.
#define PPP_PROT_BR				0x04	// Enable bridging.
#define PPP_PROT_IP				0x08	// Enable IP.
#define PPP_PROT_IPX			0x10	// Enable IPX.
#define PPP_PROT_NBF			0x20	// Enable NetBeui.
#define PPP_PROT_CCP			0x40	// Enable Compression Control Protocol.
										//	Should set compression field.
#define PPP_PROT_BAP			0x80	// Enable BAP.
#define PPP_PROT_LCP			0x100	// Always enabled. Used for events.

/*****
*  Telco Switch constants: WARNING: Never change these values, instead add new
*									contants to the end of this list.  Some may
*									become obsolete, but always add to end of list.
*
*  In slmgr.cpp, TelcoSwitchList is a string list corresonpding to these constants.
*****/
#define TELCO_NI1 				0		// National ISDN
#define TELCO_ATT				1		// AT&T 5ESS Custom Swtch or G3 PBX
#define TELCO_NT				2		// Northern Telecom DMS-100 Custom
#define TELCO_EURO_ISDN			3		// Euro ISDN
#define TELCO_INS64				4		// The INS 64 switch type

/*****
*  Range for Sampling History (ISCBOARDFEATURESEX::dwSamplingHistory) (in seconds)x
*****/
#define TPSH_LOWER			1			// Minimum sampling history time
#define TPSH_UPPER			600			// Maximum sampling history time
#define TPSH_DEFAULT		1			// Default sampling history time

#define TPUT_LOWER			5			// Lower bound for Unexpansion time (secs)
#define TPUT_UPPER			600			// Upper bound for Unexpansion time (secs)
#define TPUT_DEFAULT		30			// Default for Unexpansion time (secs)

#define MPRC_LOWER			1			// Lower bound for MLPPP Retry Count
#define MPRC_UPPER			30			// Upper bound for MLPPP Retry Count

#define MPRI_LOWER			30			// Lower bound for MLPPP Retry Interval
#define MPRI_UPPER			600			// Upper bound for MLPPP Retry Interval

/*****
*  Switch types greater than this are not allowed for project
*****/
#if defined(_EURO_ISDN_SWITCHES)
  #define TELCO_MAX_ALLOWED		TELCO_INS64
#else
  #define TELCO_MAX_ALLOWED		TELCO_NT
#endif
 
/*****
*  These are the various link expansion methods for TurboPPP.
*****/
#define TURBOPPP_ALWAYS_EXPAND                          0
#define TURBOPPP_DBA_EXPAND                             1
#define TURBOPPP_MANUAL_EXPAND                          2

/*****
* Default settings for sampling history and unexpansion time, when ML PPP is not on.
*****/
#define NOMLPPP_EXP_LINK_UTIL_DEFAULT       100         // Default Minimum sampling history time
#define NOMLPPP_EXP_LINK_WINDOW_DEFAULT     0           // Default Maximum sampling history time
#define NOMLPPP_UNEXPAND_TIME_DEFAULT       0           // Default for Unexpansion time

#endif // _iscconst_h_included
