/******************************************************************************
 *
 *		Copyright U.S. Robotics, 1995, all rights reserved.
 *
 *  PROGRAM: 		iscioctl.h
 *
 *  DESCRIPTION:	WIN32 WDM IOCTL interface to the GCA driver
 *				    SIBBRI.386. This mechanism is an alternative
 *					to using the TAPI lineDevSpecific() calls. We have
 *					seen that these calls tend not to be reliable through
 *					TAPI.
 *
 *					The commands and structures are the same as those used in 
 *					iscdevex.h.
 *
 *	Modification Log:
 *
 *	Date		Authors	Notes/Description of Change
 *  03-03-97	JLM		Genesis.
 *****************************************************************************/

#ifndef _iscioctl_h_included
#define _iscioctl_h_included

#ifndef _iscdevext_h_included
#include "iscdevex.h"
#endif


/*****
*  Ensure all programmers are using same byte-alignment for structs.
*****/
#pragma pack(4)


/* 
// ISCCMD_BOARD_RESET	- See iscdevex.h for a description of this command.
//
// ioctl structure:
//   command         = ISCCMD_BOARD_RESET
//   InputBuffer     = points to a valid ISCBRICONFIG structure.
//   InputBufferSize = sizeof(ISCBRICONFIG)
//   OutputBuffer    = n/a
//   OutputBufferSize= n/a
//   BytesReturned   = 0
//
*/


/*
// ISC_GET_STATS	- See iscdevex.h for a description of this command.
//
// ioctl structure:
//   command         = ISCCMD_BOARD_RESET
//   InputBuffer     = points to a DWORD which contains the drivers handle
//					    to the call which was given with the 
//                      ISCEVENT_DRIVERHDCALL call info event.
//   InputBufferSize = n/a
//   OutputBuffer    = Points to a block of memory large enough to hold
//                      an ISCSTATSDATA structure.
//   OutputBufferSize= sizeof(ISCSTATSDATA)
//   BytesReturned   = 0 or sizeof(ISCSTATSDATA)
*/


/*
// ISCCMD_GET_BOARD_CONFIGURATION - See iscdevex.h for a description of this command.
//
// ioctl structure:
//   command         = ISCCMD_GET_BOARD_CONFIGURATION
//   InputBuffer     = n/a
//   InputBufferSize = n/a
//   OutputBuffer    = Points to a block of memory large enough to hold
//				       a ISCBRICONFIG structure. The data will be copied into
//				       this location.
//   OutputBufferSize= sizeof(ISCBRICONFIG)
//   BytesReturned   = 0 or sizeof(ISCBRICONFIG)
// 
*/

/*
// ISCCMD_SET_CALLDEFAULT	- Not currently supported thru IOCTL
//
*/

/*
//  ISCCMD_SET_BOARDFEATURES - See iscdevex.h for a description of this command.
//
// ioctl structure:
//   command         = ISCCMD_SET_BOARDFEATURES.
//   InputBuffer     = Points to a valid DWORD which contains the 
//					   ISCBOARDFEATURES (constants) to use.
//   InputBufferSize = sizeof(DWORD)
//   OutputBuffer    = n/a
//   OutputBufferSize= n/a
//   BytesReturned   = 0
*/

/*
// ISCCMD_BOARD_STOP	- See iscdevex.h for a description of this command.
//
// ioctl structure:
//   command         = ISCCMD_BOARD_STOP
//   InputBuffer     = n/a
//   InputBufferSize = n/a
//   OutputBuffer    = n/a
//   OutputBufferSize= n/a
//   BytesReturned   = 0
*/

/*
// ISCCMD_RUNBOARDDIAGS	- See iscdevex.h for a description of this command.
//
// Note: The diag return code is placed into the structure pointed
//       to by the InputBuffer.
//
// ioctl structure:
//   command         = ISCCMD_RUNBOARDDIAGS	
//   InputBuffer     = Points to a valid ISCDIAGNOSTIC structure.
//   InputBufferSize = sizeof(ISCDIAGNOSTIC)
//   OutputBuffer    = Points to a DWORD which will contain the diagnostic
//                      return code SL_xxxx as defined in iscconst.h
//   OutputBufferSize= sizeof(DWORD)
//   BytesReturned   = 0or sizeof(DWORD)
*/


/*
// ISCCMD_RINGBOARD	- See iscdevex.h for a description of this command.
//
// ioctl structure:
//   command         = ISCCMD_RINGBOARD
//   InputBuffer     = Points to a valid ISCDIAGNOSTIC structure.
//   InputBufferSize = sizeof(ISCDIAGNOSTIC)
//   OutputBuffer    = n/a
//   OutputBufferSize= n/a
//   BytesReturned   = 0
*/

/*
//  ISCCMD_SET_TURBOPPP_SPECIFIC - See iscdevex.h for a description of this command.
//
//
// ioctl structure:
//   command         = ISCCMD_SET_TURBOPPP_SPECIFIC
//   InputBuffer     = Points to a valid ISCIOCTLCALLDATA structure.
//   InputBufferSize = sizeof(ISCIOCTLCALLDATA)
//   OutputBuffer    = n/a
//   OutputBufferSize= n/a
//   BytesReturned   = 0
*/
typedef struct tagISCIOCTLCALLDATA
	{
	DWORD				hdCall;	// Handle to call retrieved from event
								// 	ISCEVENT_DRIVERHDCALL
	LPISCCALLSPECIFICDATA	lpCall;
	} ISCIOCTLCALLDATA, *LPISCIOCTLCALLDATA;

/*
// ISCCMD_SET_SPECIAL_ACCESS_CODE - See iscdevex.h for a description of this command.
//
// ioctl structure:
//   command         = ISCCMD_SET_SPECIAL_ACCESS_CODE
//   InputBuffer     = Points to a valid ISCACCESSCODE structure.
//   InputBufferSize = sizeof(ISCACCESSCODE)
//   OutputBuffer    = n/a
//   OutputBufferSize= n/a
//   BytesReturned   = 0
*/


/*
// ISCCMD_GET_SPECIAL_ACCESS_CODE - See iscdevex.h for a description of this command.
//
// ioctl structure:
//   command         = ISCCMD_GET_SPECIAL_ACCESS_CODE
//   InputBuffer     = Points to a valid ISCACCESSCODE structure.
//   InputBufferSize = sizeof(ISCACCESSCODE)
//   OutputBuffer    = n/a
//   OutputBufferSize= n/a
//   BytesReturned   = 0
*/

/*
// ISCCMD_RAISE_TURBOPPP_LINK - See iscdevex.h for a description of this command.
//
// ioctl structure:
//   command         = ISCCMD_RAISE_TURBOPPP_LINK
//   InputBuffer     = Points to hdCall Handle to call retrieved from event
						ISCEVENT_DRIVERHDCALL.
//   InputBufferSize = sizeof(DWORD)
//   OutputBuffer    = n/a
//   OutputBufferSize= n/a
//   BytesReturned   = 0
*/

/*
// ISCCMD_LOWER_TURBOPPP_LINK - See iscdevex.h for a description of this command
//
// ioctl structure:
//   command         = ISCCMD_LOWER_TURBOPPP_LINK
//   InputBuffer     = Points to hdCall Handle to call retrieved from event
						ISCEVENT_DRIVERHDCALL.
//   InputBufferSize = sizeof(DWORD)
//   OutputBuffer    = n/a
//   OutputBufferSize= n/a
//   BytesReturned   = 0
*/

/*****
*  Revert to the default packing alignment.  NOTE:  For the Borlandc compiler,
*  there is no way to revert back.  Thus, for Borlandc builds, everyone must
*  be using 
*****/
#pragma pack()

#endif	// iscioctl_h_included

