/*Tab stops set to 3*/
/******************************************************************************
 *
 *		Copyright U.S. Robotics, 1995, all rights reserved.
 *
 *  PROGRAM: 		isdndll.h
 *
 *  DESCRIPTION: 	Commands that can be passed to winisdn.dll using
 *					ISDNSetRequest().
 *
 *						See also WinISDN Specification dated 2 February 1995.
 *
 *
 *	Modification Log:
 *
 *	Date		Authors		Notes/Description of Change
 *	02-18-95	JLM			Genesis
 * 05-31-95	JLM			Added window parameter for diagnostics option
 *****************************************************************************/

#ifndef _isdndll_h_included
#define _isdndll_h_included

#include "isdndef.h"

// The name of the winisdn library
#define	WINISDN_LIBRARY	"WINISDN.DLL"

// Pointer to a WinISDN SetRequest function call.
typedef int (FAR PASCAL *LPWINISDNREQUESTFUN) (LPrequest_values);

// These are the SecureLink extensions which are callable through
//  ISDNSetRequest(). You must specify the command field in the
//  request values structure to ISDN_REQ_DLL_ACTION. Each of the
//	 commands listed below, is placed in the data_value1 field.

// *****************************************************************
// This command will turn on packet dump traceing.
// *****************************************************************

#define	WINISDN_PKT_TRACE_ON				1	

/*
	Invocation
	----------
	ISDNSetRequest(&request_values);


	request_values structure:
	-------------------------

	field								Value
	----------------------------------------------------
	command							ISDN_REQ_DLL_ACTION
	board_id							1
	call_handle						0
	data_buffer						NULL
	buffer_size						0
	data_length						0
	data_value1						WINISDN_PKT_TRACE_ON
	data_value2						hWnd -> Window winisdn can post to for
												  diagnostics buffer. See ISDNdiagnose().
	data_value3						0
	data_value4						0
*/

// *****************************************************************
// This command will turn packet traceing off.
// *****************************************************************

#define	WINISDN_PKT_TRACE_OFF			2	

/*
	Invocation
	----------
	ISDNSetRequest(&request_values);

	request_values structure:
	--------------------------

	Field								Value
	----------------------------------------------------
	command							ISDN_REQ_DLL_ACTION
	board_id							1
	call_handle						0
	data_buffer						NULL
	buffer_size						0
	data_length						0
	data_value1						WINISDN_PKT_TRACE_OFF
	data_value2						0
	data_value3						0
	data_value4						0
*/

// *****************************************************************
// This command will return whether packet raceing is on or off.
// *****************************************************************

#define	WINISDN_GET_PKT_TRACE_MODE		3  

/*
	Invocation
	----------
	ISDNSetRequest(&request_values);

	request_values structure:
	--------------------------

	Field								Value
	----------------------------------------------------
	command							ISDN_REQ_DLL_ACTION
	board_id							1
	call_handle						0
	data_buffer						NULL
	buffer_size						0
	data_length						0
	data_value1						WINISDN_GET_PKT_TRACE_MODE
	data_value2						WinISDN returns TRUE if on or FALSE if off.
	data_value3						0
	data_value4						0
*/


// *****************************************************************
// These commands should not be used. They are called by WinISDNSpy.
// Applications can get the same results by using the diagnostics
// method for ISDNDiagnose().
// *****************************************************************

#define	WINISDN_TRACE_ON				4	
#define	WINISDN_TRACE_OFF				5	
#define	WINISDN_GET_TRACE_MODE		   	6 


#endif   //_isdndll_h_included

