/*
// A note from U.S. Robotics. It seems that isdn_status structure was modified 
//   at some point to include a board id. The person who added this did so in 
//   the middle of the structure. Since our DLL does not know which structure 
//   you are using it is impossible for us to support this new structure 
//   accross some applications. Therefore we do not use the new structure but
//   would be interested in developing a method to support both versions.
*/

#if !defined(ISDNDEF_H)
#define ISDNDEF_H

#include        <windows.h>

typedef char FAR * LPSTR;

#define ISDN_H_CHANNEL			1
#define ISDN_D_CHANNEL			101
#define ISDN_B_VOICE			201
#define ISDN_B_56K				202
#define ISDN_B_64K				203
#define ISDN_B_112K				204
#define ISDN_B_128K				205
#define ISDN_B_64K_OS			206
#define ISDN_B_128K_OS			207
#define ISDN_B_DOV				208
#define ISDN_B_VS				209
#define ISDN_B_DS_56K			210
#define ISDN_B_DS_64K			211
#define ISDN_INTERCOM			212

#define ISDN_ACCEPT_ANY			0

#define ISDN_H_LOW				1
#define ISDN_H_HIGH				99
#define ISDN_D_LOW				100
#define ISDN_D_HIGH				199
#define ISDN_B_LOW				200
#define ISDN_B_HIGH				299

#define is_a_B_call(type) \
((type) >= ISDN_B_LOW && (type) <= ISDN_B_HIGH)

#define ISDN_EVENT_READ					0x1
#define ISDN_EVENT_WRITE				0x2
#define ISDN_EVENT_CONNECT				0x4
#define ISDN_EVENT_DISCONNECT			0x8
#define ISDN_EVENT_ACCEPT				0x10
#define ISDN_EVENT_CALL_CONTROL			0x20
#define ISDN_EVENT_INFO_ELEMENT			0x40
#define ISDN_EVENT_INDICATION			0x80

#define LISTEN_ALL						0x1
#define LISTEN_SPEECH					0x2
#define LISTEN_64K_DATA					0x4
#define LISTEN_RESTRICTED				0x8
#define LISTEN_3_1_KHZ					0x10
#define LISTEN_7_KHZ					0x20
#define LISTEN_VIDEO					0x40
#define LISTEN_PACKET					0x80
#define LISTEN_56K_DATA					0x100

#define MSG_PEEK						1

#define ISDN_READ_QUEUE					1
#define ISDN_WRITE_QUEUE				2
#define ISDN_READ_WRITE_QUEUE			3

#define ISDN_REQ_NULL					0
#define ISDN_REQ_RESET_BOARD			1
#define ISDN_REQ_IS_CAPI				2
#define ISDN_REQ_CODEC					3
#define ISDN_REQ_STREAM					4
#define ISDN_REQ_L1_ACTIVATE			5
#define ISDN_REQ_TEI_REQUEST			6
#define ISDN_REQ_L1_STATE				7
#define ISDN_REQ_L2_STATE				8
#define ISDN_REQ_L3_STATE				9

#define ISDN_REQ_INFO_EL_MASK			10
#define ISDN_REQ_INDICATIONS_MASK		11
#define ISDN_REQ_L3_AUTO_ON				12
#define ISDN_REQ_L3_AUTO_OFF			13
#define ISDN_REQ_VOICE_ENERGY			14
#define ISDN_REQ_VOICE_CAPTURE			15
#define ISDN_REQ_DATA_PUMP				16
#define ISDN_REQ_LOOP_TEST				17
#define ISDN_REQ_LISTEN_MASK			18

#define ISDN_REQ_ACTION					20
#define ISDN_REQ_L3_DECODE_ON			21
#define ISDN_REQ_L3_DECODE_OFF			22
#define ISDN_REQ_FACILITY				23
#define ISDN_REQ_LISTEN_MODEM			24
#define ISDN_REQ_LISTEN_DTMF			25
#define ISDN_REQ_SEND_DTMF				26
#define ISDN_REQ_X25_SABME				27
#define ISDN_REQ_X25_RESET				28

#define ISDN_REQ_DLL_ACTION				30
#define ISDN_REQ_SERIAL_NUM				31
#define ISDN_REQ_VOLUME_CTRL			32
#define ISDN_REQ_CHANNEL_B1				33
#define ISDN_REQ_CHANNEL_B2				34
#define ISDN_REQ_AUTO_DISCONNECT		35
#define ISDN_REQ_CALL_TYPE_CHANGE		36

#define ISDN_REQ_HIGH					39

#define ISDN_IND_L1_ACTIVATED			0x1
#define ISDN_IND_L1_DEACTIVATED			0x2
#define ISDN_IND_TEI_ASSIGNED			0x4
#define ISDN_IND_TEI_REMOVED			0x8
#define ISDN_IND_VOICE_ENERGY			0x10
#define ISDN_IND_DTMF_DETECTED			0x20
#define ISDN_IND_CALL_STATE				0x40
#define ISDN_IND_CRC_ERROR				0x80
#define ISDN_IND_FEATURE_IND			0x100
#define ISDN_IND_MODEM_CED				0x200

#define ISDN_INFO_CAUSE					0x1
#define ISDN_INFO_DATE_TIME				0x2
#define ISDN_INFO_DISPLAY				0x4
#define ISDN_INFO_USER_USER				0x8
#define ISDN_INFO_CALL_PROGRESS			0x10
#define ISDN_INFO_FACILITY				0x20
#define ISDN_INFO_CHARGING				0x40
#define ISDN_INFO_LOW_LEVEL_COMP		0x80
#define ISDN_INFO_SIGNAL				0x100
#define ISDN_INFO_CALL_APPEARANCE		0x200
#define ISDN_INFO_CALLING_PARTY			0x400
#define ISDN_INFO_REDIRECTING			0x800

#define CALL_STATE_NULL					0
#define CALL_STATE_INIT					1
#define CALL_STATE_OVRLAP_SND			2
#define CALL_STATE_OUT_CALL_PROC		3
#define CALL_STATE_DELIVERED			4
#define CALL_STATE_NEGOTIATE			5
#define CALL_STATE_RECEIVED				7
#define CALL_STATE_CON_REQ				8
#define CALL_STATE_IN_CALL_PROC			9
#define CALL_STATE_ACTIVE				10
#define CALL_STATE_DISC_REQ				11
#define CALL_STATE_DISC_IND				12
#define CALL_STATE_DET_REQ				13
#define CALL_STATE_DETACH				14
#define CALL_STATE_SUSP_REQ				15
#define CALL_STATE_LOCAL_SUSP			16
#define CALL_STATE_RESUME_REQ			17
#define CALL_STATE_REL_REQ				19
#define CALL_STATE_REMOTE_FAC_REQ		20
#define CALL_STATE_LOCAL_FAC_REQ		21


#define ISDN_RETCD_SUCCESS				 0
#define ISDN_RETCD_BOARDID				-1
#define ISDN_RETCD_CONNECTID			-2
#define ISDN_RETCD_INVALID				-3
#define ISDN_RETCD_CALLTYPE				-4
#define ISDN_RETCD_NOCALLS				-5
#define ISDN_RETCD_BUFFULL				-6
#define ISDN_RETCD_NOMORECHANNELS		-7
#define ISDN_RETCD_DUPLICATECALL		-8
#define ISDN_RETCD_MEMACCESS			-9
#define ISDN_RETCD_TIMEOUT				-10
#define ISDN_RETCD_PACKET				-11
#define ISDN_RETCD_MAXBOARDS			-12
#define ISDN_RETCD_CANNOTDO				-13
#define ISDN_RETCD_FUNCFAILED			-14
#define ISDN_RETCD_FUNCNOTSUPPORTED		-15
#define ISDN_RETCD_PREVIOUSLISTENER		-30


struct isdn_call {
	int				call_handle;
	int				board_id;
	int				call_type;
	int				send_queue_size;
	int				recv_queue_size;
	char			dial1[64];
	int				version;
	int				line_id;
	unsigned int	listen_mask;
	char			reserved[58];
};
typedef struct isdn_call isdn_call;
typedef struct isdn_call FAR *LPisdn_call;

struct isdn_notify {
	unsigned int	event_mask;
	HWND			win_handle;
	unsigned int	msg_value;
	LPSTR			callback;
};
typedef struct isdn_notify isdn_notify;
typedef struct isdn_notify FAR *LPisdn_notify;

#ifdef NEW_STATUS_RECORD
struct isdn_status {
	int		call_handle;
	int		board_id;
	int		line_id;
	int		call_ref;
	int		call_type;
	int		call_state;
	int		b_channel;
	int		lcn;
	char	called[64];
	char	calling[64];
	char	reserved[64];
};
#else
struct isdn_status {
	int		call_handle;
	int		line_id;
	int		call_ref;
	int		call_type;
	int		call_state;
	int		b_channel;
	int		lcn;
	char	called[64];
	char	calling[64];
	char	reserved[64];
};
#endif
typedef struct isdn_status isdn_status;
typedef struct isdn_status FAR *LPisdn_status;

struct line_config {
	int		line_id;
	int		line_type;
	int		line_status;
	char	spid[24];
	char	dir_num[64];
};
typedef struct line_config line_config;
typedef struct line_config FAR *LPline_config;

struct isdn_config {
	int				config_length;
	int				board_id;
	int				mem_address;
	int				mem_range;
	int				io_address;
	int				io_range;
	int				interrupt_req;
	int				bandwidth;
	char			version[16];
	char			serial[16];
	char			mfr_info[64];
	int				num_lines;
	char			reserved[64];
	line_config		line_config_b_line[1];
};
typedef struct isdn_config isdn_config;
typedef struct isdn_config FAR *LPisdn_config;

struct request_values {
	int		command;
	int		board_id;
	int		call_handle;
	LPSTR	data_buffer;
	int		buffer_size;
	int		data_length;
	int		data_value1;
	int		data_value2;
	int		data_value3;
	int		data_value4;
};
typedef struct request_values request_values;
typedef struct request_values FAR *LPrequest_values;


int		WINAPI ISDNOpen(int, LPisdn_config);
int		WINAPI ISDNClose(int);
int		WINAPI ISDNConnect(LPisdn_call, LPisdn_notify);
int		WINAPI ISDNDisconnect(int);
int		WINAPI ISDNListenForConnection(LPisdn_call, LPisdn_notify);
int		WINAPI ISDNAccept(int, LPisdn_call, LPisdn_notify);
int		WINAPI ISDNReject(int);
int		WINAPI ISDNRead(int, LPSTR, int, int, int FAR *);
int		WINAPI ISDNWrite(int, LPSTR, int);
int		WINAPI ISDNFlush(int, int);
int		WINAPI ISDNGetStatus(int, LPisdn_status);
int		WINAPI ISDNGetConfiguration(int, LPisdn_config);
int		WINAPI ISDNSetConfiguration(int, LPisdn_config);
int		WINAPI ISDNGetEventMask(int, LPisdn_notify);
int		WINAPI ISDNSetEventMask(int, LPisdn_notify);

int		WINAPI ISDNGetBoardEventMask(int, LPisdn_notify);
int		WINAPI ISDNSetBoardEventMask(int, LPisdn_notify);
int		WINAPI ISDNSetRequest(LPrequest_values);
int		WINAPI ISDNGetIndication(int, LPSTR, int, int FAR *);
int		WINAPI ISDNReadCallControl(int, LPSTR, int);
int		WINAPI ISDNWriteCallControl(int, LPSTR, int);
int		WINAPI ISDNReadInfoElement(int, LPSTR, int);

#endif


