
; option expr32

; Begin of file isdndef.h
; HWND			TYPEDEF			WORD

; LPSTR			TYPEDEF 		FAR PTR SBYTE

ISDN_H_CHANNEL			EQU		1t
ISDN_D_CHANNEL			EQU		101t
ISDN_B_VOICE			EQU		201t
ISDN_B_56K				EQU		202t
ISDN_B_64K				EQU		203t
ISDN_B_112K				EQU		204t
ISDN_B_128K				EQU		205t
ISDN_B_64K_OS			EQU		206t
ISDN_B_128K_OS			EQU		207t
ISDN_B_DOV				EQU		208t
ISDN_B_VS				EQU		209t
ISDN_B_DS_56K			EQU		210t
ISDN_B_DS_64K			EQU		211t
ISDN_INTERCOM			EQU		212t

ISDN_ACCEPT_ANY			EQU		0t

ISDN_EVENT_READ					EQU		00001h
ISDN_EVENT_WRITE				EQU		00002h
ISDN_EVENT_CONNECT				EQU		00004h
ISDN_EVENT_DISCONNECT			EQU		00008h
ISDN_EVENT_ACCEPT				EQU		00010h
ISDN_EVENT_CALL_CONTROL			EQU		00020h
ISDN_EVENT_INFO_ELEMENT			EQU		00040h
ISDN_EVENT_INDICATION			EQU		00080h

LISTEN_ALL						EQU		00001h
LISTEN_SPEECH					EQU		00002h
LISTEN_64K_DATA					EQU		00004h
LISTEN_RESTRICTED				EQU		00008h
LISTEN_3_1_KHZ					EQU		00010h
LISTEN_7_KHZ					EQU		00020h
LISTEN_VIDEO					EQU		00040h
LISTEN_PACKET					EQU		00080h
LISTEN_56K_DATA					EQU		00100h

MSG_PEEK				EQU		1t

ISDN_READ_QUEUE					EQU		1t
ISDN_WRITE_QUEUE				EQU		2t
ISDN_READ_WRITE_QUEUE			EQU		3t


ISDN_REQ_NULL					EQU	0t
ISDN_REQ_RESET_BOARD			EQU		1t
ISDN_REQ_IS_CAPI				EQU		2t
ISDN_REQ_CODEC					EQU		3t
ISDN_REQ_STREAM					EQU		4t
ISDN_REQ_L1_ACTIVATE			EQU		5t
ISDN_REQ_TEI_REQUEST			EQU		6t
ISDN_REQ_L1_STATE				EQU		7t
ISDN_REQ_L2_STATE				EQU		8t
ISDN_REQ_L3_STATE				EQU		9t

ISDN_REQ_INFO_EL_MASK			EQU		10t
ISDN_REQ_INDICATIONS_MASK		EQU		11t
ISDN_REQ_L3_AUTO_ON				EQU		12t
ISDN_REQ_L3_AUTO_OFF			EQU		13t
ISDN_REQ_VOICE_ENERGY			EQU		14t
ISDN_REQ_VOICE_CAPTURE			EQU		15t
ISDN_REQ_DATA_PUMP				EQU		16t
ISDN_REQ_LOOP_TEST				EQU		17t
ISDN_REQ_LISTEN_MASK			EQU		18t

ISDN_REQ_ACTION					EQU		20t
ISDN_REQ_L3_DECODE_ON			EQU		21t
ISDN_REQ_L3_DECODE_OFF			EQU		22t
ISDN_REQ_FACILITY				EQU		23t
ISDN_REQ_LISTEN_MODEM			EQU		24t
ISDN_REQ_LISTEN_DTMF			EQU		25t
ISDN_REQ_SEND_DTMF				EQU		26t
ISDN_REQ_X25_SABME				EQU		27t
ISDN_REQ_X25_RESET				EQU		28t

ISDN_REQ_DLL_ACTION				EQU		30t
ISDN_REQ_SERIAL_NUM				EQU		31t
ISDN_REQ_VOLUME_CTRL			EQU		32t
ISDN_REQ_CHANNEL_B1				EQU		33t
ISDN_REQ_CHANNEL_B2				EQU		34t
ISDN_REQ_AUTO_DISCONNECT		EQU		35t
ISDN_REQ_CALL_TYPE_CHANGE		EQU		36t

ISDN_REQ_HIGH					EQU		39t

ISDN_IND_L1_ACTIVATED			EQU		00001h
ISDN_IND_L1_DEACTIVATED 		EQU		00002h
ISDN_IND_TEI_ASSIGNED			EQU		00004h
ISDN_IND_TEI_REMOVED			EQU		00008h
ISDN_IND_VOICE_ENERGY			EQU		00010h
ISDN_IND_DTMF_DETECTED			EQU		00020h
ISDN_IND_CALL_STATE				EQU		00040h
ISDN_IND_CRC_ERROR				EQU		00080h
ISDN_IND_FEATURE_IND			EQU		00100h
ISDN_IND_MODEM_CED				EQU		00200h

ISDN_INFO_CAUSE					EQU		00001h
ISDN_INFO_DATE_TIME				EQU		00002h
ISDN_INFO_DISPLAY				EQU		00004h
ISDN_INFO_USER_USER				EQU		00008h
ISDN_INFO_CALL_PROGRESS			EQU		00010h
ISDN_INFO_FACILITY				EQU		00020h
ISDN_INFO_CHARGING				EQU		00040h
ISDN_INFO_LOW_LEVEL_COMP		EQU		00080h
ISDN_INFO_SIGNAL				EQU		00100h
ISDN_INFO_CALL_APPEARANCE		EQU		00200h
ISDN_INFO_CALLING_PARTY			EQU		00400h
ISDN_INFO_REDIRECTING			EQU		00800h

CALL_STATE_NULL					EQU		0t
CALL_STATE_INIT					EQU		1t
CALL_STATE_OVRLAP_SND			EQU		2t
CALL_STATE_OUT_CALL_PROC		EQU		3t
CALL_STATE_DELIVERED			EQU		4t
CALL_STATE_NEGOTIATE			EQU		5t
CALL_STATE_RECEIVED				EQU		7t
CALL_STATE_CON_REQ				EQU		8t
CALL_STATE_IN_CALL_PROC			EQU		9t
CALL_STATE_ACTIVE				EQU		10t
CALL_STATE_DISC_REQ				EQU		11t
CALL_STATE_DISC_IND				EQU		12t
CALL_STATE_DET_REQ				EQU		13t
CALL_STATE_DETACH				EQU		14t
CALL_STATE_SUSP_REQ				EQU		15t
CALL_STATE_LOCAL_SUSP			EQU		16t
CALL_STATE_RESUME_REQ			EQU		17t
CALL_STATE_REL_REQ				EQU		19t
CALL_STATE_REMOTE_FAC_REQ		EQU		20t
CALL_STATE_LOCAL_FAC_REQ		EQU		21t


ISDN_RETCD_SUCCESS				EQU		 0t
ISDN_RETCD_BOARDID				EQU		-1t
ISDN_RETCD_CONNECTID			EQU		-2t
ISDN_RETCD_INVALID				EQU		-3t
ISDN_RETCD_CALLTYPE				EQU		-4t
ISDN_RETCD_NOCALLS				EQU		-5t
ISDN_RETCD_BUFFULL				EQU		-6t
ISDN_RETCD_NOMORECHANNELS		EQU		-7t
ISDN_RETCD_DUPLICATECALL		EQU		-8t
ISDN_RETCD_MEMACCESS			EQU		-9t
ISDN_RETCD_TIMEOUT				EQU		-10t
ISDN_RETCD_PACKET				EQU		-11t
ISDN_RETCD_MAXBOARDS			EQU		-12t
ISDN_RETCD_CANNOTDO				EQU		-13t
ISDN_RETCD_FUNCFAILED			EQU		-14t
ISDN_RETCD_FUNCNOTSUPPORTED		EQU		-15t

ISDN_RETCD_PREVIOUSLISTENER		EQU		-30t


isdn_call		STRUCT 2t
	call_handle 		SWORD			?
	board_id			SWORD			?
	call_type			SWORD			?
	send_queue_size 	SWORD			?
	recv_queue_size 	SWORD			?
	dial1				SBYTE			64t DUP (?)
	version 			SWORD			1
	line_id 			SWORD			?
	listen_mask 		WORD			?
	reserved			SBYTE			58t DUP (?)
isdn_call		ENDS

LPisdn_call				TYPEDEF			FAR PTR isdn_call

isdn_notify		STRUCT 2t
	event_mask				WORD			?
	win_handle				HWND			?
	msg_value				WORD			?
	callback				LPSTR			?
isdn_notify		ENDS

LPisdn_notify			TYPEDEF			FAR PTR isdn_notify

isdn_status		STRUCT 2t
	call_handle 		SWORD			?
	board_id 			SWORD			?
	line_id 			SWORD			?
	call_ref			SWORD			?
	call_type			SWORD			?
	call_state			SWORD			?
	b_channel			SWORD			?
	lcn 				SWORD			?
	called				SBYTE			64t DUP (?)
	calling 			SBYTE			64t DUP (?)
	reserved			SBYTE			64t DUP (?)
isdn_status		ENDS

LPisdn_status			TYPEDEF			FAR PTR isdn_status

line_config		STRUCT 2t
	line_id				SWORD			?
	line_type			SWORD			?
	line_status			SWORD			?
	spid				SBYTE			24t DUP (?)
	dir_num				SBYTE			64t DUP (?)
line_config		ENDS

LPline_config			TYPEDEF			FAR PTR line_config

isdn_config		STRUCT 2t
	config_length		SWORD			?
	board_id			SWORD			?
	mem_address 		SWORD			?
	mem_range			SWORD			?
	io_address			SWORD			?
	io_range			SWORD			?
	interrupt_req		SWORD			?
	bandwidth			SWORD			?
	version				SBYTE			16t DUP (?)
	serial				SBYTE			16t DUP (?)
	mfr_info			SBYTE			64t DUP (?)
	num_lines			SWORD			?
	reserved			SBYTE			64t DUP (?)
	line_config_b_line1	line_config		<>
isdn_config		ENDS

LPisdn_config			TYPEDEF			FAR PTR isdn_config

request_values	STRUCT 2t
	command				SWORD			?
	board_id			SWORD			?
	call_handle			SWORD			?
	buffer_size			WORD			?
	data_buffer			LPSTR			?
	data_length			WORD			?
	data_value1			SWORD			?
	data_value2			SWORD			?
	data_value3			SWORD			?
	data_value4			SWORD			?
request_values	ENDS

LPrequest_values		TYPEDEF			FAR PTR request_values


@isdn_proto_2			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPisdn_config
ISDNOpen				PROTO			@isdn_proto_2

@isdn_proto_3			TYPEDEF			PROTO FAR PASCAL :SWORD
ISDNClose				PROTO			@isdn_proto_3

@isdn_proto_4			TYPEDEF			PROTO FAR PASCAL :LPisdn_call, :LPisdn_notify
ISDNConnect				PROTO			@isdn_proto_4

@isdn_proto_5			TYPEDEF			PROTO FAR PASCAL :SWORD
ISDNDisconnect			PROTO			@isdn_proto_5

@isdn_proto_6			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPisdn_notify
ISDNListen				PROTO			@isdn_proto_6

@isdn_proto_7			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPisdn_call, :LPisdn_notify
ISDNAccept				PROTO			@isdn_proto_7

@isdn_proto_8			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPSTR, :SWORD, :SWORD, :FAR PTR SWORD
ISDNRead				PROTO			@isdn_proto_8

@isdn_proto_9			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPSTR, :SWORD
ISDNWrite				PROTO			@isdn_proto_9

@isdn_proto_10			TYPEDEF			PROTO FAR PASCAL :SWORD, :SWORD
ISDNFlush				PROTO			@isdn_proto_10

@isdn_proto_11			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPisdn_status
ISDNGetStatus			PROTO			@isdn_proto_11

@isdn_proto_12			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPisdn_config
ISDNGetConfiguration	PROTO			@isdn_proto_12

@isdn_proto_13			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPisdn_config
ISDNSetConfiguration	PROTO			@isdn_proto_13

@isdn_proto_14			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPisdn_notify
ISDNGetEventMask		PROTO			@isdn_proto_14

@isdn_proto_15			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPisdn_notify
ISDNSetEventMask		PROTO			@isdn_proto_15

@isdn_proto_16			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPisdn_notify
ISDNDiagnose			PROTO			@isdn_proto_16

@isdn_proto_17			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPSTR, :SWORD
ISDNGetDiagnostics		PROTO			@isdn_proto_17

@isdn_proto_18			TYPEDEF			PROTO FAR PASCAL :SWORD
ISDNReset				PROTO			@isdn_proto_18

@isdn_proto_19			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPisdn_notify
ISDNGetBoardEventMask	PROTO			@isdn_proto_19

@isdn_proto_20			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPisdn_notify
ISDNSetBoardEventMask	PROTO			@isdn_proto_20

@isdn_proto_21			TYPEDEF			PROTO FAR PASCAL :LPrequest_values
ISDNSetRequest			PROTO			@isdn_proto_21

@isdn_proto_22			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPSTR, :SWORD, :FAR PTR SWORD
ISDNGetIndication		PROTO			@isdn_proto_22

@isdn_proto_23			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPSTR, :SWORD
ISDNReadCallControl		PROTO			@isdn_proto_23

@isdn_proto_24			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPSTR, :SWORD
ISDNWriteCallControl	PROTO			@isdn_proto_24

@isdn_proto_25			TYPEDEF			PROTO FAR PASCAL :SWORD, :LPSTR, :SWORD
ISDNReadInfoElement		PROTO			@isdn_proto_25

@isdn_proto_26			TYPEDEF			PROTO FAR PASCAL :LPisdn_call, :LPisdn_notify
ISDNListenForConnection	PROTO			@isdn_proto_26

@isdn_proto_27			TYPEDEF			PROTO FAR PASCAL :SWORD
ISDNReject				PROTO			@isdn_proto_27

; End of file isdndef.h
