/******************************************************************************
 *
 *		Copyright U.S. Robotics, 1995, all rights reserved.
 *
 *  PROGRAM: 		iscstream.h
 *
 *  DESCRIPTION:	This is the interface definition file for the PROD_TM 
 *					data stream library.
 *
 *	Modification Log:
 *
 *	Date		Authors		Notes/Description of Change
 * 06-18-95		JLM			Genesis
 *****************************************************************************/

#ifndef _iscstream_h_included
#define _iscstream_h_included

// *********************************************************************
// ISC Data Handle type, as returned by IscOpen().
// *********************************************************************

DECLARE_OPAQUE32(ISCHANDLE);
typedef ISCHANDLE FAR *LPISCHANDLE;


// *********************************************************************
// These are the return codes from the various library calls.
// *********************************************************************

typedef enum 
	{
	GCA_STATUS_SUCCESS = 0,		// Call succeeded
	GCA_STATUS_FAILURE,			// Call failed
	GCA_STATUS_NOT_READY,		// Unable to transmit, try again.
	GCA_STATUS_NOMEM,			// No heap mem to allocate
	GCA_STATUS_NO_PACKET,		// No packet to read
	GCA_STATUS_TOOSMALL			// Buffer to read into too small.
	} GCA_STATUS;

// *********************************************************************
// Stream types used on an open
// *********************************************************************
#define	STREAM_DATA			1	// Plain old data.
#define	STREAM_VOICE_PCM	2	// Digitized voice from a voice call.


// *********************************************************************
// Values for uFlags on an IscDataReceive
// *********************************************************************
#define	ISC_PEEK		1		// Grab packet from receive but do not
								// de-queue it.


// *********************************************************************
// Various function calls you can make
// *********************************************************************

// Open a stream for the call specified and return the handle.
GCA_STATUS
IscOpenStream (HLINE hLine, HCALL hCall, UINT uRxSize, UINT uTxSize,
				UINT uStreamType, DWORD dwStreamID, LPISCHANDLE lpHandle);

// Close an open stream. 
GCA_STATUS
IscCloseStream (ISCHANDLE hHandle);

// Get a received packet.
GCA_STATUS
IscReadStream (ISCHANDLE	hIsc, UINT uFlags, UINT uPacketSize,
				BYTE FAR *lpPacket, UINT FAR *lpuSize);

// Returns sizeof received packet if there is one or zero (0).
UINT IscStreamLookAhead (ISCHANDLE	hIsc);

// Transmit a received packet.
GCA_STATUS
IscWriteStream (ISCHANDLE hIsc, BYTE FAR *lpPacket,
				 UINT uPacketSize, UINT uFlags);

#endif	// iscstream_h_included

